/*
 * Decompiled with CFR 0.152.
 */
package score_calculators;

import data_structures.Gap_function;
import data_structures.Residue;
import data_structures.Residue_combinations;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import java.util.ArrayList;
import java.util.HashMap;

public class TPro_calculator {
    public static void calculate_TPro(SC_Structure struc, SC_Structure struc_other, double[][] w_intra, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = TPro_calculator.calculateSi(struc, struc_other, g, isA);
        for (Integer i : struc.residues.keySet()) {
            Residue res_central = struc.residues.get(i);
            double sum = 0.0;
            for (Residue res_inpatch : res_central.getPatch().patch_residues) {
                sum += w_intra[res_central.getRefSite()][res_inpatch.getRefSite()] * Sis.get(res_inpatch.getRefSite());
            }
            if (res_central.getPatch().patch_residues.size() == 0) continue;
            res_central.setTPro(sum / (double)res_central.getPatch().patch_residues.size());
        }
    }

    public static HashMap<Integer, Double> calculateSi(SC_Structure struc, SC_Structure struc_other, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = new HashMap<Integer, Double>();
        for (Integer i : struc.residues.keySet()) {
            Residue res_it = struc.residues.get(i);
            int it = res_it.getRefSite();
            double total_it = 0.0;
            for (Integer l : struc_other.residues.keySet()) {
                double patch_sum;
                double total_other = 0.0;
                double partialsum = 0.0;
                int num_of_sequences = 0;
                Residue res_other = struc_other.residues.get(l);
                int k = res_other.getRefSite();
                ArrayList<SequencePair> eligible = isA ? g.g_func_pair[it][k] : g.g_func_pair[k][it];
                if (eligible != null) {
                    double temp_mul;
                    for (Residue res : res_it.getPatch().patch_residues) {
                        for (SequencePair sp : eligible) {
                            if (isA) {
                                if (sp.sequenceA[res.getRefSite()] == Residue_type.gap) continue;
                                temp_mul = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[sp.sequenceA[it].classification.ordinal()][sp.sequenceB[k].classification.ordinal()].ordinal()][sp.sequenceA[res.getRefSite()].classification.ordinal()];
                                partialsum += temp_mul * Residue_combinations.triangle_lookup[sp.sequenceA[it].classification.ordinal()][sp.sequenceB[k].classification.ordinal()][sp.sequenceA[res.getRefSite()].classification.ordinal()];
                                ++num_of_sequences;
                                continue;
                            }
                            if (sp.sequenceB[res.getRefSite()] == Residue_type.gap) continue;
                            temp_mul = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[sp.sequenceB[it].classification.ordinal()][sp.sequenceA[k].classification.ordinal()].ordinal()][sp.sequenceB[res.getRefSite()].classification.ordinal()];
                            partialsum += temp_mul * Residue_combinations.triangle_lookup[sp.sequenceB[it].classification.ordinal()][sp.sequenceA[k].classification.ordinal()][sp.sequenceB[res.getRefSite()].classification.ordinal()];
                            ++num_of_sequences;
                        }
                        if (num_of_sequences == 0) continue;
                        total_other += partialsum / (double)num_of_sequences;
                        partialsum = 0.0;
                        num_of_sequences = 0;
                    }
                    for (Residue res : res_other.getPatch().patch_residues) {
                        for (SequencePair sp : eligible) {
                            if (isA) {
                                if (sp.sequenceB[res.getRefSite()] == Residue_type.gap) continue;
                                temp_mul = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[sp.sequenceA[it].classification.ordinal()][sp.sequenceB[k].classification.ordinal()].ordinal()][sp.sequenceB[res.getRefSite()].classification.ordinal()];
                                partialsum += temp_mul * Residue_combinations.triangle_lookup[sp.sequenceA[it].classification.ordinal()][sp.sequenceB[k].classification.ordinal()][sp.sequenceB[res.getRefSite()].classification.ordinal()];
                                ++num_of_sequences;
                                continue;
                            }
                            if (sp.sequenceA[res.getRefSite()] == Residue_type.gap) continue;
                            temp_mul = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[sp.sequenceB[it].classification.ordinal()][sp.sequenceA[k].classification.ordinal()].ordinal()][sp.sequenceA[res.getRefSite()].classification.ordinal()];
                            partialsum += temp_mul * Residue_combinations.triangle_lookup[sp.sequenceB[it].classification.ordinal()][sp.sequenceA[k].classification.ordinal()][sp.sequenceA[res.getRefSite()].classification.ordinal()];
                            ++num_of_sequences;
                        }
                        if (num_of_sequences == 0) continue;
                        total_other += partialsum / (double)num_of_sequences;
                        partialsum = 0.0;
                        num_of_sequences = 0;
                    }
                }
                if ((patch_sum = (double)(res_other.getPatch().patch_residues.size() + res_it.getPatch().patch_residues.size())) == 0.0) continue;
                total_it += total_other / patch_sum;
            }
            Sis.put(it, total_it / (double)struc_other.residues.size());
        }
        return Sis;
    }
}

