/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking_global.EpitopeSelector;
import docking_global.PrepareData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class GraphTrainer {
    public static String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        GraphTrainer.CreateHighPrecSet("_R");
        GraphTrainer.CreateHighPrecSet("_H");
    }

    public static void CreateHighPrecSet(String to_exclude) {
        ArrayList<String> pdbs = FileSystemTools.getFolders("/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases/zdock/zdock_ipatch_0_H");
        ArrayList<String> _cases = FileSystemTools.getFolders("/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases/zdock");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String _case : _cases) {
            if (_case.contains(to_exclude)) continue;
            for (String pdb : pdbs) {
                Object list;
                ResStruc rs = GraphTrainer.getData(_case, pdb);
                if (map.containsKey(pdb)) {
                    list = (ArrayList)map.get(pdb);
                    ((ArrayList)list).add(rs);
                    map.put(pdb, list);
                    continue;
                }
                list = new ArrayList();
                ((ArrayList)list).add(rs);
                map.put(pdb, list);
            }
        }
        for (String pdb : pdbs) {
            File f;
            ResStruc curr_best = (ResStruc)((ArrayList)map.get(pdb)).get(0);
            int succ = 0;
            for (ResStruc rs : (ArrayList)map.get(pdb)) {
                if (rs.prec > 0.3) {
                    ++succ;
                }
                if (!(rs.prec > curr_best.prec)) continue;
                curr_best = rs;
            }
            System.out.println(String.valueOf(pdb) + "(" + succ + ") : " + curr_best._case + " : " + curr_best.rec + " : " + curr_best.prec);
            String prefix = "/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases/zdock/";
            String target = "/Users/bielasek/Desktop/GraphAnalyzer/resources/HighPrecCases/H/" + pdb;
            if (curr_best._case.contains("_R")) {
                target = target.replace("/H/", "/R/");
            }
            if (!(f = new File(target)).exists()) {
                f.mkdir();
            }
            ArrayList<String> tocopy = new ArrayList<String>();
            tocopy.add("AB.pdb");
            tocopy.add("AG.pdb");
            tocopy.add("epitope.txt");
            tocopy.add("paratope.txt");
            tocopy.add("stats.txt");
            for (String s : tocopy) {
                FileSystemTools.CopyFile(String.valueOf(prefix) + curr_best._case + "/" + pdb + "/" + s, String.valueOf(target) + "/" + s);
            }
        }
    }

    public static ResStruc getData(String _case, String pdb) {
        ArrayList<String> in = FileSystemTools.readFile("/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases/zdock/" + _case + "/" + pdb + "/stats.txt");
        String stats = in.get(0);
        double rec = Double.parseDouble(FileSystemTools.getColumn(stats, 10));
        double prec = Double.parseDouble(FileSystemTools.getColumn(stats, 11));
        ResStruc rs = new ResStruc(rec, prec);
        rs._case = _case;
        return rs;
    }

    public static void ExpStats(int N, double cutoff, int iterations, int num_samples) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_5_R");
        String src_folder = String.valueOf(userdir) + "/resources/DockingCases/zdock";
        for (String _case : cases) {
            HashMap<String, ArrayList> res_map = new HashMap<String, ArrayList>();
            int iter = 0;
            while (iter < iterations) {
                String w_case = _case.replace("_5_", "_" + iter + "_");
                int i = 0;
                for (String pdb : pdbs) {
                    System.out.println(String.valueOf(iter) + "/" + iterations + " " + i + "/15");
                    String curr_folder = String.valueOf(src_folder) + "/zdock_" + _case + "/" + pdb.toLowerCase();
                    ArrayList<PrepareData.Struct_maximization> str = EpitopeSelector.GetEpitopes(pdb, curr_folder, _case, num_samples, cutoff, ++i);
                    EpitopeSelector.SuperEpi se = EpitopeSelector.PickBiggest(str, N, i);
                    String stats = se.data;
                    double recall = Double.parseDouble(FileSystemTools.getColumn(stats, 10));
                    double precision = Double.parseDouble(FileSystemTools.getColumn(stats, 11));
                    if (precision > 0.3) {
                        ArrayList curr;
                        System.out.println(String.valueOf(pdb) + " : R=" + recall + " : P=" + precision);
                        if (res_map.containsKey(pdb)) {
                            curr = (ArrayList)res_map.get(pdb);
                            curr.add(String.valueOf(recall) + " " + precision);
                            res_map.put(pdb, curr);
                        } else {
                            curr = new ArrayList();
                            curr.add(String.valueOf(recall) + " " + precision);
                            res_map.put(pdb, curr);
                        }
                    }
                    HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(src_folder) + "/zdock_" + _case + "/" + pdb.toLowerCase() + "/AG.pdb", 'A');
                    ArrayList<String> epi_out = new ArrayList<String>();
                    for (Integer resid : ag.keySet()) {
                        if (se.epitope.contains(resid)) continue;
                        epi_out.add("" + resid);
                    }
                }
                ++iter;
            }
            for (String pdb_code : res_map.keySet()) {
                ArrayList list = (ArrayList)res_map.get(pdb_code);
                System.out.println("@" + iterations + " " + pdb_code + " had " + list.size());
                for (String s : list) {
                    System.out.println(String.valueOf(pdb_code) + " " + s);
                }
            }
        }
    }

    public static class ResStruc {
        public final double rec;
        public final double prec;
        public String _case;

        public ResStruc(double r, double i) {
            this.rec = r;
            this.prec = i;
        }

        public void printOut() {
            System.out.println("Recall : " + this.rec);
            System.out.println("Precision : " + this.prec);
        }
    }
}

