/*
 * Decompiled with CFR 0.152.
 */
package ipatch_lite;

import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import main.Main_inter;
import main.Main_outer;
import main.ResultWriter;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class iPatchLite {
    private static final String userdir = System.getProperty("user.dir");
    private static final String db_folder = String.valueOf(userdir) + "/protein_database/standardized";

    public static void main(String[] args) {
        iPatchLite.ab_lite_run("TPRO");
    }

    public static void ab_lite_run(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsABAG";
        String results = "TestResults/ABAG" + method;
        iPatchLite.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa);
    }

    public static void analyze(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa) {
        double max_c = -1.0;
        double min_c = 100.0;
        boolean test_ind = true;
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
            int test_num = 10;
            int i = 1;
            while (i < test_num) {
                System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
                HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
                ArrayList<Integer> roi = new ArrayList<Integer>();
                int inter = 0;
                while (inter < 9999) {
                    roi.add(inter);
                    ++inter;
                }
                String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B";
                String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment";
                MSA msa = null;
                Residue_type[] first = PDB_parser.getSeqFromPDB(pdb_file1, 'A');
                Residue_type[] second = PDB_parser.getSeqFromPDB(pdb_file2, 'A');
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                msa = new MSA(sp_arr);
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, -1, true, roi, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, -1, false, roi, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                Main_inter mi = new Main_inter(msa, strA, strB);
                strA = iPatchLite.calculateNeighborsAWrite(strA, strB);
                strB = iPatchLite.calculateNeighborsBWrite(strA, strB);
                ArrayList<Integer> consider1 = iPatchLite.HalveStructure(strA);
                ArrayList<Integer> consider2 = iPatchLite.HalveStructure(strB);
                double cutoff = 0.0;
                while (cutoff < 3.5) {
                    ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, "TPRO");
                    ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, "TPRO");
                    TP_s.put(cutoff, forA.get(0) + forB.get(0));
                    FP_s.put(cutoff, forA.get(1) + forB.get(1));
                    TN_s.put(cutoff, forA.get(2) + forB.get(2));
                    FN_s.put(cutoff, forA.get(3) + forB.get(3));
                    cutoff += 0.1;
                }
                TPs.add(TP_s);
                FPs.add(FP_s);
                TNs.add(TN_s);
                FNs.add(FN_s);
                ++i;
            }
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + j, TPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + j, FPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + j, FNs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + j, TNs);
            System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)(test_num - 1) + "s/test on average over " + (test_num - 1) + " tests");
            ++j;
        }
        System.out.println("Wrote results");
    }

    public static void WriteResultScore(SC_Structure str, String save_file) {
        String lines = "";
        for (Integer i : str.residues.keySet()) {
            lines = String.valueOf(lines) + i + "\t" + str.residues.get(i).getTPro() + " " + "\n";
        }
        FileSystemTools.writeFile(save_file, lines);
    }

    public static ArrayList<Integer> HalveStructure(SC_Structure str) {
        ArrayList<Integer> consider = new ArrayList<Integer>();
        double cons = 0.0;
        double nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact) {
                cons += 1.0;
                continue;
            }
            nons += 1.0;
        }
        Random r = new Random();
        double ratio = cons / nons;
        nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact || !(ratio > r.nextDouble())) continue;
            consider.add(si);
            nons += 1.0;
        }
        return consider;
    }

    public static SC_Structure calculateNeighborsAWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        int all_count = 0;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5)) continue;
                s1.residues.get((Object)i).isContact = true;
                if (i == s1.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
            if (!s1.residues.get((Object)i).isContact) continue;
            ++all_count;
        }
        System.out.println("Found " + all_count + " contact residues on AB");
        return s1;
    }

    public static SC_Structure calculateNeighborsBWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        int all_count = 0;
        for (Integer i : residues_s2.keySet()) {
            s2.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (!(residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5)) continue;
                s2.residues.get((Object)i).isContact = true;
                if (i == s2.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
            if (!s2.residues.get((Object)i).isContact) continue;
            ++all_count;
        }
        System.out.println("Found " + all_count + " contact residues on AG");
        return s2;
    }
}

