/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;

public class IncrementalClassifierEvaluator
extends AbstractEvaluator
implements IncrementalClassifierListener,
EventConstraints {
    private static final long serialVersionUID = -3105419818939541291L;
    private transient Evaluation m_eval;
    private transient Classifier m_classifier;
    private Vector m_listeners = new Vector();
    private Vector m_textListeners = new Vector();
    private Vector m_dataLegend = new Vector();
    private ChartEvent m_ce = new ChartEvent(this);
    private double[] m_dataPoint = new double[1];
    private boolean m_reset = false;
    private double m_min = Double.MAX_VALUE;
    private double m_max = Double.MIN_VALUE;
    private int m_statusFrequency = 100;
    private int m_instanceCount = 0;
    private boolean m_outputInfoRetrievalStats = false;

    public IncrementalClassifierEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/IncrementalClassifierEvaluator.gif", "weka/gui/beans/icons/IncrementalClassifierEvaluator_animated.gif");
        this.m_visual.setText("IncrementalClassifierEvaluator");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Evaluate the performance of incrementally trained classifiers.";
    }

    @Override
    public void acceptClassifier(IncrementalClassifierEvent ce) {
        try {
            if (ce.getStatus() == 0) {
                this.m_eval = new Evaluation(ce.getStructure());
                this.m_eval.useNoPriors();
                this.m_dataLegend = new Vector();
                this.m_reset = true;
                this.m_dataPoint = new double[0];
                Instances inst = ce.getStructure();
                System.err.println("NEW BATCH");
                this.m_instanceCount = 0;
                if (this.m_logger != null) {
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "IncrementalClassifierEvaluator: started processing...");
                    this.m_logger.logMessage("[IncrementalClassifierEvaluator]" + this.statusMessagePrefix() + " started processing...");
                }
            } else {
                if (this.m_instanceCount > 0 && this.m_instanceCount % this.m_statusFrequency == 0 && this.m_logger != null) {
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "Processed " + this.m_instanceCount + " instances.");
                }
                ++this.m_instanceCount;
                Instance inst = ce.getCurrentInstance();
                double[] dist = ce.getClassifier().distributionForInstance(inst);
                double pred = 0.0;
                if (!inst.isMissing(inst.classIndex())) {
                    if (this.m_outputInfoRetrievalStats) {
                        this.m_eval.evaluateModelOnceAndRecordPrediction(dist, inst);
                    } else {
                        this.m_eval.evaluateModelOnce(dist, inst);
                    }
                } else {
                    pred = ce.getClassifier().classifyInstance(inst);
                }
                if (inst.classIndex() >= 0) {
                    if (inst.attribute(inst.classIndex()).isNominal()) {
                        if (!inst.isMissing(inst.classIndex())) {
                            if (this.m_dataPoint.length < 2) {
                                this.m_dataPoint = new double[2];
                                this.m_dataLegend.addElement("Accuracy");
                                this.m_dataLegend.addElement("RMSE (prob)");
                            }
                            this.m_dataPoint[1] = this.m_eval.rootMeanSquaredError();
                        } else if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            this.m_dataLegend.addElement("Confidence");
                        }
                        double primaryMeasure = 0.0;
                        primaryMeasure = !inst.isMissing(inst.classIndex()) ? 1.0 - this.m_eval.errorRate() : dist[Utils.maxIndex(dist)];
                        this.m_dataPoint[0] = primaryMeasure;
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(0.0);
                        this.m_ce.setMax(1.0);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    } else {
                        if (this.m_dataPoint.length < 1) {
                            this.m_dataPoint = new double[1];
                            if (inst.isMissing(inst.classIndex())) {
                                this.m_dataLegend.addElement("Prediction");
                            } else {
                                this.m_dataLegend.addElement("RMSE");
                            }
                        }
                        if (!inst.isMissing(inst.classIndex())) {
                            double update = !inst.isMissing(inst.classIndex()) ? this.m_eval.rootMeanSquaredError() : pred;
                            this.m_dataPoint[0] = update;
                            if (update > this.m_max) {
                                this.m_max = update;
                            }
                            if (update < this.m_min) {
                                this.m_min = update;
                            }
                        }
                        this.m_ce.setLegendText(this.m_dataLegend);
                        this.m_ce.setMin(inst.isMissing(inst.classIndex()) ? this.m_min : 0.0);
                        this.m_ce.setMax(this.m_max);
                        this.m_ce.setDataPoint(this.m_dataPoint);
                        this.m_ce.setReset(this.m_reset);
                        this.m_reset = false;
                    }
                    this.notifyChartListeners(this.m_ce);
                    if (ce.getStatus() == 2) {
                        if (this.m_logger != null) {
                            this.m_logger.logMessage("[IncrementalClassifierEvaluator]" + this.statusMessagePrefix() + " Finished processing.");
                            this.m_logger.statusMessage(this.statusMessagePrefix() + "Done.");
                        }
                        if (this.m_textListeners.size() > 0) {
                            String textTitle = ce.getClassifier().getClass().getName();
                            textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                            String results = "=== Performance information ===\n\nScheme:   " + textTitle + "\n" + "Relation: " + inst.dataset().relationName() + "\n\n" + this.m_eval.toSummaryString();
                            if (inst.classIndex() >= 0 && inst.classAttribute().isNominal() && this.m_outputInfoRetrievalStats) {
                                results = results + "\n" + this.m_eval.toClassDetailsString();
                            }
                            if (inst.classIndex() >= 0 && inst.classAttribute().isNominal()) {
                                results = results + "\n" + this.m_eval.toMatrixString();
                            }
                            textTitle = "Results: " + textTitle;
                            TextEvent te = new TextEvent(this, results, textTitle);
                            this.notifyTextListeners(te);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this.m_logger != null) {
                this.m_logger.logMessage("[IncrementalClassifierEvaluator]" + this.statusMessagePrefix() + " Error processing prediction " + ex.getMessage());
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR: problem processing prediction (see log for details)");
            }
            ex.printStackTrace();
            this.stop();
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier");
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChartListeners(ChartEvent ce) {
        Vector l;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ChartListener)l.elementAt(i)).acceptDataPoint(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        IncrementalClassifierEvaluator incrementalClassifierEvaluator = this;
        synchronized (incrementalClassifierEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(te);
            }
        }
    }

    public void setStatusFrequency(int s) {
        this.m_statusFrequency = s;
    }

    public int getStatusFrequency() {
        return this.m_statusFrequency;
    }

    public String statusFrequencyTipText() {
        return "How often to report progress to the status bar.";
    }

    public void setOutputPerClassInfoRetrievalStats(boolean i) {
        this.m_outputInfoRetrievalStats = i;
    }

    public boolean getOutputPerClassInfoRetrievalStats() {
        return this.m_outputInfoRetrievalStats;
    }

    public String outputPerClassInfoRetrievalStatsTipText() {
        return "Output per-class info retrieval stats. If set to true, predictions get stored so that stats such as AUC can be computed. Note: this consumes some memory.";
    }

    public synchronized void addChartListener(ChartListener cl) {
        this.m_listeners.addElement(cl);
    }

    public synchronized void removeChartListener(ChartListener cl) {
        this.m_listeners.remove(cl);
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

