/*
 * Decompiled with CFR 0.152.
 */
package abModels;

import data_structures.Atom;
import data_structures.Residue;
import java.io.File;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class CDRGrafter {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        File ctrl_f;
        String FULL_out = String.valueOf(userdir) + "/Tests/ABModelsFullH3";
        String CDR_out = String.valueOf(userdir) + "/Tests/ABModelsCDRH3";
        File model_f = new File(FULL_out);
        if (!model_f.exists()) {
            model_f.mkdir();
        }
        if (!(ctrl_f = new File(CDR_out)).exists()) {
            ctrl_f.mkdir();
        }
        String model_folds = String.valueOf(userdir) + "/Tests/ABModels";
        String ctrl_folds = String.valueOf(userdir) + "/Tests/ABControl";
        for (String pdb_code : FileSystemTools.getFolders(model_folds)) {
            if (pdb_code.equals("1YNT") || pdb_code.equals("1Z3G") || pdb_code.equals("1IQD") || pdb_code.equals("2H1P") || pdb_code.equals("1KB5")) continue;
            model_f = new File(String.valueOf(FULL_out) + "/" + pdb_code);
            if (!model_f.exists()) {
                model_f.mkdir();
            }
            if (!(ctrl_f = new File(String.valueOf(CDR_out) + "/" + pdb_code)).exists()) {
                ctrl_f.mkdir();
            }
            HashMap<Integer, Residue> real = PDB_parser.parse(String.valueOf(ctrl_folds) + "/" + pdb_code + "/strA.pdb");
            HashMap<Integer, Residue> model = PDB_parser.parse(String.valueOf(model_folds) + "/" + pdb_code + "/strA.pdb");
            TreeSet<Integer> tree = new TreeSet<Integer>();
            for (Integer i : real.keySet()) {
                tree.add(i);
            }
            boolean identified = false;
            String out = "";
            for (Integer res_i : tree) {
                Residue model_res = model.get(res_i);
                boolean found_h3 = false;
                for (Atom a : model_res.atoms) {
                    if (a.x_cord == a.y_cord && a.y_cord == a.z_cord && a.z_cord == 0.0) {
                        identified = true;
                        found_h3 = true;
                    }
                    if (found_h3) break;
                }
                if (found_h3) {
                    Residue real_res = real.get(res_i);
                    if (real_res.type != model_res.type) {
                        System.err.println("Model and real types do not match " + pdb_code + " " + res_i + " real=" + (Object)((Object)real_res.type) + " model=" + (Object)((Object)model_res.type));
                        System.exit(0);
                    }
                    for (Atom a : real_res.atoms) {
                        out = String.valueOf(out) + a.pdb_line + "\n";
                    }
                    continue;
                }
                for (Atom a : model_res.atoms) {
                    out = String.valueOf(out) + a.pdb_line + "\n";
                }
            }
            if (!identified) {
                System.err.println("H3 not found for " + pdb_code);
                System.exit(0);
            }
            FileSystemTools.writeFile(String.valueOf(FULL_out) + "/" + pdb_code + "/strA.pdb", out);
            FileSystemTools.writeFile(String.valueOf(CDR_out) + "/" + pdb_code + "/strA.pdb", out);
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/strB.pdb", String.valueOf(FULL_out) + "/" + pdb_code + "/strB.pdb");
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/strB.pdb", String.valueOf(CDR_out) + "/" + pdb_code + "/strB.pdb");
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/map.txt", String.valueOf(FULL_out) + "/" + pdb_code + "/map.txt");
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/map.txt", String.valueOf(CDR_out) + "/" + pdb_code + "/map.txt");
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/map_con.txt", String.valueOf(FULL_out) + "/" + pdb_code + "/map_con.txt");
            FileSystemTools.CopyFile(String.valueOf(model_folds) + "/" + pdb_code + "/map_con.txt", String.valueOf(CDR_out) + "/" + pdb_code + "/map_con.txt");
        }
    }
}

