/*
 * Decompiled with CFR 0.152.
 */
package abModels;

import data_structures.Atom;
import data_structures.Residue;
import for_terry.DBStats;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DataCreator {
    public static final String userdir = System.getProperty("user.dir");
    public static final String model_fld = String.valueOf(userdir) + "/Tests/ABModels";
    public static final String control_fld = String.valueOf(userdir) + "/Tests/ABControl";

    public static void main(String[] args) {
        DataCreator.WriteProperPDBTest();
        DataCreator.checkCorrespondences();
    }

    public static void WriteProperPDBTest() {
        HashMap<String, DBStats.PDB_record> chain_map = DBStats.getLHMapping();
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/test_pdbs.txt");
        HashMap<Integer, Residue> result = new HashMap<Integer, Residue>();
        int prog = 0;
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(pdb) + " ProperTest: " + ++prog + "/" + pdbs.size());
            pdb = pdb.substring(0, 4);
            if (!pdb.equals("1IQD")) continue;
            HashMap<Integer, Residue> residues_H = PDB_parser.parseString(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3/" + pdb.toLowerCase() + "_homology_noH3.pdb", 'H');
            HashMap<Integer, Residue> residues_L = PDB_parser.parseString(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3/" + pdb.toLowerCase() + "_homology_noH3.pdb", 'L');
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            HashMap<String, Residue> map_res = new HashMap<String, Residue>();
            ArrayList<String> list_con = new ArrayList<String>();
            char src_h = chain_map.get((Object)pdb).H;
            char src_l = chain_map.get((Object)pdb).L;
            String ags = chain_map.get((Object)pdb).Ag;
            HashMap<Integer, Residue> l_residues = null;
            HashMap<Integer, Residue> h_residues = null;
            TreeSet<Integer> l_sorted = null;
            TreeSet<Integer> h_sorted = null;
            if (src_h != '0') {
                h_residues = PDB_parser.parseString(String.valueOf(userdir) + "/protein_database/raw_files/" + pdb + ".pdb", src_h);
                h_sorted = new TreeSet<Integer>();
                for (int i : h_residues.keySet()) {
                    h_sorted.add(i);
                }
            }
            if (src_l != '0') {
                l_residues = PDB_parser.parseString(String.valueOf(userdir) + "/protein_database/raw_files/" + pdb + ".pdb", src_l);
                l_sorted = new TreeSet<Integer>();
                for (int i : l_residues.keySet()) {
                    l_sorted.add(i);
                }
            }
            int ordinal = 0;
            int l_ordinal = 0;
            String output = "";
            if (l_sorted != null) {
                for (Integer r_i : l_sorted) {
                    ++l_ordinal;
                    boolean added = false;
                    Residue r = l_residues.get(r_i);
                    String ordinal_str = String.valueOf(++ordinal);
                    while (ordinal_str.length() < 4) {
                        ordinal_str = " " + ordinal_str;
                    }
                    for (Atom atom : r.atoms) {
                        Object line = atom.pdb_line;
                        line = PDB_parser.renameChain((String)line, 'A');
                        int int_sid = Integer.parseInt(((String)line).substring(22, 26).replace(" ", ""));
                        String sid = ((String)line).substring(22, 27).replace(" ", "");
                        if (!map.containsKey(String.valueOf(sid) + "L")) {
                            map.put(ordinal, String.valueOf(sid) + "L");
                            map_res.put(String.valueOf(sid) + "L", r);
                            r.model_seq_id = String.valueOf(sid) + "L";
                        }
                        String out_line = String.valueOf(((String)line).substring(0, 22)) + ordinal_str + " " + ((String)line).substring(27) + "\n";
                        if (l_ordinal < residues_L.size() + 1 && int_sid > 3) {
                            output = String.valueOf(output) + out_line;
                            added = true;
                            continue;
                        }
                        if (!pdb.equals("1IQD") || l_ordinal >= 110 || int_sid <= 0) continue;
                        output = String.valueOf(output) + out_line;
                        added = true;
                    }
                    if (!added) {
                        --ordinal;
                        --l_ordinal;
                        continue;
                    }
                    result.put(ordinal, r);
                }
            }
            int h_ordinal = 0;
            if (h_sorted != null) {
                for (Integer r_i : h_sorted) {
                    ++h_ordinal;
                    boolean added = false;
                    Residue r = h_residues.get(r_i);
                    String ordinal_str = String.valueOf(++ordinal);
                    while (ordinal_str.length() < 4) {
                        ordinal_str = " " + ordinal_str;
                    }
                    for (Atom atom : r.atoms) {
                        String line = atom.pdb_line;
                        int int_sid = Integer.parseInt(line.substring(22, 26).replace(" ", ""));
                        String sid = (line = PDB_parser.renameChain(line, 'A')).substring(22, 27).replace(" ", "");
                        if (!map.containsKey(String.valueOf(sid) + "H")) {
                            map.put(ordinal, String.valueOf(sid) + "H");
                            map_res.put(String.valueOf(sid) + "H", r);
                            r.model_seq_id = String.valueOf(sid) + "H";
                        }
                        String out_line = String.valueOf(line.substring(0, 22)) + ordinal_str + " " + line.substring(27) + "\n";
                        if (h_ordinal < residues_H.size() + 1 && int_sid > 3) {
                            output = String.valueOf(output) + out_line;
                            added = true;
                            continue;
                        }
                        if (!pdb.equals("1IQD") || h_ordinal >= 108 || int_sid <= 0) continue;
                        output = String.valueOf(output) + out_line;
                        added = true;
                    }
                    if (!added) {
                        --ordinal;
                        --h_ordinal;
                        continue;
                    }
                    result.put(ordinal, r);
                }
            }
            ordinal = 0;
            String antigen_out = "";
            int ch_i = 0;
            while (ch_i < ags.length()) {
                System.out.println("ch_i = " + ch_i);
                HashMap<Integer, Residue> ag_residues = PDB_parser.parseString(String.valueOf(userdir) + "/protein_database/raw_files/" + pdb + ".pdb", ags.charAt(ch_i));
                TreeSet<Integer> ag_sorted = new TreeSet<Integer>();
                Iterator<Object> iterator = ag_residues.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    ag_sorted.add(i);
                }
                for (Integer r_i : ag_sorted) {
                    ++ordinal;
                    Residue r = ag_residues.get(r_i);
                    Iterator int_sid = result.keySet().iterator();
                    while (int_sid.hasNext()) {
                        int ab_i = (Integer)int_sid.next();
                        Residue ab_r = (Residue)result.get(ab_i);
                        if (list_con.contains(String.valueOf(ab_i) + "_AB") || !(ab_r.distanceFrom(r) < 4.5)) continue;
                        list_con.add(String.valueOf(ab_i) + "_AB");
                        if (list_con.contains(String.valueOf(ordinal) + "_AG")) continue;
                        list_con.add(String.valueOf(ordinal) + "_AG");
                    }
                    String ordinal_str = String.valueOf(ordinal);
                    while (ordinal_str.length() < 4) {
                        ordinal_str = " " + ordinal_str;
                    }
                    for (Atom atom : r.atoms) {
                        String line = atom.pdb_line;
                        line = PDB_parser.renameChain(line, 'A');
                        String sid = line.substring(22, 27).replace(" ", "");
                        String out_line = String.valueOf(line.substring(0, 22)) + ordinal_str + " " + line.substring(27) + "\n";
                        antigen_out = String.valueOf(antigen_out) + out_line;
                    }
                }
                ++ch_i;
            }
            File f = new File(String.valueOf(control_fld) + "/" + pdb);
            f.mkdir();
            f = new File(String.valueOf(model_fld) + "/" + pdb);
            f.mkdir();
            String map_out = "";
            for (Integer i : map.keySet()) {
                map_out = String.valueOf(map_out) + i + " " + (String)map.get(i) + "\n";
            }
            String contact_out = "";
            for (String s : list_con) {
                contact_out = String.valueOf(contact_out) + s + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(control_fld) + "/" + pdb + "/map.txt", map_out);
            FileSystemTools.writeFile(String.valueOf(control_fld) + "/" + pdb + "/map_con.txt", contact_out);
            FileSystemTools.writeFile(String.valueOf(control_fld) + "/" + pdb + "/strA.pdb", output);
            FileSystemTools.writeFile(String.valueOf(control_fld) + "/" + pdb + "/strB.pdb", antigen_out);
            FileSystemTools.writeFile(String.valueOf(model_fld) + "/" + pdb + "/map_con.txt", contact_out);
            FileSystemTools.writeFile(String.valueOf(model_fld) + "/" + pdb + "/strB.pdb", antigen_out);
        }
    }

    public static void WriteModelPDB() {
        HashMap<String, DBStats.PDB_record> chain_map = DBStats.getLHMapping();
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/test_pdbs.txt");
        int prog = 0;
        for (String pdb : pdbs) {
            String out_line;
            String sid;
            String line;
            String ordinal_str;
            Residue r;
            System.out.println("ModelTest: " + ++prog + "/" + pdbs.size());
            pdb = pdb.substring(0, 4);
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            char src_h = chain_map.get((Object)pdb).H;
            char src_l = chain_map.get((Object)pdb).L;
            HashMap<Integer, Residue> l_residues = null;
            HashMap<Integer, Residue> h_residues = null;
            TreeSet<Integer> l_sorted = null;
            TreeSet<Integer> h_sorted = null;
            if (src_h != '0') {
                h_residues = PDB_parser.parseString(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3/" + pdb.toLowerCase() + "_homology_noH3.pdb", 'H');
                if (h_residues.size() == 0) {
                    System.err.println("Empty model H");
                    System.exit(0);
                }
                h_sorted = new TreeSet<Integer>();
                for (int i : h_residues.keySet()) {
                    h_sorted.add(i);
                }
            }
            if (src_l != '0') {
                l_residues = PDB_parser.parseString(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3/" + pdb.toLowerCase() + "_homology_noH3.pdb", 'L');
                if (l_residues.size() == 0) {
                    System.err.println("Empty model L");
                    System.exit(0);
                }
                l_sorted = new TreeSet<Integer>();
                for (int i : l_residues.keySet()) {
                    l_sorted.add(i);
                }
            }
            int ordinal = 0;
            String output = "";
            if (l_sorted != null) {
                for (Integer r_i : l_sorted) {
                    r = l_residues.get(r_i);
                    ordinal_str = String.valueOf(++ordinal);
                    while (ordinal_str.length() < 4) {
                        ordinal_str = " " + ordinal_str;
                    }
                    for (Atom atom : r.atoms) {
                        line = atom.pdb_line;
                        if (line.charAt(12) != ' ' || line.charAt(13) == 'H') continue;
                        sid = (line = PDB_parser.renameChain(line, 'A')).substring(22, 27).replace(" ", "");
                        if (!map.containsKey(String.valueOf(sid) + "L")) {
                            map.put(ordinal, String.valueOf(sid) + "L");
                            r.model_seq_id = String.valueOf(sid) + "L";
                        }
                        out_line = String.valueOf(line.substring(0, 22)) + ordinal_str + " " + line.substring(27) + "\n";
                        output = String.valueOf(output) + out_line;
                    }
                }
            }
            if (h_sorted != null) {
                for (Integer r_i : h_sorted) {
                    r = h_residues.get(r_i);
                    ordinal_str = String.valueOf(++ordinal);
                    while (ordinal_str.length() < 4) {
                        ordinal_str = " " + ordinal_str;
                    }
                    for (Atom atom : r.atoms) {
                        line = atom.pdb_line;
                        if (line.charAt(12) != ' ' || line.charAt(13) == 'H') continue;
                        sid = (line = PDB_parser.renameChain(line, 'A')).substring(22, 27).replace(" ", "");
                        if (!map.containsKey(String.valueOf(sid) + "H")) {
                            map.put(ordinal, String.valueOf(sid) + "H");
                            r.model_seq_id = String.valueOf(sid) + "H";
                        }
                        out_line = String.valueOf(line.substring(0, 22)) + ordinal_str + " " + line.substring(27) + "\n";
                        output = String.valueOf(output) + out_line;
                    }
                }
            }
            File f = new File(String.valueOf(model_fld) + "/" + pdb);
            f.mkdir();
            String map_out = "";
            for (Integer i : map.keySet()) {
                map_out = String.valueOf(map_out) + i + " " + (String)map.get(i) + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(model_fld) + "/" + pdb + "/map.txt", map_out);
            FileSystemTools.writeFile(String.valueOf(model_fld) + "/" + pdb + "/strA.pdb", output);
        }
    }

    public static void checkCorrespondences() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/test_pdbs.txt");
        String model_folds = String.valueOf(userdir) + "/Tests/ABModels";
        String ctrl_folds = String.valueOf(userdir) + "/Tests/ABControl";
        int prog = 0;
        for (String pdb : pdbs) {
            System.out.println("ModelTest: " + ++prog + "/" + pdbs.size());
            pdb = pdb.substring(0, 4);
            HashMap<Integer, Residue> real = PDB_parser.parse(String.valueOf(ctrl_folds) + "/" + pdb + "/strA.pdb");
            HashMap<Integer, Residue> model = PDB_parser.parse(String.valueOf(model_folds) + "/" + pdb + "/strA.pdb");
            for (Integer i : real.keySet()) {
                if (real.get((Object)i).type == model.get((Object)i).type) continue;
                System.out.println(String.valueOf(pdb) + " @ " + i + " real = " + (Object)((Object)real.get((Object)i).type) + " model = " + (Object)((Object)model.get((Object)i).type));
            }
        }
    }
}

