/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Residue;
import docking.CompareHash;
import docking.DockingAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class ContactPrediction {
    private static final String userdir = System.getProperty("user.dir");
    private static final String temp_dir = String.valueOf(userdir) + "/temp_dump";
    private static final String temp_AB = String.valueOf(temp_dir) + "/tempAB2.txt";
    private static final String temp_AG = String.valueOf(temp_dir) + "/tempAG2.txt";
    private static final String main_fold = "/Volumes/D/results_p_zdock";

    public static void main(String[] args) {
    }

    public static void recalculateContactData() {
        ArrayList<String> cases = FileSystemTools.getFolders(main_fold);
        for (String _case : cases) {
            ContactPrediction.CollectSingleData(50, _case, true);
            ContactPrediction.CollectSingleData(50, _case, false);
            ContactPrediction.CollectPairData(50, _case, true);
            ContactPrediction.CollectPairData(50, _case, false);
        }
    }

    public static SingleEntry getTopIPATCH(String _case, String pdb_code, int n) {
        String res_fold = "/Volumes/D/results_p_zdock/" + _case;
        String file = String.valueOf(res_fold) + "/" + pdb_code + "/output/complex.1.pdb";
        DockingAnalyzer.createTemp(file, "2");
        HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
        HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
        HashMap<Integer, Integer> ab_con = new HashMap<Integer, Integer>();
        for (int z : ab.keySet()) {
            ab_con.put(z, 0);
        }
        HashMap<Integer, Integer> ag_con = new HashMap<Integer, Integer>();
        for (int z : ag.keySet()) {
            ag_con.put(z, 0);
        }
        HashMap<Integer, Integer> ipatchmap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> ipatchmap2 = new HashMap<Integer, Integer>();
        double[][] pair_cons = new double[500][500];
        int i = 1;
        while (i < 20) {
            file = String.valueOf(res_fold) + "/" + pdb_code + "/output/complex." + i + ".pdb";
            int file_ind = Integer.parseInt(file.substring(file.indexOf(".") + 1, file.lastIndexOf(".")));
            DockingAnalyzer.createTemp(file, "2");
            ab = PDB_parser.parse(temp_AB);
            ag = PDB_parser.parse(temp_AG);
            int score = ContactPrediction.calculateIPATCH(_case, pdb_code, ab, ag);
            ipatchmap.put(i, score);
            ipatchmap2.put(i, score);
            ++i;
        }
        HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
        int i2 = 1;
        while (i2 < 201) {
            indexes.put(i2, i2);
            ++i2;
        }
        HashMap<Integer, Integer> sorted = CompareHash.sort(ipatchmap, indexes);
        int j = 1;
        while (j < n + 1) {
            int i3 = sorted.get(j);
            file = String.valueOf(res_fold) + "/" + pdb_code + "/output/complex." + i3 + ".pdb";
            int file_ind = Integer.parseInt(file.substring(file.indexOf(".") + 1, file.lastIndexOf(".")));
            DockingAnalyzer.createTemp(file, "2");
            ab = PDB_parser.parse(temp_AB);
            ag = PDB_parser.parse(temp_AG);
            ArrayList<Integer> dups_ab = new ArrayList<Integer>();
            ArrayList<Integer> dups_ag = new ArrayList<Integer>();
            for (Integer ab_i : ab.keySet()) {
                Residue ab_r = ab.get(ab_i);
                for (Integer ag_i : ag.keySet()) {
                    Residue ag_r = ag.get(ag_i);
                    if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                    if (!dups_ab.contains(ab_i)) {
                        if (!ab_con.containsKey(ab_i)) {
                            ab_con.put(ab_i, 0);
                        }
                        ab_con.put(ab_i, ab_con.get(ab_i) + 1);
                        dups_ab.add(ab_i);
                    }
                    if (!dups_ag.contains(ag_i)) {
                        if (!ag_con.containsKey(ag_i)) {
                            ag_con.put(ag_i, 0);
                        }
                        ag_con.put(ag_i, ag_con.get(ag_i) + 1);
                        dups_ag.add(ag_i);
                    }
                    double[] dArray = pair_cons[ab_i];
                    int n2 = ag_i;
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
            ++j;
        }
        SingleEntry se = new SingleEntry(pdb_code, _case, ab_con, ag_con, pair_cons);
        return se;
    }

    public static void CollectPairData(int cuts, String _case, boolean ipatch) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/Temp/case_5H");
        HashMap<Integer, Double> tp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> fp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> fn = new HashMap<Integer, Double>();
        int j = 0;
        while (j < cuts) {
            tp.put(j, 0.0);
            fp.put(j, 0.0);
            fn.put(j, 0.0);
            ++j;
        }
        int prog = 0;
        String res_fold = String.valueOf(userdir) + "/result_dump/Docking/ContactPreds/" + _case;
        File f = new File(res_fold);
        if (!f.exists()) {
            f.mkdir();
        }
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(_case) + " Prog= " + ++prog);
            SingleEntry se = null;
            se = ipatch ? ContactPrediction.getTopIPATCH(_case, pdb, 10) : ContactPrediction.getTopZDOCK(_case, pdb, 10);
            int[][] arr = DockingAnalyzer.getSpecificMatrix(pdb);
            int cutoff = 0;
            while (cutoff < cuts) {
                int _tp = 0;
                int _fp = 0;
                int _fn = 0;
                for (Integer i_ab : se.ab.keySet()) {
                    for (Integer i_ag : se.ag.keySet()) {
                        if (se.cons[i_ab][i_ag] > (double)cutoff && arr[i_ab][i_ag] != 0) {
                            ++_tp;
                        }
                        if (se.cons[i_ab][i_ag] > (double)cutoff && arr[i_ab][i_ag] == 0) {
                            ++_fp;
                        }
                        if (!(se.cons[i_ab][i_ag] < (double)cutoff) || arr[i_ab][i_ag] == 0) continue;
                        ++_fn;
                    }
                }
                tp.put(cutoff, (Double)tp.get(cutoff) + (double)_tp);
                fp.put(cutoff, (Double)fp.get(cutoff) + (double)_fp);
                fn.put(cutoff, (Double)fn.get(cutoff) + (double)_fn);
                ++cutoff;
            }
        }
        String pair_all = "";
        int i = 0;
        while (i < cuts) {
            pair_all = String.valueOf(pair_all) + i + " " + (Double)tp.get(i) / ((Double)tp.get(i) + (Double)fp.get(i)) * 100.0 + " " + (Double)tp.get(i) / ((Double)tp.get(i) + (Double)fn.get(i)) * 100.0 + "\n";
            System.out.println("PAIR==========");
            System.out.println(String.valueOf(i) + "(PR) : " + (Double)tp.get(i) / ((Double)tp.get(i) + (Double)fp.get(i)) * 100.0);
            System.out.println(String.valueOf(i) + "(RE) : " + (Double)tp.get(i) / ((Double)tp.get(i) + (Double)fn.get(i)) * 100.0);
            System.out.println("==========");
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(res_fold) + "/allPAIR" + "_" + (ipatch ? "I" : "Z") + "_.txt", pair_all);
    }

    public static void CompareOld(int cutoff, String _case, boolean ipatch) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/Temp/case_5H");
        String iter_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/Iterative_cases/ag_" + cutoff;
        boolean prog = false;
        double tp_tot = 0.0;
        double fn_tot = 0.0;
        double fp_tot = 0.0;
        System.out.println(String.valueOf(_case) + "@" + cutoff);
        for (String pdb : pdbs) {
            SingleEntry se = null;
            se = ipatch ? ContactPrediction.getTopIPATCH(_case, pdb, 10) : ContactPrediction.getTopZDOCK(_case, pdb, 10);
            ArrayList<Integer> ag_c = ContactPrediction.getSingleCons(pdb, "epitope.txt");
            ArrayList<Integer> old_cons = new ArrayList<Integer>();
            ArrayList<String> list = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/newnew_cases/" + _case + "/" + pdb + "/epitope_z.txt");
            for (String line : list) {
                old_cons.add(Integer.parseInt(line));
            }
            double tp = 0.0;
            double fp = 0.0;
            double fn = 0.0;
            boolean eliminated = false;
            for (Integer i : se.ag.keySet()) {
                if (!old_cons.contains(i) && ag_c.contains(i)) {
                    tp += 1.0;
                    tp_tot += 1.0;
                }
                if (!old_cons.contains(i) && !ag_c.contains(i)) {
                    fp += 1.0;
                    fp_tot += 1.0;
                }
                if (!old_cons.contains(i) || !ag_c.contains(i)) continue;
                fn += 1.0;
                fn_tot += 1.0;
            }
        }
        System.out.println(String.valueOf(cutoff) + " PR= " + tp_tot / (tp_tot + fp_tot) + " RE=" + tp_tot / (tp_tot + fn_tot) + "\n");
    }

    public static void CollectSingleCase(int cutoff, String _case, boolean ipatch) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/Temp/case_5H");
        String iter_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/Iterative_cases/ag_" + cutoff;
        boolean prog = false;
        double tp_tot = 0.0;
        double fn_tot = 0.0;
        double fp_tot = 0.0;
        System.out.println(String.valueOf(_case) + "@" + cutoff);
        for (String pdb : pdbs) {
            SingleEntry se = null;
            se = ipatch ? ContactPrediction.getTopIPATCH(_case, pdb, 10) : ContactPrediction.getTopZDOCK(_case, pdb, 10);
            ArrayList<Integer> ag_c = ContactPrediction.getSingleCons(pdb, "epitope.txt");
            ArrayList<Integer> old_cons = new ArrayList<Integer>();
            ArrayList<String> list = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/newnew_cases/" + _case + "/" + pdb + "/epitope_z.txt");
            for (String line : list) {
                old_cons.add(Integer.parseInt(line));
            }
            String contacts = "";
            double tp = 0.0;
            double fp = 0.0;
            double fn = 0.0;
            boolean eliminated = false;
            for (Integer i : se.ag.keySet()) {
                if (se.ag.get(i) < cutoff) {
                    contacts = String.valueOf(contacts) + i + "\n";
                }
                if (se.ag.get(i) > cutoff && ag_c.contains(i)) {
                    tp += 1.0;
                    tp_tot += 1.0;
                }
                if (se.ag.get(i) > cutoff && !ag_c.contains(i)) {
                    fp += 1.0;
                    fp_tot += 1.0;
                }
                if (se.ag.get(i) >= cutoff || !ag_c.contains(i)) continue;
                fn += 1.0;
                fn_tot += 1.0;
            }
            FileSystemTools.writeFile(String.valueOf(iter_fold) + "/" + _case + "/" + pdb + "/epitope_z.txt", contacts);
        }
        System.out.println(String.valueOf(cutoff) + " PR= " + tp_tot / (tp_tot + fp_tot) + " RE=" + tp_tot / (tp_tot + fn_tot) + "\n");
    }

    public static void CollectSingleData(int cuts, String _case, boolean ipatch) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/Temp/case_5H");
        HashMap<Integer, Double> abmap_tp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> abmap_fp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> abmap_fn = new HashMap<Integer, Double>();
        HashMap<Integer, Double> agmap_tp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> agmap_fp = new HashMap<Integer, Double>();
        HashMap<Integer, Double> agmap_fn = new HashMap<Integer, Double>();
        int j = 0;
        while (j < cuts) {
            abmap_tp.put(j, 0.0);
            abmap_fp.put(j, 0.0);
            abmap_fn.put(j, 0.0);
            agmap_tp.put(j, 0.0);
            agmap_fp.put(j, 0.0);
            agmap_fn.put(j, 0.0);
            ++j;
        }
        int prog = 0;
        String res_fold = String.valueOf(userdir) + "/result_dump/Docking/ContactPreds/" + _case;
        File f = new File(res_fold);
        if (!f.exists()) {
            f.mkdir();
        }
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(_case) + " Prog= " + ++prog);
            SingleEntry se = null;
            se = ipatch ? ContactPrediction.getTopIPATCH(_case, pdb, 10) : ContactPrediction.getTopZDOCK(_case, pdb, 10);
            ArrayList<Integer> ab_c = ContactPrediction.getSingleCons(pdb, "paratope.txt");
            ArrayList<Integer> ag_c = ContactPrediction.getSingleCons(pdb, "epitope.txt");
            String ab_out = "";
            int cutoff = 0;
            while (cutoff < cuts) {
                double tp = 0.0;
                double fp = 0.0;
                double fn = 0.0;
                for (Integer i : se.ab.keySet()) {
                    if (se.ab.get(i) > cutoff && ab_c.contains(i)) {
                        tp += 1.0;
                    }
                    if (se.ab.get(i) > cutoff && !ab_c.contains(i)) {
                        fp += 1.0;
                    }
                    if (se.ab.get(i) >= cutoff || !ab_c.contains(i)) continue;
                    fn += 1.0;
                }
                ab_out = String.valueOf(ab_out) + cutoff + " " + tp / (tp + fp) + " " + tp / (tp + fn) + "\n";
                abmap_tp.put(cutoff, (Double)abmap_tp.get(cutoff) + tp);
                abmap_fp.put(cutoff, (Double)abmap_fp.get(cutoff) + fp);
                abmap_fn.put(cutoff, (Double)abmap_fn.get(cutoff) + fn);
                ++cutoff;
            }
            FileSystemTools.writeFile(String.valueOf(res_fold) + "/" + pdb + "_" + (ipatch ? "I" : "Z") + "_ab.txt", ab_out);
            String ag_out = "";
            int cutoff2 = 0;
            while (cutoff2 < 11) {
                double tp = 0.0;
                double fp = 0.0;
                double fn = 0.0;
                for (Integer i : se.ag.keySet()) {
                    if (se.ag.get(i) > cutoff2 && ag_c.contains(i)) {
                        tp += 1.0;
                    }
                    if (se.ag.get(i) > cutoff2 && !ag_c.contains(i)) {
                        fp += 1.0;
                    }
                    if (se.ag.get(i) >= cutoff2 || !ag_c.contains(i)) continue;
                    fn += 1.0;
                }
                agmap_tp.put(cutoff2, (Double)agmap_tp.get(cutoff2) + tp);
                agmap_fp.put(cutoff2, (Double)agmap_fp.get(cutoff2) + fp);
                agmap_fn.put(cutoff2, (Double)agmap_fn.get(cutoff2) + fn);
                ag_out = String.valueOf(ag_out) + cutoff2 + " " + tp / (tp + fp) + " " + tp / (tp + fn) + "\n";
                ++cutoff2;
            }
            FileSystemTools.writeFile(String.valueOf(res_fold) + "/" + pdb + "_" + (ipatch ? "I" : "Z") + "_ag.txt", ag_out);
        }
        String all_ab = "";
        int i = 0;
        while (i < cuts) {
            all_ab = String.valueOf(all_ab) + i + " " + (Double)abmap_tp.get(i) / ((Double)abmap_tp.get(i) + (Double)abmap_fp.get(i)) + " " + (Double)abmap_tp.get(i) / ((Double)abmap_tp.get(i) + (Double)abmap_fn.get(i)) + "\n";
            System.out.println("AB==========");
            System.out.println(String.valueOf(i) + "(PR) : " + (Double)abmap_tp.get(i) / ((Double)abmap_tp.get(i) + (Double)abmap_fp.get(i)) * 100.0);
            System.out.println(String.valueOf(i) + "(RE) : " + (Double)abmap_tp.get(i) / ((Double)abmap_tp.get(i) + (Double)abmap_fn.get(i)) * 100.0);
            System.out.println("==========");
            ++i;
        }
        String all_ag = "";
        int i2 = 0;
        while (i2 < cuts) {
            all_ag = String.valueOf(all_ag) + i2 + " " + (Double)agmap_tp.get(i2) / ((Double)agmap_tp.get(i2) + (Double)agmap_fp.get(i2)) + " " + (Double)agmap_tp.get(i2) / ((Double)agmap_tp.get(i2) + (Double)agmap_fn.get(i2)) + "\n";
            System.out.println("AG==========");
            System.out.println(String.valueOf(i2) + "(PR) : " + (Double)agmap_tp.get(i2) / ((Double)agmap_tp.get(i2) + (Double)agmap_fp.get(i2)) * 100.0);
            System.out.println(String.valueOf(i2) + "(RE) : " + (Double)agmap_tp.get(i2) / ((Double)agmap_tp.get(i2) + (Double)agmap_fn.get(i2)) * 100.0);
            System.out.println("==========");
            ++i2;
        }
        FileSystemTools.writeFile(String.valueOf(res_fold) + "/all" + "_" + (ipatch ? "I" : "Z") + "_ab.txt", all_ab);
        FileSystemTools.writeFile(String.valueOf(res_fold) + "/all" + "_" + (ipatch ? "I" : "Z") + "_ag.txt", all_ag);
    }

    public static int calculateIPATCH(String _case, String pdb_code, HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        ArrayList<String> lines = FileSystemTools.readFile("/Volumes/D/results_p_zdock/" + _case + "/" + pdb_code + "/paratope_z.txt");
        ArrayList<Integer> ip_ab = new ArrayList<Integer>();
        for (String line : lines) {
            ip_ab.add(Integer.parseInt(line));
        }
        lines = FileSystemTools.readFile("/Volumes/D/results_p_zdock/" + _case + "/" + pdb_code + "/epitope_z.txt");
        ArrayList<Integer> ip_ag = new ArrayList<Integer>();
        for (String line : lines) {
            ip_ag.add(Integer.parseInt(line));
        }
        int score = 0;
        for (Integer ab_i : ab.keySet()) {
            Residue r_ab = ab.get(ab_i);
            for (Integer ag_i : ag.keySet()) {
                Residue r_ag = ag.get(ag_i);
                if (!(r_ab.distanceFrom(r_ag) < 4.5) || ip_ab.contains(ab_i) || ip_ag.contains(ag_i)) continue;
                ++score;
            }
        }
        return score;
    }

    public static SingleEntry getTopZDOCK(String _case, String pdb_code, int n) {
        String res_fold = "/Volumes/D/results_p_zdock/" + _case;
        String file = String.valueOf(res_fold) + "/" + pdb_code + "/output/complex.1.pdb";
        DockingAnalyzer.createTemp(file, "2");
        HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
        HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
        HashMap<Integer, Integer> ab_con = new HashMap<Integer, Integer>();
        for (int z : ab.keySet()) {
            ab_con.put(z, 0);
        }
        HashMap<Integer, Integer> ag_con = new HashMap<Integer, Integer>();
        for (int z : ag.keySet()) {
            ag_con.put(z, 0);
        }
        double[][] pair_cons = new double[500][500];
        int i = 1;
        while (i < n + 1) {
            file = String.valueOf(res_fold) + "/" + pdb_code + "/output/complex." + i + ".pdb";
            DockingAnalyzer.createTemp(file, "2");
            ab = PDB_parser.parse(temp_AB);
            ag = PDB_parser.parse(temp_AG);
            ArrayList<Integer> dups_ab = new ArrayList<Integer>();
            ArrayList<Integer> dups_ag = new ArrayList<Integer>();
            for (Integer ab_i : ab.keySet()) {
                Residue ab_r = ab.get(ab_i);
                for (Integer ag_i : ag.keySet()) {
                    Residue ag_r = ag.get(ag_i);
                    if (!(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                    if (!dups_ab.contains(ab_i)) {
                        if (!ab_con.containsKey(ab_i)) {
                            ab_con.put(ab_i, 0);
                        }
                        ab_con.put(ab_i, ab_con.get(ab_i) + 1);
                        dups_ab.add(ab_i);
                    }
                    if (!dups_ag.contains(ag_i)) {
                        if (!ag_con.containsKey(ag_i)) {
                            ag_con.put(ag_i, 0);
                        }
                        ag_con.put(ag_i, ag_con.get(ag_i) + 1);
                        dups_ag.add(ag_i);
                    }
                    double[] dArray = pair_cons[ab_i];
                    int n2 = ag_i;
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
            ++i;
        }
        SingleEntry se = new SingleEntry(pdb_code, _case, ab_con, ag_con, pair_cons);
        return se;
    }

    public static ArrayList<Integer> getSingleCons(String _pdb, String epipara) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + _pdb + "/" + epipara);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            line = line.replace(" A", "");
            int con = Integer.parseInt(line);
            cons.add(con);
        }
        return cons;
    }

    public static class SingleEntry {
        public final String pdb_code;
        public final String _case;
        public final HashMap<Integer, Integer> ab;
        public final HashMap<Integer, Integer> ag;
        public final double[][] cons;

        public SingleEntry(String _pdb, String _c, HashMap<Integer, Integer> _ab, HashMap<Integer, Integer> _ag, double[][] _cons) {
            this.pdb_code = _pdb;
            this._case = _c;
            this.ab = _ab;
            this.ag = _ag;
            this.cons = _cons;
        }
    }
}

