/*
 * Decompiled with CFR 0.152.
 */
package domain_analysis;

import data_structures.Residue;
import data_structures.SC_Structure;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;

public class Domain_parser {
    private static int[] AA_props_con = new int[20];
    private static int[] AA_props_non = new int[20];
    private static int[][] PAIR_props_con = new int[20][20];
    private static int[][] PAIR_props_non = new int[20][20];
    private static int[][] w_intra_con = new int[20][20];
    private static int[][] w_intra_non = new int[20][20];
    private static int[][][] TRI_props_con = new int[20][20][20];
    private static int[][][] TRI_props_non = new int[20][20][20];
    private static int[][][] w_pair_con = new int[20][20][20];
    private static int[][][] w_pair_non = new int[20][20][20];

    public static void main(String[] args) {
        int index_h;
        int index = 0;
        while (index < AA_props_con.length) {
            Domain_parser.AA_props_con[index] = 0;
            Domain_parser.AA_props_non[index] = 0;
            ++index;
        }
        int index_v = 0;
        while (index_v < 20) {
            index_h = 0;
            while (index_h < 20) {
                Domain_parser.PAIR_props_con[index_v][index_h] = 0;
                Domain_parser.PAIR_props_non[index_v][index_h] = 0;
                ++index_h;
            }
            ++index_v;
        }
        index_v = 0;
        while (index_v < 20) {
            index_h = 0;
            while (index_h < 20) {
                int index_s = 0;
                while (index_s < 20) {
                    Domain_parser.TRI_props_con[index_v][index_h][index_s] = 0;
                    Domain_parser.TRI_props_non[index_v][index_h][index_s] = 0;
                    ++index_s;
                }
                ++index_h;
            }
            ++index_v;
        }
        double start = System.currentTimeMillis();
        Domain_parser.parseDomainFile(null);
        Domain_parser.parseComplexFile(null);
        System.out.println(String.valueOf(((double)System.currentTimeMillis() - start) / 1000.0) + "s for 10 runs");
    }

    private static void printResults() {
        System.out.println("Triangles con:");
        int index_v = 0;
        while (index_v < 20) {
            int indexo = index_v + 1;
            System.out.print("tri_con(:,:," + indexo + ")=[");
            int index_h = 0;
            while (index_h < 20) {
                int index_s = 0;
                while (index_s < 20) {
                    System.out.print(String.valueOf(TRI_props_con[index_v][index_h][index_s]) + " ");
                    ++index_s;
                }
                System.out.println(";");
                ++index_h;
            }
            System.out.println("];");
            ++index_v;
        }
    }

    public static void parseDomainFile(String file_name) {
        if (file_name == null) {
            file_name = "/home/markov/krawczyk/Desktop/domain_analysis/domains_from_qiang";
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(file_name);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double progress = 0.0;
            while ((s = dis.readLine()) != null) {
                double d = progress;
                progress = d + 1.0;
                System.out.println(d / 1827.0 * 100.0);
                s = s.toUpperCase();
                String pdb_code = s.substring(0, 4);
                String domain_data = s.substring(s.indexOf("=") + 1);
                System.out.println(s);
                String domain_1 = domain_data.substring(0, domain_data.indexOf("_"));
                String domain_2 = domain_data.substring(domain_data.indexOf("_") + 1);
                char chain_1 = domain_1.charAt(0);
                char chain_2 = domain_2.charAt(0);
                domain_1 = domain_1.substring(2);
                domain_2 = domain_2.substring(2);
                int start_1 = Integer.parseInt(domain_1.substring(0, domain_1.indexOf("-")));
                int start_2 = Integer.parseInt(domain_2.substring(0, domain_2.indexOf("-")));
                int end_1 = Integer.parseInt(domain_1.substring(domain_1.indexOf("-") + 1));
                int end_2 = Integer.parseInt(domain_2.substring(domain_2.indexOf("-") + 1));
                ArrayList<Integer> roi_1 = new ArrayList<Integer>();
                ArrayList<Integer> roi_2 = new ArrayList<Integer>();
                int i = start_1;
                while (i <= end_1) {
                    roi_1.add(i);
                    ++i;
                }
                int j = start_2;
                while (j <= end_2) {
                    roi_2.add(j);
                    ++j;
                }
                String constraining_1 = "/home/markov/krawczyk/Desktop/const_1";
                String constraining_2 = "/home/markov/krawczyk/Desktop/const_2";
                PDB_parser.writeConstrainingPDB("/data/martial/krawczyk/data/scop_pdbs/" + pdb_code + ".pdb", constraining_1, null, chain_1);
                PDB_parser.writeConstrainingPDB("/data/martial/krawczyk/data/scop_pdbs/" + pdb_code + ".pdb", constraining_2, null, chain_2);
                HashMap<Integer, Boolean> accepted_1 = PSA.runPSA(7.0, constraining_1);
                HashMap<Integer, Boolean> accepted_2 = PSA.runPSA(7.0, constraining_2);
                HashMap<Integer, Residue> residues_tmp1 = PDB_parser.parse(constraining_1, roi_1, chain_1);
                HashMap<Integer, Residue> residues_tmp2 = PDB_parser.parse(constraining_2, roi_2, chain_2);
                HashMap<Integer, Residue> residues_1 = new HashMap<Integer, Residue>();
                HashMap<Integer, Residue> residues_2 = new HashMap<Integer, Residue>();
                for (Integer i2 : residues_tmp1.keySet()) {
                    if (!accepted_1.containsKey(i2) || !accepted_1.get(i2).booleanValue()) continue;
                    residues_1.put(i2, residues_tmp1.get(i2));
                }
                for (Integer i2 : residues_tmp2.keySet()) {
                    if (!accepted_2.containsKey(i2) || !accepted_2.get(i2).booleanValue()) continue;
                    residues_2.put(i2, residues_tmp2.get(i2));
                }
                SC_Structure s_1 = new SC_Structure(residues_1, null, true, chain_1);
                SC_Structure s_2 = new SC_Structure(residues_2, null, true, chain_2);
                Domain_parser.calculateNeighbors(s_1, s_2);
                Domain_parser.printResults();
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void parseComplexFile(String file_name) {
        if (file_name == null) {
            file_name = "/home/markov/krawczyk/Desktop/domain_analysis/complex_from_qiang";
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(file_name);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double progress = 677.0;
            while ((s = dis.readLine()) != null) {
                double d = progress;
                progress = d + 1.0;
                System.out.println(d / 1827.0 * 100.0);
                s = s.toUpperCase();
                String pdb_code = s.substring(0, 4);
                String chains = PDB_parser.getChains("/data/martial/krawczyk/data/complex_pdbs/" + pdb_code + ".pdb");
                System.out.println(pdb_code);
                String constraining_1 = "/home/markov/krawczyk/Desktop/const_1";
                String constraining_2 = "/home/markov/krawczyk/Desktop/const_2";
                PDB_parser.writeConstrainingPDB("/data/martial/krawczyk/data/complex_pdbs/" + pdb_code + ".pdb", constraining_1, null, chains.charAt(0));
                PDB_parser.writeConstrainingPDB("/data/martial/krawczyk/data/complex_pdbs/" + pdb_code + ".pdb", constraining_2, null, chains.charAt(1));
                HashMap<Integer, Boolean> accepted_1 = PSA.runPSA(7.0, constraining_1);
                HashMap<Integer, Boolean> accepted_2 = PSA.runPSA(7.0, constraining_2);
                System.out.println(chains);
                System.out.println("Accepted_1 " + accepted_1.size());
                System.out.println("Accepted_2 " + accepted_2.size());
                HashMap<Integer, Residue> residues_tmp1 = PDB_parser.parse(constraining_1, null, chains.charAt(0));
                HashMap<Integer, Residue> residues_tmp2 = PDB_parser.parse(constraining_2, null, chains.charAt(1));
                HashMap<Integer, Residue> residues_1 = new HashMap<Integer, Residue>();
                HashMap<Integer, Residue> residues_2 = new HashMap<Integer, Residue>();
                for (Integer i : residues_tmp1.keySet()) {
                    if (!accepted_1.containsKey(i) || !accepted_1.get(i).booleanValue()) continue;
                    residues_1.put(i, residues_tmp1.get(i));
                }
                for (Integer i : residues_tmp2.keySet()) {
                    if (!accepted_2.containsKey(i) || !accepted_2.get(i).booleanValue()) continue;
                    residues_2.put(i, residues_tmp2.get(i));
                }
                SC_Structure s_1 = new SC_Structure(residues_1, null, true, chains.charAt(0));
                SC_Structure s_2 = new SC_Structure(residues_2, null, true, chains.charAt(1));
                Domain_parser.calculateNeighbors(s_1, s_2);
                Domain_parser.printResults();
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void calculateNeighbors(SC_Structure s1, SC_Structure s2) {
        int index_s;
        int index_h;
        int index_v;
        boolean added;
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s1.keySet()) {
            added = false;
            residues_s1.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5) {
                    added = true;
                    residues_s1.get((Object)i).isContact = true;
                    int[] nArray = PAIR_props_con[residues_s1.get((Object)i).type.ordinal()];
                    int n = residues_s2.get((Object)j).type.ordinal();
                    nArray[n] = nArray[n] + 1;
                    if (residues_s1.get((Object)i).type.ordinal() != residues_s2.get((Object)j).type.ordinal()) {
                        // empty if block
                    }
                    int[] nArray2 = PAIR_props_con[residues_s2.get((Object)j).type.ordinal()];
                    int n2 = residues_s1.get((Object)i).type.ordinal();
                    nArray2[n2] = nArray2[n2] + 1;
                    for (Integer k : residues_s1.keySet()) {
                        index_v = residues_s1.get((Object)i).type.ordinal();
                        index_h = residues_s1.get((Object)k).type.ordinal();
                        index_s = residues_s2.get((Object)j).type.ordinal();
                        if (residues_s1.get(k).distanceFrom(residues_s1.get(i)) < 4.5 && residues_s1.get(k).distanceFrom(residues_s2.get(j)) < 4.5) {
                            if (k == i) continue;
                            int[] nArray3 = TRI_props_con[index_h][index_v];
                            int n3 = index_s;
                            nArray3[n3] = nArray3[n3] + 1;
                            continue;
                        }
                        if (k == i) continue;
                        int[] nArray4 = TRI_props_non[index_h][index_v];
                        int n4 = index_s;
                        nArray4[n4] = nArray4[n4] + 1;
                    }
                    continue;
                }
                for (Integer k : residues_s1.keySet()) {
                    index_v = residues_s1.get((Object)i).type.ordinal();
                    index_h = residues_s1.get((Object)k).type.ordinal();
                    index_s = residues_s2.get((Object)j).type.ordinal();
                    if (k == i) continue;
                    int[] nArray = TRI_props_non[index_h][index_v];
                    int n = index_s;
                    nArray[n] = nArray[n] + 1;
                }
                int[] nArray = PAIR_props_non[residues_s1.get((Object)i).type.ordinal()];
                int n = residues_s2.get((Object)j).type.ordinal();
                nArray[n] = nArray[n] + 1;
                if (residues_s1.get((Object)i).type.ordinal() != residues_s2.get((Object)j).type.ordinal()) {
                    // empty if block
                }
                int[] nArray5 = PAIR_props_non[residues_s2.get((Object)j).type.ordinal()];
                int n5 = residues_s1.get((Object)i).type.ordinal();
                nArray5[n5] = nArray5[n5] + 1;
            }
            if (added) {
                int n = residues_s1.get((Object)i).type.ordinal();
                AA_props_con[n] = AA_props_con[n] + 1;
                for (Integer ind_n : residues_s1.keySet()) {
                    if (!(residues_s1.get(i).distanceFrom(residues_s1.get(ind_n)) < 4.5)) continue;
                    int[] nArray = w_intra_con[residues_s1.get((Object)i).type.ordinal()];
                    int n6 = residues_s1.get((Object)ind_n).type.ordinal();
                    nArray[n6] = nArray[n6] + 1;
                }
                continue;
            }
            int n = residues_s1.get((Object)i).type.ordinal();
            AA_props_non[n] = AA_props_non[n] + 1;
            for (Integer ind_n : residues_s1.keySet()) {
                if (!(residues_s1.get(i).distanceFrom(residues_s1.get(ind_n)) < 4.5)) continue;
                int[] nArray = w_intra_non[residues_s1.get((Object)i).type.ordinal()];
                int n7 = residues_s1.get((Object)ind_n).type.ordinal();
                nArray[n7] = nArray[n7] + 1;
            }
        }
        for (Integer i : residues_s2.keySet()) {
            added = false;
            residues_s2.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5) {
                    added = true;
                    residues_s2.get((Object)i).isContact = true;
                    for (Integer k : residues_s2.keySet()) {
                        index_v = residues_s2.get((Object)i).type.ordinal();
                        index_h = residues_s2.get((Object)k).type.ordinal();
                        index_s = residues_s1.get((Object)j).type.ordinal();
                        if (residues_s2.get(k).distanceFrom(residues_s2.get(i)) < 4.5 && residues_s2.get(k).distanceFrom(residues_s1.get(j)) < 4.5) {
                            if (k == i) continue;
                            int[] nArray = TRI_props_con[index_h][index_v];
                            int n = index_s;
                            nArray[n] = nArray[n] + 1;
                            continue;
                        }
                        if (k == i) continue;
                        int[] nArray = TRI_props_non[index_h][index_v];
                        int n = index_s;
                        nArray[n] = nArray[n] + 1;
                    }
                    continue;
                }
                for (Integer k : residues_s2.keySet()) {
                    index_v = residues_s2.get((Object)i).type.ordinal();
                    index_h = residues_s2.get((Object)k).type.ordinal();
                    index_s = residues_s1.get((Object)j).type.ordinal();
                    if (k == i) continue;
                    int[] nArray = TRI_props_non[index_h][index_v];
                    int n = index_s;
                    nArray[n] = nArray[n] + 1;
                }
            }
            if (added) {
                int n = residues_s2.get((Object)i).type.ordinal();
                AA_props_con[n] = AA_props_con[n] + 1;
                for (Integer ind_n : residues_s2.keySet()) {
                    if (!(residues_s2.get(i).distanceFrom(residues_s2.get(ind_n)) < 4.5)) continue;
                    int[] nArray = w_intra_con[residues_s2.get((Object)i).type.ordinal()];
                    int n8 = residues_s2.get((Object)ind_n).type.ordinal();
                    nArray[n8] = nArray[n8] + 1;
                }
                continue;
            }
            int n = residues_s2.get((Object)i).type.ordinal();
            AA_props_non[n] = AA_props_non[n] + 1;
            for (Integer ind_n : residues_s2.keySet()) {
                if (!(residues_s2.get(i).distanceFrom(residues_s2.get(ind_n)) < 4.5)) continue;
                int[] nArray = w_intra_non[residues_s2.get((Object)i).type.ordinal()];
                int n9 = residues_s2.get((Object)ind_n).type.ordinal();
                nArray[n9] = nArray[n9] + 1;
            }
        }
    }
}

