/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Atom;
import data_structures.Residue;
import docking.Visualization;
import docking_global.ADARS;
import docking_global.DockingDistances;
import docking_global.GraphCreator;
import docking_global.PrepareData;
import dockingfurther.PropensityCalculation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class EpitopeSelector {
    private static final String userdir = System.getProperty("user.dir");
    private static double perc_cutoff = 0.5;

    public static void main(String[] args) {
        System.out.println("Running");
        EpitopeSelector.CreateGlobalDockingTestSetFull(1, 0.5, 1);
    }

    public static void standardizationCode() {
        String pdb_code = "2jix";
        char chain = 'D';
        HashMap<Integer, Residue> pdb = PDB_parser.parse("/Users/bielasek/Desktop/" + pdb_code + ".pdb", chain);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : pdb.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> output = new ArrayList<String>();
        for (Integer i : sorted) {
            for (Atom a : pdb.get((Object)i).atoms) {
                output.add(a.pdb_line);
            }
        }
        pdb = PDB_parser.parse("/Users/bielasek/Desktop/" + pdb_code + ".pdb", 'G');
        sorted = new TreeSet();
        for (Integer i : pdb.keySet()) {
            sorted.add(i);
        }
        for (Integer i : sorted) {
            for (Atom a : pdb.get((Object)i).atoms) {
                output.add(a.pdb_line);
            }
        }
        FileSystemTools.writeFile("/Users/bielasek/Desktop/temp.pdb", output);
        PDB_parser.standardizePDB("/Users/bielasek/Desktop/temp.pdb", "/Users/bielasek/Desktop/" + pdb_code + "_A.pdb", 'A');
        System.out.println("Done");
    }

    public static SuperEpi PickBiggestRemove(ArrayList<PrepareData.Struct_maximization> epis, int N, int pdb_id) {
        int orig_n = N;
        int temp_n = N;
        TreeSet sorted = new TreeSet();
        double delta = 1.0E-4;
        double curr_max = -1.0;
        PrepareData.Struct_maximization best = null;
        for (PrepareData.Struct_maximization struc : epis) {
            if (!(struc.score > curr_max)) continue;
            curr_max = struc.score;
            best = struc;
        }
        epis.remove(best);
        return new SuperEpi("", best.epitope);
    }

    public static SuperEpi PickBiggest(ArrayList<PrepareData.Struct_maximization> epis, int N, int pdb_id) {
        int orig_n = N;
        int temp_n = N;
        HashMap<Double, PrepareData.Struct_maximization> epimap = new HashMap<Double, PrepareData.Struct_maximization>();
        TreeSet<Double> sorted = new TreeSet<Double>();
        double delta = 1.0E-4;
        for (PrepareData.Struct_maximization struc : epis) {
            if (epimap.containsKey(struc.score)) {
                struc.score += delta;
                delta += 1.0E-5;
            }
            epimap.put(struc.score, struc);
            sorted.add(struc.score);
        }
        ArrayList<PrepareData.Struct_maximization> top = new ArrayList<PrepareData.Struct_maximization>();
        for (Double d : sorted.descendingSet()) {
            if (temp_n > 0) {
                top.add((PrepareData.Struct_maximization)epimap.get(d));
                System.out.println("No. " + --temp_n + " has " + ((PrepareData.Struct_maximization)epimap.get((Object)d)).overlap);
            }
            if (temp_n == 0) break;
        }
        HashMap<PrepareData.Struct_maximization, Integer> overlaps = new HashMap<PrepareData.Struct_maximization, Integer>();
        int i = 0;
        while (i < top.size()) {
            PrepareData.Struct_maximization str_central = (PrepareData.Struct_maximization)top.get(i);
            int curr_overlaps = 0;
            for (PrepareData.Struct_maximization struct_maximization : top) {
                if (struct_maximization == str_central || !EpitopeSelector.overlap(str_central.epitope, struct_maximization.epitope)) continue;
                ++curr_overlaps;
            }
            overlaps.put(str_central, curr_overlaps);
            ++i;
        }
        int max = 0;
        PrepareData.Struct_maximization maximal = null;
        for (PrepareData.Struct_maximization str : overlaps.keySet()) {
            if ((Integer)overlaps.get(str) < max) continue;
            maximal = str;
            max = (Integer)overlaps.get(str);
        }
        ArrayList<Integer> super_epi = new ArrayList<Integer>();
        super_epi.addAll(maximal.epitope);
        for (PrepareData.Struct_maximization struct_maximization : overlaps.keySet()) {
            if (!EpitopeSelector.overlap(maximal.epitope, struct_maximization.epitope)) continue;
            for (Integer i2 : struct_maximization.epitope) {
                if (super_epi.contains(i2)) continue;
                super_epi.add(i2);
            }
        }
        SuperEpi superEpi = new SuperEpi("", super_epi);
        return superEpi;
    }

    public static void CreateTrainingSet() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        for (String pdb : pdbs) {
            if (pdb.toLowerCase().equals("1bgx")) continue;
            EpitopeSelector.CreateCase(pdb);
        }
    }

    public static void CreateCase(String pdb_code) {
        String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
        HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
        DockingDistances.extractCons(ab_sol, ag_sol);
        ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab_sol, 2.0);
        ArrayList<Integer> ag_cons = DockingDistances.augmentBinding(ag_sol, 5.0);
        System.out.println(String.valueOf(pdb_code) + " : " + ab_cons.size() + " : " + ag_cons.size());
        ArrayList<String> para = new ArrayList<String>();
        for (Integer i : ab_sol.keySet()) {
            if (ab_cons.contains(i)) continue;
            para.add("" + i);
        }
        File f = new File(String.valueOf(userdir) + "/resources/GlobalTraining/" + pdb_code);
        if (!f.exists()) {
            f.mkdir();
        }
        FileSystemTools.CopyFile(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", String.valueOf(userdir) + "/resources/GlobalTraining/" + pdb_code + "/AB.pdb");
        FileSystemTools.CopyFile(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", String.valueOf(userdir) + "/resources/GlobalTraining/" + pdb_code + "/AG.pdb");
        FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/GlobalTraining/" + pdb_code + "/paratope.txt", para);
    }

    public static ArrayList<PrepareData.Struct_maximization> GetEpitopesPonomStrucs(String pdb_code, int num_iterations, double cutoff_graph, int id) {
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        ArrayList<String> output = new ArrayList<String>();
        int depth = 3;
        int iterations = 0;
        while (iterations < num_iterations) {
            pdb_code = pdb_code.toUpperCase();
            double precision = 1.0;
            double overlap = 1.0;
            System.out.println("Doing pdb " + pdb_code + " iteration " + iterations);
            String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
            double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
            ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab_sol, 0.0);
            ArrayList<Integer> ag_cons_corr = DockingDistances.augmentBinding(ag_sol, 5.0);
            ArrayList<Integer> real_cons = DockingDistances.augmentBinding(ag_sol, 0.0);
            HashMap<Integer, Boolean> surface_exp = new HashMap();
            System.out.println("Getting the surface exposed residues for the antigen in " + pdb_code);
            surface_exp = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb");
            PrepareData.Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, ag_sol, depth, ag_cons_corr, 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            precision = struc.precision;
            overlap = struc.overlap;
            struc.correct = ag_cons_corr;
            struc.ag_size = ag_sol.size();
            struc.small_size = real_cons.size();
            struc.correct_epitope = real_cons;
            System.out.println("Ab cons = " + ab_cons.size() + " out of " + ab_sol.size());
            System.out.println("Ag cons = " + ag_cons.size() + " out of " + ag_sol.size());
            double[][] ab_dists = new double[ab_sol.size() + 1][ab_sol.size() + 1];
            double[][] ag_dists = new double[ag_sol.size() + 1][ag_sol.size() + 1];
            for (Integer ab_i_1 : ab_cons) {
                for (Integer ab_i_2 : ab_cons) {
                    if (ab_i_1 == ab_i_2) continue;
                    ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab_sol.get(ab_i_1).distanceFrom(ab_sol.get(ab_i_2));
                }
            }
            for (Integer ag_i_1 : ag_cons) {
                for (Integer ag_i_2 : ag_cons) {
                    if (ag_i_1 == ag_i_2) continue;
                    ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag_sol.get(ag_i_1).distanceFrom(ag_sol.get(ag_i_2));
                }
            }
            System.out.println("Creating the graph for " + pdb_code);
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab_sol, ag_sol, cons, ab_cons, ag_cons, ab_dists, ag_dists);
            String out_line = String.valueOf(cutoff_graph) + " " + Math.round(precision / 0.25) + " " + Math.round(overlap / 0.25) + " " + gs.score_sum_deg + " " + gs.score_sum_deg / gs.num_vertices + " " + id + " " + gs.score_sum_rd + " " + gs.score_sum_rd / gs.num_vertices + " " + ag_sol.size();
            System.out.println(out_line);
            System.out.println("Done with " + pdb_code + " iteration " + iterations);
            output.add(out_line);
            results.add(struc);
            ++iterations;
        }
        return results;
    }

    public static ArrayList<String> GetEpitopesPonom(String pdb_code, int num_iterations, double cutoff_graph, int id) {
        ArrayList<String> output = new ArrayList<String>();
        int depth = 3;
        int iterations = 0;
        while (iterations < num_iterations) {
            boolean prog = false;
            pdb_code = pdb_code.toUpperCase();
            double precision = 1.0;
            double overlap = 1.0;
            System.out.println("Doing pdb " + pdb_code + " iteration " + iterations);
            String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
            double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
            ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab_sol, 0.0);
            ArrayList<Integer> ag_cons_corr = DockingDistances.augmentBinding(ag_sol, 5.0);
            HashMap<Integer, Boolean> surface_exp = new HashMap();
            System.out.println("Getting the surface exposed residues for the antigen in " + pdb_code);
            surface_exp = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb");
            PrepareData.Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, ag_sol, depth, ag_cons_corr, 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            precision = struc.precision;
            overlap = struc.overlap;
            System.out.println("Ab cons = " + ab_cons.size() + " out of " + ab_sol.size());
            System.out.println("Ag cons = " + ag_cons.size() + " out of " + ag_sol.size());
            double[][] ab_dists = new double[ab_sol.size() + 1][ab_sol.size() + 1];
            double[][] ag_dists = new double[ag_sol.size() + 1][ag_sol.size() + 1];
            for (Integer ab_i_1 : ab_cons) {
                for (Integer ab_i_2 : ab_cons) {
                    if (ab_i_1 == ab_i_2) continue;
                    ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab_sol.get(ab_i_1).distanceFrom(ab_sol.get(ab_i_2));
                }
            }
            for (Integer ag_i_1 : ag_cons) {
                for (Integer ag_i_2 : ag_cons) {
                    if (ag_i_1 == ag_i_2) continue;
                    ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag_sol.get(ag_i_1).distanceFrom(ag_sol.get(ag_i_2));
                }
            }
            System.out.println("Creating the graph for " + pdb_code);
            double out_cut = cutoff_graph;
            out_cut = Math.round(out_cut);
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab_sol, ag_sol, cons, ab_cons, ag_cons, ab_dists, ag_dists);
            String out_line = String.valueOf(out_cut /= 10.0) + " " + Math.round(precision / 0.25) + " " + Math.round(overlap / 0.25) + " " + gs.score_sum_deg + " " + gs.score_sum_deg / gs.num_vertices + " " + id + " " + gs.score_sum_rd + " " + gs.score_sum_rd / gs.num_vertices + " " + ag_sol.size();
            System.out.println(out_line);
            System.out.println("Done with " + pdb_code + " iteration " + iterations);
            output.add(out_line);
            ++iterations;
        }
        return output;
    }

    public static boolean overlap(ArrayList<Integer> e1, ArrayList<Integer> e2) {
        for (Integer i1 : e1) {
            if (!e2.contains(i1)) continue;
            return true;
        }
        return false;
    }

    public static int overlapNum(ArrayList<Integer> e1, ArrayList<Integer> e2) {
        int overlaps = 0;
        for (Integer i1 : e1) {
            if (!e2.contains(i1)) continue;
            ++overlaps;
        }
        return overlaps;
    }

    public static ArrayList<PrepareData.Struct_maximization> FullPredictEpi(String pdb, String ab_file, String ag_file, ArrayList<Integer> ab_cons, int num_iteations, double cutoff_graph, int id) {
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        int depth = 3;
        HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
        HashMap<Integer, Boolean> ab_surface_exp = PropensityCalculation.getSurfExp(pdb, "AG_protein", "Ab");
        HashMap<Integer, Boolean> ag_surface_exp = PropensityCalculation.getSurfExp(pdb, "AG_protein", "Ag");
        System.out.println("Done with PSA");
        double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
        double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
        for (Integer ab_i_1 : ab_cons) {
            for (Integer ab_i_2 : ab_cons) {
                if (ab_i_1 == ab_i_2) continue;
                ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(ab_i_2));
            }
        }
        for (Integer ag_i_1 : ag.keySet()) {
            for (Integer ag_i_2 : ag.keySet()) {
                if (ag_i_1 == ag_i_2) continue;
                ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(ag_i_2));
            }
        }
        ArrayList n_dists = new ArrayList();
        ArrayList c_dists = new ArrayList();
        int prog = 1;
        for (Integer i : ag_surface_exp.keySet()) {
            System.out.println(String.valueOf(prog++) + "/" + ag_surface_exp.size());
            if (!ag_surface_exp.get(i).booleanValue()) continue;
            System.out.println("Seeding " + i);
            System.out.println("Currently results " + results.size());
            int d = depth;
            PrepareData.Struct_maximization struc = PrepareData.randomEpitopeSeeded(i, null, ag_surface_exp, ag, d, ab_cons, 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            System.out.println("Size = " + ag_cons.size());
            System.out.println("Creating the graph");
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(ag_surface_exp, cutoff_graph, ab, ag, null, ab_cons, ag_cons, ab_dists, ag_dists);
            struc.score = gs.score_sum_deg;
            results.add(struc);
        }
        return results;
    }

    public static ArrayList<PrepareData.Struct_maximization> PredictEpi(String ab_file, String ag_file, ArrayList<Integer> ab_cons, int num_iterations, double cutoff_graph, int id) {
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        int depth = 3;
        int iterations = 0;
        while (iterations < num_iterations) {
            System.out.println(String.valueOf(iterations) + "/" + num_iterations);
            HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
            HashMap<Integer, Boolean> surface_exp = new HashMap();
            surface_exp = PSA.runPSA(7.5, ag_file);
            PrepareData.Struct_maximization struc = PrepareData.randomEpitope(null, surface_exp, ag, depth, new ArrayList<Integer>(), 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
            double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
            for (Integer ab_i_1 : ab_cons) {
                for (Integer ab_i_2 : ab_cons) {
                    if (ab_i_1 == ab_i_2) continue;
                    ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(ab_i_2));
                }
            }
            for (Integer ag_i_1 : ag_cons) {
                for (Integer ag_i_2 : ag_cons) {
                    if (ag_i_1 == ag_i_2) continue;
                    ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(ag_i_2));
                }
            }
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab, ag, null, ab_cons, ag_cons, ab_dists, ag_dists);
            struc.score = gs.score_sum_deg / gs.num_vertices;
            results.add(struc);
            ++iterations;
        }
        return results;
    }

    public static ArrayList<PrepareData.Struct_maximization> GetEpitopes(String pdb_code, String case_folder, String _case, int num_iterations, double cutoff_graph, int id) {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        int depth = 3;
        int iterations = 0;
        while (iterations < num_iterations) {
            boolean prog = false;
            pdb_code = pdb_code.toUpperCase();
            double precision = 1.0;
            double overlap = 1.0;
            String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
            HashMap<Integer, Residue> ab_in = PDB_parser.parse(String.valueOf(case_folder) + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_in = PDB_parser.parse(String.valueOf(case_folder) + "/AG.pdb", 'A');
            HashMap<Integer, Boolean> surface_exp = new HashMap();
            double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
            ArrayList<Integer> ab_cons = new ArrayList<Integer>();
            ArrayList<String> ins = FileSystemTools.readFile(String.valueOf(case_folder) + "/paratope.txt");
            for (Integer i : ab_in.keySet()) {
                if (ins.contains("" + i)) continue;
                ab_cons.add(i);
            }
            ArrayList<Integer> ag_cons_corr = DockingDistances.augmentBinding(ag_sol, 5.0);
            ArrayList<Integer> real_cons = DockingDistances.augmentBinding(ag_sol, 0.0);
            surface_exp = PSA.runPSA(7.5, String.valueOf(case_folder) + "/AG.pdb");
            PrepareData.Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, ag_in, depth, ag_cons_corr, 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            precision = struc.precision;
            overlap = struc.overlap;
            struc.correct = ag_cons_corr;
            struc.ag_size = ag_sol.size();
            struc.small_size = real_cons.size();
            struc.correct_epitope = real_cons;
            double[][] ab_dists = new double[ab_in.size() + 1][ab_in.size() + 1];
            double[][] ag_dists = new double[ag_in.size() + 1][ag_in.size() + 1];
            for (Integer ab_i_1 : ab_cons) {
                for (Integer ab_i_2 : ab_cons) {
                    if (ab_i_1 == ab_i_2) continue;
                    ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab_in.get(ab_i_1).distanceFrom(ab_in.get(ab_i_2));
                }
            }
            for (Integer ag_i_1 : ag_cons) {
                for (Integer ag_i_2 : ag_cons) {
                    if (ag_i_1 == ag_i_2) continue;
                    ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag_in.get(ag_i_1).distanceFrom(ag_in.get(ag_i_2));
                }
            }
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab_in, ag_in, cons, ab_cons, ag_cons, ab_dists, ag_dists);
            String out_line = String.valueOf(cutoff_graph) + " " + Math.round(precision / 0.25) + " " + Math.round(overlap / 0.25) + " " + gs.score_sum_deg + " " + gs.score_sum_deg / gs.num_vertices + " " + id + " " + gs.score_sum_rd + " " + gs.score_sum_rd / gs.num_vertices + " " + ag_in.size();
            struc.score = Math.random();
            results.add(struc);
            output.add(out_line);
            ++iterations;
        }
        return results;
    }

    public static ArrayList<String> GetEpitopesStats(String pdb_code, String case_folder, String _case, int num_iterations, double cutoff_graph, int id) {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<PrepareData.Struct_maximization> results = new ArrayList<PrepareData.Struct_maximization>();
        int depth = 3;
        int iterations = 0;
        while (iterations < num_iterations) {
            boolean prog = false;
            pdb_code = pdb_code.toUpperCase();
            double precision = 1.0;
            double overlap = 1.0;
            System.out.println("Doing pdb " + pdb_code + " iteration " + iterations);
            String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
            HashMap<Integer, Residue> ab_in = PDB_parser.parse(String.valueOf(case_folder) + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_in = PDB_parser.parse(String.valueOf(case_folder) + "/AG.pdb", 'A');
            double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
            ArrayList<Integer> ab_cons = new ArrayList<Integer>();
            ArrayList<String> ins = FileSystemTools.readFile(String.valueOf(ag_folder) + "/paratope.txt");
            for (Integer i : ab_in.keySet()) {
                if (ins.contains("" + i)) continue;
                ab_cons.add(i);
            }
            ArrayList<Integer> ag_cons_corr = DockingDistances.augmentBinding(ag_sol, 5.0);
            ArrayList<Integer> real_cons = DockingDistances.augmentBinding(ag_sol, 0.0);
            HashMap<Integer, Boolean> surface_exp = new HashMap();
            System.out.println("Getting the surface exposed residues for the antigen in " + pdb_code);
            surface_exp = PSA.runPSA(7.5, String.valueOf(case_folder) + "/AG.pdb");
            PrepareData.Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, ag_in, depth, ag_cons_corr, 4.5);
            ArrayList<Integer> ag_cons = struc.epitope;
            precision = struc.precision;
            overlap = struc.overlap;
            struc.correct = ag_cons_corr;
            struc.ag_size = ag_sol.size();
            struc.small_size = real_cons.size();
            struc.correct_epitope = real_cons;
            System.out.println("Ab cons = " + ab_cons.size() + " out of " + ab_sol.size());
            System.out.println("Ag cons = " + ag_cons.size() + " out of " + ag_sol.size());
            double[][] ab_dists = new double[ab_in.size() + 1][ab_in.size() + 1];
            double[][] ag_dists = new double[ag_in.size() + 1][ag_in.size() + 1];
            for (Integer ab_i_1 : ab_cons) {
                for (Integer ab_i_2 : ab_cons) {
                    if (ab_i_1 == ab_i_2) continue;
                    ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab_in.get(ab_i_1).distanceFrom(ab_in.get(ab_i_2));
                }
            }
            for (Integer ag_i_1 : ag_cons) {
                for (Integer ag_i_2 : ag_cons) {
                    if (ag_i_1 == ag_i_2) continue;
                    ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag_in.get(ag_i_1).distanceFrom(ag_in.get(ag_i_2));
                }
            }
            double out_cut = cutoff_graph * 10.0;
            out_cut = Math.round(out_cut);
            System.out.println("Creating the graph");
            GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab_in, ag_in, cons, ab_cons, ag_cons, ab_dists, ag_dists);
            System.out.println("Done creating the graph");
            String out_line = String.valueOf(out_cut /= 10.0) + " " + Math.round(precision / 0.25) + " " + Math.round(overlap / 0.25) + " " + gs.score_sum_deg + " " + gs.score_sum_deg / gs.num_vertices + " " + id + " " + gs.score_sum_rd + " " + gs.score_sum_rd / gs.num_vertices + " " + ag_in.size();
            struc.score = gs.score_sum_deg / gs.num_vertices;
            results.add(struc);
            System.out.println(out_line);
            System.out.println("Done with " + pdb_code + " iteration " + iterations);
            output.add(out_line);
            ++iterations;
        }
        return output;
    }

    public static void colorStructure(ArrayList<Integer> ag_cons, ArrayList<Integer> ag_cons_corr, HashMap<Integer, Residue> ag_in, String _case, String pdb_code) {
        File f;
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : ag_in.keySet()) {
            sorted.add(i);
        }
        if (!new File(String.valueOf(userdir) + "/resources/SelectedEpitopes/zdock_" + _case).exists()) {
            f = new File(String.valueOf(userdir) + "/resources/SelectedEpitopes/zdock_" + _case);
            f.mkdir();
        }
        if (!new File(String.valueOf(userdir) + "/resources/SelectedEpitopes/zdock_" + _case + "/" + pdb_code.toLowerCase()).exists()) {
            f = new File(String.valueOf(userdir) + "/resources/SelectedEpitopes/zdock_" + _case + "/" + pdb_code.toLowerCase());
            f.mkdir();
        }
        for (Integer res_id : sorted) {
            Residue res = ag_in.get(res_id);
            double color = 0.0;
            color = ag_cons.contains(res_id) ? (ag_cons_corr.contains(res_id) ? 25.0 : 75.0) : (ag_cons_corr.contains(res_id) ? 100.0 : 0.0);
            for (Atom atom : res.atoms) {
            }
        }
    }

    public static void getEpi(String ag_file, String ab_file, int N) {
    }

    public static void BigEpiStatsPonom() {
        int iterations = 10;
        String outfile = String.valueOf(userdir) + "/result_dump/global_merged/merged_stats.txt";
        File f = new File(outfile);
        if (f.exists()) {
            f.delete();
        }
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        int pdb_id = 0;
        int N = 2;
        while (N < 9) {
            for (String pdb : pdbs) {
                if (pdb.toLowerCase().equals("1bgx")) continue;
                ++pdb_id;
                ArrayList<String> output = new ArrayList<String>();
                int iter = 0;
                while (iter < iterations) {
                    ArrayList<PrepareData.Struct_maximization> str = EpitopeSelector.GetEpitopesPonomStrucs(pdb, 30, 0.5, pdb_id);
                    String out_line = EpitopeSelector.PickBiggest(str, (int)N, (int)pdb_id).data;
                    output.add(out_line);
                    ++iter;
                }
                FileSystemTools.append(outfile, output);
            }
            ++N;
        }
    }

    public static void BigEpiStatsTestSet() {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_5_H");
        cases.add("paratome_5_H");
        cases.add("ipatch_5_H");
        cases.add("correct_5_H");
        cases.add("cdr_5_R");
        cases.add("paratome_5_R");
        cases.add("ipatch_5_R");
        cases.add("correct_5_R");
        String src_folder = String.valueOf(userdir) + "/resources/DockingCases/zdock";
        int N = 2;
        while (N < 6) {
            for (String _case : cases) {
                ArrayList<String> full_out = new ArrayList<String>();
                int i = 0;
                for (String pdb : pdbs) {
                    String curr_folder = String.valueOf(src_folder) + "/zdock_" + _case + "/" + pdb.toLowerCase();
                    System.out.println("Doing the pdb: " + pdb);
                    ArrayList<PrepareData.Struct_maximization> str = EpitopeSelector.GetEpitopes(pdb, curr_folder, _case, 30, 0.5, ++i);
                    String out_line = EpitopeSelector.PickBiggest(str, (int)N, (int)i).data;
                    full_out.add(out_line);
                }
                FileSystemTools.append(String.valueOf(userdir) + "/result_dump/global_merged/" + _case + "_merged.txt", full_out);
            }
            ++N;
        }
    }

    public static void CutoffStatsTestSet() {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_5_R");
        String src_folder = String.valueOf(userdir) + "/resources/DockingCases/zdock";
        for (String _case : cases) {
            int i = 0;
            for (String pdb : pdbs) {
                ArrayList<String> full_out = new ArrayList<String>();
                ++i;
                String curr_folder = String.valueOf(src_folder) + "/zdock_" + _case + "/" + pdb.toLowerCase();
                System.out.println("Doing the pdb: " + pdb);
                double cut = 0.1;
                while (cut < 3.0) {
                    ArrayList<String> output = EpitopeSelector.GetEpitopesStats(pdb, curr_folder, _case, 30, cut, i);
                    full_out.addAll(output);
                    cut += 0.1;
                }
                File f = new File(String.valueOf(userdir) + "/result_dump/global_maximization/cases/zdock_" + _case);
                if (!f.exists()) {
                    f.mkdir();
                }
                String res_file = String.valueOf(userdir) + "/result_dump/global_maximization/cases/zdock_" + _case + "/results.txt";
                FileSystemTools.append(res_file, full_out);
            }
        }
    }

    public static void CutoffStatsOnPonom() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        System.out.println(System.currentTimeMillis());
        double sec_start = System.currentTimeMillis();
        String res_file = String.valueOf(userdir) + "/result_dump/global_maximization/results_ponom.txt";
        int i = 0;
        for (String pdb : pdbs) {
            ArrayList<String> full_out = new ArrayList<String>();
            if (pdb.toLowerCase().equals("1bgx")) continue;
            ++i;
            System.out.println("Doing the pdb: " + pdb);
            double cut = 0.1;
            while (cut < 3.0) {
                ArrayList<String> output = EpitopeSelector.GetEpitopesPonom(pdb, 30, cut, i);
                full_out.addAll(output);
                cut += 0.1;
            }
            FileSystemTools.append(res_file, full_out);
        }
        double sec_end = System.currentTimeMillis();
        double elapsed = (sec_end - sec_start) / 1000.0;
        System.out.println("Elapsed " + elapsed + "s");
    }

    public static void CreateScalingMatrix() {
        double[][] dummy = new double[20][20];
        MathFunctions.printParsable2DDouble(dummy, String.valueOf(userdir) + "/result_dump/trainingstats_deg_neg.txt");
        MathFunctions.printParsable2DDouble(dummy, String.valueOf(userdir) + "/result_dump/trainingstats_deg_pos.txt");
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        System.out.println(System.currentTimeMillis());
        double sec_start = System.currentTimeMillis();
        String res_file = String.valueOf(userdir) + "/result_dump/global_maximization/results_ponom.txt";
        int i = 0;
        for (String pdb : pdbs) {
            ArrayList<String> full_out = new ArrayList<String>();
            if (pdb.toLowerCase().equals("1bgx")) continue;
            System.out.println("Doing the pdb: " + pdb);
            double cut = 0.5;
            ArrayList<String> output = EpitopeSelector.GetEpitopesPonom(pdb, 100, cut, ++i);
            full_out.addAll(output);
        }
        double sec_end = System.currentTimeMillis();
        double elapsed = (sec_end - sec_start) / 1000.0;
        System.out.println("Elapsed " + elapsed + "s");
    }

    public static boolean checkDuplicates(ArrayList<SuperEpi> ses, SuperEpi se, double cutoff) {
        for (SuperEpi se_temp : ses) {
            if (!(EpitopeSelector.overlapPerc(se_temp.epitope, se.epitope) > cutoff)) continue;
            return true;
        }
        return false;
    }

    public static double overlapPerc(ArrayList<Integer> a1, ArrayList<Integer> a2) {
        double tot = 0.0;
        for (Integer i : a1) {
            if (!a2.contains(i)) continue;
            tot += 1.0;
        }
        return tot / (double)a2.size();
    }

    public static void CreateGlobalDockingTestSetFull(int N, double cutoff, int iterations) {
        String dataset = "nr_training";
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/resources/" + dataset + "/dataset");
        int mini = 500;
        int i = 0;
        for (String pdb : pdbs) {
            File f3;
            System.out.println("Doing " + pdb);
            if (pdb.toLowerCase().equals("1e6j")) {
                System.out.println("Changing cut-off");
                perc_cutoff = 0.9;
            }
            if (pdb.toLowerCase().equals("1bql")) {
                System.out.println("Changing cut-off");
                perc_cutoff = 0.6;
            }
            if ((f3 = new File(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_0/" + pdb.toLowerCase() + "/paratope.txt")).exists()) continue;
            ++i;
            String ab_file = String.valueOf(userdir) + "/resources/" + dataset + "/dataset/" + pdb + "/AB.pdb";
            String ag_file = String.valueOf(userdir) + "/resources/" + dataset + "/dataset/" + pdb + "/AG.pdb";
            HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
            String ab_file_stats = String.valueOf(userdir) + "/resources/" + dataset + "/solution/" + pdb + "/AB.pdb";
            String ag_file_stats = String.valueOf(userdir) + "/resources/" + dataset + "/solution/" + pdb + "/AG.pdb";
            HashMap<Integer, Residue> ab_stats = PDB_parser.parse(ab_file_stats, 'A');
            HashMap<Integer, Residue> ag_stats = PDB_parser.parse(ag_file_stats, 'A');
            double[][] cons = DockingDistances.extractCons(ab_stats, ag_stats);
            ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab_stats, 5.0);
            ArrayList<Integer> ag_corr = DockingDistances.augmentBinding(ag_stats, 0.0);
            ArrayList<Integer> ag_ext = DockingDistances.augmentBinding(ag_stats, 5.0);
            ArrayList<Integer> ag_cons = new ArrayList<Integer>();
            for (Integer i_c : ag.keySet()) {
                if (ag_corr.contains("" + i_c)) continue;
                ag_cons.add(i_c);
            }
            ArrayList<PrepareData.Struct_maximization> str = EpitopeSelector.FullPredictEpi(pdb, ab_file, ag_file, ab_cons, 30, cutoff, i);
            if (str.size() < mini) {
                mini = str.size();
            }
            ArrayList<String> stats_out = new ArrayList<String>();
            HashMap<Integer, PrepareData.Struct_maximization> all_strucs = new HashMap<Integer, PrepareData.Struct_maximization>();
            int i0 = 0;
            while (i0 < str.size()) {
                all_strucs.put(i0, str.get(i0));
                ++i0;
            }
            for (Integer i02 : all_strucs.keySet()) {
                PrepareData.Struct_maximization max = (PrepareData.Struct_maximization)all_strucs.get(i02);
                Object stats = ADARS.getStats(max.epitope, ag_ext, ag_corr);
                stats = String.valueOf(max.score) + " " + (String)stats + " " + i02;
                stats_out.add((String)stats);
            }
            double[][] arr = new double[all_strucs.size()][all_strucs.size()];
            int prog = 0;
            for (Integer i03 : all_strucs.keySet()) {
                System.out.println(String.valueOf(++prog) + "/" + all_strucs.size());
                PrepareData.Struct_maximization sm0 = (PrepareData.Struct_maximization)all_strucs.get(i03);
                for (Integer i1 : all_strucs.keySet()) {
                    double d;
                    PrepareData.Struct_maximization sm1 = (PrepareData.Struct_maximization)all_strucs.get(i1);
                    arr[i03.intValue()][i1.intValue()] = d = EpitopeSelector.overlapPerc(sm0.epitope, sm1.epitope);
                }
            }
            ArrayList<SuperEpi> epis = new ArrayList<SuperEpi>();
            int iter = 0;
            while (iter < iterations) {
                if (str.size() == 0) {
                    System.err.println(pdb);
                    System.exit(0);
                }
                SuperEpi se = EpitopeSelector.PickBiggestRemove(str, N, i);
                if (epis.size() != 0 && EpitopeSelector.checkDuplicates(epis, se, perc_cutoff)) {
                    --iter;
                } else {
                    File case_f_pdb;
                    System.out.println("Went into iteration " + iter);
                    epis.add(se);
                    File case_f = new File(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter);
                    if (!case_f.exists()) {
                        case_f.mkdir();
                    }
                    if (!(case_f_pdb = new File(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase())).exists()) {
                        case_f_pdb.mkdir();
                    }
                    MathFunctions.printParsable2D(arr, String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_0/" + pdb.toLowerCase() + "/overlaps.txt");
                    String stats = ADARS.getStats(se.epitope, ag_ext, ag_corr);
                    HashMap<Integer, String> colors = new HashMap<Integer, String>();
                    for (Integer i_ag : ag.keySet()) {
                        if (se.epitope.contains(i_ag) && ag_cons.contains(i_ag)) {
                            colors.put(i_ag, "100");
                            continue;
                        }
                        if (se.epitope.contains(i_ag)) {
                            colors.put(i_ag, "75");
                            continue;
                        }
                        if (ag_cons.contains(i_ag)) {
                            colors.put(i_ag, "25");
                            continue;
                        }
                        colors.put(i_ag, "0");
                    }
                    ArrayList<String> epitope = new ArrayList<String>();
                    for (Integer i_ag : ag.keySet()) {
                        if (se.epitope.contains(i_ag)) continue;
                        epitope.add("" + i_ag);
                    }
                    ArrayList<String> paratope = new ArrayList<String>();
                    for (Integer i_ag : ab.keySet()) {
                        if (ab_cons.contains(i_ag)) continue;
                        paratope.add("" + i_ag);
                    }
                    String ab_file_pred = String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/AB.pdb";
                    String ag_file_pred = String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/AG.pdb";
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/paratope.txt", paratope);
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/epitope.txt", epitope);
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/stats.txt", stats);
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/" + dataset + "/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/stats_all.txt", stats_out);
                }
                ++iter;
            }
        }
    }

    public static void CreateGlobalDockingTestSet(int N, double cutoff, int iterations) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/resources/adars/dataset");
        int iter = 0;
        while (iter < iterations) {
            int i = 0;
            File case_f = new File(String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter);
            if (!case_f.exists()) {
                case_f.mkdir();
            }
            for (String pdb : pdbs) {
                File case_f_pdb = new File(String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase());
                if (!case_f_pdb.exists()) {
                    case_f_pdb.mkdir();
                }
                System.out.println(String.valueOf(iter) + "/" + iterations + " : " + i + "/" + pdbs.size());
                ++i;
                String ab_file = String.valueOf(userdir) + "/resources/adars/dataset/" + pdb + "/AB.pdb";
                String ag_file = String.valueOf(userdir) + "/resources/adars/dataset/" + pdb + "/AG.pdb";
                ArrayList<String> ab_c = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dataset/" + pdb + "/paratope.txt");
                ArrayList<String> ag_c = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/solution/" + pdb + "/epitope.txt");
                HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
                HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
                String ab_file_stats = String.valueOf(userdir) + "/resources/adars/solution/" + pdb + "/AB.pdb";
                String ag_file_stats = String.valueOf(userdir) + "/resources/adars/solution/" + pdb + "/AG.pdb";
                HashMap<Integer, Residue> ab_stats = PDB_parser.parse(ab_file_stats, 'A');
                HashMap<Integer, Residue> ag_stats = PDB_parser.parse(ag_file_stats, 'A');
                double[][] cons = DockingDistances.extractCons(ab_stats, ag_stats);
                ArrayList<Integer> ag_corr = DockingDistances.augmentBinding(ag_stats, 0.0);
                ArrayList<Integer> ag_ext = DockingDistances.augmentBinding(ag_stats, 5.0);
                ArrayList<Integer> ab_cons = new ArrayList<Integer>();
                for (Integer i_c : ab.keySet()) {
                    if (ab_c.contains("" + i_c)) continue;
                    ab_cons.add(i_c);
                }
                ArrayList<Integer> ag_cons = new ArrayList<Integer>();
                for (Integer i_c : ag.keySet()) {
                    if (ag_c.contains("" + i_c)) continue;
                    ag_cons.add(i_c);
                }
                ArrayList<PrepareData.Struct_maximization> str = EpitopeSelector.PredictEpi(ab_file, ag_file, ab_cons, 30, cutoff, i);
                ArrayList<String> stats_out = new ArrayList<String>();
                for (PrepareData.Struct_maximization max : str) {
                    String stats = ADARS.getStats(max.epitope, ag_ext, ag_corr);
                    stats = String.valueOf(max.score) + " " + stats;
                    stats_out.add(stats);
                }
                SuperEpi se = EpitopeSelector.PickBiggest(str, N, i);
                String stats = ADARS.getStats(se.epitope, ag_ext, ag_corr);
                HashMap<Integer, String> colors = new HashMap<Integer, String>();
                for (Integer i_ag : ag.keySet()) {
                    if (se.epitope.contains(i_ag) && ag_cons.contains(i_ag)) {
                        colors.put(i_ag, "100");
                        continue;
                    }
                    if (se.epitope.contains(i_ag)) {
                        colors.put(i_ag, "75");
                        continue;
                    }
                    if (ag_cons.contains(i_ag)) {
                        colors.put(i_ag, "25");
                        continue;
                    }
                    colors.put(i_ag, "0");
                }
                ArrayList<String> epitope = new ArrayList<String>();
                for (Integer i_ag : ag.keySet()) {
                    if (se.epitope.contains(i_ag)) continue;
                    epitope.add("" + i_ag);
                }
                Visualization.colorStruc("randoms/" + pdb + "_RAND_" + iter, ag, colors);
                String ab_file_pred = String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/AB.pdb";
                String ag_file_pred = String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/AG.pdb";
                String paratope = String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/paratope.txt";
                FileSystemTools.CopyFile(String.valueOf(userdir) + "/resources/adars/dataset/" + pdb.toLowerCase() + "/AB.pdb", ab_file_pred);
                FileSystemTools.CopyFile(String.valueOf(userdir) + "/resources/adars/dataset/" + pdb.toLowerCase() + "/AG.pdb", ag_file_pred);
                FileSystemTools.CopyFile(String.valueOf(userdir) + "/resources/adars/dataset/" + pdb.toLowerCase() + "/paratope.txt", paratope);
                FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/epitope.txt", epitope);
                FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/stats.txt", stats);
                FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/pred_epi/case_" + iter + "/" + pdb.toLowerCase() + "/stats_all.txt", stats_out);
            }
            ++iter;
        }
    }

    public static class SuperEpi {
        final String data;
        public double score;
        final ArrayList<Integer> epitope;

        public SuperEpi(String stats, ArrayList<Integer> epi) {
            this.data = stats;
            this.epitope = epi;
        }
    }
}

