/*
 * Decompiled with CFR 0.152.
 */
package for_terry;

import for_terry.Abysis;
import for_terry.DBStats;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class NewDefs {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        NewDefs.FrameForAll();
    }

    public static void FrameForAll() {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/ABAGSummary.txt");
        int progress = 0;
        for (String line : lines) {
            String pdb = line.substring(0, 4);
            System.out.println(String.valueOf(pdb) + " " + ++progress + "/" + lines.size());
            if (pdb.equals("1F3R") || pdb.equals("3BKJ")) continue;
            NewDefs.processFile(pdb);
        }
    }

    public static void processFile(String pdb) {
        Abysis.Abysis_AB rec = Abysis.createRecord(pdb);
        Abysis.Abysis_rec h = rec.heavy;
        Abysis.Abysis_rec l = rec.light;
        HashMap<String, DBStats.PDB_record> map = DBStats.getLHMapping();
        char src_h = map.get((Object)pdb).H;
        char src_l = map.get((Object)pdb).L;
        String original = String.valueOf(userdir) + "/protein_database/raw_files/" + pdb + ".pdb";
        String temp = String.valueOf(userdir) + "/temp_dump/temp.txt";
        PDB_parser.writeConstrainingPDB(original, temp, src_h, src_l);
        NewDefs.constrainFrame("kabat", h, l, pdb);
        NewDefs.constrainFrame("chothia", h, l, pdb);
        NewDefs.constrainFrame("abm", h, l, pdb);
        NewDefs.constrainFrame("contact", h, l, pdb);
    }

    public static void constrainFrame(String annot, Abysis.Abysis_rec h, Abysis.Abysis_rec l, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/temp_dump/temp.txt");
        String h_out = "";
        String l_out = "";
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.substring(0, 4).equals("ATOM")) {
                HashMap<Integer, String> annotation;
                HashMap<Integer, String> numbering;
                char chain = line.charAt(21);
                if (chain == 'H') {
                    numbering = h.kabat_num;
                    if (annot.equals("kabat")) {
                        annotation = h.kabat_annot;
                    } else if (annot.equals("chothia")) {
                        annotation = h.chothia_annot;
                    } else if (annot.equals("abm")) {
                        annotation = h.abm_annot;
                    } else if (annot.equals("contact")) {
                        annotation = h.contact_annot;
                    } else {
                        System.err.println("constrainFrame: unknown CDR definition " + annot);
                        System.exit(0);
                        annotation = null;
                    }
                } else {
                    numbering = l.kabat_num;
                    if (annot.equals("kabat")) {
                        annotation = l.kabat_annot;
                    } else if (annot.equals("chothia")) {
                        annotation = l.chothia_annot;
                    } else if (annot.equals("abm")) {
                        annotation = l.abm_annot;
                    } else if (annot.equals("contact")) {
                        annotation = l.contact_annot;
                    } else {
                        System.err.println("constrainFrame: unknown CDR definition " + annot);
                        System.exit(0);
                        annotation = null;
                    }
                }
                int seq_id = Integer.parseInt(line.substring(22, 26).replace(" ", ""));
                if (annotation.containsKey(seq_id) && annotation.get(seq_id).equals("F")) {
                    String num = numbering.get(seq_id);
                    num = num.substring(1);
                    while (num.length() < 4) {
                        num = " " + num;
                    }
                    String out = String.valueOf(line.substring(0, 22)) + num + " " + line.substring(27);
                    if (chain == 'H') {
                        h_out = String.valueOf(h_out) + out + "\n";
                    } else {
                        l_out = String.valueOf(l_out) + out + "\n";
                    }
                }
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/protein_database/definitions/" + annot + "/" + pdb + "_H.pdb", h_out);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/protein_database/definitions/" + annot + "/" + pdb + "_L.pdb", l_out);
    }
}

