#!/bin/bash
cases=(
$1
)
pdbs=( '1ahw  213  200'
'1bql  210  126'
'1jhl  214  126'
'1jps  213  200'
'1k4c  214   97'
'1mlc  212  126'
'1nca  216  388'
'1vfb  212  126'
'1wej  213  101'
'1ynt  214  252'
'1ztx  215  101'
'2aep  216  388'
'2b2x  213  188'
'2bdn  213   68'
'2jel  219   82'
	)



cases_len=${#cases[@]}
pdbs_len=${#pdbs[@]}
total=0
done=0
let "total=$pdbs_len*200"

ref_temp='ref.pdb'
mob_temp='mob.pdb'
cases_done=0
for c in "${cases[@]}"
do


#See if the run directory for this case already exists
if [ -d "output/$2" ];
then
echo "Directory output/$2 exists, not creating"
else
mkdir "output/$2"
fi

	pdbs_done=0
	for i in "${pdbs[@]}"
	do
		
		#first off, need to generate the pdbs...
		rm input/complex*		
		cd ../done_runs/$2/$i
		./create.pl zdock.out 200
		mv complex* ../../../ProFitV3.1/input/
		cd ../../../ProFitV3.1		
		
		#See if the output directory for this pdb already exists
		if [ -d "output/$2/${i:0:4}" ];
		then
		echo "Directory output/$2/${i:0:4} exists, not creating"
		else
		mkdir "output/$2/${i:0:4}"
		fi
		#See if the RMSD output file for this pdb already exists
		if [ -f "output/$2/${i:0:4}/lrmsds.txt" ];
		then
		echo "File output/$2/${i:0:4}/lrmsds.txt exists, removing, recreating"
		rm "output/$2/${i:0:4}/lrmsds.txt"		
		touch "output/$2/${i:0:4}/lrmsds.txt"
		else
		touch "output/$2/${i:0:4}/lrmsds.txt"
		fi

		#Prepare the temp file for program execution
		if [ -f $ref_temp ];
		then
			echo "Found old ref file, deleting..."
			rm $ref_temp
		fi

		#copy the reference file
		while read line         
		do         
			
			echo "$line" >> $ref_temp
				
		done < "solution/${i:0:4}/AB.pdb"
		
		while read line         
		do         
		
			echo "${line:0:21}B${line:22}" >> $ref_temp
		
		done < "solution/${i:0:4}/AG.pdb"		

		cp ref.pdb "output/$2/${i:0:4}/a_ref.pdb"
		#For each of 200 decoys
		decoys_done=0
		for num in {1..200}
		do
			let "done=($cases_done*$pdbs_len*200) + $pdbs_done*200 + $decoys_done"
			progress=$(echo "($done / $total)*100" |bc -l)
			echo "Executing L_RMSD for $i, run=$2, decoy $num , ${progress:0:4}% completed"
			
			#Prepare the Profit script
			./profit_scriptor.sh $i "output/$2/${i:0:4}/c$num.pdb"
			
			
			if [ -f $mob_temp ];
			then
				echo "Found old mob file, deleting..."
				rm $mob_temp
			fi
		
			molecule='AB'		
			last_found=0		
			while read line         
			do         
				curr=${line:22:4}
				if [ $last_found -gt $curr ]
				then
					molecule='AG'
					last_found=$curr
				else
					last_found=$curr
					if [ "$molecule" = "AB" ]
					then
						echo "$line" >> $mob_temp
					else
						echo "${line:0:21}B${line:22}" >> $mob_temp
					fi 
				fi
			
			done < "input/complex.$num.pdb"
		
			
		
			echo 'Running ProFit'		
		
			#Run Profit
			output_file="output_file.txt"
			if [ -f $output_file ];
			then
				echo "Found old output file, deleting..."
				rm $output_file
			fi
			
			./profit -f prof_script.txt -h ref.pdb mob.pdb >> $output_file
				
			RMSD=`cat $output_file | tail -1`
			echo "$num ${RMSD:8}" >> "output/$2/${i:0:4}/lrmsds.txt"
			rm "output/$2/${i:0:4}/c$num.pdb"	
			let "decoys_done+=1"
		done
		let "pdbs_done+=1"
	done
	let "cases_done+=1"
done

#Remove all the decoys created
rm ../../../ProFitV3.1/input/complex*

