import sys
import operator

#Out of different maps, for each element select the one with the highest value
def get_best_map(mappings,out_of):
	indices = []
	for mapp in mappings:
		for elem in mappings[mapp]:
			if elem[0] not in indices:			
				indices.append(elem[0])
	
	indices_map = dict()
	for index in indices:
		for mapp in mappings:
			for elem in mappings[mapp]:
				if index==elem[0]:
					if index in indices_map:
						if elem[1]>indices_map[index]:
							indices_map[index] = elem[1]
					else:
						indices_map[index] = elem[1]

	indices_map = sorted(iter(indices_map.items()),reverse=True, key=operator.itemgetter(1))
	counter = 0	
	for elem in indices_map:
		if counter>out_of:
			break
		counter+=1
		print(int(elem[0]),float(elem[1]))	

	

#Return the score map for a particular epitope prediction
def get_score_map(whichone,out_of):
	f = open("scores"+str(whichone)+".txt")
	mapping = dict()
	
	for line in f:
		
		line = line.strip()
		line = line.split(" ")
		mapping[line[0]] = line[1]

	sorted_map = sorted(iter(mapping.items()),reverse=True, key=operator.itemgetter(1))
	sorted_return = dict()	
	counter = 0
	for elem in sorted_map:
		if counter>out_of:
			break
		counter+=1
		sorted_return[int(elem[0])] = float(elem[1])
		
	return sorted_return

#==Main==#

args = sys.argv

return_top = int(args[1])
out_of = int(args[2])
maps_to_use = int(args[3])+1

maps = dict()

for i in range(0,maps_to_use):
	
	maps[i] = get_score_map(i,out_of)
	maps[i] = sorted(iter(maps[i].items()),reverse=True, key=operator.itemgetter(1))
	
get_best_map(maps,return_top)
