#!/bin/bash
#ZdockDock wrapper for the special case of Ab-Ag complexes

#Number of decoys to rescore
num_decoys=200
#Number of epitopes to use - num_epitopes+1
num_epitopes=$9

#How many decoys to return
return_top=$8

BASEDIR=$(dirname $0)
#Unfortunately it is necessary to go to this directory to run it...
cd $BASEDIR

echo 'Running ZDOCK'
#Antibody and antigen files
AB=$1
AG=$2
#the temporary folder that ZDOCK might use
tempfolder=$3
input_folder=$4

#Paratope for zdock is different because it requires only the residues that are NOT in the paratope.
paratope_zdock=$5
paratope_rescoring=$6
output_folder=$7
ABM=$tempfolder/AB_m.pdb
AGM=$tempfolder/AG_m.pdb
output=$tempfolder/zdock.out

#Constrain the area of the paratope
#python zdock_constraint.py $epitope $tempfolder/epitope_constraint.txt B

#Prepare the PDB files...
echo "Mark_sur AB"
./mark_sur $AB $ABM
echo "Mark_sur AG"
./mark_sur $AG $AGM 

#Constrain the files
./block.pl $ABM $paratope_zdock $tempfolder/AB_temp.pdb
mv $tempfolder/AB_temp.pdb $ABM

#Constrain the files
#./block.pl $AGM $tempfolder/epitope_constraint.txt $tempfolder/AG_temp.pdb
#mv $tempfolder/AG_temp.pdb $AGM

#Random seed
#rand_seed=6534 
rand_seed=$[ ( $RANDOM % 10000 )  + 1 ]
echo "ZDOCK run with random seed $rand_seed"
./zdock -N 2000 -S $rand_seed -F -R $ABM -L $AGM -o $output
echo "Done"

mkdir $tempfolder/decoys
cp $output $tempfolder/decoys/

#REMOVE
#cp /tmp/tmpJzlOlv/decoys/zdock.out $tempfolder/decoys/

cp DockSorterConstr.jar $tempfolder/decoys/
cp $paratope_rescoring $tempfolder/decoys/paratope.txt
for num in `seq 0 $num_epitopes`
do

	cp $input_folder/out/* $tempfolder/decoys/
	cp $input_folder/temp_out/*.pdb $tempfolder/decoys/
done

cp create.pl $tempfolder/decoys/
cp create_lig $tempfolder/decoys/
cp SortScores.py $tempfolder/decoys/
cp -r MultiAlign $tempfolder/decoys/
cd $tempfolder/decoys

#Create the decoys requested by the user.
./create.pl zdock.out $num_decoys

#Decoys were created, so we can rescore them
for num in `seq 1 $num_decoys`
do

	echo "Running decoy $num out of $num_decoys $num_epitopes"
	molecule='AB'
	
	
	for num_epi in `seq 0 $num_epitopes`
	do	
		#Check if the said epitope exists.
		if [ -f "$num_epi.txt" ];
		then
			echo "Epitope $num_epi"
		else
			continue
		fi		
		maps_to_use=$num_epi
		temp_out=temp.txt
		if [ -f "$temp_out" ];
		then
			rm $temp_out
		else
			touch $temp_out
		fi
		echo "Running DockSorter file $num_epi.txt"
		echo "java -jar DockSorterConstr.jar -abf complex.$num.pdb -agf complex.$num.pdb -abc A -agc B -constab paratope.txt -constag $num_epi.txt -quiet"
		java -jar DockSorterConstr.jar -abf complex.$num.pdb -agf complex.$num.pdb -abc A -agc B -constab paratope.txt -constag $num_epi.txt -quiet >> $temp_out
		SCORE=`cat $temp_out | tail -1`
		echo "DockSorter says: $SCORE"
		echo "$num $SCORE" >> scores$num_epi.txt
	done
	
done

#Using the 
python SortScores.py $return_top $num_decoys $maps_to_use > MultiAlign/final_scores.txt
cd MultiAlign
python align_all.py
mkdir $output_folder/top_decoys
mkdir $output_folder/epitope_predictions
cp output/*.pdb $output_folder/top_decoys/
cp $input_folder/out/original_* $output_folder/epitope_predictions/
cp $input_folder/temp_out/*.pdb $output_folder/epitope_predictions/
echo "ZDOCK Finished"
