#!/usr/bin/env python

from distutils.core import setup, Extension
import numpy as np

numpy_include_dir = np.get_include()

# Setup script written by Jinwoo Leem
setup(name = "prosci",
      version = "1.0",
      description = "FREAD: fragment-based loop modelling method",
      author = "Sebastian Kelm",
      author_email = "kelm@stats.ox.ac.uk",
      packages = [

          "prosci",                    # Entire module
          "prosci.loops",
          "prosci.util",
      ],
      package_dir = {
          "prosci": "lib/python/prosci",
          "prosci.loops": "lib/python/prosci/loops",
          "prosci.util": "lib/python/prosci/util",           # Entire protocol as a master script
      },
      scripts = ["bin/esst.txt", "bin/esst.txt", "bin/fread_db_add", "bin/fread_db_optimise", "bin/multifread",
                 "bin/multifread.orig", "bin/pyfread", "bin/pyfread_cpp/", "bin/tools/"]
)
