/*
 * Decompiled with CFR 0.152.
 */
package Abnum;

import data_structures.Residue;
import docking_global.DockingDistances;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.WebTools;

public class Abnum {
    public static void main(String[] argsp) {
        Abnum.getChain(null, null);
    }

    public static void getChain(String pdb, String chain_id) {
        String basis = "/Users/bielasek/Desktop/AG_protein/";
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/DP_recalculation/PDBs_all/AG_protein.txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        double precision = 0.0;
        double recall = 0.0;
        for (String line : lines) {
            if (line.contains("1xiw") || line.contains("2yc1") || line.contains("3kr3") || line.contains("4hkx") || line.contains("1dee") || line.contains("4hwb") || line.contains("3ux9") || line.contains("3h3b") || line.contains("3bdy")) continue;
            System.out.println(line);
            HashMap<String, Residue> heavy_residues = new HashMap<String, Residue>();
            HashMap<String, Residue> light_residues = new HashMap<String, Residue>();
            String parsed = line.replace("_", " ");
            String light_chain = FileSystemTools.getColumn(parsed, 3);
            String heavy_chain = FileSystemTools.getColumn(parsed, 2);
            HashMap<Integer, Residue> light = PDB_parser.parse(String.valueOf(basis) + line + "/Ab_full.pdb", light_chain.charAt(0));
            HashMap<Integer, Residue> heavy = PDB_parser.parse(String.valueOf(basis) + line + "/Ab_full.pdb", heavy_chain.charAt(0));
            HashMap<Integer, Residue> antigen = PDB_parser.parse(String.valueOf(basis) + line + "/Ag_std.pdb", 'A');
            TreeSet<Integer> h_sorted = new TreeSet<Integer>();
            for (Integer i : heavy.keySet()) {
                h_sorted.add(i);
            }
            TreeSet<Integer> l_sorted = new TreeSet<Integer>();
            for (Integer i : light.keySet()) {
                l_sorted.add(i);
            }
            System.out.println(l_sorted.size());
            String l = "";
            for (Integer i : l_sorted) {
                l = String.valueOf(l) + (Object)((Object)light.get((Object)i).type);
            }
            String h = "";
            for (Integer i : h_sorted) {
                h = String.valueOf(h) + (Object)((Object)heavy.get((Object)i).type);
            }
            System.out.println("H: " + h);
            System.out.println("L: " + l);
            NumStruc h_ns = Abnum.getNumbers(h);
            HashMap<String, String> h_numbering = h_ns.number_map;
            int i = 0;
            boolean first = true;
            for (String number : h_ns.numbers) {
                ++i;
                if (h_numbering.get(number).equals("-")) break;
                if (h_numbering.get(number).equals("" + (Object)((Object)heavy.get((Object)Integer.valueOf((int)i)).type))) {
                    first = false;
                    heavy_residues.put(number, heavy.get(i));
                    continue;
                }
                if (first) continue;
                System.out.println("Fuckup " + line);
                System.out.println(String.valueOf(number) + " " + i);
                System.out.println(String.valueOf(h_numbering.get(number)) + " : " + (Object)((Object)heavy.get((Object)Integer.valueOf((int)i)).type));
            }
            NumStruc l_ns = Abnum.getNumbers(l);
            HashMap<String, String> l_numbering = l_ns.number_map;
            i = 0;
            first = true;
            for (String number : l_ns.numbers) {
                ++i;
                if (l_numbering.get(number).equals("-")) break;
                if (l_numbering.get(number).equals("" + (Object)((Object)light.get((Object)Integer.valueOf((int)i)).type))) {
                    first = false;
                    light_residues.put(number, light.get(i));
                    continue;
                }
                if (first) continue;
                System.out.println("Fuckup light " + line);
                System.out.println(String.valueOf(number) + " " + i);
                System.out.println(String.valueOf(l_numbering.get(number)) + " : " + (Object)((Object)light.get((Object)Integer.valueOf((int)i)).type));
            }
            DockingDistances.extractConsAbnum(heavy_residues, antigen);
            DockingDistances.extractConsAbnum(light_residues, antigen);
            for (String number : light_residues.keySet()) {
                if (Abnum.isCDR(number) && light_residues.get((Object)number).isContact) {
                    tp += 1.0;
                    continue;
                }
                if (Abnum.isCDR(number) && !light_residues.get((Object)number).isContact) {
                    fp += 1.0;
                    continue;
                }
                if (Abnum.isCDR(number) || !light_residues.get((Object)number).isContact) continue;
                fn += 1.0;
            }
            for (String number : heavy_residues.keySet()) {
                if (Abnum.isCDR(number) && heavy_residues.get((Object)number).isContact) {
                    tp += 1.0;
                    continue;
                }
                if (Abnum.isCDR(number) && !heavy_residues.get((Object)number).isContact) {
                    fp += 1.0;
                    continue;
                }
                if (Abnum.isCDR(number) || !heavy_residues.get((Object)number).isContact) continue;
                fn += 1.0;
            }
            precision = tp / (tp + fp);
            recall = tp / (tp + fn);
            System.out.println("P: " + precision);
            System.out.println("R: " + recall);
        }
    }

    public static NumStruc getNumbers(String aas) {
        ArrayList<String> list = WebTools.newReadPage("http://www.bioinf.org.uk/cgi-bin/abnum/abnum.pl?plain=1&aaseq=" + aas + "&scheme=-c");
        ArrayList<String> numbers = new ArrayList<String>();
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String s : list) {
            String number = FileSystemTools.getColumn(s, 1);
            String aa = FileSystemTools.getColumn(s, 2);
            mapping.put(number, aa);
            numbers.add(number);
        }
        return new NumStruc(numbers, mapping);
    }

    public static boolean isCDR(String number) {
        int last = number.length() - 1;
        if (number.charAt(last) == 'A' || number.charAt(last) == 'B' || number.charAt(last) == 'C' || number.charAt(last) == 'D' || number.charAt(last) == 'E' || number.charAt(last) == 'F' || number.charAt(last) == 'G') {
            number = number.substring(0, last);
        }
        number = String.valueOf(number) + ";";
        String allowed = "L30;L31;L32;L33;L34;L35;L36;L46;L47;L48;L49;L50;L51;L52;L53;L54;L55;L89;L90;L91;L92;L93;L94;L95;L96";
        return (allowed = String.valueOf(allowed) + "H30;H31;H32;H33;H34;H35;H47;H48;H49;H50;H51;H52;H53;H54;H55;H56;H57;H58;H93;H94;H95;H96;H97;H98;H99;H101").contains(number);
    }

    public static class NumStruc {
        final ArrayList<String> numbers;
        final HashMap<String, String> number_map;

        public NumStruc(ArrayList<String> n, HashMap<String, String> nm) {
            this.numbers = n;
            this.number_map = nm;
        }
    }
}

