/*
 * Decompiled with CFR 0.152.
 */
package DockSorter;

import data_structures.Residue;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DockSorterPiper {
    private static final String userdir = System.getProperty("user.dir");
    private static final double[][] prop_mat = new double[][]{{0.20499805164508159, 0.16750851213572426, 0.19744195927318303, 0.059907013926387816, 0.18287038061132502, 0.1673079653060306, 0.13066396127749202, 0.0708979161725203, 0.17759522207528275, 0.08572268077130307, 0.07511742727004006, 0.07225666927728187, 0.24796082475891185, 0.07261612636173871, 0.12537299266257745, 0.18611101880825603, 0.0775612297532633, 0.26437960677637623, 0.18842263063755776, 0.12483782070097652}, {0.20107110444859158, 0.08601717784943697, 0.10406903632375285, 0.055211466396850976, 0.11289452710587597, 0.08167850017332448, 0.14475488719274587, 0.13901450490207654, 0.12011224028282462, 0.038164554923005696, 0.12367309568578078, 0.17370746475321153, 0.15656811774324028, 0.1027173263415464, 0.13099285642243724, 0.11972210997231149, 0.027217476887187196, 0.14745854156673646, 0.1313604079971408, 0.16049970542117678}, {0.15717109520794373, 0.14664752091603117, 0.0401053110083649, 0.02050524560549611, 0.11963948118686231, 0.08732244671793081, 0.13113833340969028, 0.17844875483134104, 0.11643941533883705, 0.14768251571984567, 0.18425669606753564, 0.11168049400995189, 0.19826329833431947, 0.09322256880353123, 0.12396918383752975, 0.0812506173731877, 0.07858692955444982, 0.10477048239432893, 0.08670339186503102, 0.08924415488567883}, {0.0032910798076830937, 0.004534027177382738, 0.006635789619665506, 0.007258068128324283, 0.006847039030191249, 0.009836444443484664, 0.0016788843149061039, 0.0031914896092739686, 0.0061155411457513775, 0.002665767511125737, 0.001517849740821481, 0.0028595346475053006, 0.006193691841046052, 0.00449449221539659, 7.104187808343687E-4, 9.195330148555958E-4, 0.008820938654442625, 0.0022088653911493316, 0.006753053673070668, 0.00950583332505366}, {0.015029411354257312, 0.09082981051288219, 0.05811700942837954, 0.003066403921449895, 0.0405475251096359, 0.008643616221590194, 0.05378835739726901, 0.007635212912917261, 0.04232307525123221, 0.027648744020734417, 0.06330998655182037, 0.024943705432017384, 0.16756092255116237, 0.03719273600942575, 0.113673284054701, 0.15946574124884857, 0.001519046721436358, 0.006861288358077009, 0.005064819676963991, 0.13886186534002237}, {0.40375296224694956, 0.16805074891074293, 0.03806222321985338, 0.08700931836748375, 0.09629091216351535, 0.014333201450493984, 0.1260424719059789, 0.15337602097063918, 0.0535689104113527, 0.057961981512152046, 0.1471100821386912, 0.012259753223855708, 0.06523443564402678, 0.050642087857377345, 0.1316432783310911, 0.08942360486377635, 0.317667852582394, 0.07931203843251097, 0.03714874419599361, 0.13741100934501313}, {0.19009677219646726, 0.08258818248186163, 0.10225017682779064, 0.05916437755276169, 0.14173489252970464, 0.1355473339384309, 0.1203416340713057, 0.12209650272916504, 0.13309419290859464, 0.07432467903603679, 0.13469904898260507, 0.26291615069914387, 0.1757068440552806, 0.15345281733976035, 0.10247474341153236, 0.13345553395796203, 0.0617422531212806, 0.1278797902959154, 0.14685295581310992, 0.11632095937786156}, {0.19854313703128068, 0.12677206962105836, 0.36302150795343935, 0.23335338973302797, 0.17943632703298254, 0.14418445286112144, 0.2341552718860585, 0.4039813335557629, 0.21873778455695547, 0.11445283048923405, 0.15905811715143417, 0.32120557530633415, 0.34355450263823095, 0.2820876555794322, 0.10294908716973752, 0.32055502870445873, 0.25014945507135405, 0.2390968997328732, 0.2334600480382337, 0.07344810678871719}, {0.05794807824856105, 0.026651653091882724, 0.04222313913408342, 0.0012106883959488457, 0.12490060059627688, 0.16789789686339288, 0.038597315365595054, 0.004406105041307776, 0.1715580012562413, 0.2025119807000775, 0.16628612851831395, 0.35161683303396646, 0.3511545767345317, 0.02484444054077154, 0.06859870937757201, 0.07647925833834968, 0.25387342784234923, 0.1479605779972991, 0.2512751961279669, 9.626337467703583E-4}, {0.18874278177410853, 0.06082518770687624, 0.04035802345114759, 5.79643141214653E-4, 0.09416814464641249, 0.15555049633375073, 0.17651698497484655, 0.11146525491173401, 0.2781279070025248, 0.3784724129224023, 0.10645026360631052, 0.5092009414298521, 0.25230566382921527, 0.10473844325522165, 0.24121939974725448, 0.029700681335443686, 0.3601925351790173, 0.27931938447446436, 0.2526505653398697, 0.0975896801980536}, {0.1076636158739684, 0.06716603889750183, 0.041193316689666866, 0.0035831679762066302, 0.03625669069337388, 0.20275076819113985, 0.10649708238153258, 0.07897801826585184, 0.08442232317689706, 0.12376330680563999, 0.10178888848131039, 0.061604248037331236, 0.0056510786739189635, 0.10149707083623498, 0.13635976952007126, 0.1083143103773694, 0.3568700960736264, 0.08629133781208445, 0.036143106107316976, 0.002814977639174718}, {0.34758744528508195, 0.0017277410579315266, 0.008773737883749258, 0.9370965374863945, 9.919909014990613E-4, 0.004263627316861219, 0.008025267392164963, 0.23319945186131108, 0.21705685513439718, 0.002491992348202429, 0.12184667201815971, 0.5139316311944726, 0.004146086675280346, 0.37573108256548327, 0.025489709031230434, 0.054794789607846464, 0.006415601819196243, 0.194636769901922, 0.006931905821092253, 0.006355777667187579}, {0.20715420404950913, 0.09640401326216755, 0.1720804007746872, 0.12726358939923477, 0.31555354729531254, 0.20952204717822723, 0.25245970213747926, 0.24771474032869417, 0.2583047237457067, 0.2508388318792109, 0.17891587550469382, 0.3010717637203992, 0.3597969197089135, 0.19281529632118677, 0.13896924942664649, 0.10265820455698957, 0.14461328494483378, 0.08897668996070693, 0.24331242784125148, 0.26847752854336365}, {0.1362231399078555, 0.1371454226605882, 0.038551533737664595, 0.008513464937538191, 0.08555857057071223, 0.032884040528129925, 0.05078965215356637, 0.29089408040507825, 0.1752079798703641, 0.07429988939652384, 0.05667484046008819, 0.12775440887189976, 0.3405818844812722, 0.04370910347399359, 0.11242187529440495, 0.10270230886801544, 0.16594559901442166, 0.21224601086702574, 0.0696934011194062, 0.049099233366902244}, {0.13351028578118804, 0.09586943448572441, 0.1775338755588225, 0.027402493677460886, 0.15325253248027862, 0.15903271730800947, 0.10293214694023631, 0.09559346463714215, 0.0431787110200577, 0.0846542388639233, 0.07422840064655847, 0.13369495221350217, 0.20520630013231628, 0.13062749104319876, 0.07431377403054329, 0.1811362649130973, 0.14236043658884817, 0.11674638334616211, 0.0293213165591209, 0.05217685111826366}, {0.13816330872923188, 0.07835457074136815, 0.13593869149664684, 0.07385221385638593, 0.12579256842422806, 0.10693084542013044, 0.10096217645237975, 0.10165761406165902, 0.11674394059048664, 0.12375087025312691, 0.0835020475283744, 0.23998968650901237, 0.14504530106099628, 0.10671507914495951, 0.07963608049945888, 0.1461344852282649, 0.11542382032988642, 0.17734600262840192, 0.1205979349528941, 0.08144415867019333}, {0.3069737570261181, 0.1915847277594976, 0.14036404942051617, 0.23939118968346385, 0.3469863460136935, 0.20181150840646614, 0.1904103676744075, 0.32238360499427005, 0.11811615166845511, 0.10828837422992235, 0.32987192458491676, 0.3711209076043668, 0.17546817567436623, 0.26207890675878903, 0.24699399116385928, 0.2613010630573486, 0.15557988912970588, 0.3880069855694947, 0.31176053362415046, 0.24052564292867878}, {0.22547059743711106, 0.14769055730357455, 0.20012725376684828, 0.039629658192879155, 0.1825838868465678, 0.1495698105307718, 0.18489055531107929, 0.2159373762774229, 0.20068557131416745, 0.18672627174608417, 0.19407391163938406, 0.20679473244512073, 0.1972371787801222, 0.20951099681987934, 0.18883875723350013, 0.16445205837986648, 0.2355358000898393, 0.1270525749522279, 0.13886528936006987, 0.1640852587769147}, {0.11327777379288695, 0.14805212466371087, 0.11322242078199876, 0.009317062256254744, 0.1439023266425758, 0.1646398180942733, 0.1871936403830156, 0.1556192508865479, 0.09518401082951523, 0.22949186441697597, 0.07489652747083951, 0.25258431871276404, 0.34629775736290636, 0.18499630560708014, 0.0280492413693066, 0.19017182965933188, 0.2659337897478473, 0.14810695085345263, 0.2621861240846756, 0.10743278482621241}, {0.108131693248318, 0.06364832758711902, 0.08008651030418484, 0.0078076013101496975, 0.1547624860503859, 0.13105975667637623, 0.11155429300983646, 0.05658929621007584, 0.10813978318226443, 0.15471170612076546, 0.038486898539058886, 0.18833988803464594, 0.2860378860607952, 0.17130689702473673, 0.0780492606028306, 0.051205018808861275, 0.05788557476821252, 0.20196533812048947, 0.11760967504437886, 0.037600987261180586}};

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("-h") || s.equals("--help")) {
                DockSorterPiper.printUsage();
            }
            ++n2;
        }
        HashMap<String, String> options = DockSorterPiper.readInOptions(args);
        boolean quiet = false;
        if (options.get("-quiet").equals("T")) {
            quiet = true;
        }
        HashMap<Character, HashMap<Integer, Residue>> ab_struc = DockSorterPiper.ChainAvailability(options, "b");
        HashMap<Character, HashMap<Integer, Residue>> ag_struc = DockSorterPiper.ChainAvailability(options, "g");
        HashMap<Character, ArrayList<Integer>> ab_constr = null;
        if (options.get("-constab").length() > 0) {
            ab_constr = DockSorterPiper.CheckConstraints(options, "b", ab_struc);
        }
        HashMap<Character, ArrayList<Integer>> ag_constr = null;
        if (options.get("-constag").length() > 0) {
            ag_constr = DockSorterPiper.CheckConstraints(options, "g", ag_struc);
        }
        double sum = 0.0;
        int total_sums = 0;
        for (Character chain_ag : ag_struc.keySet()) {
            for (Character chain_ab : ab_struc.keySet()) {
                HashMap<Integer, Residue> ab = ab_struc.get(chain_ab);
                HashMap<Integer, Residue> ag = ag_struc.get(chain_ag);
                for (Integer i_ab : ab.keySet()) {
                    for (Integer i_ag : ag.keySet()) {
                        if (ab_constr != null && ab_constr.containsKey(chain_ab)) {
                            if (!quiet) {
                                System.out.println("By constraint");
                            }
                            if (!ab_constr.get(chain_ab).contains(i_ab)) continue;
                        }
                        if (ag_constr != null && ag_constr.containsKey(chain_ag) && !ag_constr.get(chain_ag).contains(i_ag) || !(ab.get(i_ab).distanceFrom(ag.get(i_ag)) < 4.5)) continue;
                        sum += prop_mat[ab.get((Object)i_ab).type.ordinal()][ag.get((Object)i_ag).type.ordinal()];
                        ++total_sums;
                    }
                }
            }
        }
        System.out.println(sum);
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -jar DockSorter.jar -abf [antibody file] -agf [antigen file] -abc [antibody chain(s)] -agc [antigen chain(s)] -constab [constraint file for antibody] -constag [constraint file for antigen]");
        System.out.println("If the option --quiet is given on input, only the final score will be printed out");
        System.out.println("The constraint files are optional - if not provided the calcualation will involve all interface (<4.5A apart) residues");
        System.out.println("The decoys should be sorted in descending order by the output of this program (ie highest score decoys are 'the best')");
        System.out.println("Since the command is fairly long, it is strongly suggested that the user adapts the example distributed with program at http://www.stats.ox.ac.uk/research/proteins/resources");
        System.exit(0);
    }

    public static HashMap<Character, ArrayList<Integer>> CheckConstraints(HashMap<String, String> options, String abag, HashMap<Character, HashMap<Integer, Residue>> struc) {
        ArrayList<String> constr = FileSystemTools.readFile(options.get("-consta" + abag));
        HashMap<Character, ArrayList<Integer>> constr_map = new HashMap<Character, ArrayList<Integer>>();
        for (String line : constr) {
            ArrayList<Integer> temp;
            char chain;
            if (!line.contains(" ")) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            Integer res_id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            String chain_part = line.substring(line.indexOf(" ") + 1);
            if (chain_part.length() > 1) {
                System.out.println("The constraints file " + options.get("-consta" + abag) + " appears to be badly formatted. Check line: \n" + line);
            }
            if (!struc.containsKey(Character.valueOf(chain = chain_part.charAt(0)))) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", contains a chain " + chain + " which was not specified as one of the chains of the structure. Stopping");
                DockSorterPiper.printUsage();
            }
            if (!struc.get(Character.valueOf(chain)).containsKey(res_id)) {
                System.out.println("The constraint file for  " + (abag.equals("b") ? "antibody" : "antigen") + ", lists residue " + res_id + " on chain " + chain + " - there is no such residue on this chain in the structure. Stopping");
                DockSorterPiper.printUsage();
            }
            if (constr_map.containsKey(Character.valueOf(chain))) {
                temp = constr_map.get(Character.valueOf(chain));
                temp.add(res_id);
                constr_map.put(Character.valueOf(chain), temp);
                continue;
            }
            if (!constr_map.containsKey(Character.valueOf(chain))) continue;
            temp = new ArrayList();
            temp.add(res_id);
            constr_map.put(Character.valueOf(chain), temp);
        }
        return constr_map;
    }

    public static HashMap<Character, HashMap<Integer, Residue>> ChainAvailability(HashMap<String, String> options, String abag) {
        HashMap<Character, HashMap<Integer, Residue>> struc = new HashMap<Character, HashMap<Integer, Residue>>();
        String chains = PDB_parser.getChains(options.get("-a" + abag + "f"));
        int i = 0;
        while (i < options.get("-a" + abag + "c").length()) {
            String chain = String.valueOf(options.get("-a" + abag + "c").charAt(i));
            if (!chains.contains(chain)) {
                System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " file does not have chain " + chain + " - Stopping");
                DockSorterPiper.printUsage();
            } else {
                HashMap<Integer, Residue> ab = PDB_parser.parse(options.get("-a" + abag + "f"), chain.charAt(0));
                if (ab.size() < 5) {
                    System.out.println("The " + (abag.equals("b") ? "antibody" : "antigen") + " you provided appears incomplete - size of chain " + chain + " is " + ab.size() + ". Stopping");
                    DockSorterPiper.printUsage();
                }
                if (!struc.containsKey(Character.valueOf(chain.charAt(0)))) {
                    struc.put(Character.valueOf(chain.charAt(0)), ab);
                } else {
                    System.out.println("You have supplied multiple instances of one chain for the " + (abag.equals("b") ? "antibody" : "antigen") + " : " + chain.charAt(0));
                    DockSorterPiper.printUsage();
                }
            }
            ++i;
        }
        for (Character c : struc.keySet()) {
        }
        return struc;
    }

    public static HashMap<String, String> readInOptions(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("-agf", "");
        options.put("-abf", "");
        options.put("-agc", "");
        options.put("-abc", "");
        options.put("-constab", "");
        options.put("-constag", "");
        options.put("-quiet", "F");
        boolean quiet = false;
        int i = 0;
        while (i < args.length) {
            String opt;
            if (i == args.length) {
                System.err.println("Not enough arguments supplied");
                DockSorterPiper.printUsage();
            }
            if (!options.containsKey(opt = args[i])) {
                System.err.println("Unknown option : " + opt);
                DockSorterPiper.printUsage();
            }
            if (opt.equals("-quiet")) {
                options.put(opt, "T");
                quiet = true;
            } else {
                String input = args[i + 1];
                ++i;
                options.put(opt, input);
            }
            ++i;
        }
        if (!quiet) {
            System.out.println("Executing with options:");
        }
        for (String opt : options.keySet()) {
            if (options.get(opt).length() == 0 && !opt.contains("-cons")) {
                System.err.println(String.valueOf(opt) + " uninitialized");
                DockSorterPiper.printUsage();
                continue;
            }
            if (!quiet) {
                System.out.println(String.valueOf(opt) + " : " + options.get(opt));
            }
            if (opt.equals("-agc") || opt.equals("-abc") || opt.equals("-quiet")) continue;
            File f = null;
            if (options.get(opt).charAt(0) == '/') {
                f = new File(options.get(opt));
            } else {
                f = new File(String.valueOf(userdir) + "/" + options.get(opt));
                options.put(opt, String.valueOf(userdir) + "/" + options.get(opt));
            }
            if (f.exists()) continue;
            System.out.println("The file " + options.get(opt) + " doesn't exist - Stopping");
            DockSorterPiper.printUsage();
        }
        return options;
    }
}

