/*
 * Decompiled with CFR 0.152.
 */
package DockingSets;

import java.util.ArrayList;
import java.util.HashMap;
import utils.FileSystemTools;

public class IdentityTable {
    private static final String userdir = System.getProperty("user.dir");
    private static final String dir = String.valueOf(userdir) + "/resources/DatasetAnalysis";

    public static void main(String[] args) {
        IdentityTable.createLatexADARS();
    }

    public static void ADARSfinalAG() {
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/ALL/AG.fa");
        ArrayList<String> train = IdentityTable.adarsAG();
        ArrayList<String> output = new ArrayList<String>();
        int i = 0;
        while (i < abs.size()) {
            String pdb;
            String s = abs.get(i);
            System.out.println(s);
            if (s.length() > 0 && s.charAt(0) == '>' && train.contains(pdb = s.substring(1, 7))) {
                System.out.println(pdb);
                output.add(s);
                output.add(abs.get(i + 1));
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(dir) + "/ADARS/AG.fa", output);
    }

    public static void ADARSfinalAB() {
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/ALL/AB.fa");
        ArrayList<String> train = IdentityTable.adarsAB();
        ArrayList<String> output = new ArrayList<String>();
        int i = 0;
        while (i < abs.size()) {
            String pdb;
            String s = abs.get(i);
            if (s.length() > 0 && s.charAt(0) == '>' && train.contains(pdb = s.substring(1, 8))) {
                System.out.println(pdb);
                output.add(s);
                output.add(abs.get(i + 1));
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(dir) + "/ADARS/AB.fa", output);
    }

    public static ArrayList<String> adarsAB() {
        ArrayList<Object> u_pdb_orig = new ArrayList<Object>();
        ArrayList<Object> u_pdb_got = new ArrayList<Object>();
        ArrayList<String> testAG = IdentityTable.adarsTestAB();
        System.out.println(testAG.size());
        for (String s : testAG) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_orig.contains(pdb)) {
                u_pdb_orig.add(pdb);
            }
            System.out.println(s);
        }
        ArrayList<String> testAGconstr = IdentityTable.constrainDatasetAB(testAG);
        for (String s : testAGconstr) {
            Object pdb = s.substring(0, 4);
            if (!u_pdb_got.contains(pdb)) {
                u_pdb_got.add(pdb);
            }
            System.out.println("Contrained " + s);
        }
        ArrayList<String> trainAG = IdentityTable.adarsTrainingAB();
        System.out.println(trainAG.size());
        for (String s : trainAG) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_orig.contains(pdb)) {
                u_pdb_orig.add(pdb);
            }
            System.out.println(s);
        }
        ArrayList<String> trainAGconstr = IdentityTable.constrainDatasetAB(trainAG);
        for (String s : trainAGconstr) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_got.contains(pdb)) {
                u_pdb_got.add(pdb);
            }
            System.out.println("Contrained " + s);
        }
        System.out.println(String.valueOf(u_pdb_orig.size()) + " : " + u_pdb_got.size());
        for (Object pdb : u_pdb_orig) {
            if (u_pdb_got.contains(pdb)) continue;
            System.out.println("Didnt get " + (String)pdb);
        }
        trainAGconstr.addAll(testAGconstr);
        return trainAGconstr;
    }

    public static ArrayList<String> adarsAG() {
        ArrayList<Object> u_pdb_orig = new ArrayList<Object>();
        ArrayList<Object> u_pdb_got = new ArrayList<Object>();
        ArrayList<String> testAG = IdentityTable.adarsTestAG();
        System.out.println(testAG.size());
        for (String s : testAG) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_orig.contains(pdb)) {
                u_pdb_orig.add(pdb);
            }
            System.out.println(s);
        }
        ArrayList<String> testAGconstr = IdentityTable.constrainDatasetAG(testAG);
        for (String s : testAGconstr) {
            Object pdb = s.substring(0, 4);
            if (!u_pdb_got.contains(pdb)) {
                u_pdb_got.add(pdb);
            }
            System.out.println("Contrained " + s);
        }
        ArrayList<String> trainAG = IdentityTable.adarsTrainingAG();
        System.out.println(trainAG.size());
        for (String s : trainAG) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_orig.contains(pdb)) {
                u_pdb_orig.add(pdb);
            }
            System.out.println(s);
        }
        ArrayList<String> trainAGconstr = IdentityTable.constrainDatasetAG(trainAG);
        for (String s : trainAGconstr) {
            String pdb = s.substring(0, 4);
            if (!u_pdb_got.contains(pdb)) {
                u_pdb_got.add(pdb);
            }
            System.out.println("Contrained " + s);
        }
        System.out.println(String.valueOf(u_pdb_orig.size()) + " : " + u_pdb_got.size());
        for (Object pdb : u_pdb_orig) {
            if (u_pdb_got.contains(pdb)) continue;
            System.out.println("Didnt get " + (String)pdb);
        }
        trainAGconstr.addAll(testAGconstr);
        return trainAGconstr;
    }

    public static ArrayList<String> adarsTestAB() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(dir) + "/ADARS/test.txt");
        ArrayList<String> abs = new ArrayList<String>();
        ArrayList<String> ags = new ArrayList<String>();
        for (String pdb : pdbs) {
            String pdb_code = pdb.substring(0, pdb.indexOf("_"));
            String ab_ch = pdb.substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String ag_ch = pdb.substring(pdb.indexOf(":") + 1, pdb.indexOf(" "));
            abs.add(String.valueOf(pdb_code.toLowerCase()) + "_" + ab_ch);
            int i = 0;
            while (i < ag_ch.length()) {
                char c = ag_ch.charAt(i);
                System.out.println("AG " + pdb_code + "_" + c);
                ags.add(String.valueOf(pdb_code.toLowerCase()) + "_" + c);
                ++i;
            }
        }
        return abs;
    }

    public static ArrayList<String> adarsTestAG() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(dir) + "/ADARS/test.txt");
        ArrayList<String> abs = new ArrayList<String>();
        ArrayList<String> ags = new ArrayList<String>();
        for (String pdb : pdbs) {
            String pdb_code = pdb.substring(0, pdb.indexOf("_"));
            String ab_ch = pdb.substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String ag_ch = pdb.substring(pdb.indexOf(":") + 1, pdb.indexOf(" "));
            abs.add(String.valueOf(pdb_code.toLowerCase()) + "_" + ab_ch);
            int i = 0;
            while (i < ag_ch.length()) {
                char c = ag_ch.charAt(i);
                System.out.println("AG " + pdb_code + "_" + c);
                ags.add(String.valueOf(pdb_code.toLowerCase()) + "_" + c);
                ++i;
            }
        }
        return ags;
    }

    public static ArrayList<String> adarsTrainingAB() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(dir) + "/ADARS/training.txt");
        ArrayList<String> abs = new ArrayList<String>();
        ArrayList<String> ags = new ArrayList<String>();
        for (String pdb : pdbs) {
            String pdb_code = pdb.substring(0, pdb.indexOf("_"));
            String ab_ch = pdb.substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String ag_ch = pdb.substring(pdb.indexOf(":") + 1);
            abs.add(String.valueOf(pdb_code.toLowerCase()) + "_" + ab_ch);
            int i = 0;
            while (i < ag_ch.length()) {
                char c = ag_ch.charAt(i);
                System.out.println("AG " + pdb_code + "_" + c);
                ags.add(String.valueOf(pdb_code.toLowerCase()) + "_" + c);
                ++i;
            }
        }
        return abs;
    }

    public static ArrayList<String> adarsTrainingAG() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(dir) + "/ADARS/training.txt");
        ArrayList<String> abs = new ArrayList<String>();
        ArrayList<String> ags = new ArrayList<String>();
        for (String pdb : pdbs) {
            String pdb_code = pdb.substring(0, pdb.indexOf("_"));
            String ab_ch = pdb.substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String ag_ch = pdb.substring(pdb.indexOf(":") + 1);
            abs.add(String.valueOf(pdb_code.toLowerCase()) + "_" + ab_ch);
            int i = 0;
            while (i < ag_ch.length()) {
                char c = ag_ch.charAt(i);
                System.out.println("AG " + pdb_code + "_" + c);
                ags.add(String.valueOf(pdb_code.toLowerCase()) + "_" + c);
                ++i;
            }
        }
        return ags;
    }

    public static void createLatexADARS() {
        IdentityTable.createOrTableAll("ADARS_cdhit");
        IdentityTable.createANDTableAll("ADARS_cdhit");
    }

    public static void createLatex() {
        IdentityTable.createOrTableAll("ALL");
        IdentityTable.createANDTableAll("ALL");
        IdentityTable.createOrTablePep("ALL");
        IdentityTable.createANDTablePep("ALL");
        IdentityTable.createOrTableProtein("ALL");
        IdentityTable.createANDTableProtein("ALL");
    }

    public static ArrayList<String> constrainDatasetAG(ArrayList<String> abs) {
        ArrayList<String> abfa = IdentityTable.loadAGSonly("ALL");
        for (String string : abfa) {
        }
        ArrayList<String> goodpdbs = new ArrayList<String>();
        ArrayList<String> fails = new ArrayList<String>();
        for (String pdb_code : abs) {
            boolean added = false;
            for (String have : abfa) {
                boolean reject = false;
                String pdb = have.substring(0, 4);
                if (pdb_code.contains(pdb)) {
                    String chains_have = have.substring(5);
                    String chains_seek = pdb_code.substring(5);
                    System.out.println(String.valueOf(pdb_code) + " : " + have);
                    System.out.println(String.valueOf(chains_have) + " : " + chains_seek);
                    int i = 0;
                    while (i < chains_seek.length()) {
                        char c = chains_seek.charAt(i);
                        if (!chains_have.contains(String.valueOf(c))) {
                            reject = true;
                        }
                        ++i;
                    }
                } else {
                    reject = true;
                }
                if (reject) continue;
                goodpdbs.add(have);
                added = true;
                break;
            }
            if (added) continue;
            fails.add(pdb_code);
        }
        for (String f : fails) {
            System.out.println("Failed " + f);
        }
        for (String g : goodpdbs) {
            System.out.println("Good " + g);
        }
        return goodpdbs;
    }

    public static ArrayList<String> constrainDatasetAB(ArrayList<String> abs) {
        ArrayList<String> abfa = IdentityTable.loadABS("ALL");
        for (String string : abfa) {
        }
        ArrayList<String> goodpdbs = new ArrayList<String>();
        ArrayList<String> fails = new ArrayList<String>();
        for (String pdb_code : abs) {
            boolean added = false;
            for (String have : abfa) {
                boolean reject = false;
                String pdb = have.substring(0, 4);
                if (pdb_code.contains(pdb)) {
                    String chains_have = have.substring(5, 7);
                    String chains_seek = pdb_code.substring(5, 7);
                    System.out.println(String.valueOf(pdb_code) + " : " + have);
                    System.out.println(String.valueOf(chains_have) + " : " + chains_seek);
                    int i = 0;
                    while (i < chains_seek.length()) {
                        char c = chains_seek.charAt(i);
                        if (!chains_have.contains(String.valueOf(c))) {
                            reject = true;
                        }
                        ++i;
                    }
                } else {
                    reject = true;
                }
                if (reject) continue;
                goodpdbs.add(have);
                added = true;
                break;
            }
            if (added) continue;
            fails.add(pdb_code);
        }
        for (String f : fails) {
            System.out.println("Failed " + f);
        }
        for (String g : goodpdbs) {
            System.out.println("Good " + g);
        }
        return goodpdbs;
    }

    public static void createOrTableAll(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGS(dataset, 0);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Only one of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust(dataset, ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust(dataset, ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        System.out.println("1: " + ab + " " + abmap.get(ab));
                        System.out.println("2: " + ag + " " + agmap.get(ag));
                        System.out.println("3: " + ab_acc + " " + abmap.get(ab_acc));
                        System.out.println("4: " + ag_acc + " " + agmap.get(ag_acc));
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) || !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_OR_All.tex", output);
    }

    public static void createANDTableAll(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGS(dataset, 0);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Both of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust(dataset, ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust(dataset, ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) && !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_AND_All.tex", output);
    }

    public static void createOrTableProtein(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGS(dataset, 39);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Only one of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust("ALL", ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust("ALL", ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) || !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_OR_Protein.tex", output);
    }

    public static void createANDTableProtein(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGS(dataset, 39);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Both of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust("ALL", ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust("ALL", ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) && !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_AND_Protein.tex", output);
    }

    public static void createOrTablePep(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGSPep(dataset, 39);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Only one of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust("ALL", ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust("ALL", ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) || !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_OR_Pep.tex", output);
    }

    public static void createANDTablePep(String dataset) {
        HashMap<String, String> bound = IdentityTable.loadAGSPep(dataset, 39);
        ArrayList<String> abs = IdentityTable.loadABS(dataset);
        double sum = 0.0;
        for (String ab : abs) {
            if (!bound.containsKey(ab)) continue;
            sum += 1.0;
        }
        System.out.println(String.valueOf(sum) + "/" + abs.size());
        System.out.println(bound.size());
        ArrayList<String> output = new ArrayList<String>();
        output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + dataset + " : Both of the conditions must be met.}\\begin{tabular}{|c || c | c | c | c | c | c | c | c |}\\hline" + "\n Ab/Ag & All & 70 & 75 & 80 & 85 & 90 & 95 & 99 \\\\ \\hline \\hline");
        ArrayList<Integer> ab_cuts = new ArrayList<Integer>();
        ab_cuts.add(-1);
        ab_cuts.add(70);
        ab_cuts.add(75);
        ab_cuts.add(80);
        ab_cuts.add(85);
        ab_cuts.add(90);
        ab_cuts.add(95);
        ab_cuts.add(99);
        ArrayList<Integer> ag_cuts = new ArrayList<Integer>();
        ag_cuts.add(-1);
        ag_cuts.add(70);
        ag_cuts.add(75);
        ag_cuts.add(80);
        ag_cuts.add(85);
        ag_cuts.add(90);
        ag_cuts.add(95);
        ag_cuts.add(99);
        int i_ab = 0;
        while (i_ab < ab_cuts.size()) {
            String out_str = "";
            int i_ag = 0;
            while (i_ag < ag_cuts.size()) {
                int ab_cut = (Integer)ab_cuts.get(i_ab);
                int ag_cut = (Integer)ag_cuts.get(i_ag);
                HashMap<String, String> agmap = IdentityTable.AGClust("ALL", ab_cut);
                HashMap<String, String> abmap = IdentityTable.ABClust("ALL", ag_cut);
                HashMap<String, String> accepted = new HashMap<String, String>();
                for (String ab : bound.keySet()) {
                    String ag = bound.get(ab);
                    boolean reject = false;
                    for (String ab_acc : accepted.keySet()) {
                        String ag_acc = (String)accepted.get(ab_acc);
                        if (!abmap.get(ab).equals(abmap.get(ab_acc)) && !agmap.get(ag).equals(agmap.get(ag_acc))) continue;
                        reject = true;
                        break;
                    }
                    if (reject) continue;
                    accepted.put(ab, ag);
                }
                out_str = i_ag == 0 ? ((Integer)ab_cuts.get(i_ab) == -1 ? String.valueOf(out_str) + "All & " + accepted.size() : String.valueOf(out_str) + ab_cuts.get(i_ab) + " & " + accepted.size()) : String.valueOf(out_str) + " & " + accepted.size();
                System.out.println(" : " + accepted.size() + " out of " + bound.size());
                ++i_ag;
            }
            out_str = String.valueOf(out_str) + "\\\\ \\hline";
            output.add(out_str);
            ++i_ab;
        }
        output.add("\\end{tabular}\\end{table}\\end{document}");
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/latex/table_AND_Pep.tex", output);
    }

    public static HashMap<String, String> allmap(String dataset, String abag) {
        int i = 0;
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/output/" + abag + "_99.txt");
        HashMap<String, String> agmap = new HashMap<String, String>();
        for (String s : abs) {
            String pdb = s.substring(0, s.indexOf("|"));
            String cluster = String.valueOf(i);
            agmap.put(pdb, cluster);
            ++i;
        }
        return agmap;
    }

    public static ArrayList<String> loadABS(String dataset) {
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/AB.fa");
        ArrayList<String> pdbs = new ArrayList<String>();
        for (String s : abs) {
            if (s.length() <= 0 || s.charAt(0) != '>') continue;
            String pdb = s.substring(1, 5);
            String chains = s.substring(s.indexOf("_") + 1, s.indexOf("|"));
            if (chains.length() > 2) continue;
            pdbs.add(String.valueOf(pdb) + "_" + chains);
        }
        return pdbs;
    }

    public static ArrayList<String> loadAGSonly(String dataset) {
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/AG.fa");
        ArrayList<String> pdbs = new ArrayList<String>();
        for (String s : abs) {
            if (s.length() <= 0 || s.charAt(0) != '>') continue;
            String pdb = s.substring(1, 5);
            String chains = s.substring(s.indexOf("_") + 1, s.indexOf("|"));
            if (chains.length() > 2) continue;
            pdbs.add(String.valueOf(pdb) + "_" + chains);
        }
        return pdbs;
    }

    public static HashMap<String, String> loadAGS(String dataset, int size_limit) {
        ArrayList<String> ag_stuff = new ArrayList<String>();
        ArrayList<String> ag_sizes = new ArrayList<String>();
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/AG.fa");
        HashMap<String, String> pdbs = new HashMap<String, String>();
        int i = 0;
        while (i < abs.size()) {
            String s = abs.get(i);
            if (s.length() > 0 && s.charAt(0) == '>') {
                String pdb = s.substring(1, 5);
                String chains = s.substring(s.indexOf("_") + 1, s.indexOf("|"));
                String ag = abs.get(i + 1);
                if (!ag_stuff.contains(ag)) {
                    ag_stuff.add(ag);
                    ag_sizes.add("" + ag.length());
                }
                if (ag.length() > size_limit) {
                    String ab = s.substring(s.indexOf("bound to:") + 10);
                    pdbs.put(ab, String.valueOf(pdb) + "_" + chains);
                }
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/ag_dist.txt", ag_sizes);
        return pdbs;
    }

    public static HashMap<String, String> loadAGSPep(String dataset, int size_limit) {
        ArrayList<String> ag_stuff = new ArrayList<String>();
        ArrayList<String> ag_sizes = new ArrayList<String>();
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/AG.fa");
        HashMap<String, String> pdbs = new HashMap<String, String>();
        int i = 0;
        while (i < abs.size()) {
            String s = abs.get(i);
            if (s.length() > 0 && s.charAt(0) == '>') {
                String pdb = s.substring(1, 5);
                String chains = s.substring(s.indexOf("_") + 1, s.indexOf("|"));
                String ag = abs.get(i + 1);
                if (!ag_stuff.contains(ag)) {
                    ag_stuff.add(ag);
                    ag_sizes.add("" + ag.length());
                }
                if (ag.length() < size_limit) {
                    String ab = s.substring(s.indexOf("bound to:") + 10);
                    pdbs.put(ab, String.valueOf(pdb) + "_" + chains);
                }
            }
            ++i;
        }
        FileSystemTools.writeFile(String.valueOf(dir) + "/" + dataset + "/ag_dist.txt", ag_sizes);
        return pdbs;
    }

    public static HashMap<String, String> AGClust(String dataset, int cutoff) {
        if (cutoff == -1) {
            return IdentityTable.allmap(dataset, "AG");
        }
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/output/AG_" + cutoff + ".txt");
        HashMap<String, String> agmap = new HashMap<String, String>();
        for (String s : abs) {
            String pdb = s.substring(0, s.indexOf("|"));
            String cluster = s.substring(s.indexOf("\t") + 1);
            agmap.put(pdb, cluster);
        }
        return agmap;
    }

    public static HashMap<String, String> ABClust(String dataset, int cutoff) {
        if (cutoff == -1) {
            return IdentityTable.allmap(dataset, "AB");
        }
        ArrayList<String> abs = FileSystemTools.readFile(String.valueOf(dir) + "/" + dataset + "/output/AB_" + cutoff + ".txt");
        HashMap<String, String> agmap = new HashMap<String, String>();
        for (String s : abs) {
            String pdb = s.substring(0, s.indexOf("|"));
            String cluster = s.substring(s.indexOf("\t") + 1);
            agmap.put(pdb, cluster);
        }
        return agmap;
    }
}

