/*
 * Decompiled with CFR 0.152.
 */
import data_structures.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

public class NeedlemanWunsch {
    char[] mSeqA;
    char[] mSeqB;
    int[][] mD;
    int mScore;
    String mAlignmentSeqA = "";
    String mAlignmentSeqB = "";

    void init(char[] seqA, char[] seqB) {
        this.mSeqA = seqA;
        this.mSeqB = seqB;
        this.mD = new int[this.mSeqA.length + 1][this.mSeqB.length + 1];
        int i = 0;
        while (i <= this.mSeqA.length) {
            int j = 0;
            while (j <= this.mSeqB.length) {
                this.mD[i][j] = i == 0 ? -j : (j == 0 ? -i : 0);
                ++j;
            }
            ++i;
        }
    }

    void process() {
        int i = 1;
        while (i <= this.mSeqA.length) {
            int j = 1;
            while (j <= this.mSeqB.length) {
                int scoreDiag = this.mD[i - 1][j - 1] + this.weight(i, j);
                int scoreLeft = this.mD[i][j - 1] - 1;
                int scoreUp = this.mD[i - 1][j] - 1;
                this.mD[i][j] = Math.max(Math.max(scoreDiag, scoreLeft), scoreUp);
                ++j;
            }
            ++i;
        }
    }

    void backtrack() {
        int i = this.mSeqA.length;
        int j = this.mSeqB.length;
        this.mScore = this.mD[i][j];
        while (i > 0 && j > 0) {
            if (this.mD[i][j] == this.mD[i - 1][j - 1] + this.weight(i, j)) {
                this.mAlignmentSeqA = String.valueOf(this.mAlignmentSeqA) + this.mSeqA[i - 1];
                this.mAlignmentSeqB = String.valueOf(this.mAlignmentSeqB) + this.mSeqB[j - 1];
                --i;
                --j;
                continue;
            }
            if (this.mD[i][j] == this.mD[i][j - 1] - 1) {
                this.mAlignmentSeqA = String.valueOf(this.mAlignmentSeqA) + "-";
                this.mAlignmentSeqB = String.valueOf(this.mAlignmentSeqB) + this.mSeqB[j - 1];
                --j;
                continue;
            }
            this.mAlignmentSeqA = String.valueOf(this.mAlignmentSeqA) + this.mSeqA[i - 1];
            this.mAlignmentSeqB = String.valueOf(this.mAlignmentSeqB) + "-";
            --i;
        }
        System.out.println("Initial form :");
        System.out.println(new StringBuffer(this.mAlignmentSeqA).toString());
        this.mAlignmentSeqA = new StringBuffer(this.mAlignmentSeqA).reverse().toString();
        this.mAlignmentSeqB = new StringBuffer(this.mAlignmentSeqB).reverse().toString();
    }

    private int weight(int i, int j) {
        if (this.mSeqA[i - 1] == this.mSeqB[j - 1]) {
            return 1;
        }
        return -1;
    }

    void printMatrix() {
        System.out.println("D =");
        int i = 0;
        while (i < this.mSeqA.length + 1) {
            int j = 0;
            while (j < this.mSeqB.length + 1) {
                System.out.print(String.format("%4d ", this.mD[i][j]));
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    void printScoreAndAlignments() {
        System.out.println("Score: " + this.mScore);
        System.out.println("Sequence A: " + this.mAlignmentSeqA);
        System.out.println("Sequence B: " + this.mAlignmentSeqB);
        System.out.println();
    }

    public static void NW_align(HashMap<Integer, Residue> pdbs, String sequence) {
        char[] from_pdb = NeedlemanWunsch.changeToChars(pdbs);
        char[] from_seq = NeedlemanWunsch.changeToChars(sequence);
        ArrayList<charObj> res_map = NeedlemanWunsch.annotate(from_seq, from_pdb);
        String seq = "";
        int i = 0;
        while (i < 5) {
            seq = String.valueOf(seq) + res_map.get((int)i).c;
            ++i;
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i2 : pdbs.keySet()) {
            sorted.add(i2);
        }
        String pdb_seq = "";
        for (Integer i3 : sorted) {
            pdb_seq = String.valueOf(pdb_seq) + (Object)((Object)pdbs.get((Object)i3).type);
        }
        int to_drop = pdb_seq.indexOf(seq);
        int index = 0;
        for (Integer i4 : sorted) {
            if (to_drop > 0) {
                --to_drop;
                continue;
            }
            charObj co = res_map.get(index);
            System.out.println((Object)((Object)pdbs.get((Object)i4).type) + " : " + co.c + " : " + co.ann);
            pdbs.get(i4).setRefSite(co.ann);
            ++index;
        }
    }

    public static char[] changeToChars(HashMap<Integer, Residue> res) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : res.keySet()) {
            sorted.add(i);
        }
        String seq = "";
        for (Integer i : sorted) {
            seq = String.valueOf(seq) + (Object)((Object)res.get((Object)i).type);
        }
        System.out.println("From pdb:");
        return NeedlemanWunsch.changeToChars(seq);
    }

    public static char[] changeToChars(String seq) {
        char[] seq_c = new char[seq.length()];
        int i = 0;
        while (i < seq.length()) {
            seq_c[i] = seq.charAt(i);
            ++i;
        }
        System.out.println(seq_c);
        return seq_c;
    }

    public static void main(String[] args) {
    }

    public static ArrayList<charObj> annotate(char[] seqA, char[] seqB) {
        NeedlemanWunsch nw = new NeedlemanWunsch();
        nw.init(seqA, seqB);
        nw.process();
        nw.backtrack();
        nw.printScoreAndAlignments();
        ArrayList<charObj> res_map = new ArrayList<charObj>();
        int actual_index = 0;
        int i = 0;
        while (i < nw.mAlignmentSeqB.length()) {
            char c_A = nw.mAlignmentSeqA.charAt(i);
            char c_B = nw.mAlignmentSeqB.charAt(i);
            if (c_B == '-') {
                ++actual_index;
            } else {
                charObj co;
                if (c_A != '-') {
                    co = new charObj(c_B, actual_index);
                    ++actual_index;
                } else {
                    co = new charObj(c_B, -1);
                }
                res_map.add(co);
            }
            ++i;
        }
        return res_map;
    }

    public static class charObj {
        public final char c;
        public final int ann;

        public charObj(char _c, int _a) {
            this.c = _c;
            this.ann = _a;
        }
    }
}

