/*
 * Decompiled with CFR 0.152.
 */
package Ponomarenko;

import data_structures.Atom;
import data_structures.Residue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.WebTools;

public class PrepareData {
    public static final String userdir = System.getProperty("user.dir");
    public static final String dir = String.valueOf(userdir) + "/result_dump/Ponomarenko";
    public static final String result_dump = String.valueOf(userdir) + "/result_dump";

    public static void main(String[] args) {
        PrepareData.standardizePDBS();
    }

    public static void getCDRs() {
        ArrayList<String> test = PrepareData.readPDBSet(String.valueOf(userdir) + "/result_dump/test_training_sets/test_ponom.txt");
        HashMap<String, PDB_record> map = PrepareData.readABChains();
        for (String pdb : test) {
            File f = new File(String.valueOf(userdir) + "/protein_database/antibodies/cdr_files/" + pdb + ".txt");
            if (f.exists()) continue;
            HashMap<String, String> cdrs = WebTools.downloadCDRRealChain(pdb, String.valueOf(map.get((Object)pdb).H_chain) + map.get((Object)pdb).L_chain);
            System.out.println("==========================");
            String out = "";
            for (String id : cdrs.keySet()) {
                out = String.valueOf(out) + id + " " + cdrs.get(id) + "\n";
                System.out.println(String.valueOf(pdb) + "_" + id + " : " + cdrs.get(id));
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/protein_database/antibodies/cdr_files/" + pdb + ".txt", out);
            System.out.println("==========================");
        }
    }

    public static void createConcat() {
        String concat_folder = String.valueOf(userdir) + "/protein_database/concat";
        String std_fold = String.valueOf(userdir) + "/protein_database/standard_pono";
        HashMap<String, PDB_record> map = PrepareData.readABChains();
        int prog = 0;
        for (String pdb_code : map.keySet()) {
            System.out.println(String.valueOf(pdb_code) + " :" + ++prog + "/" + map.size());
            ArrayList<String> ab = FileSystemTools.readFile(String.valueOf(std_fold) + "/" + pdb_code + "_A.pdb");
            ArrayList<String> ag = FileSystemTools.readFile(String.valueOf(std_fold) + "/" + pdb_code + "_B.pdb");
            String out = "";
            int i = 0;
            while (i < ab.size()) {
                out = String.valueOf(out) + ab.get(i) + "\n";
                ++i;
            }
            i = 0;
            while (i < ag.size()) {
                out = String.valueOf(out) + ag.get(i) + "\n";
                ++i;
            }
            FileSystemTools.writeFile(String.valueOf(concat_folder) + "/" + pdb_code + "_C.pdb", out);
        }
    }

    public static void FindFarFarAway() {
        String std_fold = String.valueOf(userdir) + "/protein_database/standard_pono";
        HashMap<String, PDB_record> map = PrepareData.readABChains();
        for (String pdb_code : map.keySet()) {
            HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(std_fold) + "/" + pdb_code + "_A.pdb", 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(std_fold) + "/" + pdb_code + "_B.pdb", 'A');
            if (ab.size() == 0 || ag.size() == 0) {
                System.err.println(String.valueOf(pdb_code) + " is empty");
            }
            boolean found = false;
            double min = 100.0;
            if (pdb_code.equals("2JIX")) {
                System.out.println("AG: " + (Object)((Object)ag.get((Object)Integer.valueOf((int)17)).type));
                System.out.println("absize = " + ab.size());
                System.out.println("AB: " + (Object)((Object)ab.get((Object)Integer.valueOf((int)277)).type));
            }
            for (Integer i : ab.keySet()) {
                Residue r_ab = ab.get(i);
                for (Integer j : ag.keySet()) {
                    Residue r_ag = ag.get(j);
                    if (r_ab.distanceFrom(r_ag) < min) {
                        min = r_ab.distanceFrom(r_ag);
                    }
                    if (!(r_ab.distanceFrom(r_ag) < 4.5)) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            System.out.println("Minimal distance found = " + min);
            System.out.println(String.valueOf(pdb_code) + " is very far away from the antigen");
        }
    }

    public static void standardizePDBS() {
        String std_fold = String.valueOf(userdir) + "/protein_database/standard_pono";
        String raw_fold = String.valueOf(userdir) + "/protein_database/raw_files";
        HashMap<String, PDB_record> map = PrepareData.readABChains();
        int prog = 0;
        for (String pdb_code : map.keySet()) {
            String pdb_folder;
            System.out.println(String.valueOf(pdb_code) + " :" + ++prog + "/" + map.size());
            String original_pdb = String.valueOf(raw_fold) + "/" + pdb_code + ".pdb";
            HashMap<Integer, Residue> heavy = PDB_parser.parse(original_pdb, map.get((Object)pdb_code).H_chain);
            TreeSet<Integer> s_h = new TreeSet<Integer>();
            for (Integer i : heavy.keySet()) {
                s_h.add(i);
            }
            HashMap<Integer, Residue> light = PDB_parser.parse(original_pdb, map.get((Object)pdb_code).L_chain);
            TreeSet<Integer> s_l = new TreeSet<Integer>();
            for (Integer i : light.keySet()) {
                s_l.add(i);
            }
            HashMap<Integer, Residue> ag = PDB_parser.parse(original_pdb, map.get((Object)pdb_code).ag_chain);
            TreeSet<Integer> s_ag = new TreeSet<Integer>();
            for (Integer i : ag.keySet()) {
                s_ag.add(i);
            }
            FileWriter fstream = null;
            BufferedWriter out = null;
            try {
                String ord;
                String line;
                Residue r;
                fstream = new FileWriter(String.valueOf(std_fold) + "/" + pdb_code + "_A.pdb");
                out = new BufferedWriter(fstream);
                int ordinal = 1;
                for (Integer i : s_h) {
                    r = heavy.get(i);
                    for (Atom a : r.atoms) {
                        line = a.pdb_line;
                        ord = String.valueOf(ordinal);
                        while (ord.length() < 4) {
                            ord = " " + ord;
                        }
                        line = String.valueOf(line.substring(0, 22)) + ord + " " + line.substring(27);
                        line = PDB_parser.renameChain(line, 'A');
                        out.write(String.valueOf(line) + "\n");
                    }
                    ++ordinal;
                }
                for (Integer i : s_l) {
                    r = light.get(i);
                    for (Atom a : r.atoms) {
                        line = a.pdb_line;
                        ord = String.valueOf(ordinal);
                        while (ord.length() < 4) {
                            ord = " " + ord;
                        }
                        line = String.valueOf(line.substring(0, 22)) + ord + " " + line.substring(27);
                        line = PDB_parser.renameChain(line, 'A');
                        out.write(String.valueOf(line) + "\n");
                    }
                    ++ordinal;
                }
                out.flush();
                fstream.close();
                out.close();
                fstream = new FileWriter(String.valueOf(std_fold) + "/" + pdb_code + "_B.pdb");
                out = new BufferedWriter(fstream);
                ordinal = 1;
                for (Integer i : s_ag) {
                    r = ag.get(i);
                    for (Atom a : r.atoms) {
                        line = a.pdb_line;
                        ord = String.valueOf(ordinal);
                        while (ord.length() < 4) {
                            ord = " " + ord;
                        }
                        line = String.valueOf(line.substring(0, 22)) + ord + line.substring(26);
                        line = PDB_parser.renameChain(line, 'A');
                        out.write(String.valueOf(line) + "\n");
                    }
                    ++ordinal;
                }
                out.flush();
                fstream.close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
            String test_folder = String.valueOf(userdir) + "/Tests/ABPonom";
            File f = new File(test_folder);
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(pdb_folder = String.valueOf(test_folder) + "/" + pdb_code)).exists()) {
                f.mkdir();
            }
            FileSystemTools.CopyFile(String.valueOf(std_fold) + "/" + pdb_code + "_A.pdb", String.valueOf(pdb_folder) + "/strA.pdb");
            FileSystemTools.CopyFile(String.valueOf(std_fold) + "/" + pdb_code + "_B.pdb", String.valueOf(pdb_folder) + "/strB.pdb");
        }
    }

    public static void downloadMissingPDBS() {
        ArrayList<String> train = PrepareData.readPDBSet(String.valueOf(dir) + "/training.txt");
        ArrayList<String> test = PrepareData.readPDBSet(String.valueOf(dir) + "/test.txt");
        ArrayList<String> total_new = new ArrayList<String>();
        total_new.addAll(train);
        total_new.addAll(test);
        String new_std = String.valueOf(userdir) + "/protein_database/raw_files";
        ArrayList<String> old_pdbs = FileSystemTools.getFiles(new_std);
        ArrayList<String> missing = new ArrayList<String>();
        int tot_miss = 0;
        for (String t : total_new) {
            if (old_pdbs.contains(String.valueOf(t.toLowerCase()) + ".pdb") || old_pdbs.contains(String.valueOf(t.toUpperCase()) + ".pdb")) continue;
            missing.add(t);
            ++tot_miss;
        }
        for (String t : test) {
            if (!train.contains(t)) continue;
            System.out.println("GUILTY" + t);
        }
        System.out.println("Missing " + tot_miss);
        PrepareData.DownloadPDBS(missing, new_std);
    }

    public static ArrayList<String> readPDBSet(String filename) {
        ArrayList<String> list = new ArrayList<String>();
        for (String line : FileSystemTools.readFile(filename)) {
            list.add(line.substring(0, 4));
        }
        return list;
    }

    public static void DownloadPDBS(ArrayList<String> pdbs, String to_directory) {
        int i = 1;
        for (String s : pdbs) {
            System.out.println("Downloading " + i + " of " + pdbs.size());
            ++i;
            System.out.println("http://www.pdb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId=" + s.toUpperCase());
            WebTools.writeWebPage(String.valueOf(s.toUpperCase()) + ".pdb", to_directory, "http://www.pdb.org/pdb/download/downloadFile.do?fileFormat=pdb&compression=NO&structureId=" + s.toUpperCase());
        }
    }

    public static void verifyAllIsGood() {
        ArrayList<String> train = PrepareData.readPDBSet(String.valueOf(dir) + "/training.txt");
        ArrayList<String> test = PrepareData.readPDBSet(String.valueOf(dir) + "/test.txt");
        ArrayList<String> total_new = new ArrayList<String>();
        total_new.addAll(train);
        total_new.addAll(test);
        String new_std = String.valueOf(userdir) + "/protein_database/standard_pono";
        ArrayList<String> old_pdbs = FileSystemTools.getFiles(new_std);
        ArrayList<String> missing = new ArrayList<String>();
        int tot_miss = 0;
        for (String t : total_new) {
            if (old_pdbs.contains(String.valueOf(t.toLowerCase()) + ".pdb") || old_pdbs.contains(String.valueOf(t.toUpperCase()) + ".pdb")) continue;
            missing.add(t);
            ++tot_miss;
        }
        int min = Integer.MAX_VALUE;
        String min_pdb = "";
        for (String t : total_new) {
            System.out.println(t);
            String filename = "";
            filename = String.valueOf(new_std) + "/" + t + "_B.pdb";
            ArrayList<String> lines = FileSystemTools.readFile(filename);
            if (min <= lines.size()) continue;
            min = lines.size();
            min_pdb = t;
        }
        System.out.println("Analyzed total of " + total_new.size() + " files");
        System.out.println("Minimal num of lines was " + min + " " + min_pdb);
        System.out.println("Missing " + tot_miss);
    }

    public static HashMap<String, PDB_record> readABChains() {
        HashMap<String, PDB_record> ab = new HashMap<String, PDB_record>();
        ArrayList<String> line_train = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
        ArrayList<String> line_test = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_ponom.txt");
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(line_test);
        lines.addAll(line_train);
        for (String line : lines) {
            String pdb_code = line.substring(0, 4);
            line = line.substring(line.indexOf(32) + 1);
            String H_chain = line.substring(0, line.indexOf(32)).replace(" ", "");
            line = line.substring(line.indexOf(32) + 1);
            String L_chain = line.substring(0, line.indexOf(32)).replace(" ", "");
            line = line.substring(line.indexOf(32) + 1);
            String ag_chain = line.replace(" ", "");
            PDB_record rec = new PDB_record(pdb_code, H_chain.charAt(0), L_chain.charAt(0), ag_chain.charAt(0));
            ab.put(pdb_code, rec);
        }
        for (String pdb : ab.keySet()) {
            System.out.println("===========");
            System.out.println("For " + pdb);
            System.out.println(ab.get(pdb));
            System.out.println("===========");
        }
        return ab;
    }

    public static class PDB_record {
        public final char L_chain;
        public final char H_chain;
        public final char ag_chain;
        public final String pdb_code;

        public PDB_record(String _pdb, char _H, char _L, char _ag) {
            this.L_chain = _L;
            this.H_chain = _H;
            this.ag_chain = _ag;
            this.pdb_code = _pdb;
        }

        public String toString() {
            String res = "pdb=" + this.pdb_code + "\n" + "H=" + this.H_chain + "\n" + "L=" + this.L_chain + "\n" + "ag=" + this.ag_chain + "\n";
            return res;
        }
    }
}

