/*
 * Decompiled with CFR 0.152.
 */
package abModels;

import data_structures.Residue;
import for_terry.DBStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.SmithWaterman;

public class DataCleaner {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String out = "";
        for (String pdb_code : FileSystemTools.getFolders(String.valueOf(userdir) + "/Tests/ABModels/")) {
            HashMap<Integer, Residue> res1 = PDB_parser.parse(String.valueOf(userdir) + "/Tests/ABModels/" + pdb_code + "/strA.pdb");
            HashMap<Integer, Residue> res2 = PDB_parser.parse(String.valueOf(userdir) + "/Tests/ABControl/" + pdb_code + "/strA.pdb");
            for (Integer i : res1.keySet()) {
                if (res1.get((Object)i).type == res2.get((Object)i).type) continue;
                System.err.println(String.valueOf(pdb_code) + " " + i);
            }
        }
    }

    public static HashMap<String, String> getModelMapping() {
        ArrayList<String> models = FileSystemTools.getFiles(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3");
        HashMap<String, String> model_map = new HashMap<String, String>();
        for (String model : models) {
            String model_fld = String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3";
            String pdb = String.valueOf(model_fld) + "/" + model;
            String h = DataCleaner.getSequence(pdb, 'H');
            String l = DataCleaner.getSequence(pdb, 'L');
            if (h.length() != 0) {
                model_map.put(String.valueOf(model.substring(0, 4)) + "H", h);
            }
            if (l.length() == 0) continue;
            model_map.put(String.valueOf(model.substring(0, 4)) + "L", l);
        }
        return model_map;
    }

    public static String getSequence(String pdb, char chain) {
        HashMap<Integer, Residue> residues = PDB_parser.parseString(pdb, chain);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (int i : residues.keySet()) {
            sorted.add(i);
        }
        String output = "";
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int res_i = (Integer)iterator.next();
            output = String.valueOf(output) + (Object)((Object)residues.get((Object)Integer.valueOf((int)res_i)).type);
        }
        return output;
    }

    public static void getSeqSimilar() {
        String model_fld = String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3";
        HashMap<String, DBStats.PDB_record> map = DBStats.getLHMapping();
        ArrayList<String> eligible = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/peptides_and_eligible_pdbs.txt");
        HashMap<String, String> model_map = DataCleaner.getModelMapping();
        int prog = 0;
        String output = "";
        for (String pdb_file : eligible) {
            String pdb_code = pdb_file.substring(0, 4);
            System.out.println(String.valueOf(++prog) + "/" + eligible.size());
            String seq_H = "";
            String seq_L = "";
            char src_h = map.get((Object)pdb_code).H;
            char src_l = map.get((Object)pdb_code).L;
            if (src_h != '\u0000') {
                seq_H = DataCleaner.getSequence(String.valueOf(userdir) + "/protein_database/raw_files/" + pdb_code + ".pdb", src_h);
            }
            if (src_l != '\u0000') {
                seq_L = DataCleaner.getSequence(String.valueOf(userdir) + "/protein_database/raw_files/" + pdb_code + ".pdb", src_l);
            }
            double id_h = 0.0;
            double id_l = 0.0;
            String h_best = "";
            String l_best = "";
            for (String model : model_map.keySet()) {
                double identity;
                String m_seq = model_map.get(model);
                if (model.charAt(4) == 'L' && seq_L.length() != 0) {
                    identity = SmithWaterman.computeIdentity(seq_L, m_seq);
                    if (!(identity > id_l)) continue;
                    id_l = identity;
                    l_best = model;
                    continue;
                }
                if (model.charAt(4) != 'H' || seq_H.length() == 0 || !((identity = SmithWaterman.computeIdentity(seq_H, m_seq)) > id_h)) continue;
                id_h = identity;
                h_best = model;
            }
            output = String.valueOf(output) + "===============\n";
            output = String.valueOf(output) + "PDB= " + pdb_file + "\n";
            output = String.valueOf(output) + "id_h = " + id_h + "% " + h_best + "\n";
            output = String.valueOf(output) + "id_l = " + id_l + "% " + l_best + "\n";
            output = String.valueOf(output) + "===============\n";
            System.out.println("===============");
            System.out.println("PDB= " + pdb_file);
            System.out.println("id_h = " + id_h + "% " + h_best);
            System.out.println("id_l = " + id_l + "% " + l_best);
            System.out.println("===============");
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/seq_sim.txt", output);
    }

    public static ArrayList<String> getAlreadyIn() {
        ArrayList<String> models = FileSystemTools.getFiles(String.valueOf(userdir) + "/resources/RosettaAntibody_Homology_Models_noH3");
        ArrayList<String> eligible = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/peptides_and_eligible_pdbs.txt");
        ArrayList<String> testset = new ArrayList<String>();
        int tot = 0;
        for (String model : models) {
            String pdb = String.valueOf(model.substring(0, 4).toUpperCase()) + "_AB";
            if (!eligible.contains(pdb)) continue;
            ++tot;
            testset.add(pdb);
            System.out.println(pdb);
        }
        System.out.println("Identified " + tot + " out of " + models.size());
        return testset;
    }
}

