/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import db_interface.Controller;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import main.Main_inter;
import main.Main_inter_lite;
import main.Main_outer;
import main.ResultWriter;
import othermethods.MSAmethods;
import parsing.FASTA_parser;
import parsing.PDB_parser;
import parsing.ROI_parser;
import propensity.FrequencyCalculator;
import utils.FileSystemTools;
import utils.MathFunctions;

public class Analyzer {
    private static String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        Analyzer.ab_lite_run("TPRO");
    }

    public static void minimalTriangle(SC_Structure strA, SC_Structure strB, double cutoff) {
        double delta = 2.0;
        double[][] distA = Analyzer.CalculateDistances(strA);
        double[][] distB = Analyzer.CalculateDistances(strB);
        boolean initialized = false;
        double score = Double.MAX_VALUE;
        double combination = Double.MAX_VALUE;
        int[] residues = new int[6];
        System.out.println("Triangles cutoff: " + cutoff);
        System.out.println("A size: " + strA.residues.size());
        System.out.println("B size: " + strB.residues.size());
        int progress = 0;
        for (Integer A_1 : strA.residues.keySet()) {
            System.out.println("Progress: " + ++progress / strA.residues.size());
            for (Integer A_2 : strA.residues.keySet()) {
                for (Integer A_3 : strA.residues.keySet()) {
                    if (A_1 == A_2 || A_2 == A_3 || A_1 == A_3 || !(strA.residues.get(A_1).getTPro() > cutoff) || !(strA.residues.get(A_2).getTPro() > cutoff) || !(strA.residues.get(A_3).getTPro() > cutoff)) continue;
                    for (Integer B_1 : strB.residues.keySet()) {
                        for (Integer B_2 : strB.residues.keySet()) {
                            for (Integer B_3 : strB.residues.keySet()) {
                                double[] res;
                                double B_d3;
                                double B_d2;
                                double B_d1;
                                double A_d3;
                                double A_d2;
                                double A_d1;
                                if (B_1 == B_2 || B_2 == B_3 || B_1 == B_3 || !(strB.residues.get(B_1).getTPro() > cutoff) || !(strB.residues.get(B_2).getTPro() > cutoff) || !(strB.residues.get(B_3).getTPro() > cutoff) || !((A_d1 = distA[A_1][A_2]) + (A_d2 = distA[A_1][A_3]) + (A_d3 = distA[A_2][A_3]) - ((B_d1 = distB[B_1][B_2]) + (B_d2 = distB[B_1][B_3]) + (B_d3 = distB[B_2][B_3])) < delta) || !((res = MathFunctions.scoreTriangle(A_d1, A_d2, A_d3, B_d1, B_d2, B_d3))[0] < score)) continue;
                                score = res[0];
                                combination = res[1];
                                if (combination == 0.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_1;
                                    residues[4] = B_2;
                                    residues[5] = B_3;
                                }
                                if (combination == 1.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_1;
                                    residues[4] = B_3;
                                    residues[5] = B_2;
                                }
                                if (combination == 2.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_2;
                                    residues[4] = B_1;
                                    residues[5] = B_3;
                                }
                                if (combination == 3.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_2;
                                    residues[4] = B_3;
                                    residues[5] = B_1;
                                }
                                if (combination == 4.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_3;
                                    residues[4] = B_2;
                                    residues[5] = B_1;
                                }
                                if (combination == 5.0) {
                                    residues[0] = A_1;
                                    residues[1] = A_2;
                                    residues[2] = A_3;
                                    residues[3] = B_3;
                                    residues[4] = B_1;
                                    residues[5] = B_2;
                                }
                                initialized = true;
                                System.out.println("Best score " + score);
                                double d1 = strA.residues.get(residues[0]).distanceFrom(strB.residues.get(residues[3]));
                                double d2 = strA.residues.get(residues[1]).distanceFrom(strB.residues.get(residues[4]));
                                double d3 = strA.residues.get(residues[2]).distanceFrom(strB.residues.get(residues[5]));
                                if (d1 < 4.5 && d2 < 4.5 && d3 < 4.5) {
                                    System.out.println(String.valueOf(cutoff) + " Success");
                                    continue;
                                }
                                System.out.println(String.valueOf(cutoff) + " Failure");
                                System.out.println(String.valueOf(d1) + " " + d2 + " " + d3);
                            }
                        }
                    }
                }
            }
        }
        if (initialized) {
            double d1 = strA.residues.get(residues[0]).distanceFrom(strB.residues.get(residues[3]));
            double d2 = strA.residues.get(residues[1]).distanceFrom(strB.residues.get(residues[4]));
            double d3 = strA.residues.get(residues[2]).distanceFrom(strB.residues.get(residues[5]));
            if (d1 < 4.5 && d2 < 4.5 && d3 < 4.5) {
                System.out.println(String.valueOf(cutoff) + " Success");
            } else {
                System.out.println(String.valueOf(cutoff) + " Failure");
            }
        } else {
            System.out.println(String.valueOf(cutoff) + " No candidates found");
        }
    }

    public static void minimalPair(SC_Structure strA, SC_Structure strB, double cutoff) {
        int eligible_pair_count = 0;
        block0: for (Integer A_i : strA.residues.keySet()) {
            for (Integer B_i : strB.residues.keySet()) {
                if (!(strA.residues.get(A_i).getTPro() > cutoff) || !(strB.residues.get(B_i).getTPro() > cutoff) || !(strA.residues.get(A_i).distanceFrom(strB.residues.get(B_i)) < 4.5)) continue;
                ++eligible_pair_count;
                continue block0;
            }
        }
        double[][] distA = Analyzer.CalculateDistances(strA);
        double[][] distB = Analyzer.CalculateDistances(strB);
        double minimal = Double.MAX_VALUE;
        for (Integer A_1 : strA.residues.keySet()) {
            for (Integer A_2 : strA.residues.keySet()) {
                if (A_1 == A_2 || !(strA.residues.get(A_1).getTPro() > cutoff) || !(strA.residues.get(A_2).getTPro() > cutoff) || !(distA[A_1][A_2] < 7.5)) continue;
                for (Integer B_1 : strB.residues.keySet()) {
                    for (Integer B_2 : strB.residues.keySet()) {
                        double delta_d;
                        if (B_1 == B_2 || !(strB.residues.get(B_1).getTPro() > cutoff) || !(strB.residues.get(B_2).getTPro() > cutoff) || !(distB[B_1][B_2] < 7.5) || !((delta_d = Math.abs(distA[A_1][A_2] - distB[B_1][B_2])) < minimal)) continue;
                        minimal = delta_d;
                        double d1 = strA.residues.get(A_1).distanceFrom(strB.residues.get(B_1));
                        double d2 = strA.residues.get(A_2).distanceFrom(strB.residues.get(B_2));
                        double d3 = strA.residues.get(A_2).distanceFrom(strB.residues.get(B_1));
                        double d4 = strA.residues.get(A_1).distanceFrom(strB.residues.get(B_2));
                        if (d1 < 4.5 && d2 < 4.5 || d3 < 4.5 && d4 < 4.5) {
                            System.err.println(String.valueOf(cutoff) + " Success " + delta_d);
                            continue;
                        }
                        System.out.println(String.valueOf(cutoff) + " Failure " + delta_d + " " + eligible_pair_count);
                    }
                }
            }
        }
    }

    public static void reduceFP(SC_Structure strA, SC_Structure strB, double cutoff) {
        double tolerance = 0.001;
        HashMap<Integer, Integer> mapA = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mapB = new HashMap<Integer, Integer>();
        double[][] distA = Analyzer.CalculateDistances(strA);
        double[][] distB = Analyzer.CalculateDistances(strB);
        for (Integer A_1 : strA.residues.keySet()) {
            for (Integer A_2 : strA.residues.keySet()) {
                if (A_1 == A_2 || !(strA.residues.get(A_1).getTPro() > cutoff) || !(strA.residues.get(A_2).getTPro() > cutoff) || !(distA[A_1][A_2] < 7.5)) continue;
                for (Integer B_1 : strB.residues.keySet()) {
                    for (Integer B_2 : strB.residues.keySet()) {
                        double delta_d;
                        if (B_1 == B_2 || !(strB.residues.get(B_1).getTPro() > cutoff) || !(strB.residues.get(B_2).getTPro() > cutoff) || !(distB[B_1][B_2] < 7.5) || !((delta_d = Math.abs(distA[A_1][A_2] - distB[B_1][B_2])) < tolerance)) continue;
                        if (!mapA.containsKey(A_1)) {
                            mapA.put(A_1, 1);
                        } else {
                            mapA.put(A_1, (Integer)mapA.get(A_1) + 1);
                        }
                        if (!mapA.containsKey(A_2)) {
                            mapA.put(A_2, 1);
                        } else {
                            mapA.put(A_2, (Integer)mapA.get(A_2) + 1);
                        }
                        if (!mapB.containsKey(B_1)) {
                            mapB.put(B_1, 1);
                        } else {
                            mapB.put(B_1, (Integer)mapB.get(B_1) + 1);
                        }
                        if (!mapB.containsKey(B_2)) {
                            mapB.put(B_2, 1);
                            continue;
                        }
                        mapB.put(B_2, (Integer)mapB.get(B_2) + 1);
                    }
                }
            }
        }
        for (Integer i : strA.residues.keySet()) {
            strA.residues.get((Object)i).tempTPRO = strA.residues.get(i).getTPro();
            if (!mapA.containsKey(i)) continue;
            strA.residues.get((Object)i).tempTPRO = strA.residues.get(i).getTPro() * (double)((Integer)mapA.get(i)).intValue();
        }
        for (Integer i : strB.residues.keySet()) {
            strB.residues.get((Object)i).tempTPRO = strB.residues.get(i).getTPro();
            if (!mapB.containsKey(i)) continue;
            strB.residues.get((Object)i).tempTPRO = strB.residues.get(i).getTPro() * (double)((Integer)mapB.get(i)).intValue();
        }
    }

    public static double[][] CalculateDistances(SC_Structure str) {
        int max = -1;
        for (Integer i : str.residues.keySet()) {
            if (i <= max) continue;
            max = i;
        }
        double[][] dists = new double[max + 1][max + 1];
        for (Integer i : str.residues.keySet()) {
            Residue r1 = str.residues.get(i);
            for (Integer j : str.residues.keySet()) {
                if (i == j) continue;
                Residue r2 = str.residues.get(j);
                dists[i.intValue()][j.intValue()] = r1.distanceFrom(r2);
            }
        }
        return dists;
    }

    public static void old_run(String method) {
        boolean use_full_msa = true;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAll";
        String results = "TestResults/old50" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void old_runSingapore(String method) {
        boolean use_full_msa = true;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsSinga";
        String results = "TestResults/singa" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void old_runMIR(String method) {
        boolean use_full_msa = true;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/form";
        String results = "TestResults/formir" + method;
        Analyzer.analyzeMIR(scramble_run, results, use_full_msa, randomize_msa, 100, do_clustal, false, method, constrain_msa);
    }

    public static void data_for_others(String method) {
        boolean use_full_msa = true;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = true;
        String scramble_run = "/Tests/TestSetsForOther";
        String results = "TestResults/for_other" + method;
        Analyzer.analyzeOther(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa);
    }

    public static void run_others(String method) {
        String scramble_run = "/Tests/TestSetsForOther";
        Analyzer.runOtherMethods(scramble_run);
    }

    public static void old_run_difference() {
        boolean use_full_msa = true;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        String scramble_run = "/Tests/TestSetsAll";
        String results = "TestResults/old_diff";
        Analyzer.analyzeDifference(scramble_run, results, use_full_msa, randomize_msa, 1000, do_clustal, false);
    }

    public static void lite_run(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/new" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void lite_run_reducefp(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/reducefp" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, true);
    }

    public static void lite_runNoStruc(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/nostruc" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void lite_runNoStruc2(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/nostruc2" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void lite_runNoStruc3(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/nostruc3" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void lite_run_mods(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/newMOD" + method;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
    }

    public static void ab_lite_run(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        boolean constrain_msa = false;
        double max = 0.0;
        int i = 0;
        while (i < 1) {
            Controller.createNewTestSet();
            FrequencyCalculator.initializeResiduesTriangle("ab");
            FrequencyCalculator.initializeResiduesTriangle("ag");
            String scramble_run = "/Tests/TestSetsABAG";
            String results = "TestResults/ABAG" + method;
            double max_tmp = Analyzer.analyzeAB(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, i);
            if (max_tmp > max) {
                max = max_tmp;
            }
            ++i;
        }
        System.out.println("Finished, maximum TPRO was " + max);
    }

    public static void lite_run_difference() {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = false;
        String scramble_run = "/Tests/TestSetsAllNew";
        String results = "TestResults/new_diff";
        Analyzer.analyzeDifference(scramble_run, results, use_full_msa, randomize_msa, 1000, do_clustal, false);
    }

    public static void scrambleRunLITE(String method) {
        int j = 1;
        while (j < 11) {
            System.out.println("[" + j + "/10]");
            boolean use_full_msa = false;
            boolean randomize_msa = false;
            boolean do_clustal = false;
            boolean constrain_msa = false;
            String scramble_run = "/Tests/Scrambling1/TestSetsAll" + j;
            String results = "TestResults/ScramblingLITE/res" + j;
            Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method, constrain_msa, false);
            ++j;
        }
    }

    public static void scrambleRunSeparate(String method) {
        int j = 1;
        while (j < 11) {
            System.out.println("[" + j + "/10]");
            boolean use_full_msa = false;
            boolean randomize_msa = false;
            boolean do_clustal = false;
            String scramble_run = "/Tests/Scrambling1/TestSetsAll" + j;
            String results = "TestResults/ScramblingLITE/res" + j;
            Analyzer.analyzeSEPARATELY(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, false, method);
            ++j;
        }
    }

    public static void random_msa_run(String method) {
        boolean use_full_msa = true;
        boolean randomize_msa = true;
        boolean do_clustal = false;
        String scramble_run = "/Tests/TestSetsAllRMSA";
        String results = "TestResults/randomMSA";
        boolean constrain_msa = false;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1000, do_clustal, false, method, constrain_msa, false);
    }

    public static void Clustal_run_min(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = true;
        boolean minimal = true;
        String scramble_run = "/Tests/TestSetsAllClustal";
        String results = "TestResults/clustalMIN";
        boolean constrain_msa = false;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, minimal, method, constrain_msa, false);
    }

    public static void Clustal_run_max(String method) {
        boolean use_full_msa = false;
        boolean randomize_msa = false;
        boolean do_clustal = true;
        boolean minimal = false;
        String scramble_run = "/Tests/TestSetsAllClustal";
        String results = "TestResults/clustalMAX";
        boolean constrain_msa = false;
        Analyzer.analyze(scramble_run, results, use_full_msa, randomize_msa, 1, do_clustal, minimal, method, constrain_msa, false);
    }

    public static void analyzeMIR(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa) {
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
            int test_num = 59;
            int i = 0;
            ArrayList<String> folders = FileSystemTools.getFolders(String.valueOf(userdir) + scramble_run);
            for (String testFolder : folders) {
                testFolder = "/Tests/form/" + testFolder;
                String tpstring = "";
                String fpstring = "";
                String tnstring = "";
                String fnstring = "";
                System.out.println(String.valueOf(testFolder) + " [" + ++i + "/" + folders.size() + "]");
                HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
                String interest_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_1";
                String interest_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_2";
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A.pdb";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B.pdb";
                String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment.fasta";
                ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
                ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
                MSA msa = FASTA_parser.splitToPairs(ROI_parser.getSpacing(interest_1), alignment_file);
                int reference = FASTA_parser.getReference();
                SequencePair sp = msa.sequences.get(reference);
                Residue_type[] a1 = sp.sequenceA;
                Residue_type[] a2 = sp.sequenceB;
                String seqs = "";
                System.out.println("First seq: ");
                int temp = 0;
                while (temp < a1.length) {
                    seqs = String.valueOf(seqs) + (a1[temp] == Residue_type.gap ? "" : a1[temp]);
                    ++temp;
                }
                String first_seven = "";
                int temp2 = 0;
                while (temp2 < a2.length) {
                    seqs = String.valueOf(seqs) + (a2[temp2] == Residue_type.gap ? "" : a2[temp2]);
                    ++temp2;
                }
                Residue_type[] reff = Analyzer.getNewSequence(pdb_file1, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), true);
                int temp3 = 0;
                while (temp3 < reff.length) {
                    if (first_seven.length() < 6) {
                        first_seven = String.valueOf(first_seven) + (reff[temp3] == Residue_type.gap ? "" : reff[temp3]);
                    }
                    ++temp3;
                }
                int spacing = seqs.indexOf(first_seven);
                System.out.println(spacing);
                if (doClustal) {
                    msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, minimal);
                    msa.Output();
                } else if (!use_full_alignment) {
                    Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, ROI_parser.getChain(interest_1), System.getProperty("user.dir"), true);
                    Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), false);
                    sp = new SequencePair(first, second, 0);
                    ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                    sp_arr.add(sp);
                    msa = new MSA(sp_arr);
                } else {
                    msa = !randomize_msa ? FASTA_parser.splitToPairs(spacing, alignment_file) : FASTA_parser.RandomFastaParser(spacing, alignment_file);
                }
                int size_msa = msa.sequences.size();
                SequencePair the_reference = msa.sequences.get(reference);
                int to_pick = (int)(0.7 * (double)(size_msa - 1));
                ArrayList<Integer> keys = new ArrayList<Integer>();
                int temp4 = 0;
                while (temp4 < size_msa) {
                    if (temp4 != reference) {
                        keys.add(temp4);
                    }
                    ++temp4;
                }
                ArrayList<Integer> keys_chosen = MathFunctions.chooseRandom(keys, to_pick);
                ArrayList<SequencePair> new_sps = new ArrayList<SequencePair>();
                new_sps.add(the_reference);
                the_reference.seq_id = 0;
                for (Integer temp5 : keys_chosen) {
                    SequencePair new_sp = msa.sequences.get(temp5);
                    new_sp.seq_id = temp5;
                    new_sps.add(new_sp);
                }
                System.out.println("Outpurring the MSA " + to_pick);
                msa = new MSA(new_sps);
                reference = 0;
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, false);
                strA = Analyzer.calculateNeighborsAWrite(strA, strB);
                strB = Analyzer.calculateNeighborsBWrite(strA, strB);
                Analyzer.WriteResultModel(strA, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1");
                Analyzer.WriteResultModel(strB, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2");
                String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
                String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
                String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
                File f1 = new File(folder);
                f1.mkdir();
                FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
                FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1", String.valueOf(folder) + "/model");
                folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
                File f2 = new File(folder);
                f2.mkdir();
                FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
                FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2", String.valueOf(folder) + "/model");
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + testFolder.substring(testFolder.length() - 4) + "_A_" + j);
                Analyzer.WriteResultScore(strB, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + testFolder.substring(testFolder.length() - 4) + "_B_" + j);
                String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
                String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
                double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
                if (res[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                ArrayList<Integer> consider1 = Analyzer.HalveStructure(strA);
                ArrayList<Integer> consider2 = Analyzer.HalveStructure(strB);
                double cutoff = 0.0;
                while (cutoff < 3.5) {
                    ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                    TP_s.put(cutoff, forA.get(0) + forB.get(0));
                    FP_s.put(cutoff, forA.get(1) + forB.get(1));
                    TN_s.put(cutoff, forA.get(2) + forB.get(2));
                    FN_s.put(cutoff, forA.get(3) + forB.get(3));
                    tpstring = String.valueOf(tpstring) + cutoff + "\t" + (forA.get(0) + forB.get(0)) + "\n";
                    fpstring = String.valueOf(fpstring) + cutoff + "\t" + (forA.get(1) + forB.get(1)) + "\n";
                    tnstring = String.valueOf(tnstring) + cutoff + "\t" + (forA.get(2) + forB.get(2)) + "\n";
                    fnstring = String.valueOf(fnstring) + cutoff + "\t" + (forA.get(3) + forB.get(3)) + "\n";
                    cutoff += 0.1;
                }
                TPs.add(TP_s);
                FPs.add(FP_s);
                TNs.add(TN_s);
                FNs.add(FN_s);
            }
            System.out.println(max_c);
            System.out.println(min_c);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + j, TPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + j, FPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + j, FNs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + j, TNs);
            System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)(test_num - 1) + "s/test on average over " + (test_num - 1) + " tests");
            ++j;
        }
        System.out.println("Wrote results");
    }

    public static void analyze(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, boolean reducefps) {
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
            int test_num = 2;
            int i = 1;
            while (i < test_num) {
                String tpstring = "";
                String fpstring = "";
                String tnstring = "";
                String fnstring = "";
                System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
                HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
                String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
                String interest_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_1";
                String interest_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_2";
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A.pdb";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B.pdb";
                String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment.ali";
                ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
                ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
                MSA msa = FASTA_parser.splitToPairs(ROI_parser.getSpacing(interest_1), alignment_file);
                int reference = FASTA_parser.getReference();
                SequencePair sp = msa.sequences.get(reference);
                Residue_type[] a1 = sp.sequenceA;
                Residue_type[] a2 = sp.sequenceB;
                String seqs = "";
                System.out.println("First seq: ");
                int temp = 0;
                while (temp < a1.length) {
                    seqs = String.valueOf(seqs) + (a1[temp] == Residue_type.gap ? "" : a1[temp]);
                    System.out.print(a1[temp] == Residue_type.gap ? Character.valueOf('-') : a1[temp]);
                    ++temp;
                }
                System.out.println();
                System.out.println("Second seq: ");
                String first_seven = "";
                int temp2 = 0;
                while (temp2 < a2.length) {
                    seqs = String.valueOf(seqs) + (a2[temp2] == Residue_type.gap ? "" : a2[temp2]);
                    System.out.print(a2[temp2] == Residue_type.gap ? Character.valueOf('-') : a2[temp2]);
                    ++temp2;
                }
                Residue_type[] reff = Analyzer.getNewSequence(pdb_file1, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), true);
                int temp3 = 0;
                while (temp3 < reff.length) {
                    if (first_seven.length() < 6) {
                        first_seven = String.valueOf(first_seven) + (reff[temp3] == Residue_type.gap ? "" : reff[temp3]);
                    }
                    ++temp3;
                }
                System.out.println();
                System.out.println("Sequence of " + first_seven);
                System.out.println("In: " + seqs);
                int spacing = seqs.indexOf(first_seven);
                spacing = 584;
                System.out.println(spacing);
                if (doClustal) {
                    msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, minimal);
                    msa.Output();
                } else if (!use_full_alignment) {
                    Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, ROI_parser.getChain(interest_1), System.getProperty("user.dir"), true);
                    Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), false);
                    sp = new SequencePair(first, second, 0);
                    ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                    sp_arr.add(sp);
                    msa = new MSA(sp_arr);
                } else {
                    msa = !randomize_msa ? FASTA_parser.splitToPairs(spacing, alignment_file) : FASTA_parser.RandomFastaParser(spacing, alignment_file);
                }
                System.out.println("First length " + msa.sequences.get((int)reference).sequenceA.length);
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, false);
                strA = Analyzer.calculateNeighborsAWrite(strA, strB);
                strB = Analyzer.calculateNeighborsBWrite(strA, strB);
                Analyzer.WriteResultModel(strA, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1");
                Analyzer.WriteResultModel(strB, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2");
                String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
                String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
                String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
                File f1 = new File(folder);
                f1.mkdir();
                FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
                FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1", String.valueOf(folder) + "/model");
                folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
                File f2 = new File(folder);
                f2.mkdir();
                FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
                FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2", String.valueOf(folder) + "/model");
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + (test_ind - 2));
                Analyzer.WriteResultScore(strB, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + (test_ind - 1));
                String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
                String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
                double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
                if (res[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                ArrayList<Integer> consider1 = Analyzer.HalveStructure(strA);
                ArrayList<Integer> consider2 = Analyzer.HalveStructure(strB);
                double cutoff = 0.0;
                while (cutoff < 3.5) {
                    ArrayList<Integer> forB;
                    ArrayList<Integer> forA;
                    if (reducefps) {
                        Analyzer.reduceFP(strA, strB, 1.5);
                        forA = PDB_parser.writePDBHalfTEMP(strA, true, cutoff, method);
                        forB = PDB_parser.writePDBHalfTEMP(strB, false, cutoff, method);
                    } else {
                        forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                        forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                        Analyzer.minimalPair(strA, strB, cutoff);
                    }
                    TP_s.put(cutoff, forA.get(0) + forB.get(0));
                    FP_s.put(cutoff, forA.get(1) + forB.get(1));
                    TN_s.put(cutoff, forA.get(2) + forB.get(2));
                    FN_s.put(cutoff, forA.get(3) + forB.get(3));
                    tpstring = String.valueOf(tpstring) + cutoff + "\t" + (forA.get(0) + forB.get(0)) + "\n";
                    fpstring = String.valueOf(fpstring) + cutoff + "\t" + (forA.get(1) + forB.get(1)) + "\n";
                    tnstring = String.valueOf(tnstring) + cutoff + "\t" + (forA.get(2) + forB.get(2)) + "\n";
                    fnstring = String.valueOf(fnstring) + cutoff + "\t" + (forA.get(3) + forB.get(3)) + "\n";
                    cutoff += 0.1;
                }
                TPs.add(TP_s);
                FPs.add(FP_s);
                TNs.add(TN_s);
                FNs.add(FN_s);
                ++i;
            }
            System.out.println(max_c);
            System.out.println(min_c);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + j, TPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + j, FPs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + j, FNs);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + j, TNs);
            System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)(test_num - 1) + "s/test on average over " + (test_num - 1) + " tests");
            ++j;
        }
        System.out.println("Wrote results");
    }

    public static double analyzeAB(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa, int test_id) {
        double maxTP = 0.0;
        double max_c = -1.0;
        double min_c = 100.0;
        int test_ind = 1;
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
        double t_start = System.currentTimeMillis();
        ArrayList<HashMap<Double, Integer>> TPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FPs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> TNs = new ArrayList<HashMap<Double, Integer>>();
        ArrayList<HashMap<Double, Integer>> FNs = new ArrayList<HashMap<Double, Integer>>();
        int progress = 0;
        for (String test_pdb : pdbcodes) {
            Residue res_central;
            String tpstring = "";
            String fpstring = "";
            String tnstring = "";
            String fnstring = "";
            System.out.println("Sample " + test_id + ": " + scramble_run + "/" + test_pdb + " [" + ++progress + "/" + pdbcodes.size() + "]");
            HashMap<Double, Integer> TP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FP_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> TN_s = new HashMap<Double, Integer>();
            HashMap<Double, Integer> FN_s = new HashMap<Double, Integer>();
            String testFolder = String.valueOf(scramble_run) + "/" + test_pdb;
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B";
            String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment";
            ArrayList<Integer> roi_1 = new ArrayList<Integer>();
            ArrayList<Integer> roi_2 = new ArrayList<Integer>();
            int lll = 0;
            while (lll < 9999) {
                roi_1.add(lll);
                roi_2.add(lll);
                ++lll;
            }
            Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, 'A', System.getProperty("user.dir"), true);
            Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, 'A', System.getProperty("user.dir"), false);
            SequencePair sp = new SequencePair(first, second, 0);
            ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
            sp_arr.add(sp);
            MSA msa = new MSA(sp_arr);
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, 0, true, roi_1, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, 0, false, roi_2, 'A', String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
            Main_inter mi = use_full_alignment ? new Main_inter(msa, strA, strB) : new Main_inter_lite(msa, strA, strB, true);
            strA = Analyzer.calculateNeighborsAWrite(strA, strB);
            strB = Analyzer.calculateNeighborsBWrite(strA, strB);
            for (Integer str_i : strA.residues.keySet()) {
                res_central = strA.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            for (Integer str_i : strB.residues.keySet()) {
                res_central = strB.residues.get(str_i);
                if (!(maxTP < res_central.getTPro())) continue;
                maxTP = res_central.getTPro();
            }
            Analyzer.WriteResultModel(strA, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1");
            Analyzer.WriteResultModel(strB, String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2");
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f1 = new File(folder);
            f1.mkdir();
            FileSystemTools.CopyFile(outname_1, String.valueOf(folder) + "/str.pdb");
            FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_1", String.valueOf(folder) + "/model");
            folder = String.valueOf(System.getProperty("user.dir")) + "/Tests/SingleTests/Test" + test_ind++;
            File f2 = new File(folder);
            f2.mkdir();
            FileSystemTools.CopyFile(outname_2, String.valueOf(folder) + "/str.pdb");
            FileSystemTools.CopyFile(String.valueOf(System.getProperty("user.dir")) + testFolder + "/model_2", String.valueOf(folder) + "/model");
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            double cutoff = 0.0;
            while (cutoff < 150.0) {
                ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                TP_s.put(cutoff, forB.get(0));
                FP_s.put(cutoff, forB.get(1));
                TN_s.put(cutoff, forB.get(2));
                FN_s.put(cutoff, forB.get(3));
                tpstring = String.valueOf(tpstring) + cutoff + "\t" + (forA.get(0) + forB.get(0)) + "\n";
                fpstring = String.valueOf(fpstring) + cutoff + "\t" + (forA.get(1) + forB.get(1)) + "\n";
                tnstring = String.valueOf(tnstring) + cutoff + "\t" + (forA.get(2) + forB.get(2)) + "\n";
                fnstring = String.valueOf(fnstring) + cutoff + "\t" + (forA.get(3) + forB.get(3)) + "\n";
                cutoff += 0.1;
            }
            TPs.add(TP_s);
            FPs.add(FP_s);
            TNs.add(TN_s);
            FNs.add(FN_s);
        }
        System.out.println(max_c);
        System.out.println(min_c);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TP" + test_id, TPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FP" + test_id, FPs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FN" + test_id, FNs);
        ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TN" + test_id, TNs);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)pdbcodes.size() + "s/test on average over " + pdbcodes.size() + " tests");
        System.out.println("Wrote results+ " + maxTP);
        return maxTP;
    }

    public static void analyzeOther(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method, boolean constrain_msa) {
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            int test_num = 59;
            int i = 1;
            while (i < test_num) {
                System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
                String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
                String interest_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_1";
                String interest_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_2";
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B";
                String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment";
                ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
                ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
                MSA msa = null;
                int spacing = ROI_parser.getSpacing(interest_1);
                if (doClustal) {
                    msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, minimal);
                    msa.Output();
                } else if (!use_full_alignment) {
                    Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, ROI_parser.getChain(interest_1), System.getProperty("user.dir"), true);
                    Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), false);
                    SequencePair sp = new SequencePair(first, second, 0);
                    ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                    sp_arr.add(sp);
                    msa = new MSA(sp_arr);
                } else {
                    msa = !randomize_msa ? FASTA_parser.splitToPairs(spacing, alignment_file) : FASTA_parser.RandomFastaParser(spacing, alignment_file);
                }
                int reference = FASTA_parser.getReference();
                System.err.println(reference);
                if (constrain_msa) {
                    minimal = true;
                    msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, true);
                    reference = 0;
                }
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                String save_folder = String.valueOf(System.getProperty("user.dir")) + testFolder;
                int salen = msa.sequences.get((int)0).sequenceA.length;
                Analyzer.calculateNeighbors(strA, strB, String.valueOf(System.getProperty("user.dir")) + testFolder, salen);
                String save_name = "new_alignment_clustal";
                MSA.constrainMSA(msa, save_folder, save_name);
                ++i;
            }
            System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)(test_num - 1) + "s/test on average over " + (test_num - 1) + " tests");
            ++j;
        }
        System.out.println("Done");
    }

    public static void runOtherMethods(String scramble_run) {
        int test_num = 59;
        int i = 1;
        while (i < test_num) {
            System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
            String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
            String save_folder = String.valueOf(System.getProperty("user.dir")) + testFolder;
            String save_name = "new_alignment";
            String save_append = "";
            MSAmethods.SCA(String.valueOf(save_folder) + "/" + save_name, String.valueOf(save_folder) + "/SCA_output" + save_append + ".txt");
            MSAmethods.ELSC(String.valueOf(save_folder) + "/" + save_name, String.valueOf(save_folder) + "/ELSC_output" + save_append + ".txt");
            MSAmethods.RandomScore(String.valueOf(save_folder) + "/" + save_name, String.valueOf(save_folder) + "/RS_output" + save_append + ".txt");
            MSAmethods.MI(String.valueOf(save_folder) + "/" + save_name, String.valueOf(save_folder) + "/MI_output" + save_append + ".txt");
            MSAmethods.OmesCovariance(String.valueOf(save_folder) + "/" + save_name, String.valueOf(save_folder) + "/Omes_output" + save_append + ".txt");
            ++i;
        }
    }

    public static void analyzeSEPARATELY(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal, String method) {
        double max_c = -1.0;
        double min_c = 100.0;
        double t_start = System.currentTimeMillis();
        int j = 1;
        while (j < num_iterations + 1) {
            ArrayList<HashMap<Double, Integer>> TPsA = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPsA = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNsA = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNsA = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TPsB = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FPsB = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> TNsB = new ArrayList<HashMap<Double, Integer>>();
            ArrayList<HashMap<Double, Integer>> FNsB = new ArrayList<HashMap<Double, Integer>>();
            int test_num = 59;
            int i = 1;
            while (i < test_num) {
                System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
                HashMap<Double, Integer> TP_sA = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_sA = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_sA = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_sA = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TP_sB = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FP_sB = new HashMap<Double, Integer>();
                HashMap<Double, Integer> TN_sB = new HashMap<Double, Integer>();
                HashMap<Double, Integer> FN_sB = new HashMap<Double, Integer>();
                String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
                String interest_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_1";
                String interest_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_2";
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B";
                String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment";
                ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
                ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
                MSA msa = null;
                int spacing = ROI_parser.getSpacing(interest_1);
                if (doClustal) {
                    msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, minimal);
                    msa.Output();
                } else if (!use_full_alignment) {
                    Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, ROI_parser.getChain(interest_1), System.getProperty("user.dir"), true);
                    Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), false);
                    SequencePair sp = new SequencePair(first, second, 0);
                    ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                    sp_arr.add(sp);
                    msa = new MSA(sp_arr);
                } else {
                    msa = !randomize_msa ? FASTA_parser.splitToPairs(spacing, alignment_file) : FASTA_parser.RandomFastaParser(spacing, alignment_file);
                }
                int reference = FASTA_parser.getReference();
                SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
                Main_inter mi = new Main_inter(msa, strA, strB);
                strA = Main_outer.calculateNeighborsA(strA, strB);
                strB = Main_outer.calculateNeighborsB(strA, strB);
                String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
                String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
                String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
                String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
                double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
                if (res[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                    max_c = res[1];
                }
                if (res[0] < min_c) {
                    min_c = res[0];
                }
                double cutoff = 0.0;
                while (cutoff < 3.5) {
                    ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, method);
                    ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, method);
                    TP_sA.put(cutoff, forA.get(0));
                    FP_sA.put(cutoff, forA.get(1));
                    TN_sA.put(cutoff, forA.get(2));
                    FN_sA.put(cutoff, forA.get(3));
                    TP_sB.put(cutoff, forB.get(0));
                    FP_sB.put(cutoff, forB.get(1));
                    TN_sB.put(cutoff, forB.get(2));
                    FN_sB.put(cutoff, forB.get(3));
                    cutoff += 0.1;
                }
                TPsA.add(TP_sA);
                FPsA.add(FP_sA);
                TNsA.add(TN_sA);
                FNsA.add(FN_sA);
                TPsB.add(TP_sB);
                FPsB.add(FP_sB);
                TNsB.add(TN_sB);
                FNsB.add(FN_sB);
                ++i;
            }
            System.out.println(max_c);
            System.out.println(min_c);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPA" + j, TPsA);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FPA" + j, FPsA);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FNA" + j, FNsA);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TNA" + j, TNsA);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPB" + j, TPsB);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FPB" + j, FPsB);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/FNB" + j, FNsB);
            ResultWriter.writeResults(String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TNB" + j, TNsB);
            System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)(test_num - 1) + "s/test on average over " + (test_num - 1) + " tests");
            ++j;
        }
        System.out.println("Wrote results");
    }

    public static void analyzeDifference(String scramble_run, String results_folder, boolean use_full_alignment, boolean randomize_msa, int num_iterations, boolean doClustal, boolean minimal) {
        double max_c = -1.0;
        double min_c = 100.0;
        double t_start = System.currentTimeMillis();
        int test_num = 59;
        int i = 1;
        while (i < test_num) {
            System.out.println(String.valueOf(scramble_run) + " [" + i + "/" + (test_num - 1) + "]");
            String testFolder = String.valueOf(scramble_run) + "/TestSet_" + i;
            String interest_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_1";
            String interest_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/roi_2";
            String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_A";
            String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_B";
            String alignment_file = String.valueOf(System.getProperty("user.dir")) + testFolder + "/alignment";
            ArrayList<Integer> roi_1 = ROI_parser.parse(interest_1);
            ArrayList<Integer> roi_2 = ROI_parser.parse(interest_2);
            MSA msa = null;
            int spacing = ROI_parser.getSpacing(interest_1);
            if (doClustal) {
                msa = FASTA_parser.ClustalFastaParser(spacing, alignment_file, minimal);
                msa.Output();
            } else if (!use_full_alignment) {
                Residue_type[] first = Analyzer.getNewSequence(pdb_file1, roi_1, ROI_parser.getChain(interest_1), System.getProperty("user.dir"), true);
                Residue_type[] second = Analyzer.getNewSequence(pdb_file2, roi_2, ROI_parser.getChain(interest_2), System.getProperty("user.dir"), false);
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                msa = new MSA(sp_arr);
            } else {
                msa = !randomize_msa ? FASTA_parser.splitToPairs(spacing, alignment_file) : FASTA_parser.RandomFastaParser(spacing, alignment_file);
            }
            int reference = FASTA_parser.getReference();
            SC_Structure strA = Main_outer.structureAndMSA(pdb_file1, msa, reference, true, roi_1, ROI_parser.getChain(interest_1), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
            SC_Structure strB = Main_outer.structureAndMSA(pdb_file2, msa, reference, false, roi_2, ROI_parser.getChain(interest_2), String.valueOf(System.getProperty("user.dir")) + testFolder, use_full_alignment, false, null);
            Main_inter mi = new Main_inter(msa, strA, strB);
            strA = Main_outer.calculateNeighborsA(strA, strB);
            strB = Main_outer.calculateNeighborsB(strA, strB);
            String outname_1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_1";
            String outname_2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/const_2";
            String over_w1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultA.pdb";
            String over_w2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/resultB.pdb";
            double[] res = PDB_parser.writeResultPDB(strA, outname_1, over_w1, true);
            if (res[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            if ((res = PDB_parser.writeResultPDB(strB, outname_2, over_w2, false))[1] > max_c) {
                max_c = res[1];
            }
            if (res[0] < min_c) {
                min_c = res[0];
            }
            int j = 1;
            while (j < num_iterations + 1) {
                String TPs = "";
                String FPs = "";
                String TNs = "";
                String FNs = "";
                ArrayList<Integer> consider1 = Analyzer.HalveStructure(strA);
                ArrayList<Integer> consider2 = Analyzer.HalveStructure(strB);
                double cutoff = 0.0;
                while (cutoff < 3.5) {
                    ArrayList<Integer> forA = PDB_parser.writePDBHalf(strA, true, cutoff, consider1);
                    ArrayList<Integer> forB = PDB_parser.writePDBHalf(strB, false, cutoff, consider2);
                    TPs = String.valueOf(TPs) + i + " " + cutoff + " " + (forA.get(0) + forB.get(0)) + "\n";
                    FPs = String.valueOf(FPs) + i + " " + cutoff + " " + (forA.get(1) + forB.get(1)) + "\n";
                    TNs = String.valueOf(TNs) + i + " " + cutoff + " " + (forA.get(2) + forB.get(2)) + "\n";
                    FNs = String.valueOf(FNs) + i + " " + cutoff + " " + (forA.get(3) + forB.get(3)) + "\n";
                    cutoff += 0.1;
                }
                String directory = String.valueOf(System.getProperty("user.dir")) + "/" + results_folder;
                FileSystemTools.append("TP" + j, directory, TPs);
                FileSystemTools.append("FP" + j, directory, FPs);
                FileSystemTools.append("TN" + j, directory, TNs);
                FileSystemTools.append("FN" + j, directory, FNs);
                ++j;
            }
            ++i;
        }
        System.out.println(max_c);
        System.out.println(min_c);
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 + "s");
        System.out.println("Wrote results");
    }

    public static void dealWithFile(String filename) {
        String reference = "";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.contains(">reference")) {
                line = lines.get(++i);
                while (!line.contains(">")) {
                    reference = String.valueOf(reference) + line;
                    line = lines.get(++i);
                }
                System.out.println("For " + filename);
                System.out.println(">reference\n" + reference + "\n>seq\n" + reference);
                break;
            }
            ++i;
        }
    }

    public static File[] prepareMSAs() {
        File dir = new File(String.valueOf(userdir) + "/test/msa");
        System.out.println(dir.exists());
        String[] children = dir.list();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                String string = children[i];
                ++i;
            }
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".");
            }
        };
        children = dir.list(filter);
        File[] files = dir.listFiles();
        return files;
    }

    public static Residue_type[] getNewSequence(String pdb, ArrayList<Integer> roi, char chain, String directory, boolean isA) {
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb, outname, roi, chain);
        Residue_type[] new_ref = new Residue_type[10000];
        ArrayList<Residue_type> ref_final = new ArrayList<Residue_type>();
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname, roi, chain);
        for (Integer inte : pdb_residues.keySet()) {
            new_ref[inte.intValue()] = pdb_residues.get((Object)inte).type;
        }
        int i = 0;
        while (i < new_ref.length) {
            if (new_ref[i] != null) {
                ref_final.add(new_ref[i]);
            }
            ++i;
        }
        Residue_type[] to_return = new Residue_type[ref_final.size()];
        int i2 = 0;
        while (i2 < ref_final.size()) {
            to_return[i2] = (Residue_type)((Object)ref_final.get(i2));
            ++i2;
        }
        return to_return;
    }

    public static void createScrambledData() {
        int j = 1;
        while (j < 11) {
            System.out.println("[" + j + "/10]");
            int i = 1;
            while (i < 59) {
                System.out.println(" [" + i + "/58]");
                String testFolderold = "/Tests/TestSetsAllNew/TestSet_" + i;
                String testFoldernew = "/Tests/Scrambling1/TestSetsAll" + j + "/TestSet_" + i;
                String pdb1 = String.valueOf(System.getProperty("user.dir")) + testFolderold + "/str_A";
                String pdb2 = String.valueOf(System.getProperty("user.dir")) + testFoldernew + "/str_A";
                PDB_parser.scrambleResidues(pdb1, pdb2);
                ++i;
            }
            ++j;
        }
    }

    public static ArrayList<Integer> HalveStructure(SC_Structure str) {
        ArrayList<Integer> consider = new ArrayList<Integer>();
        double cons = 0.0;
        double nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact) {
                cons += 1.0;
                continue;
            }
            nons += 1.0;
        }
        Random r = new Random();
        double ratio = cons / nons;
        nons = 0.0;
        for (Integer si : str.residues.keySet()) {
            if (str.residues.get((Object)si).isContact || !(ratio > r.nextDouble())) continue;
            consider.add(si);
            nons += 1.0;
        }
        return consider;
    }

    public static SC_Structure calculateNeighbors(SC_Structure s1, SC_Structure s2, String save_folder, int reference) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        String res_lines = "";
        for (Integer j : residues_s1.keySet()) {
            for (Integer i : residues_s2.keySet()) {
                res_lines = residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5 ? String.valueOf(res_lines) + residues_s1.get((Object)j).ref_site + "\t" + (residues_s2.get((Object)i).ref_site + reference) + "\t1\n" : String.valueOf(res_lines) + residues_s1.get((Object)j).ref_site + "\t" + (residues_s2.get((Object)i).ref_site + reference) + "\t0\n";
            }
        }
        FileSystemTools.writeFile("model_solution_clustal", save_folder, res_lines);
        return s2;
    }

    public static SC_Structure calculateNeighborsAWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5)) continue;
                s1.residues.get((Object)i).isContact = true;
                if (i == s1.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s1;
    }

    public static SC_Structure calculateNeighborsBWrite(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s2.keySet()) {
            s2.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s1.keySet()) {
                if (!(residues_s1.get(j).distanceFrom(residues_s2.get(i)) < 4.5)) continue;
                s2.residues.get((Object)i).isContact = true;
                if (i == s2.residues.get((Object)i).site) continue;
                System.err.println("unequal");
                System.exit(0);
            }
        }
        return s2;
    }

    public static void WriteResultScore(SC_Structure str, String save_file) {
        String lines = "";
        for (Integer i : str.residues.keySet()) {
            lines = String.valueOf(lines) + i + "\t" + str.residues.get(i).getTPro() + " " + "\n";
        }
        FileSystemTools.writeFile(save_file, lines);
    }

    public static void WriteResultModel(SC_Structure str, String save_file) {
        String lines = "";
        for (Integer i : str.residues.keySet()) {
            lines = String.valueOf(lines) + i + "\t" + (str.residues.get((Object)i).isContact ? "1" : "0") + "\n";
        }
        FileSystemTools.writeFile(save_file, lines);
    }
}

