/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.Analyzer;
import data_structures.MSA;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import data_structures.SequencePair;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeSet;
import main.Main_inter;
import parsing.PDB_parser;
import parsing.PSA;

public class FakeProtein {
    public static final String cwd = System.getProperty("user.dir");

    public static void main(String[] args) {
        FakeProtein.annotated_patches();
    }

    public static void annotated_patches() {
        String patches_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/contact_patches_all";
        String method = "TPRO";
        String bias = "triple_contact";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/contact_patches" + method;
        FakeProtein.FakePatches(scramble_run, results, 1, bias, patches_folder);
    }

    public static void triple_contact(String method) {
        String bias = "triple_contact";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/contact3" + method;
        int iterations = 200;
        FakeProtein.analyze(scramble_run, results, iterations, bias);
    }

    public static void short_verification(String method) {
        String bias = "triple_contact";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/single_verification" + method;
        String patches_folder = String.valueOf(cwd) + "/SurfaceData/DataFiles/processed_domain";
        int iterations = 100;
        FakeProtein.analyzeRandomPDB(scramble_run, results, iterations, patches_folder);
    }

    public static void triple_relative(String method) {
        String bias = "triple_relative";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/relative3" + method;
        int iterations = 200;
        FakeProtein.analyze(scramble_run, results, iterations, bias);
    }

    public static void single_contact(String method) {
        String bias = "single_contact";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/single" + method;
        int iterations = 200;
        FakeProtein.analyze(scramble_run, results, iterations, bias);
    }

    public static void surface_bias(String method) {
        String bias = "surface_bias";
        String scramble_run = "/Tests/SingleTests";
        String results = "TestResults/surface" + method;
        int iterations = 200;
        FakeProtein.analyze(scramble_run, results, iterations, bias);
    }

    public static void analyze(String scramble_run, String results_folder, int iterations, String bias) {
        double t_start = System.currentTimeMillis();
        int test_num = 117;
        int i = 1;
        while (i < iterations + 1) {
            int test_ind = 1;
            while (test_ind < test_num) {
                System.out.println(String.valueOf(scramble_run) + " iteration " + i + " [" + test_ind + "/" + (test_num - 1) + "]");
                String testFolder = String.valueOf(scramble_run) + "/Test" + test_ind;
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str.pdb";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_biased";
                PDB_parser.writeBiasedPDB(pdb_file1, pdb_file2, bias);
                Residue_type[] first = FakeProtein.getNewSequence(pdb_file1, System.getProperty("user.dir"), true);
                Residue_type[] second = FakeProtein.getNewSequence(pdb_file2, System.getProperty("user.dir"), false);
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                MSA msa = new MSA(sp_arr);
                SC_Structure strA = FakeProtein.structureAndMSA(pdb_file1, msa, true, String.valueOf(System.getProperty("user.dir")) + testFolder);
                SC_Structure strB = FakeProtein.structureAndMSA(pdb_file2, msa, false, String.valueOf(System.getProperty("user.dir")) + testFolder);
                Main_inter mi = new Main_inter(msa, strA, strB);
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + i + "_" + test_ind);
                ++test_ind;
            }
            ++i;
        }
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)((test_num - 1) * iterations) + "s/test on average over " + (test_num - 1) + " tests");
        System.out.println("Done");
    }

    public static void analyzeRandomPDB(String scramble_run, String results_folder, int iterations, String pdb_source) {
        double t_start = System.currentTimeMillis();
        int test_num = 117;
        int i = 1;
        while (i < iterations + 1) {
            int test_ind = 1;
            while (test_ind < test_num) {
                System.out.println(String.valueOf(scramble_run) + " iteration " + i + " [" + test_ind + "/" + (test_num - 1) + "]");
                String testFolder = String.valueOf(scramble_run) + "/Test" + test_ind;
                Random r = new Random();
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str.pdb";
                ArrayList<String> available_pdbs = FakeProtein.getInputFiles(pdb_source);
                System.out.println(available_pdbs.size());
                String chosen_pdb = available_pdbs.get(r.nextInt(available_pdbs.size()));
                String pdb_file2 = String.valueOf(pdb_source) + "/" + chosen_pdb;
                Residue_type[] first = FakeProtein.getNewSequence(pdb_file1, System.getProperty("user.dir"), true);
                Residue_type[] second = FakeProtein.getNewSequence(pdb_file2, System.getProperty("user.dir"), false);
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                MSA msa = new MSA(sp_arr);
                SC_Structure strA = FakeProtein.structureAndMSA(pdb_file1, msa, true, String.valueOf(System.getProperty("user.dir")) + testFolder);
                SC_Structure strB = FakeProtein.structureAndMSA(pdb_file2, msa, false, String.valueOf(System.getProperty("user.dir")) + testFolder);
                Main_inter mi = new Main_inter(msa, strA, strB);
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + i + "_" + test_ind);
                ++test_ind;
            }
            ++i;
        }
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)((test_num - 1) * iterations) + "s/test on average over " + (test_num - 1) + " tests");
        System.out.println("Done");
    }

    public static void analyzeShortMSA(String scramble_run, String results_folder, int iterations, String bias, String source_folder) {
        double t_start = System.currentTimeMillis();
        int test_num = 117;
        int i = 1;
        while (i < iterations + 1) {
            int test_ind = 1;
            while (test_ind < test_num) {
                System.out.println(String.valueOf(scramble_run) + " iteration " + i + " [" + test_ind + "/" + (test_num - 1) + "]");
                String testFolder = String.valueOf(scramble_run) + "/Test" + test_ind;
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str.pdb";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_biased";
                PDB_parser.writeBiasedPDB(pdb_file1, pdb_file2, bias);
                SC_Structure strB = FakeProtein.structureAndMSAShortMSA(pdb_file2, false, String.valueOf(System.getProperty("user.dir")) + testFolder);
                Residue_type[] first = FakeProtein.getNewSequence(pdb_file1, System.getProperty("user.dir"), true);
                Residue_type[] second = Main_inter.annotateFakePatches(strB, Main_inter.createPatchLookup(source_folder));
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                MSA msa = new MSA(sp_arr);
                SC_Structure strA = FakeProtein.structureAndMSA(pdb_file1, msa, true, String.valueOf(System.getProperty("user.dir")) + testFolder);
                Main_inter mi = new Main_inter(msa, strA, strB);
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + i + "_" + test_ind);
                ++test_ind;
            }
            ++i;
        }
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)((test_num - 1) * iterations) + "s/test on average over " + (test_num - 1) + " tests");
        System.out.println("Done");
    }

    public static void FakePatches(String scramble_run, String results_folder, int iterations, String bias, String patch_db) {
        double t_start = System.currentTimeMillis();
        int test_num = 117;
        int i = 1;
        while (i < iterations + 1) {
            int test_ind = 1;
            while (test_ind < test_num) {
                System.out.println(String.valueOf(scramble_run) + " iteration " + i + " [" + test_ind + "/" + (test_num - 1) + "]");
                String testFolder = String.valueOf(scramble_run) + "/Test" + test_ind;
                String pdb_file1 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str.pdb";
                String pdb_file2 = String.valueOf(System.getProperty("user.dir")) + testFolder + "/str_biased";
                PDB_parser.writeBiasedPDB(pdb_file1, pdb_file2, bias);
                Residue_type[] first = FakeProtein.getNewSequence(pdb_file1, System.getProperty("user.dir"), true);
                Residue_type[] second = FakeProtein.getNewSequence(pdb_file2, System.getProperty("user.dir"), false);
                SequencePair sp = new SequencePair(first, second, 0);
                ArrayList<SequencePair> sp_arr = new ArrayList<SequencePair>();
                sp_arr.add(sp);
                MSA msa = new MSA(sp_arr);
                SC_Structure strA = FakeProtein.structureAndMSA(pdb_file1, msa, true, String.valueOf(System.getProperty("user.dir")) + testFolder);
                SC_Structure strB = FakeProtein.structureAndMSA(pdb_file2, msa, false, String.valueOf(System.getProperty("user.dir")) + testFolder);
                Main_inter mi = new Main_inter(msa, strA, strB, patch_db);
                Analyzer.WriteResultScore(strA, String.valueOf(System.getProperty("user.dir")) + "/" + results_folder + "/TPRO_" + i + "_" + test_ind);
                ++test_ind;
            }
            ++i;
        }
        System.out.println("Program takes: " + ((double)System.currentTimeMillis() - t_start) / 1000.0 / (double)((test_num - 1) * iterations) + "s/test on average over " + (test_num - 1) + " tests");
        System.out.println("Done");
    }

    public static Residue_type[] getNewSequence(String pdb, String directory, boolean isA) {
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb, outname);
        Residue_type[] new_ref = new Residue_type[10000];
        ArrayList<Residue_type> ref_final = new ArrayList<Residue_type>();
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname);
        for (Integer inte : pdb_residues.keySet()) {
            new_ref[inte.intValue()] = pdb_residues.get((Object)inte).type;
        }
        int i = 0;
        while (i < new_ref.length) {
            if (new_ref[i] != null) {
                ref_final.add(new_ref[i]);
            }
            ++i;
        }
        Residue_type[] to_return = new Residue_type[ref_final.size()];
        int i2 = 0;
        while (i2 < ref_final.size()) {
            to_return[i2] = (Residue_type)((Object)ref_final.get(i2));
            ++i2;
        }
        return to_return;
    }

    public static Residue_type[] getNewSequenceShortMSA() {
        Residue_type[] typs = new Residue_type[20];
        int i = 0;
        while (i < 20) {
            typs[i] = Residue_type.values()[i];
            ++i;
        }
        return typs;
    }

    public static SC_Structure structureAndMSA(String pdb_file1, MSA msa, boolean isA, String directory) {
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb_file1, outname);
        HashMap<Integer, Boolean> map = PSA.runPSA(7.0, outname);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : map.keySet()) {
            sorted.add(i);
        }
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname);
        Residue_type[] ref_seq = isA ? msa.sequences.get((int)0).sequenceA : msa.sequences.get((int)0).sequenceB;
        String first_seven = "";
        int k = 1;
        for (Integer i : sorted) {
            first_seven = String.valueOf(first_seven) + (Object)((Object)pdb_residues.get((Object)i).type);
            if (++k > 7) break;
        }
        String sequence = "";
        int l = 0;
        while (l < ref_seq.length) {
            if (ref_seq[l] != Residue_type.gap) {
                sequence = String.valueOf(sequence) + (Object)((Object)ref_seq[l]);
            }
            ++l;
        }
        System.out.println("First occurence " + sequence.indexOf(first_seven) + " of " + first_seven);
        System.out.println("In the sequence \n" + sequence);
        String the_ref = "";
        String the_res = "";
        int j = 0;
        int res_count = 0;
        int l2 = 0;
        while (l2 < ref_seq.length && res_count < sequence.indexOf(first_seven)) {
            if (ref_seq[l2] != Residue_type.gap) {
                ++res_count;
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + "-";
            }
            ++j;
            ++l2;
        }
        for (Integer i : sorted) {
            if (!pdb_residues.containsKey(i)) continue;
            while (j < ref_seq.length && ref_seq[j] != pdb_residues.get((Object)i).type) {
                if (ref_seq[j] != Residue_type.gap) {
                    the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                    the_res = String.valueOf(the_res) + "-";
                    int temp_count = 0;
                    String prop_seq = "";
                    for (Integer i_new : sorted) {
                        if (i_new < i || temp_count >= 7) continue;
                        prop_seq = String.valueOf(prop_seq) + (Object)((Object)pdb_residues.get((Object)i_new).type);
                        ++temp_count;
                    }
                    String sequence_here = "";
                    int k_other = j + 1;
                    while (k_other < ref_seq.length) {
                        if (ref_seq[k_other] != Residue_type.gap) {
                            sequence_here = String.valueOf(sequence_here) + (Object)((Object)ref_seq[k_other]);
                        }
                        ++k_other;
                    }
                    int first_ = sequence_here.indexOf(prop_seq);
                    int k_other2 = j + 1;
                    k_other2 = j + 1;
                    while (k_other2 < ref_seq.length && first_ > 0) {
                        if (ref_seq[k_other2] != Residue_type.gap) {
                            --first_;
                        }
                        ++k_other2;
                    }
                    j = k_other2 - 1;
                }
                ++j;
            }
            if (j < ref_seq.length) {
                the_ref = String.valueOf(the_ref) + (Object)((Object)ref_seq[j]);
                the_res = String.valueOf(the_res) + (Object)((Object)pdb_residues.get((Object)i).type);
                pdb_residues.get(i).setRefSite(j);
                ++j;
                continue;
            }
            System.err.println("Main_outer1:StructureandMSA: It was impossible to annotate sequence at residue " + i);
            pdb_residues.get(i).setRefSite(-1);
        }
        HashMap<Integer, Residue> final_residues = new HashMap<Integer, Residue>();
        ArrayList<Integer> nogapA = msa.gapColumnsA(0.5);
        ArrayList<Integer> nogapB = msa.gapColumnsB(0.5);
        for (Integer i : pdb_residues.keySet()) {
            if (!map.get(i).booleanValue() || (!isA || !nogapA.contains(pdb_residues.get(i).getRefSite())) && (isA || !nogapB.contains(pdb_residues.get(i).getRefSite()))) continue;
            Residue res = pdb_residues.get(i);
            final_residues.put(i, res);
        }
        return new SC_Structure(final_residues, sorted, isA, 'A');
    }

    public static SC_Structure structureAndMSAShortMSA(String pdb_file1, boolean isA, String directory) {
        String outname = String.valueOf(directory) + (isA ? "/const_1" : "/const_2");
        PDB_parser.writeConstrainingPDB(pdb_file1, outname);
        char chain = PDB_parser.getChains(pdb_file1).charAt(0);
        HashMap<Integer, Boolean> map = PSA.runPSA(7.0, outname);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : map.keySet()) {
            sorted.add(i);
        }
        HashMap<Integer, Residue> pdb_residues = PDB_parser.parse(outname);
        HashMap<Integer, Residue> final_residues = new HashMap<Integer, Residue>();
        for (Integer i : pdb_residues.keySet()) {
            if (!map.get(i).booleanValue()) continue;
            Residue res = pdb_residues.get(i);
            final_residues.put(i, res);
        }
        return new SC_Structure(final_residues, sorted, isA, chain);
    }

    public static ArrayList<String> getInputFiles(String input_folder) {
        File folder = new File(input_folder);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> out_files = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            String files;
            if (listOfFiles[i].isFile() && (files = listOfFiles[i].getName()).contains(".pdb")) {
                out_files.add(files);
            }
            ++i;
        }
        System.out.println(String.valueOf(out_files.size()) + " elements extracted from " + input_folder);
        return out_files;
    }
}

