/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.MSA;
import data_structures.Residue_type;
import data_structures.SequencePair;
import java.util.ArrayList;
import java.util.HashMap;

public class Gap_function {
    public final HashMap<Integer, ArrayList<Residue_type[]>> g_func1 = new HashMap();
    public final HashMap<Integer, ArrayList<Residue_type[]>> g_func2 = new HashMap();
    public final ArrayList<SequencePair>[][] g_func_pair;

    public Gap_function(MSA msa) {
        this.g_func_pair = new ArrayList[msa.sequences.get((int)0).sequenceA.length][msa.sequences.get((int)0).sequenceB.length];
        this.calculateGaps(msa);
    }

    private void calculateGaps(MSA msa) {
        for (SequencePair sp : msa.sequences) {
            Residue_type[] seqA = sp.sequenceA;
            Residue_type[] seqB = sp.sequenceB;
            int i = 0;
            while (i < seqA.length) {
                if (seqA[i] != Residue_type.gap) {
                    if (!this.g_func1.containsKey(i)) {
                        ArrayList newlist = new ArrayList();
                        this.g_func1.put(i, newlist);
                    }
                    ArrayList<Residue_type[]> oldlist = this.g_func1.get(i);
                    oldlist.add(sp.sequenceA);
                    this.g_func1.put(i, oldlist);
                }
                int j = 0;
                while (j < seqB.length) {
                    if (i == 0 && seqB[j] != Residue_type.gap) {
                        if (!this.g_func2.containsKey(j)) {
                            ArrayList newlist2 = new ArrayList();
                            this.g_func2.put(j, newlist2);
                        }
                        ArrayList<Residue_type[]> oldlist2 = this.g_func2.get(j);
                        oldlist2.add(sp.sequenceB);
                        this.g_func2.put(j, oldlist2);
                    }
                    if (seqA[i] != Residue_type.gap && seqB[j] != Residue_type.gap) {
                        if (this.g_func_pair[i][j] == null) {
                            ArrayList newarray = new ArrayList();
                            this.g_func_pair[i][j] = newarray;
                        }
                        this.g_func_pair[i][j].add(sp);
                    }
                    ++j;
                }
                ++i;
            }
        }
        System.out.println("I-Patch$>Calculated gap free sequence mappings.");
    }
}

