/*
 * Decompiled with CFR 0.152.
 */
package data_structures;

import data_structures.Residue;
import data_structures.Residue_type;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class SC_Structure {
    public final HashMap<Integer, Residue> residues;
    public String src_file;
    public TreeSet<Integer> sorted;
    public boolean isA;
    public HashMap<Integer, Boolean> surface_exposed;
    public final char chain;

    public SC_Structure(HashMap<Integer, Residue> res, char _chain, String pdb_file) {
        this.residues = res;
        TreeSet<Integer> srt = new TreeSet<Integer>();
        for (Integer i : res.keySet()) {
            srt.add(i);
        }
        this.sorted = srt;
        this.chain = _chain;
        this.src_file = pdb_file;
        this.initializeIndexing();
    }

    public SC_Structure(HashMap<Integer, Residue> res, TreeSet<Integer> _srt, boolean isa, char _chain) {
        this.residues = res;
        TreeSet<Integer> srt = new TreeSet<Integer>();
        for (Integer i : res.keySet()) {
            srt.add(i);
        }
        this.sorted = srt;
        this.isA = isa;
        this.chain = _chain;
        this.initializeIndexing();
    }

    private void initializeIndexing() {
        int index = 0;
        for (Integer i : this.sorted) {
            this.residues.get((Object)i).in_array = index++;
        }
    }

    public String toString() {
        String out = "";
        for (Integer i : this.sorted) {
            out = String.valueOf(out) + (Object)((Object)this.residues.get((Object)i).type);
        }
        return out;
    }

    public String printAnnotated() {
        String out = "";
        for (Integer i : this.sorted) {
            out = String.valueOf(out) + i + " " + (Object)((Object)this.residues.get((Object)i).type) + "\n";
        }
        return out;
    }

    public Residue_type[] to_array() {
        Residue_type[] arr = new Residue_type[this.sorted.size()];
        int index = 0;
        for (Integer i : this.sorted) {
            arr[index++] = this.residues.get((Object)i).type;
        }
        return arr;
    }

    public String getPDBRenamed(char new_name) {
        String output = "";
        for (int r_i : this.sorted) {
            Residue res = this.residues.get(r_i);
            int a_i = 0;
            while (a_i < res.atoms.size()) {
                output = String.valueOf(output) + PDB_parser.renameChain(res.atoms.get((int)a_i).pdb_line, new_name) + "\n";
                ++a_i;
            }
        }
        return output;
    }

    public void writePDBRenamed(String filename, char new_name) {
        String output = "";
        for (int r_i : this.sorted) {
            Residue res = this.residues.get(r_i);
            int a_i = 0;
            while (a_i < res.atoms.size()) {
                output = String.valueOf(output) + PDB_parser.renameChain(res.atoms.get((int)a_i).pdb_line, new_name) + "\n";
                ++a_i;
            }
        }
        FileSystemTools.writeFile(filename, output);
    }

    public void writePDB(String filename) {
        String output = "";
        for (int r_i : this.sorted) {
            Residue res = this.residues.get(r_i);
            int a_i = 0;
            while (a_i < res.atoms.size()) {
                output = String.valueOf(output) + res.atoms.get((int)a_i).pdb_line + "\n";
                ++a_i;
            }
        }
        FileSystemTools.writeFile(filename, output);
    }

    public void writePDBContact(String filename) {
        String output = "";
        for (int r_i : this.sorted) {
            Residue res = this.residues.get(r_i);
            int a_i = 0;
            while (a_i < res.atoms.size()) {
                String color = res.isContact ? "100.01" : "0.01";
                String line = res.atoms.get((int)a_i).pdb_line;
                output = String.valueOf(output) + SC_Structure.colorBFactor(line, color) + "\n";
                ++a_i;
            }
        }
        FileSystemTools.writeFile(filename, output);
    }

    public SC_Structure GetSurfaceResidues(double cutoff) {
        HashMap<Integer, Boolean> mapping = PSA.runPSA(cutoff, this.src_file);
        HashMap<Integer, Residue> new_residues = new HashMap<Integer, Residue>();
        for (Integer r_i : mapping.keySet()) {
            if (!mapping.get(r_i).booleanValue()) continue;
            new_residues.put(r_i, this.residues.get(r_i));
        }
        SC_Structure new_sc = new SC_Structure(new_residues, this.chain, this.src_file);
        return new_sc;
    }

    public static String colorBFactor(String pdb_line, String color) {
        if (color.length() > 6) {
            System.err.println();
            System.exit(0);
        }
        while (color.length() < 6) {
            color = " " + color;
        }
        return String.valueOf(pdb_line.substring(0, 60)) + color + pdb_line.substring(66);
    }
}

