/*
 * Decompiled with CFR 0.152.
 */
package db_interface;

import data_structures.Residue;
import data_structures.SC_Structure;
import db_interface.Complex_Structure;
import db_interface.Energetics;
import java.io.File;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;
import utils.WebTools;

public class Controller {
    static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        Controller.countSitesSinglePono("normal_training");
        Controller.countSitesPairPono("normal_training");
        Controller.countSitesTrianglePono("normal_training");
    }

    public static void generateConsNonsSingle(String abag, String consnons) {
        System.out.println("Doing: single " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
        int[] res = new int[20];
        for (String pdb : pdbcodes) {
            int[] c = MathFunctions.readParsable1D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_single_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addVector(res, c);
        }
        MathFunctions.printParsable1D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_" + abag + "_" + consnons + ".txt");
    }

    public static void generateConsNonsPair(String abag, String consnons) {
        System.out.println("Doing: pair " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
        int[][] res = new int[20][20];
        for (String pdb : pdbcodes) {
            int[][] c = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_pair_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addMatrix(res, c);
        }
        MathFunctions.printParsable2D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_" + abag + "_" + consnons + ".txt");
    }

    public static void generateConsNonsTriangle(String abag, String consnons) {
        System.out.println("Doing: triangle " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
        int[][][] res = new int[20][20][20];
        for (String pdb : pdbcodes) {
            int[][][] c = MathFunctions.readParsable3D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_triangle_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addMatrix(res, c);
        }
        MathFunctions.printParsable3D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_" + abag + "_" + consnons + ".txt");
    }

    public static void generateConsNonsSinglePonom(String abag, String consnons) {
        System.out.println("Doing: single " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
        int[] res = new int[20];
        for (String pdb : pdbcodes) {
            pdb = pdb.substring(0, 4);
            int[] c = MathFunctions.readParsable1D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_single_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addVector(res, c);
        }
        MathFunctions.printParsable1D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_" + abag + "_" + consnons + ".txt");
    }

    public static void generateConsNonsPairPonom(String abag, String consnons) {
        System.out.println("Doing: pair " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
        int[][] res = new int[20][20];
        for (String pdb : pdbcodes) {
            pdb = pdb.substring(0, 4);
            int[][] c = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_pair_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addMatrix(res, c);
        }
        MathFunctions.printParsable2D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_" + abag + "_" + consnons + ".txt");
    }

    public static void generateConsNonsTrianglePonom(String abag, String consnons) {
        System.out.println("Doing: triangle " + abag + " " + consnons);
        String result_folder = "data/training_pdbs";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
        int[][][] res = new int[20][20][20];
        for (String pdb : pdbcodes) {
            pdb = pdb.substring(0, 4);
            int[][][] c = MathFunctions.readParsable3D(String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb + "_triangle_" + abag + "_" + consnons + ".txt");
            res = MathFunctions.addMatrix(res, c);
        }
        MathFunctions.printParsable3D(res, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_" + abag + "_" + consnons + ".txt");
    }

    public static void createNewTestSetNoSplitPonom() {
        System.out.println("Calculating new cons/nons matrices");
        ArrayList<String> abag = new ArrayList<String>();
        abag.add("ab");
        abag.add("ag");
        ArrayList<String> ncons = new ArrayList<String>();
        ncons.add("nons");
        ncons.add("cons");
        for (String s_abag : abag) {
            for (String s_ncons : ncons) {
                Controller.generateConsNonsSinglePonom(s_abag, s_ncons);
                Controller.generateConsNonsPairPonom(s_abag, s_ncons);
                Controller.generateConsNonsTrianglePonom(s_abag, s_ncons);
            }
        }
    }

    public static void createNewTestSetNoSplit() {
        System.out.println("Calculating new cons/nons matrices");
        ArrayList<String> abag = new ArrayList<String>();
        abag.add("ab");
        abag.add("ag");
        ArrayList<String> ncons = new ArrayList<String>();
        ncons.add("nons");
        ncons.add("cons");
        for (String s_abag : abag) {
            for (String s_ncons : ncons) {
                Controller.generateConsNonsSingle(s_abag, s_ncons);
                Controller.generateConsNonsPair(s_abag, s_ncons);
                Controller.generateConsNonsTriangle(s_abag, s_ncons);
            }
        }
    }

    public static void createNewTestSet() {
        System.out.println("Splitting the test and training sets");
        Controller.splitTestTraining(30);
        System.out.println("Calculating new cons/nons matrices");
        ArrayList<String> abag = new ArrayList<String>();
        abag.add("ab");
        abag.add("ag");
        ArrayList<String> ncons = new ArrayList<String>();
        ncons.add("nons");
        ncons.add("cons");
        for (String s_abag : abag) {
            for (String s_ncons : ncons) {
                Controller.generateConsNonsSingle(s_abag, s_ncons);
                Controller.generateConsNonsPair(s_abag, s_ncons);
                Controller.generateConsNonsTriangle(s_abag, s_ncons);
            }
        }
    }

    public static void generateNewEnergeticsTraining() {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        HashMap<String, Double> pdb_map = Energetics.BigAntigenEnergies();
        ArrayList<String> accepted_pdbs = new ArrayList<String>();
        int accepted = 0;
        String training = "";
        String test = "";
        for (String eligible_pdb : pdbcodes) {
            if (!pdb_map.keySet().contains(("" + eligible_pdb.subSequence(0, 4)).toLowerCase())) {
                ++accepted;
                accepted_pdbs.add(eligible_pdb);
                training = String.valueOf(training) + eligible_pdb + "\n";
                continue;
            }
            test = String.valueOf(test) + eligible_pdb + "\n";
        }
        System.out.println("Accepted " + accepted + " out of " + pdbcodes.size());
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt", training);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt", test);
    }

    public static void seqDistCorr() {
        String cdrs_folder = String.valueOf(userdir) + "/protein_database/antibodies/cdrs";
        ArrayList<String> cdrnames = FileSystemTools.getFiles(cdrs_folder);
        String correlations = "";
        int progress = 0;
        for (String cdr_name : cdrnames) {
            System.out.println(String.valueOf(++progress) + "/" + cdrnames.size());
            HashMap<Integer, Residue> residues = PDB_parser.parse(String.valueOf(cdrs_folder) + "/" + cdr_name);
            for (Integer i_res_A : residues.keySet()) {
                Residue res_A = residues.get(i_res_A);
                for (Integer i_res_B : residues.keySet()) {
                    if (i_res_A == i_res_B) continue;
                    Residue res_B = residues.get(i_res_B);
                    int seq_dist = Math.abs(i_res_A - i_res_B);
                    double str_dist = res_B.distanceFrom(res_A);
                    correlations = String.valueOf(correlations) + seq_dist + " " + str_dist + "\n";
                }
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/seq_str_correlation/corrs.txt", correlations);
    }

    public static void CDRpacking() {
        String src_folder = String.valueOf(userdir) + "/protein_database/non_protein_complexes";
        String res_tag = "small";
        String cdrs_folder = String.valueOf(userdir) + "/protein_database/antibodies/cdrs";
        ArrayList<String> pdbnames = FileSystemTools.getFiles(src_folder);
        ArrayList<String> done = new ArrayList<String>();
        ArrayList<String> duplicates = new ArrayList<String>();
        double[][] distances_all = new double[6][6];
        int progress = 0;
        int complete = 0;
        int incomplete = 0;
        for (String pdb_name : pdbnames) {
            String pdb_code;
            System.out.println(String.valueOf(++progress) + "/" + pdbnames.size());
            if (!pdb_name.contains("_AB_") || done.contains(pdb_code = pdb_name.substring(0, 4))) continue;
            done.add(pdb_code);
            File fl1 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L1.pdb");
            File fl2 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L2.pdb");
            File fl3 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "L3.pdb");
            File fh1 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H1.pdb");
            File fh2 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H2.pdb");
            File fh3 = new File(String.valueOf(cdrs_folder) + "/" + pdb_code + "H3.pdb");
            if (fl1.exists() && fl2.exists() && fl3.exists() && fh1.exists() && fh2.exists() && fh3.exists()) {
                ++complete;
                HashMap<Integer, Residue> l1 = PDB_parser.parse(fl1.getAbsolutePath());
                HashMap<Integer, Residue> l2 = PDB_parser.parse(fl2.getAbsolutePath());
                HashMap<Integer, Residue> l3 = PDB_parser.parse(fl3.getAbsolutePath());
                HashMap<Integer, Residue> h1 = PDB_parser.parse(fh1.getAbsolutePath());
                HashMap<Integer, Residue> h2 = PDB_parser.parse(fh2.getAbsolutePath());
                HashMap<Integer, Residue> h3 = PDB_parser.parse(fh3.getAbsolutePath());
                HashMap<String, HashMap<Integer, Residue>> cdrs = new HashMap<String, HashMap<Integer, Residue>>();
                if (l1.size() == 0 || l2.size() == 0 || l3.size() == 0 || h1.size() == 0 || h2.size() == 0 || h3.size() == 0) {
                    System.err.println("One is empty " + pdb_code);
                    System.exit(0);
                }
                SC_Structure sh1 = new SC_Structure(h1, 'C', null);
                SC_Structure sh2 = new SC_Structure(h2, 'C', null);
                SC_Structure sh3 = new SC_Structure(h3, 'C', null);
                SC_Structure sl1 = new SC_Structure(l1, 'C', null);
                SC_Structure sl2 = new SC_Structure(l2, 'C', null);
                SC_Structure sl3 = new SC_Structure(l3, 'C', null);
                String all = String.valueOf(sh1.toString()) + sh2 + sh3 + sl1 + sl2 + sl3;
                if (!duplicates.contains(all)) {
                    duplicates.add(all);
                    cdrs.put("H1", h1);
                    cdrs.put("H2", h2);
                    cdrs.put("H3", h3);
                    cdrs.put("L1", l1);
                    cdrs.put("L2", l2);
                    cdrs.put("L3", l3);
                    HashMap<String, Integer> name_map = new HashMap<String, Integer>();
                    name_map.put("H1", 1);
                    name_map.put("H2", 2);
                    name_map.put("H3", 3);
                    name_map.put("L1", 4);
                    name_map.put("L2", 5);
                    name_map.put("L3", 6);
                    double[][] distances = new double[6][6];
                    for (String chain_outer : cdrs.keySet()) {
                        for (String chain_inter : cdrs.keySet()) {
                            double dist;
                            if (chain_outer.equals(chain_inter)) continue;
                            distances[((Integer)name_map.get((Object)chain_outer)).intValue() - 1][((Integer)name_map.get((Object)chain_inter)).intValue() - 1] = dist = Controller.getDistance((HashMap)cdrs.get(chain_outer), (HashMap)cdrs.get(chain_inter));
                        }
                    }
                    distances_all = MathFunctions.addMatrix(distances_all, distances);
                    continue;
                }
                System.out.println("duplicate_found " + all);
                continue;
            }
            ++incomplete;
        }
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 6) {
                distances_all[i][j] = distances_all[i][j] / (double)complete;
                ++j;
            }
            ++i;
        }
        System.out.println("Incomplete: " + incomplete);
        System.out.println("Complete: " + complete);
        MathFunctions.write2Drray(distances_all, String.valueOf(userdir) + "/result_dump/seq_str_correlation/" + res_tag + "_binding_site.txt");
    }

    public static double getDistance(HashMap<Integer, Residue> ch1, HashMap<Integer, Residue> ch2) {
        double min = Double.MAX_VALUE;
        for (Integer i_res : ch1.keySet()) {
            Residue r1 = ch1.get(i_res);
            for (Integer j_res : ch2.keySet()) {
                Residue r2 = ch2.get(j_res);
                double d = r1.distanceFrom(r2);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return min;
    }

    public static void testPSA() {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        Complex_Structure cs = new Complex_Structure("1A2Y_AB", raw_folder, std_folder);
        cs.runPSA();
        int res_number = 1;
        while (res_number < 130) {
            if (cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)Integer.valueOf((int)res_number)).d_asa != 0.0) {
                System.out.println("ID: " + res_number);
                System.out.println("IC: " + cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)Integer.valueOf((int)res_number)).asa_IC);
                System.out.println("NC: " + cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)Integer.valueOf((int)res_number)).asa_NC);
                System.out.println("DASA: " + cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)Integer.valueOf((int)res_number)).d_asa);
            }
            ++res_number;
        }
    }

    public static ArrayList<String> splitTestTraining(int n) {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        ArrayList<String> selected_pdbs = new ArrayList<String>();
        Random r = new Random();
        int i = 0;
        while (i < n) {
            int index = r.nextInt(pdbcodes.size());
            selected_pdbs.add(pdbcodes.get(index));
            pdbcodes.remove(index);
            ++i;
        }
        String training = "";
        for (String pdb_code : pdbcodes) {
            training = String.valueOf(training) + pdb_code + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt", training);
        String test = "";
        for (String pdb_code : selected_pdbs) {
            test = String.valueOf(test) + pdb_code + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt", test);
        return selected_pdbs;
    }

    public static void removeSmall(int cutoff) {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        boolean progress = false;
        int tot = 0;
        for (String pdb_code : pdbcodes) {
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            if (cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.size() <= cutoff) continue;
            ++tot;
            System.out.println(pdb_code);
        }
        System.out.println("Got " + tot + " @ " + cutoff);
    }

    public static void countSitesSingle(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String model_folder = String.valueOf(userdir) + "/result_dump/model_solutions";
        int progress = 0;
        int[] ab_cons = new int[20];
        int[] ab_nons = new int[20];
        int[] ab_all = new int[20];
        int[] ag_cons = new int[20];
        int[] ag_nons = new int[20];
        int[] ag_all = new int[20];
        for (String pdb_code : pdbcodes) {
            int[] ab_cons_ind = new int[20];
            int[] ab_nons_ind = new int[20];
            int[] ab_all_ind = new int[20];
            int[] ag_cons_ind = new int[20];
            int[] ag_nons_ind = new int[20];
            int[] ag_all_ind = new int[20];
            System.out.println("Single: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                int n = ag_res.type.ordinal();
                ag_all[n] = ag_all[n] + 1;
                int n2 = ag_res.type.ordinal();
                ag_all_ind[n2] = ag_all_ind[n2] + 1;
                boolean found = false;
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5) || ag_res.d_asa == 0.0 || ab_res.d_asa == 0.0) continue;
                        int n3 = ag_res.type.ordinal();
                        ag_cons[n3] = ag_cons[n3] + 1;
                        int n4 = ag_res.type.ordinal();
                        ag_cons_ind[n4] = ag_cons_ind[n4] + 1;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    int n5 = ag_res.type.ordinal();
                    ag_nons[n5] = ag_nons[n5] + 1;
                    int n6 = ag_res.type.ordinal();
                    ag_nons_ind[n6] = ag_nons_ind[n6] + 1;
                    antigen_model = String.valueOf(antigen_model) + "A_" + ag_res_i + " 0\n";
                    continue;
                }
                antigen_model = String.valueOf(antigen_model) + "A_" + ag_res_i + " 1\n";
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    boolean found = false;
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    int n = ab_res.type.ordinal();
                    ab_all[n] = ab_all[n] + 1;
                    int n7 = ab_res.type.ordinal();
                    ab_all_ind[n7] = ab_all_ind[n7] + 1;
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5) || ag_res.d_asa == 0.0 || ab_res.d_asa == 0.0) continue;
                        int n8 = ab_res.type.ordinal();
                        ab_cons[n8] = ab_cons[n8] + 1;
                        int n9 = ab_res.type.ordinal();
                        ab_cons_ind[n9] = ab_cons_ind[n9] + 1;
                        found = true;
                        break;
                    }
                    if (!found) {
                        int n10 = ab_res.type.ordinal();
                        ab_nons[n10] = ab_nons[n10] + 1;
                        int n11 = ab_res.type.ordinal();
                        ab_nons_ind[n11] = ab_nons_ind[n11] + 1;
                        ab_model = String.valueOf(ab_model) + chain + "_" + ab_res_i + " 0\n";
                        continue;
                    }
                    ab_model = String.valueOf(ab_model) + chain + "_" + ab_res_i + " 1\n";
                }
            }
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_B.txt", antigen_model);
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_A.txt", ab_model);
            MathFunctions.printParsable1D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ab_cons.txt");
            MathFunctions.printParsable1D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ab_nons.txt");
            MathFunctions.printParsable1D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ag_cons.txt");
            MathFunctions.printParsable1D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ag_nons.txt");
        }
        MathFunctions.printParsable1D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ab_cons.txt");
        MathFunctions.printParsable1D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ab_nons.txt");
        MathFunctions.printParsable1D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ag_cons.txt");
        MathFunctions.printParsable1D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ag_nons.txt");
    }

    public static void countSitesPair(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        int progress = 0;
        int[][] ab_cons = new int[20][20];
        int[][] ab_nons = new int[20][20];
        int[][] ag_cons = new int[20][20];
        int[][] ag_nons = new int[20][20];
        for (String pdb_code : pdbcodes) {
            int[][] ab_cons_ind = new int[20][20];
            int[][] ab_nons_ind = new int[20][20];
            int[][] ag_cons_ind = new int[20][20];
            int[][] ag_nons_ind = new int[20][20];
            System.out.println("Pair: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (ag_res.distanceFrom(ab_res) < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                            int[] nArray = ag_cons[ag_res.type.ordinal()];
                            int n = ab_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray2 = ag_cons_ind[ag_res.type.ordinal()];
                            int n2 = ab_res.type.ordinal();
                            nArray2[n2] = nArray2[n2] + 1;
                            continue;
                        }
                        int[] nArray = ag_nons[ag_res.type.ordinal()];
                        int n = ab_res.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        int[] nArray3 = ag_nons_ind[ag_res.type.ordinal()];
                        int n3 = ab_res.type.ordinal();
                        nArray3[n3] = nArray3[n3] + 1;
                    }
                }
            }
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (ag_res.distanceFrom(ab_res) < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                            int[] nArray = ab_cons[ab_res.type.ordinal()];
                            int n = ag_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray4 = ab_cons_ind[ab_res.type.ordinal()];
                            int n4 = ag_res.type.ordinal();
                            nArray4[n4] = nArray4[n4] + 1;
                            continue;
                        }
                        int[] nArray = ab_nons[ab_res.type.ordinal()];
                        int n = ag_res.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        int[] nArray5 = ab_nons_ind[ab_res.type.ordinal()];
                        int n5 = ag_res.type.ordinal();
                        nArray5[n5] = nArray5[n5] + 1;
                    }
                }
            }
            MathFunctions.printParsable2D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ab_cons.txt");
            MathFunctions.printParsable2D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ab_nons.txt");
            MathFunctions.printParsable2D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ag_cons.txt");
            MathFunctions.printParsable2D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ag_nons.txt");
        }
        MathFunctions.printParsable2D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ab_cons.txt");
        MathFunctions.printParsable2D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ab_nons.txt");
        MathFunctions.printParsable2D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ag_cons.txt");
        MathFunctions.printParsable2D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ag_nons.txt");
    }

    public static void countSitesTriangle(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_pdbs.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String model_folder = String.valueOf(userdir) + "/result_dump/model_solutions";
        int progress = 0;
        int[][][] ab_cons = new int[20][20][20];
        int[][][] ab_nons = new int[20][20][20];
        int[][][] ag_cons = new int[20][20][20];
        int[][][] ag_nons = new int[20][20][20];
        for (String pdb_code : pdbcodes) {
            int[][][] ab_cons_ind = new int[20][20][20];
            int[][][] ab_nons_ind = new int[20][20][20];
            int[][][] ag_cons_ind = new int[20][20][20];
            int[][][] ag_nons_ind = new int[20][20][20];
            System.out.println("Triangle: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            int max_ab = -1;
            int max_ag = -1;
            for (Integer i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                if (i <= max_ab) continue;
                max_ab = i;
            }
            for (Integer i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                if (i <= max_ag) continue;
                max_ag = i;
            }
            double[][] dists = new double[max_ab + 1][max_ag + 1];
            for (Integer ab_i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ab_res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(ab_i);
                for (Integer ag_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                    Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_i);
                    dists[ab_i.intValue()][ag_i.intValue()] = ag_res.distanceFrom(ab_res);
                }
            }
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                for (int patch_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                    if (patch_i == ag_res_i) continue;
                    Residue patch_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(patch_i);
                    for (Character chain : cs.m1.chains.keySet()) {
                        for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                            Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                            if (dists[ab_res_i][ag_res_i] < 4.5 && dists[ab_res_i][patch_i] < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0 && patch_res.d_asa != 0.0) {
                                int[] nArray = ag_cons[ag_res.type.ordinal()][patch_res.type.ordinal()];
                                int n = ab_res.type.ordinal();
                                nArray[n] = nArray[n] + 1;
                                int[] nArray2 = ag_cons_ind[ag_res.type.ordinal()][patch_res.type.ordinal()];
                                int n2 = ab_res.type.ordinal();
                                nArray2[n2] = nArray2[n2] + 1;
                                continue;
                            }
                            int[] nArray = ag_nons[ag_res.type.ordinal()][patch_res.type.ordinal()];
                            int n = ab_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray3 = ag_nons_ind[ag_res.type.ordinal()][patch_res.type.ordinal()];
                            int n3 = ab_res.type.ordinal();
                            nArray3[n3] = nArray3[n3] + 1;
                        }
                    }
                }
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    Iterator<Constable> iterator = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet().iterator();
                    while (iterator.hasNext()) {
                        int patch_i = (Integer)iterator.next();
                        if (patch_i == ab_res_i) continue;
                        Residue patch_res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(patch_i);
                        for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                            Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                            if (dists[ab_res_i][ag_res_i] < 4.5 && dists[patch_i][ag_res_i] < 4.5 && patch_res.d_asa != 0.0 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                                int[] nArray = ab_cons[ab_res.type.ordinal()][patch_res.type.ordinal()];
                                int n = ag_res.type.ordinal();
                                nArray[n] = nArray[n] + 1;
                                int[] nArray4 = ab_cons_ind[ab_res.type.ordinal()][patch_res.type.ordinal()];
                                int n4 = ag_res.type.ordinal();
                                nArray4[n4] = nArray4[n4] + 1;
                                continue;
                            }
                            int[] nArray = ab_nons[ab_res.type.ordinal()][patch_res.type.ordinal()];
                            int n = ag_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray5 = ab_nons_ind[ab_res.type.ordinal()][patch_res.type.ordinal()];
                            int n5 = ag_res.type.ordinal();
                            nArray5[n5] = nArray5[n5] + 1;
                        }
                    }
                }
            }
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_B.txt", antigen_model);
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_A.txt", ab_model);
            MathFunctions.printParsable3D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ab_cons.txt");
            MathFunctions.printParsable3D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ab_nons.txt");
            MathFunctions.printParsable3D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ag_cons.txt");
            MathFunctions.printParsable3D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ag_nons.txt");
        }
        MathFunctions.printParsable3D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ab_cons.txt");
        MathFunctions.printParsable3D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ab_nons.txt");
        MathFunctions.printParsable3D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ag_cons.txt");
        MathFunctions.printParsable3D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ag_nons.txt");
    }

    public static void countSitesSinglePono(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String model_folder = String.valueOf(userdir) + "/result_dump/model_solutions";
        int progress = 0;
        int[] ab_cons = new int[20];
        int[] ab_nons = new int[20];
        int[] ab_all = new int[20];
        int[] ag_cons = new int[20];
        int[] ag_nons = new int[20];
        int[] ag_all = new int[20];
        for (String pdb_code : pdbcodes) {
            pdb_code = pdb_code.substring(0, 4);
            int[] ab_cons_ind = new int[20];
            int[] ab_nons_ind = new int[20];
            int[] ab_all_ind = new int[20];
            int[] ag_cons_ind = new int[20];
            int[] ag_nons_ind = new int[20];
            int[] ag_all_ind = new int[20];
            System.out.println("Single: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                int n = ag_res.type.ordinal();
                ag_all[n] = ag_all[n] + 1;
                int n2 = ag_res.type.ordinal();
                ag_all_ind[n2] = ag_all_ind[n2] + 1;
                boolean found = false;
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5) || ag_res.d_asa == 0.0 || ab_res.d_asa == 0.0) continue;
                        int n3 = ag_res.type.ordinal();
                        ag_cons[n3] = ag_cons[n3] + 1;
                        int n4 = ag_res.type.ordinal();
                        ag_cons_ind[n4] = ag_cons_ind[n4] + 1;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    int n5 = ag_res.type.ordinal();
                    ag_nons[n5] = ag_nons[n5] + 1;
                    int n6 = ag_res.type.ordinal();
                    ag_nons_ind[n6] = ag_nons_ind[n6] + 1;
                    antigen_model = String.valueOf(antigen_model) + "A_" + ag_res_i + " 0\n";
                    continue;
                }
                antigen_model = String.valueOf(antigen_model) + "A_" + ag_res_i + " 1\n";
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    boolean found = false;
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    int n = ab_res.type.ordinal();
                    ab_all[n] = ab_all[n] + 1;
                    int n7 = ab_res.type.ordinal();
                    ab_all_ind[n7] = ab_all_ind[n7] + 1;
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5) || ag_res.d_asa == 0.0 || ab_res.d_asa == 0.0) continue;
                        int n8 = ab_res.type.ordinal();
                        ab_cons[n8] = ab_cons[n8] + 1;
                        int n9 = ab_res.type.ordinal();
                        ab_cons_ind[n9] = ab_cons_ind[n9] + 1;
                        found = true;
                        break;
                    }
                    if (!found) {
                        int n10 = ab_res.type.ordinal();
                        ab_nons[n10] = ab_nons[n10] + 1;
                        int n11 = ab_res.type.ordinal();
                        ab_nons_ind[n11] = ab_nons_ind[n11] + 1;
                        ab_model = String.valueOf(ab_model) + chain + "_" + ab_res_i + " 0\n";
                        continue;
                    }
                    ab_model = String.valueOf(ab_model) + chain + "_" + ab_res_i + " 1\n";
                }
            }
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_B.txt", antigen_model);
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_A.txt", ab_model);
            MathFunctions.printParsable1D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ab_cons.txt");
            MathFunctions.printParsable1D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ab_nons.txt");
            MathFunctions.printParsable1D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ag_cons.txt");
            MathFunctions.printParsable1D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_single_ag_nons.txt");
        }
        MathFunctions.printParsable1D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ab_cons.txt");
        MathFunctions.printParsable1D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ab_nons.txt");
        MathFunctions.printParsable1D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ag_cons.txt");
        MathFunctions.printParsable1D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_single_ag_nons.txt");
    }

    public static void countSitesPairPono(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        int progress = 0;
        int[][] ab_cons = new int[20][20];
        int[][] ab_nons = new int[20][20];
        int[][] ag_cons = new int[20][20];
        int[][] ag_nons = new int[20][20];
        for (String pdb_code : pdbcodes) {
            pdb_code = pdb_code.substring(0, 4);
            int[][] ab_cons_ind = new int[20][20];
            int[][] ab_nons_ind = new int[20][20];
            int[][] ag_cons_ind = new int[20][20];
            int[][] ag_nons_ind = new int[20][20];
            System.out.println("Pair: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (ag_res.distanceFrom(ab_res) < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                            int[] nArray = ag_cons[ag_res.type.ordinal()];
                            int n = ab_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray2 = ag_cons_ind[ag_res.type.ordinal()];
                            int n2 = ab_res.type.ordinal();
                            nArray2[n2] = nArray2[n2] + 1;
                            continue;
                        }
                        int[] nArray = ag_nons[ag_res.type.ordinal()];
                        int n = ab_res.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        int[] nArray3 = ag_nons_ind[ag_res.type.ordinal()];
                        int n3 = ab_res.type.ordinal();
                        nArray3[n3] = nArray3[n3] + 1;
                    }
                }
            }
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (ag_res.distanceFrom(ab_res) < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                            int[] nArray = ab_cons[ab_res.type.ordinal()];
                            int n = ag_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray4 = ab_cons_ind[ab_res.type.ordinal()];
                            int n4 = ag_res.type.ordinal();
                            nArray4[n4] = nArray4[n4] + 1;
                            continue;
                        }
                        int[] nArray = ab_nons[ab_res.type.ordinal()];
                        int n = ag_res.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        int[] nArray5 = ab_nons_ind[ab_res.type.ordinal()];
                        int n5 = ag_res.type.ordinal();
                        nArray5[n5] = nArray5[n5] + 1;
                    }
                }
            }
            MathFunctions.printParsable2D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ab_cons.txt");
            MathFunctions.printParsable2D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ab_nons.txt");
            MathFunctions.printParsable2D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ag_cons.txt");
            MathFunctions.printParsable2D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_pair_ag_nons.txt");
        }
        MathFunctions.printParsable2D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ab_cons.txt");
        MathFunctions.printParsable2D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ab_nons.txt");
        MathFunctions.printParsable2D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ag_cons.txt");
        MathFunctions.printParsable2D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_pair_ag_nons.txt");
    }

    public static void countSitesTrianglePono(String which_dataset) {
        ArrayList<String> pdbcodes = null;
        String result_folder = null;
        if (which_dataset.equals("all")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
            result_folder = "data/all_pdbs";
        }
        if (which_dataset.equals("normal_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/training_ponom.txt");
            result_folder = "data/training_pdbs";
        }
        if (which_dataset.equals("normal_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/test_pdbs.txt");
            result_folder = "data/test_pdbs";
        }
        if (which_dataset.equals("energetics_training")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_training.txt");
            result_folder = "data/energetics_training";
        }
        if (which_dataset.equals("energetics_test")) {
            pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
            result_folder = "data/energetics_test";
        }
        String std_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String model_folder = String.valueOf(userdir) + "/result_dump/model_solutions";
        int progress = 0;
        int[][][] ab_cons = new int[20][20][20];
        int[][][] ab_nons = new int[20][20][20];
        int[][][] ag_cons = new int[20][20][20];
        int[][][] ag_nons = new int[20][20][20];
        for (String pdb_code : pdbcodes) {
            pdb_code = pdb_code.substring(0, 4);
            int[][][] ab_cons_ind = new int[20][20][20];
            int[][][] ab_nons_ind = new int[20][20][20];
            int[][][] ag_cons_ind = new int[20][20][20];
            int[][][] ag_nons_ind = new int[20][20][20];
            System.out.println("Triangle: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            cs.runPSA();
            int max_ab = -1;
            int max_ag = -1;
            for (Integer i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                if (i <= max_ab) continue;
                max_ab = i;
            }
            for (Integer i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                if (i <= max_ag) continue;
                max_ag = i;
            }
            double[][] dists = new double[max_ab + 1][max_ag + 1];
            for (Integer ab_i : cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ab_res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(ab_i);
                for (Integer ag_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                    Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_i);
                    dists[ab_i.intValue()][ag_i.intValue()] = ag_res.distanceFrom(ab_res);
                }
            }
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                for (int patch_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                    if (patch_i == ag_res_i) continue;
                    Residue patch_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(patch_i);
                    for (Character chain : cs.m1.chains.keySet()) {
                        for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                            Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                            if (dists[ab_res_i][ag_res_i] < 4.5 && dists[ab_res_i][patch_i] < 4.5 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0 && patch_res.d_asa != 0.0) {
                                int[] nArray = ag_cons[ag_res.type.ordinal()][patch_res.type.ordinal()];
                                int n = ab_res.type.ordinal();
                                nArray[n] = nArray[n] + 1;
                                int[] nArray2 = ag_cons_ind[ag_res.type.ordinal()][patch_res.type.ordinal()];
                                int n2 = ab_res.type.ordinal();
                                nArray2[n2] = nArray2[n2] + 1;
                                continue;
                            }
                            int[] nArray = ag_nons[ag_res.type.ordinal()][patch_res.type.ordinal()];
                            int n = ab_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray3 = ag_nons_ind[ag_res.type.ordinal()][patch_res.type.ordinal()];
                            int n3 = ab_res.type.ordinal();
                            nArray3[n3] = nArray3[n3] + 1;
                        }
                    }
                }
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    Iterator<Constable> iterator = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet().iterator();
                    while (iterator.hasNext()) {
                        int patch_i = (Integer)iterator.next();
                        if (patch_i == ab_res_i) continue;
                        Residue patch_res = cs.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get(patch_i);
                        for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                            Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                            if (dists[ab_res_i][ag_res_i] < 4.5 && dists[patch_i][ag_res_i] < 4.5 && patch_res.d_asa != 0.0 && ag_res.d_asa != 0.0 && ab_res.d_asa != 0.0) {
                                int[] nArray = ab_cons[ab_res.type.ordinal()][patch_res.type.ordinal()];
                                int n = ag_res.type.ordinal();
                                nArray[n] = nArray[n] + 1;
                                int[] nArray4 = ab_cons_ind[ab_res.type.ordinal()][patch_res.type.ordinal()];
                                int n4 = ag_res.type.ordinal();
                                nArray4[n4] = nArray4[n4] + 1;
                                continue;
                            }
                            int[] nArray = ab_nons[ab_res.type.ordinal()][patch_res.type.ordinal()];
                            int n = ag_res.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                            int[] nArray5 = ab_nons_ind[ab_res.type.ordinal()][patch_res.type.ordinal()];
                            int n5 = ag_res.type.ordinal();
                            nArray5[n5] = nArray5[n5] + 1;
                        }
                    }
                }
            }
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_B.txt", antigen_model);
            FileSystemTools.writeFile(String.valueOf(model_folder) + "/" + pdb_code + "_A.txt", ab_model);
            MathFunctions.printParsable3D(ab_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ab_cons.txt");
            MathFunctions.printParsable3D(ab_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ab_nons.txt");
            MathFunctions.printParsable3D(ag_cons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ag_cons.txt");
            MathFunctions.printParsable3D(ag_nons_ind, String.valueOf(userdir) + "/result_dump/ab_propensity/data/raw_cons/" + pdb_code + "_triangle_ag_nons.txt");
        }
        MathFunctions.printParsable3D(ab_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ab_cons.txt");
        MathFunctions.printParsable3D(ab_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ab_nons.txt");
        MathFunctions.printParsable3D(ag_cons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ag_cons.txt");
        MathFunctions.printParsable3D(ag_nons, String.valueOf(userdir) + "/result_dump/ab_propensity/" + result_folder + "/p_triangle_ag_nons.txt");
    }

    public static void writeTest() {
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        String test_folder = String.valueOf(userdir) + "/Tests/TestSetsABAG";
        int progress = 0;
        int i = 1;
        for (String pdb_code : pdbcodes) {
            System.out.println("Writing test: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                boolean found = false;
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                antigen_model = !found ? String.valueOf(antigen_model) + ag_res_i + "\t0\n" : String.valueOf(antigen_model) + ag_res_i + "\t1\n";
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    boolean found = false;
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5)) continue;
                        found = true;
                        break;
                    }
                    ab_model = !found ? String.valueOf(ab_model) + ab_res_i + "\t0\n" : String.valueOf(ab_model) + ab_res_i + "\t1\n";
                }
            }
            File dir = new File(String.valueOf(test_folder) + "/" + pdb_code);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileSystemTools.writeFile(String.valueOf(test_folder) + "/" + pdb_code + "/model_2", antigen_model);
            FileSystemTools.writeFile(String.valueOf(test_folder) + "/" + pdb_code + "/model_1", ab_model);
            FileSystemTools.CopyFile(cs.File_A_std(), String.valueOf(test_folder) + "/" + pdb_code + "/str_A");
            FileSystemTools.CopyFile(cs.File_B_std(), String.valueOf(test_folder) + "/" + pdb_code + "/str_B");
            ++i;
        }
    }

    public static void writeEnergeticsTest() {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/test_training_sets/energetics_test.txt");
        String test_folder = String.valueOf(userdir) + "/Tests/ABAGEnergetics";
        String test_mapping = "";
        int progress = 0;
        int i = 1;
        for (String pdb_code : pdbcodes) {
            System.out.println("I: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code, raw_folder, std_folder);
            String antigen_model = "";
            for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                boolean found = false;
                for (Character chain : cs.m1.chains.keySet()) {
                    for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                        Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                antigen_model = !found ? String.valueOf(antigen_model) + ag_res_i + "\t0\n" : String.valueOf(antigen_model) + ag_res_i + "\t1\n";
            }
            String ab_model = "";
            for (Character chain : cs.m1.chains.keySet()) {
                for (Integer ab_res_i : cs.m1.chains.get((Object)chain).residues.keySet()) {
                    boolean found = false;
                    Residue ab_res = cs.m1.chains.get((Object)chain).residues.get(ab_res_i);
                    for (Integer ag_res_i : cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
                        Residue ag_res = cs.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get(ag_res_i);
                        if (!(ag_res.distanceFrom(ab_res) < 4.5)) continue;
                        found = true;
                        break;
                    }
                    ab_model = !found ? String.valueOf(ab_model) + ab_res_i + "\t0\n" : String.valueOf(ab_model) + ab_res_i + "\t1\n";
                }
            }
            File dir = new File(String.valueOf(test_folder) + "/" + pdb_code);
            if (!dir.exists()) {
                dir.mkdir();
            }
            FileSystemTools.writeFile(String.valueOf(test_folder) + "/TestSet_" + i + "/model_2", antigen_model);
            FileSystemTools.writeFile(String.valueOf(test_folder) + "/TestSet_" + i + "/model_1", ab_model);
            FileSystemTools.CopyFile(cs.File_A_std(), String.valueOf(test_folder) + "/TestSet_" + i + "/str_A");
            FileSystemTools.CopyFile(cs.File_B_std(), String.valueOf(test_folder) + "/TestSet_" + i + "/str_B");
            test_mapping = String.valueOf(test_mapping) + i + " " + pdb_code + "\n";
            ++i;
            FileSystemTools.writeFile(String.valueOf(test_folder) + "/name_mapping.txt", test_mapping);
        }
    }

    public static void checkValidity() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
        HashMap<String, ArrayList> l_dups = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> h_dups = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> ag_dups = new HashMap<String, ArrayList>();
        HashMap<String, String> l_dups_pdb = new HashMap<String, String>();
        HashMap<String, String> h_dups_pdb = new HashMap<String, String>();
        HashMap<String, String> ag_dups_pdb = new HashMap<String, String>();
        HashMap<String, ArrayList> final_dups = new HashMap<String, ArrayList>();
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        ArrayList<String> res_eligible = new ArrayList<String>();
        ArrayList<String> done = new ArrayList<String>();
        int ab_count = 0;
        int progress = 0;
        String lengths = "";
        for (String pdb_code : pdbcodes) {
            ArrayList dups;
            ArrayList dups2;
            System.out.println("I: " + ++progress + "/" + pdbcodes.size() + " : " + pdb_code);
            if (done.contains(pdb_code)) continue;
            ++ab_count;
            Complex_Structure cs = new Complex_Structure(pdb_code);
            System.out.println("==========");
            System.out.println("PDB: " + pdb_code);
            String heavy_seq = "-";
            String light_seq = "-";
            if (cs.m1.chains.containsKey(Character.valueOf('H'))) {
                heavy_seq = cs.m1.chains.get(Character.valueOf('H')).toString();
                System.out.println("H: " + heavy_seq);
                h_dups_pdb.put(pdb_code, heavy_seq);
                if (h_dups.containsKey(heavy_seq)) {
                    dups2 = (ArrayList)h_dups.get(heavy_seq);
                    dups2.add(pdb_code);
                    h_dups.put(heavy_seq, dups2);
                } else {
                    dups2 = new ArrayList();
                    dups2.add(pdb_code);
                    h_dups.put(heavy_seq, dups2);
                }
            }
            if (cs.m1.chains.containsKey(Character.valueOf('L'))) {
                light_seq = cs.m1.chains.get(Character.valueOf('L')).toString();
                System.out.println("L: " + light_seq);
                l_dups_pdb.put(pdb_code, light_seq);
                if (l_dups.containsKey(light_seq)) {
                    dups2 = (ArrayList)l_dups.get(light_seq);
                    dups2.add(pdb_code);
                    l_dups.put(light_seq, dups2);
                } else {
                    dups2 = new ArrayList();
                    dups2.add(pdb_code);
                    l_dups.put(light_seq, dups2);
                }
            }
            String ag_seq = cs.m2.chains.get(Character.valueOf('A')).toString();
            String key = String.valueOf(heavy_seq) + light_seq + ag_seq;
            if (final_dups.containsKey(key)) {
                dups = (ArrayList)final_dups.get(key);
                dups.add(pdb_code);
                final_dups.put(key, dups);
            } else {
                dups = new ArrayList();
                dups.add(pdb_code);
                final_dups.put(key, dups);
            }
            System.out.println("Ag: " + ag_seq);
            lengths = String.valueOf(lengths) + ag_seq.length() + "\n";
            if (ag_seq.length() > 600) {
                System.err.println(pdb_code);
            }
            ag_dups_pdb.put(pdb_code, ag_seq);
            if (ag_dups.containsKey(ag_seq)) {
                dups = (ArrayList)ag_dups.get(ag_seq);
                dups.add(pdb_code);
                ag_dups.put(ag_seq, dups);
            } else {
                dups = new ArrayList();
                dups.add(pdb_code);
                ag_dups.put(ag_seq, dups);
            }
            System.out.println("==========");
            if (ag_seq.equals(heavy_seq) || ag_seq.equals(light_seq) || light_seq.equals(heavy_seq)) {
                System.out.println("ERROR");
                System.exit(0);
            }
            if (cs.resolution < 2.8) {
                res_eligible.add(pdb_code);
            }
            done.add(pdb_code);
        }
        System.out.println("Total eligible Ab-Ag pairs: " + ab_count);
        System.out.println("l_dups: " + l_dups.size());
        System.out.println("h_dups: " + h_dups.size());
        System.out.println("ag_dups: " + ag_dups.size());
        System.out.println("res_eligible: " + res_eligible.size());
        System.out.println("final_dups: " + final_dups.size());
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/lengths.txt", lengths);
    }

    public static void Culler() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
        HashMap<String, ArrayList> l_dups = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> h_dups = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> ag_dups = new HashMap<String, ArrayList>();
        HashMap<String, String> l_dups_pdb = new HashMap<String, String>();
        HashMap<String, String> h_dups_pdb = new HashMap<String, String>();
        HashMap<String, String> ag_dups_pdb = new HashMap<String, String>();
        HashMap<Object, ArrayList> final_dups = new HashMap<Object, ArrayList>();
        ArrayList<String> res_eligible = new ArrayList<String>();
        ArrayList<String> files = FileSystemTools.getFiles(new_folder);
        ArrayList<String> done = new ArrayList<String>();
        int ab_count = 0;
        int progress = 0;
        for (String file : files) {
            ArrayList dups;
            ArrayList dups2;
            System.out.println("I: " + ++progress + "/" + files.size() + " : " + file);
            String pdb_code = file.substring(0, file.lastIndexOf(95));
            if (done.contains(pdb_code) || !file.contains("_AB_")) continue;
            ++ab_count;
            Complex_Structure cs = new Complex_Structure(pdb_code);
            System.out.println("==========");
            System.out.println("PDB: " + pdb_code);
            String heavy_seq = "-";
            String light_seq = "-";
            if (cs.m1.chains.containsKey(Character.valueOf('H'))) {
                heavy_seq = cs.m1.chains.get(Character.valueOf('H')).toString();
                System.out.println("H: " + heavy_seq);
                h_dups_pdb.put(pdb_code, heavy_seq);
                if (h_dups.containsKey(heavy_seq)) {
                    dups2 = (ArrayList)h_dups.get(heavy_seq);
                    dups2.add(pdb_code);
                    h_dups.put(heavy_seq, dups2);
                } else {
                    dups2 = new ArrayList();
                    dups2.add(pdb_code);
                    h_dups.put(heavy_seq, dups2);
                }
            }
            if (cs.m1.chains.containsKey(Character.valueOf('L'))) {
                light_seq = cs.m1.chains.get(Character.valueOf('L')).toString();
                System.out.println("L: " + light_seq);
                l_dups_pdb.put(pdb_code, light_seq);
                if (l_dups.containsKey(light_seq)) {
                    dups2 = (ArrayList)l_dups.get(light_seq);
                    dups2.add(pdb_code);
                    l_dups.put(light_seq, dups2);
                } else {
                    dups2 = new ArrayList();
                    dups2.add(pdb_code);
                    l_dups.put(light_seq, dups2);
                }
            }
            String ag_seq = cs.m2.chains.get(Character.valueOf('A')).toString();
            String key = String.valueOf(heavy_seq) + light_seq + ag_seq;
            if (final_dups.containsKey(key)) {
                dups = (ArrayList)final_dups.get(key);
                dups.add(pdb_code);
                final_dups.put(key, dups);
            } else {
                dups = new ArrayList();
                dups.add(pdb_code);
                final_dups.put(key, dups);
            }
            System.out.println("Ag: " + ag_seq);
            ag_dups_pdb.put(pdb_code, ag_seq);
            if (ag_dups.containsKey(ag_seq)) {
                dups = (ArrayList)ag_dups.get(ag_seq);
                dups.add(pdb_code);
                ag_dups.put(ag_seq, dups);
            } else {
                dups = new ArrayList();
                dups.add(pdb_code);
                ag_dups.put(ag_seq, dups);
            }
            System.out.println("==========");
            if (ag_seq.equals(heavy_seq) || ag_seq.equals(light_seq) || light_seq.equals(heavy_seq)) {
                System.out.println("ERROR");
                System.exit(0);
            }
            if (cs.resolution < 2.8) {
                res_eligible.add(pdb_code);
            }
            done.add(pdb_code);
        }
        System.out.println("Total eligible Ab-Ag pairs: " + ab_count);
        System.out.println("l_dups: " + l_dups.size());
        System.out.println("h_dups: " + h_dups.size());
        System.out.println("ag_dups: " + ag_dups.size());
        System.out.println("res_eligible: " + res_eligible.size());
        System.out.println("final_dups: " + final_dups.size());
        ArrayList<String> final_pdbs = new ArrayList<String>();
        for (String key : final_dups.keySet()) {
            ArrayList pdbs = (ArrayList)final_dups.get(key);
            String current_pdb = "";
            double min = 100.0;
            for (String pdb_code : pdbs) {
                Complex_Structure cs = new Complex_Structure(pdb_code);
                if (!(cs.resolution < min)) continue;
                min = cs.resolution;
                current_pdb = pdb_code;
            }
            if (!(min < 2.8)) continue;
            final_pdbs.add(current_pdb);
        }
        String output = "";
        for (String pdb_code : final_pdbs) {
            output = String.valueOf(output) + pdb_code + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt", output);
    }

    public static void tests() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
        String out_folder = String.valueOf(userdir) + "/protein_database/temp";
        ArrayList<String> files = FileSystemTools.getFiles(new_folder);
        ArrayList done = new ArrayList();
        int progress = 0;
        for (String file : files) {
            System.out.println(String.valueOf(++progress) + "/" + files.size() + " : " + file);
            if (!file.contains("AB_B")) continue;
            PDB_parser.renamePDBChain(String.valueOf(new_folder) + "/" + file, String.valueOf(out_folder) + "/" + file, 'A');
        }
    }

    public static void downloadPDBS() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        ArrayList<String> done = new ArrayList<String>();
        ArrayList<String> files = FileSystemTools.getFiles(new_folder);
        int progress = 0;
        for (String file : files) {
            System.out.println(String.valueOf(++progress) + "/" + files.size() + " : " + file);
            String pdb = file.substring(0, 4);
            if (done.contains(pdb) || new File(String.valueOf(raw_folder) + "/" + pdb + ".pdb").exists()) continue;
            done.add(pdb);
            String url = "http://www.pdb.org/pdb/files/" + pdb + ".pdb";
            WebTools.writeWebPage(String.valueOf(pdb) + ".pdb", raw_folder, url);
        }
    }

    public static void renaming() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/standardized";
        ArrayList<String> pdbcodes = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/eligible_pdbs.txt");
        String output_folder = String.valueOf(userdir) + "/protein_database/temp";
        int progress = 0;
        for (String old_file : pdbcodes) {
            System.out.println(String.valueOf(++progress) + "/" + pdbcodes.size());
            System.out.println(old_file);
            Complex_Structure cs = new Complex_Structure(old_file);
            FileSystemTools.CopyFile(String.valueOf(new_folder) + "/" + old_file + "_A.pdb", String.valueOf(output_folder) + "/" + old_file + "_C.pdb");
            ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(new_folder) + "/" + old_file + "_B.pdb");
            String output = "";
            int i = 0;
            while (i < lines.size()) {
                output = String.valueOf(output) + lines.get(i) + "\n";
                ++i;
            }
            FileSystemTools.append(String.valueOf(old_file) + "_C.pdb", output_folder, output);
        }
    }

    public static void dealWithRemaining() {
        String userdir = System.getProperty("user.dir");
        String new_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
        String old_folder = String.valueOf(userdir) + "/protein_database/general_proteins/domain";
        String copy_folder = String.valueOf(userdir) + "/protein_database/test";
        ArrayList<String> old_files = FileSystemTools.getFiles(old_folder);
        int progress = 0;
        for (String old_file : old_files) {
            System.out.println(String.valueOf(++progress) + "/" + old_files.size());
            System.out.println(old_file);
            String pdb = old_file.substring(0, 4);
            int final_num = Integer.parseInt(old_file.substring(old_file.indexOf("_") + 1, old_file.indexOf(".pdb")));
            if (final_num == 1 || final_num == 2) continue;
            File f1 = new File(String.valueOf(new_folder) + "/" + pdb + final_num + "_DD_A.pdb");
            File f2 = new File(String.valueOf(new_folder) + "/" + pdb + final_num + "_DD_B.pdb");
            if (final_num % 2 != 0) {
                System.out.println(String.valueOf(old_file) + " writing " + pdb + final_num + "_DD_A.pdb");
                FileSystemTools.CopyFile(String.valueOf(old_folder) + "/" + old_file, String.valueOf(new_folder) + "/" + pdb + (final_num + 1) + "_DD_A.pdb");
                continue;
            }
            System.out.println(String.valueOf(old_file) + " writing " + pdb + final_num + "_DD_B.pdb");
            FileSystemTools.CopyFile(String.valueOf(old_folder) + "/" + old_file, String.valueOf(new_folder) + "/" + pdb + final_num + "_DD_B.pdb");
        }
    }
}

