/*
 * Decompiled with CFR 0.152.
 */
package docking;

import abModels.CDRipatch;
import data_structures.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class ParatomeComparison {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String _case = "H";
        String src_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        String target_fold = String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/" + _case;
        ArrayList<String> pdbs = FileSystemTools.getFolders(src_fold);
        for (String pdb : pdbs) {
            HashMap<Integer, Residue> str = PDB_parser.parse(String.valueOf(src_fold) + "/" + pdb + "/AB.pdb", 'A');
            CDRipatch.annotateStructurePonom(pdb, str);
            String out = "";
            for (Integer i : str.keySet()) {
                if (!str.get((Object)i).isCDR) continue;
                System.out.println("My cdr - " + pdb + " " + i);
                out = String.valueOf(out) + i + "\n";
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/our_cdrs/" + pdb + ".txt", out);
        }
    }

    public static void doCopyOver() {
        ParatomeComparison.copy_over('R');
        ParatomeComparison.copy_over('H');
    }

    public static void copy_over(char _case) {
        String src_fold = "/Volumes/D/results_p_zdock/case_part_3";
        String target_fold = String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/" + _case;
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(src_fold) + _case);
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(_case) + " " + pdb);
            int br = ParatomeComparison.get_break(String.valueOf(src_fold) + _case + "/" + pdb + "/AB.pdb");
            String target_file = String.valueOf(target_fold) + "/" + pdb + ".pdb";
            ParatomeComparison.copyAntibody(String.valueOf(src_fold) + _case + "/" + pdb + "/AB.pdb", target_file, br);
        }
    }

    public static int copyAntibody(String src, String target, int br) {
        ArrayList<String> lines = FileSystemTools.readFile(src);
        char chain = 'L';
        String output = "";
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            int seq_id = Integer.parseInt(line.substring(23, 27).replace(" ", ""));
            if (seq_id == br) {
                chain = 'H';
            }
            line = PDB_parser.renameChain(line, chain);
            output = String.valueOf(output) + line + "\n";
            ++i;
        }
        FileSystemTools.writeFile(target, output);
        return -1;
    }

    public static int get_break(String src) {
        ArrayList<String> lines = FileSystemTools.readFile(src);
        int prev = -1;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            int atom_int = Integer.parseInt(line.substring(7, 11).replace(" ", ""));
            int seq_id = Integer.parseInt(line.substring(23, 27).replace(" ", ""));
            if (prev == -1) {
                prev = atom_int;
            } else {
                if (prev > atom_int && seq_id > 100) {
                    return seq_id;
                }
                prev = atom_int;
            }
            ++i;
        }
        return -1;
    }
}

