/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Residue;
import docking.DockingAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class QuantifyGoodBS {
    private static final String userdir = System.getProperty("user.dir");
    private static final String temp_dir = String.valueOf(userdir) + "/temp_dump";
    private static final String temp_AB = String.valueOf(temp_dir) + "/tempAB.pdb";
    private static final String temp_AG = String.valueOf(temp_dir) + "/tempAG.pdb";

    public static void main(String[] args) {
        QuantifyGoodBS.createMatrices();
    }

    public static void createMatrices() {
        String main_fold = "/media/D/likelihood";
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("case_likely");
        int[][] corr = new int[20][20];
        int[][] incorr = new int[20][20];
        for (String _case : _cases) {
            if (_case.equals("case_1")) continue;
            String res_fold = String.valueOf(main_fold) + "/" + _case;
            ArrayList<String> pdbs = FileSystemTools.getFolders(res_fold);
            int j = 0;
            for (String pdb_code : pdbs) {
                String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
                HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
                HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
                System.out.println(String.valueOf(_case) + " - " + pdb_code + "[" + j + "/" + pdbs.size() + "]");
                if (pdb_code.equals("output")) continue;
                ++j;
                File f = new File(String.valueOf(res_fold) + "/" + pdb_code + "/output");
                if (!f.exists()) continue;
                ArrayList<String> files = FileSystemTools.getFiles(String.valueOf(res_fold) + "/" + pdb_code + "/output");
                for (String file : files) {
                    int file_ind = Integer.parseInt(file.substring(file.indexOf(".") + 1, file.lastIndexOf(".")));
                    if (file_ind > 200) continue;
                    String res_file = String.valueOf(res_fold) + "/" + pdb_code + "/output/" + file;
                    DockingAnalyzer.createTemp(res_file, "");
                    HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB, 'A');
                    HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG, 'A');
                    for (int ab_i : ab.keySet()) {
                        Residue ab_r = ab.get(ab_i);
                        for (int ag_i : ag.keySet()) {
                            Residue ag_r = ag.get(ag_i);
                            if (ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5 && ab_r.distanceFrom(ag_r) < 4.5) {
                                int[] nArray = corr[ab_r.type.ordinal()];
                                int n = ag_r.type.ordinal();
                                nArray[n] = nArray[n] + 1;
                            }
                            if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) > 4.5) || !(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                            int[] nArray = incorr[ab_r.type.ordinal()];
                            int n = ag_r.type.ordinal();
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                }
            }
        }
        MathFunctions.write2Drray(corr, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_raw.txt");
        MathFunctions.write2Drray(incorr, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_raw.txt");
        MathFunctions.printParsable2D(corr, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_pars.txt");
        MathFunctions.printParsable2D(incorr, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_pars.txt");
    }
}

