/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.util.ArrayList;
import java.util.HashMap;
import utils.FileSystemTools;

public class TableCompiler {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String cutoff = "6";
        String set = "R";
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("correct");
        _cases.add("cdr");
        _cases.add("paratome");
        _cases.add("ipatch");
        String t200 = "top200=[";
        String raw = "raw=[";
        String scored = "scored=[";
        int i = 0;
        while (i < 4) {
            String _case = (String)_cases.get(i);
            ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/patch_dock_results/patchdock_" + _case + "_" + cutoff + "_" + set + "/top_200.txt");
            String line = lines.get(0);
            int e_1 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            int e_2 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            int e_3 = Integer.parseInt(line);
            t200 = String.valueOf(t200) + e_3 + " " + e_2 + " " + e_1 + ";\n";
            lines = FileSystemTools.readFile(String.valueOf(userdir) + "/patch_dock_results/patchdock_" + _case + "_" + cutoff + "_" + set + "/orig_10.txt");
            line = lines.get(0);
            e_1 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            e_2 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            e_3 = Integer.parseInt(line);
            raw = String.valueOf(raw) + e_3 + " " + e_2 + " " + e_1 + ";\n";
            lines = FileSystemTools.readFile(String.valueOf(userdir) + "/patch_dock_results/patchdock_" + _case + "_" + cutoff + "_" + set + "/score_10.txt");
            line = lines.get(0);
            e_1 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            e_2 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            e_3 = Integer.parseInt(line);
            scored = String.valueOf(scored) + e_3 + " " + e_2 + " " + e_1 + ";\n";
            ++i;
        }
        t200 = String.valueOf(t200) + "];\n";
        scored = String.valueOf(scored) + "];\n";
        raw = String.valueOf(raw) + "];\n";
        System.out.println(String.valueOf(t200) + scored + raw);
    }

    public static void createTableZDOCK() {
        String results = String.valueOf(userdir) + "/result_dump/docking_results";
        int ep_cut = 5;
        int runs = 2;
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("patchdock_correct_5_R");
        _cases.add("patchdock_ipatch_5_R");
        _cases.add("patchdock_paratome_5_R");
        _cases.add("patchdock_cdr_5_R");
        _cases.add("patchdock_paratome_5_H");
        _cases.add("patchdock_cdr_5_H");
        _cases.add("patchdock_correct_5_H");
        _cases.add("patchdock_ipatch_5_H");
        for (String _case : _cases) {
            HashMap<Integer, Double> vec_o = new HashMap<Integer, Double>();
            vec_o.put(1, 0.0);
            vec_o.put(2, 0.0);
            vec_o.put(3, 0.0);
            HashMap<Integer, Double> vec_s = new HashMap<Integer, Double>();
            vec_s.put(1, 0.0);
            vec_s.put(2, 0.0);
            vec_s.put(3, 0.0);
            int i = 1;
            while (i <= runs) {
                ArrayList<String> orig = FileSystemTools.readFile(String.valueOf(results) + "/" + _case + "/" + i + "/orig_10.txt");
                vec_o = TableCompiler.vectorize(orig.get(0), vec_o);
                ArrayList<String> score = FileSystemTools.readFile(String.valueOf(results) + "/" + _case + "/" + i + "/score_10.txt");
                vec_s = TableCompiler.vectorize(score.get(0), vec_s);
                ++i;
            }
            vec_o.put(1, TableCompiler.round((Double)vec_o.get(1) / (double)runs, 2));
            vec_o.put(2, TableCompiler.round((Double)vec_o.get(2) / (double)runs, 2));
            vec_o.put(3, TableCompiler.round(vec_o.get(3) / (double)runs, 2));
            vec_s.put(1, TableCompiler.round(vec_s.get(1) / (double)runs, 2));
            vec_s.put(2, TableCompiler.round(vec_s.get(2) / (double)runs, 2));
            vec_s.put(3, TableCompiler.round(vec_s.get(3) / (double)runs, 2));
            System.out.println("Original for " + _case);
            System.out.println(vec_o.get(1) + "* " + vec_o.get(2) + "** " + vec_o.get(3) + "*** ");
            System.out.println("Score for " + _case);
            System.out.println(vec_s.get(1) + "* " + vec_s.get(2) + "** " + vec_s.get(3) + "*** ");
        }
    }

    public static double round(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static HashMap<Integer, Double> vectorize(String line, HashMap<Integer, Double> v) {
        HashMap<Integer, Double> vector = new HashMap<Integer, Double>();
        int e_1 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
        line = line.substring(line.indexOf(" ") + 1);
        int e_2 = Integer.parseInt(line.substring(0, line.indexOf(" ")));
        line = line.substring(line.indexOf(" ") + 1);
        int e_3 = Integer.parseInt(line);
        vector.put(1, v.get(1) + (double)e_1);
        vector.put(2, v.get(2) + (double)e_2);
        vector.put(3, v.get(3) + (double)e_3);
        return vector;
    }
}

