/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking_global.GraphCreator;
import docking_global.PrepareData;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class DockingDistances {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String[] argos = new String[]{"yes", "10", "no", "0.6"};
        DockingDistances.doGraphCalculation(argos[0].equals("yes"), Integer.parseInt(argos[1]), argos[2].equals("yes"), Double.parseDouble(argos[3]));
    }

    public static void DistanceStats() {
        double cutoff = 1.0;
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        FileWriter fstream_pos = null;
        BufferedWriter out_pos = null;
        FileWriter fstream_neg = null;
        BufferedWriter out_neg = null;
        try {
            fstream_pos = new FileWriter(String.valueOf(userdir) + "/result_dump/global_maximization/distance_pos.txt");
            out_pos = new BufferedWriter(fstream_pos);
            fstream_neg = new FileWriter(String.valueOf(userdir) + "/result_dump/global_maximization/distance_neg.txt");
            out_neg = new BufferedWriter(fstream_neg);
            int prog = 0;
            for (String pdb_code : pdbs) {
                System.out.println("Doing pdb " + pdb_code + " " + ++prog + "/" + pdbs.size());
                String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
                HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_A.pdb", 'A');
                HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_B.pdb", 'A');
                double[][] cons = DockingDistances.extractCons(ab, ag);
                ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab, 2.0);
                ArrayList<Integer> ag_cons = DockingDistances.augmentBinding(ag, 5.0);
                System.out.println("Ab cons = " + ab_cons.size() + " out of " + ab.size());
                System.out.println("Ag cons = " + ag_cons.size() + " out of " + ag.size());
                double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
                double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
                for (Integer ab_i_1 : ab_cons) {
                    for (Integer ab_i_2 : ab_cons) {
                        if (ab_i_1 == ab_i_2) continue;
                        ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(ab_i_2));
                    }
                }
                for (Integer ag_i_1 : ag_cons) {
                    for (Integer ag_i_2 : ag_cons) {
                        if (ag_i_1 == ag_i_2) continue;
                        ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(ag_i_2));
                    }
                }
                System.out.println("Doing positive");
                ArrayList<Integer> ab_done = new ArrayList<Integer>();
                ArrayList ag_done = new ArrayList();
                for (Integer i : ab_cons) {
                    for (Integer j : ag_cons) {
                        if (cons[i][j] != 1.0) continue;
                        for (Integer i_other : ab_cons) {
                            if (i == i_other || ab_done.contains(i_other)) continue;
                            for (Integer j_other : ag_cons) {
                                if (j == j_other || ag_done.contains(j_other) || cons[i_other][j_other] != 1.0) continue;
                                out_pos.write(String.valueOf(ab_dists[i][i_other]) + " " + ag_dists[j][j_other] + "\n");
                            }
                        }
                    }
                    ab_done.add(i);
                }
                System.out.println("Doing negative");
                ab_done = new ArrayList();
                ag_done = new ArrayList();
                for (Integer i : ab_cons) {
                    for (Integer j : ag_cons) {
                        if (cons[i][j] == 1.0) continue;
                        for (Integer i_other : ab_cons) {
                            if (i == i_other || ab_done.contains(i_other)) continue;
                            for (Integer j_other : ag_cons) {
                                if (j == j_other || ag_done.contains(j_other) || cons[i_other][j_other] == 1.0) continue;
                                out_neg.write(String.valueOf(ab_dists[i][i_other]) + " " + ag_dists[j][j_other] + "\n");
                            }
                        }
                    }
                    ab_done.add(i);
                }
                System.out.println("Creating the graph");
                GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff, ab, ag, cons, ab_cons, ag_cons, ab_dists, ag_dists);
                System.out.println("Done with " + pdb_code);
            }
            out_neg.flush();
            fstream_neg.close();
            out_neg.close();
            out_pos.flush();
            fstream_pos.close();
            out_pos.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public static void doGraphCalculation(boolean random, int num_iterations, boolean pono, double cutoff_graph) {
        int depth = 3;
        ArrayList<String> output = new ArrayList<String>();
        if (!random) {
            num_iterations = 1;
        }
        ArrayList<String> pdbs = pono ? FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt") : FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double done = 0.0;
        double total = pdbs.size() * num_iterations;
        int iterations = 0;
        while (iterations < num_iterations) {
            int prog = 0;
            for (String pdb_code : pdbs) {
                HashMap<Integer, Residue> ag;
                HashMap<Integer, Residue> ab;
                String ag_folder;
                pdb_code = pdb_code.toUpperCase();
                double precision = 1.0;
                double overlap = 1.0;
                double perc = (done += 1.0) / total;
                ++prog;
                System.out.println("Doing pdb " + pdb_code + " iteration " + iterations + " " + perc + "%");
                if (pono) {
                    ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
                    ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
                    ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
                } else {
                    ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
                    ab = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
                    ag = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
                }
                double[][] cons = DockingDistances.extractCons(ab, ag);
                ArrayList<Integer> ab_cons = DockingDistances.augmentBinding(ab, 2.0);
                ArrayList<Integer> ag_cons = DockingDistances.augmentBinding(ag, 5.0);
                if (random) {
                    HashMap<Integer, Boolean> surface_exp = new HashMap();
                    if (pono) {
                        surface_exp = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb");
                    } else {
                        String pdb_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase() + "/AG.pdb";
                        HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
                        Iterator<Integer> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/surface_docking/" + pdb_code + ".txt");
                        ArrayList<Integer> surfs = new ArrayList<Integer>();
                        Iterator<Object> iterator = ((ArrayList)((Object)lines)).iterator();
                        while (iterator.hasNext()) {
                            String line = iterator.next();
                            surfs.add(Integer.parseInt(line));
                        }
                        for (Integer i : str.keySet()) {
                            if (surfs.contains(i)) {
                                surface_exp.put(i, true);
                                continue;
                            }
                            surface_exp.put(i, false);
                        }
                    }
                    PrepareData.Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, ag, depth, ag_cons, 4.5);
                    ag_cons = struc.epitope;
                    precision = struc.precision;
                    overlap = struc.overlap;
                }
                System.out.println("Ab cons = " + ab_cons.size() + " out of " + ab.size());
                System.out.println("Ag cons = " + ag_cons.size() + " out of " + ag.size());
                double[][] ab_dists = new double[ab.size() + 1][ab.size() + 1];
                double[][] ag_dists = new double[ag.size() + 1][ag.size() + 1];
                for (Integer ab_i_1 : ab_cons) {
                    for (Integer ab_i_2 : ab_cons) {
                        if (ab_i_1 == ab_i_2) continue;
                        ab_dists[ab_i_1.intValue()][ab_i_2.intValue()] = ab.get(ab_i_1).distanceFrom(ab.get(ab_i_2));
                    }
                }
                for (Integer ag_i_1 : ag_cons) {
                    for (Integer ag_i_2 : ag_cons) {
                        if (ag_i_1 == ag_i_2) continue;
                        ag_dists[ag_i_1.intValue()][ag_i_2.intValue()] = ag.get(ag_i_1).distanceFrom(ag.get(ag_i_2));
                    }
                }
                System.out.println("Creating the graph");
                GraphCreator.Graph_struc gs = GraphCreator.createGraph(null, cutoff_graph, ab, ag, cons, ab_cons, ag_cons, ab_dists, ag_dists);
                String out_line = String.valueOf(cutoff_graph) + " " + Math.round(precision / 0.33) + " " + Math.round(overlap / 0.33) + " " + gs.score_sum_deg + " " + gs.score_sum_deg / gs.num_vertices + " " + prog + " " + gs.score_sum_rd + " " + gs.score_sum_rd / gs.num_vertices + " " + ag.size();
                System.out.println(out_line);
                output.add(out_line);
                System.out.println("Done with " + pdb_code);
            }
            ++iterations;
        }
        if (random) {
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_maximization/graph_random.txt", output);
        } else {
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_maximization/graph_real.txt", output);
        }
    }

    public static ArrayList<Integer> augmentBinding(HashMap<Integer, Residue> str, double cut) {
        ArrayList<Integer> augmented = new ArrayList<Integer>();
        for (Integer i : str.keySet()) {
            if (!str.get((Object)i).isContact) continue;
            augmented.add(i);
            for (Integer j : str.keySet()) {
                if (str.get((Object)j).isContact || augmented.contains(j) || !(str.get(j).distanceFrom(str.get(i)) < cut)) continue;
                System.out.println("Adding " + j + " close to " + i);
                augmented.add(j);
            }
        }
        return augmented;
    }

    public static ArrayList<Integer> augmentCDR(HashMap<Integer, Residue> str, double cut) {
        ArrayList<Integer> augmented = new ArrayList<Integer>();
        for (Integer i : str.keySet()) {
            if (!str.get((Object)i).isCDR) continue;
            augmented.add(i);
            for (Integer j : str.keySet()) {
                if (str.get((Object)j).isCDR || augmented.contains(j) || !(str.get(j).distanceFrom(str.get(i)) < cut)) continue;
                augmented.add(j);
            }
        }
        return augmented;
    }

    public static double[][] extractCons(HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag) {
        double[][] cons = new double[ab.size() + 1][ag.size() + 1];
        for (Integer ab_i : ab.keySet()) {
            for (Integer ag_i : ag.keySet()) {
                if (!(ab.get(ab_i).distanceFrom(ag.get(ag_i)) < 4.5)) continue;
                ab.get((Object)ab_i).isContact = true;
                ag.get((Object)ag_i).isContact = true;
                cons[ab_i.intValue()][ag_i.intValue()] = 1.0;
            }
        }
        return cons;
    }

    public static void extractConsAbnum(HashMap<String, Residue> ab, HashMap<Integer, Residue> ag) {
        for (String ab_i : ab.keySet()) {
            for (Integer ag_i : ag.keySet()) {
                if (!(ab.get(ab_i).distanceFrom(ag.get(ag_i)) < 4.5)) continue;
                ab.get((Object)ab_i).isContact = true;
                ag.get((Object)ag_i).isContact = true;
            }
        }
    }
}

