/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking.BatchAnalyzer;
import docking.LikelihoodMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class PrepareData {
    private static final String userdir = System.getProperty("user.dir");
    private static final double[] max = PrepareData.MaxScore();

    public static void main(String[] args) {
    }

    public static void calculateRealScores() {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        ArrayList<Double> cutoffs = new ArrayList<Double>();
        cutoffs.add(4.0);
        cutoffs.add(5.0);
        cutoffs.add(6.0);
        cutoffs.add(7.0);
        cutoffs.add(8.0);
        for (String pdb_code : pdbs) {
            Iterator iterator = cutoffs.iterator();
            while (iterator.hasNext()) {
                double cutoff = (Double)iterator.next();
                PrepareData.RealScores(pdb_code.toUpperCase(), cutoff);
            }
        }
    }

    public static void calculateRealScoresPonom() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        ArrayList<Double> cutoffs = new ArrayList<Double>();
        cutoffs.add(4.0);
        cutoffs.add(5.0);
        cutoffs.add(6.0);
        cutoffs.add(7.0);
        cutoffs.add(8.0);
        int progress = 1;
        for (String pdb_code : pdbs) {
            System.out.println(String.valueOf(progress++) + "/101");
            Iterator iterator = cutoffs.iterator();
            while (iterator.hasNext()) {
                double cutoff = (Double)iterator.next();
                PrepareData.RealScoresPonom(pdb_code.toUpperCase(), cutoff);
            }
        }
    }

    public static void randomEpitopeStats() {
        String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        int total = 10000;
        int depth = 2;
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        ArrayList<Double> overlap = new ArrayList<Double>();
        ArrayList<Double> ratio = new ArrayList<Double>();
        int prog = 0;
        for (String pdb_code : pdbs) {
            ++prog;
            HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_A.pdb", 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_B.pdb", 'A');
            ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
            String pdb_file = String.valueOf(userdir) + "/protein_database/standard_pono/" + pdb_code.toUpperCase() + "_B.pdb";
            HashMap<Integer, Boolean> surface_exp = PSA.runPSA(7.5, pdb_file);
            HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
            int i = 0;
            while (i < total) {
                System.out.println(String.valueOf(prog) + "/101 " + pdb_code + " : " + i + "/" + total);
                Struct s = PrepareData.randomEpitopeStats(pdb_code, surface_exp, str, depth, ep);
                overlap.add(s.overlap);
                ratio.add(s.ratio);
                ++i;
            }
        }
        double overlap_m = MathFunctions.getMeanDouble(overlap);
        double ratio_m = MathFunctions.getMeanDouble(ratio);
        double overlap_s = MathFunctions.getStdDevDouble(overlap);
        double ratio_s = MathFunctions.getStdDevDouble(ratio);
        System.out.println("Depth = " + depth);
        System.out.println("Overlap m = " + overlap_m);
        System.out.println("Overlap s = " + overlap_s);
        System.out.println("Ratio m = " + ratio_m);
        System.out.println("Ratio s = " + ratio_s);
    }

    public static Struct randomEpitopeStats(String pdb_code, HashMap<Integer, Boolean> surface_exp, HashMap<Integer, Residue> str, int depth, ArrayList<Integer> real) {
        Random r = new Random();
        Integer first = r.nextInt(surface_exp.size()) + 1;
        while (!surface_exp.get(first).booleanValue()) {
            first = r.nextInt(surface_exp.size()) + 1;
        }
        ArrayList<Integer> epitope = new ArrayList<Integer>();
        epitope.add(first);
        while (depth > 0) {
            ArrayList<Integer> newlyadded = new ArrayList<Integer>();
            for (Integer epi_res : epitope) {
                for (Integer sur_res : surface_exp.keySet()) {
                    if (!surface_exp.get(sur_res).booleanValue() || sur_res == epi_res || epitope.contains(sur_res) || newlyadded.contains(sur_res) || !(str.get(epi_res).distanceFrom(str.get(sur_res)) < 4.5)) continue;
                    newlyadded.add(sur_res);
                }
            }
            epitope.addAll(newlyadded);
            --depth;
        }
        double overlap = 0.0;
        for (Integer i : epitope) {
            if (!real.contains(i)) continue;
            overlap += 1.0;
        }
        double ratio = (double)epitope.size() / (double)real.size();
        return new Struct(overlap /= (double)real.size(), ratio);
    }

    public static ArrayList<Integer> getRandomEpitope(String pdb_code) {
        pdb_code = pdb_code.toUpperCase();
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
        ArrayList<Integer> news = new ArrayList<Integer>();
        for (Integer neigh_i : ag.keySet()) {
            for (Integer ep_i : ep) {
                if (!(ag.get(neigh_i).distanceFrom(ag.get(ep_i)) < 4.5) || ep.contains(neigh_i) || news.contains(neigh_i)) continue;
                news.add(neigh_i);
            }
        }
        System.out.println("Augmented with " + news.size());
        String pdb_file = String.valueOf(userdir) + "/protein_database/standard_pono/" + pdb_code.toUpperCase() + "_B.pdb";
        HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
        HashMap<Integer, Boolean> surface_exp = PSA.runPSA(7.5, pdb_file);
        ArrayList<Integer> real_surf = new ArrayList<Integer>();
        for (Integer i : ep) {
            if (!surface_exp.get(i).booleanValue()) continue;
            real_surf.add(i);
        }
        ArrayList<Integer> epitope = PrepareData.randomEpitopeMinimal(pdb_code, surface_exp, str, 3, real_surf);
        return epitope;
    }

    public static int[] MaximizeEpitope(String pdb_code, int iterations, int iteration_id) {
        int depth = 2;
        double cutoff = 3.5;
        String out = "";
        pdb_code = pdb_code.toUpperCase();
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
        ArrayList<Integer> news = new ArrayList<Integer>();
        for (Integer neigh_i : ag.keySet()) {
            for (Integer ep_i : ep) {
                if (!(ag.get(neigh_i).distanceFrom(ag.get(ep_i)) < 4.5) || ep.contains(neigh_i) || news.contains(neigh_i)) continue;
                news.add(neigh_i);
            }
        }
        String pdb_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase() + "/AG.pdb";
        HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
        HashMap<Integer, Boolean> surface_exp = new HashMap<Integer, Boolean>();
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/surface_docking/" + pdb_code + ".txt");
        ArrayList<Integer> surfs = new ArrayList<Integer>();
        for (String line : lines) {
            surfs.add(Integer.parseInt(line));
        }
        for (Integer i : str.keySet()) {
            if (surfs.contains(i)) {
                surface_exp.put(i, true);
                continue;
            }
            surface_exp.put(i, false);
        }
        ArrayList<Integer> real_surf = new ArrayList<Integer>();
        for (Integer i : ep) {
            if (!((Boolean)surface_exp.get(i)).booleanValue()) continue;
            real_surf.add(i);
        }
        while (iterations > 0) {
            System.out.println(String.valueOf(pdb_code) + " : " + --iterations);
            Struct_maximization struc = PrepareData.randomEpitope(pdb_code, surface_exp, str, depth, real_surf, cutoff);
            ArrayList<Integer> epitope = struc.epitope;
            int[] res_counts = new int[20];
            for (Integer i : epitope) {
                int n = ag.get((Object)i).type.ordinal();
                res_counts[n] = res_counts[n] + 1;
            }
            double score = PrepareData.calculateMax_score(res_counts);
            out = String.valueOf(out) + score + " " + struc.overlap + " " + struc.ratio + " " + struc.precision + " " + surface_exp.size() + " " + epitope.size() + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_maximization/" + pdb_code + iteration_id + ".txt", out);
        return null;
    }

    public static double RealScoresPonom(String pdb_code, double cutoff) {
        pdb_code = pdb_code.toUpperCase();
        String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_A.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code + "_B.pdb", 'A');
        ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
        ArrayList<Integer> news = new ArrayList<Integer>();
        for (Integer neigh_i : ag.keySet()) {
            for (Integer ep_i : ep) {
                if (!(ag.get(neigh_i).distanceFrom(ag.get(ep_i)) < 4.5) || ep.contains(neigh_i) || news.contains(neigh_i)) continue;
                news.add(neigh_i);
            }
        }
        String pdb_file = String.valueOf(userdir) + "/protein_database/standard_pono/" + pdb_code.toUpperCase() + "_B.pdb";
        HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
        HashMap<Integer, Boolean> surface_exp = PSA.runPSA(7.5, pdb_file);
        String out_surf = "";
        for (Integer i : surface_exp.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            out_surf = String.valueOf(out_surf) + i + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/surface_docking/" + pdb_code + ".txt", out_surf);
        ArrayList<Integer> surface_exposed_only = new ArrayList<Integer>();
        for (Integer i : surface_exp.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            surface_exposed_only.add(i);
        }
        ArrayList<Integer> real_surf = new ArrayList<Integer>();
        for (Integer i : ep) {
            if (!surface_exp.get(i).booleanValue()) continue;
            real_surf.add(i);
        }
        System.out.println(String.valueOf(pdb_code) + " : " + cutoff);
        ArrayList<Integer> epitope = PrepareData.AugmentEpitope(cutoff, real_surf, surface_exposed_only, ag);
        int[] res_counts = new int[20];
        for (Integer i : epitope) {
            int n = ag.get((Object)i).type.ordinal();
            res_counts[n] = res_counts[n] + 1;
        }
        double score = PrepareData.calculateMax_score(res_counts);
        String out = String.valueOf(score) + " " + epitope.size() + " " + surface_exposed_only.size();
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_maximization/real_scores/" + pdb_code.toUpperCase() + "_" + cutoff + ".txt", out);
        return score;
    }

    public static double RealScores(String pdb_code, double cutoff) {
        pdb_code = pdb_code.toUpperCase();
        String ag_folder = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase();
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(ag_folder) + "/AB.pdb", 'A');
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(ag_folder) + "/AG.pdb", 'A');
        ArrayList<Integer> ep = LikelihoodMatrix.getContactsAg(ab, ag);
        ArrayList<Integer> news = new ArrayList<Integer>();
        for (Integer neigh_i : ag.keySet()) {
            for (Integer ep_i : ep) {
                if (!(ag.get(neigh_i).distanceFrom(ag.get(ep_i)) < 4.5) || ep.contains(neigh_i) || news.contains(neigh_i)) continue;
                news.add(neigh_i);
            }
        }
        String pdb_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb_code.toLowerCase() + "/AG.pdb";
        HashMap<Integer, Residue> str = PDB_parser.parse(pdb_file, 'A');
        HashMap<Integer, Boolean> surface_exp = PSA.runPSA(7.5, pdb_file);
        String out_surf = "";
        for (Integer i : surface_exp.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            out_surf = String.valueOf(out_surf) + i + "\n";
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/surface_docking/" + pdb_code + ".txt", out_surf);
        ArrayList<Integer> surface_exposed_only = new ArrayList<Integer>();
        for (Integer i : surface_exp.keySet()) {
            if (!surface_exp.get(i).booleanValue()) continue;
            surface_exposed_only.add(i);
        }
        ArrayList<Integer> real_surf = new ArrayList<Integer>();
        for (Integer i : ep) {
            if (!surface_exp.get(i).booleanValue()) continue;
            real_surf.add(i);
        }
        System.out.println(String.valueOf(pdb_code) + " : " + cutoff);
        ArrayList<Integer> epitope = PrepareData.AugmentEpitope(cutoff, real_surf, surface_exposed_only, ag);
        int[] res_counts = new int[20];
        for (Integer i : epitope) {
            int n = ag.get((Object)i).type.ordinal();
            res_counts[n] = res_counts[n] + 1;
        }
        double score = PrepareData.calculateMax_score(res_counts);
        String out = String.valueOf(score) + " " + epitope.size() + " " + surface_exposed_only.size();
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_maximization/real_scores/" + pdb_code.toUpperCase() + "_" + cutoff + ".txt", out);
        return score;
    }

    public static ArrayList<Integer> AugmentEpitope(double cutoff, ArrayList<Integer> ep, ArrayList<Integer> all, HashMap<Integer, Residue> ag) {
        ArrayList<Integer> augmented = new ArrayList<Integer>();
        block0: for (Integer i : all) {
            if (ep.contains(i) || augmented.contains(i)) continue;
            for (Integer ep_i : ep) {
                if (!(ag.get(i).distanceFrom(ag.get(ep_i)) < cutoff)) continue;
                augmented.add(i);
                continue block0;
            }
        }
        return augmented;
    }

    public static double calculateMax_score(int[] res) {
        double score = 0.0;
        int i = 0;
        while (i < 20) {
            score += (double)res[i] * max[i];
            ++i;
        }
        return score;
    }

    public static double[] MaxScore() {
        double[][] prop_mat = BatchAnalyzer.getLikelihood();
        double[] maximal = new double[20];
        int ag_i = 0;
        while (ag_i < 20) {
            double max = 0.0;
            int ab_i = 0;
            while (ab_i < 20) {
                if (prop_mat[ab_i][ag_i] > max) {
                    max = prop_mat[ab_i][ag_i];
                }
                ++ab_i;
            }
            maximal[ag_i] = max;
            ++ag_i;
        }
        return maximal;
    }

    public static ArrayList<Integer> randomEpitopeMaximal(String pdb_code, HashMap<Integer, Boolean> surface_exp, HashMap<Integer, Residue> str, int depth, ArrayList<Integer> real) {
        int iter_limit = 100;
        int iterations = 0;
        int orig_depth = depth;
        double max_precision = 0.0;
        double max_overlap = 0.0;
        ArrayList<Integer> max_epi = new ArrayList<Integer>();
        while (iterations < iter_limit) {
            System.out.println(String.valueOf(pdb_code) + " " + ++iterations + "/" + iter_limit + " " + max_overlap);
            Random r = new Random();
            double overlap = 0.0;
            double limit = 0.01;
            ArrayList<Integer> epitope = new ArrayList<Integer>();
            while (overlap <= limit) {
                depth = orig_depth;
                Integer first = r.nextInt(surface_exp.size()) + 1;
                while (!surface_exp.get(first).booleanValue()) {
                    first = r.nextInt(surface_exp.size()) + 1;
                }
                epitope.add(first);
                while (depth > 0) {
                    ArrayList<Integer> newlyadded = new ArrayList<Integer>();
                    for (Integer epi_res : epitope) {
                        for (Integer sur_res : surface_exp.keySet()) {
                            if (!surface_exp.get(sur_res).booleanValue() || sur_res == epi_res || epitope.contains(sur_res) || newlyadded.contains(sur_res) || !(str.get(epi_res).distanceFrom(str.get(sur_res)) < 4.5)) continue;
                            newlyadded.add(sur_res);
                        }
                    }
                    epitope.addAll(newlyadded);
                    --depth;
                }
                overlap = 0.0;
                for (Integer i : epitope) {
                    if (!real.contains(i)) continue;
                    overlap += 1.0;
                }
                double precision = overlap / (double)epitope.size();
                double ratio = (double)epitope.size() / (double)real.size();
                if ((overlap /= (double)real.size()) < limit || epitope.size() < 10) {
                    overlap = 0.0;
                    epitope = new ArrayList();
                    continue;
                }
                if (!(max_overlap < overlap)) continue;
                max_epi = epitope;
                max_overlap = overlap;
                max_precision = precision;
            }
        }
        FileSystemTools.append("dock_log.txt", userdir, String.valueOf(pdb_code) + " " + max_overlap + " " + max_epi.size() + " " + max_precision + "\n");
        return max_epi;
    }

    public static Struct_maximization randomEpitopeSeeded(int first, String pdb_code, HashMap<Integer, Boolean> surface_exp, HashMap<Integer, Residue> str, int depth, ArrayList<Integer> real, double cutoff) {
        int orig_depth = depth;
        double overlap = 0.0;
        ArrayList<Integer> epitope = new ArrayList<Integer>();
        depth = orig_depth;
        epitope.add(first);
        while (depth > 0) {
            ArrayList<Integer> newlyadded = new ArrayList<Integer>();
            for (Integer epi_res : epitope) {
                for (Integer sur_res : surface_exp.keySet()) {
                    if (!surface_exp.get(sur_res).booleanValue() || sur_res == epi_res || epitope.contains(sur_res) || newlyadded.contains(sur_res) || !(str.get(epi_res).distanceFrom(str.get(sur_res)) < cutoff)) continue;
                    newlyadded.add(sur_res);
                }
            }
            epitope.addAll(newlyadded);
            --depth;
        }
        double precision = overlap / (double)epitope.size();
        double ratio = (double)epitope.size() / (double)real.size();
        return new Struct_maximization(overlap /= (double)real.size(), ratio, epitope, precision);
    }

    public static Struct_maximization randomEpitope(String pdb_code, HashMap<Integer, Boolean> surface_exp, HashMap<Integer, Residue> str, int depth, ArrayList<Integer> real, double cutoff) {
        double ratio;
        double precision;
        int orig_depth = depth;
        Random r = new Random();
        double overlap = 0.0;
        ArrayList<Integer> epitope = new ArrayList<Integer>();
        while (true) {
            depth = orig_depth;
            Integer first = r.nextInt(surface_exp.size()) + 1;
            while (!surface_exp.get(first).booleanValue()) {
                first = r.nextInt(surface_exp.size()) + 1;
            }
            epitope.add(first);
            while (depth > 0) {
                ArrayList<Integer> newlyadded = new ArrayList<Integer>();
                for (Integer epi_res : epitope) {
                    for (Integer sur_res : surface_exp.keySet()) {
                        if (!surface_exp.get(sur_res).booleanValue() || sur_res == epi_res || epitope.contains(sur_res) || newlyadded.contains(sur_res) || !(str.get(epi_res).distanceFrom(str.get(sur_res)) < cutoff)) continue;
                        newlyadded.add(sur_res);
                    }
                }
                epitope.addAll(newlyadded);
                --depth;
            }
            overlap = 0.0;
            for (Integer i : epitope) {
                if (!real.contains(i)) continue;
                overlap += 1.0;
            }
            precision = overlap / (double)epitope.size();
            overlap /= (double)real.size();
            ratio = (double)epitope.size() / (double)real.size();
            if (epitope.size() >= 10) break;
            overlap = 0.0;
            epitope = new ArrayList();
        }
        return new Struct_maximization(overlap, ratio, epitope, precision);
    }

    public static ArrayList<Integer> randomEpitopeMinimal(String pdb_code, HashMap<Integer, Boolean> surface_exp, HashMap<Integer, Residue> str, int depth, ArrayList<Integer> real) {
        int iter_limit = 10;
        int iterations = 0;
        int orig_depth = depth;
        double max_overlap = 1.0;
        ArrayList<Integer> max_epi = new ArrayList<Integer>();
        while (iterations < iter_limit) {
            System.out.println(String.valueOf(pdb_code) + " " + ++iterations + "/" + iter_limit + " " + max_overlap);
            Random r = new Random();
            double overlap = 1.0;
            double limit = 0.1;
            ArrayList<Integer> epitope = new ArrayList<Integer>();
            while (overlap > limit) {
                depth = orig_depth;
                Integer first = r.nextInt(surface_exp.size()) + 1;
                while (!surface_exp.get(first).booleanValue()) {
                    first = r.nextInt(surface_exp.size()) + 1;
                }
                epitope.add(first);
                while (depth > 0) {
                    ArrayList<Integer> newlyadded = new ArrayList<Integer>();
                    for (Integer epi_res : epitope) {
                        for (Integer sur_res : surface_exp.keySet()) {
                            if (!surface_exp.get(sur_res).booleanValue() || sur_res == epi_res || epitope.contains(sur_res) || newlyadded.contains(sur_res) || !(str.get(epi_res).distanceFrom(str.get(sur_res)) < 4.5)) continue;
                            newlyadded.add(sur_res);
                        }
                    }
                    epitope.addAll(newlyadded);
                    --depth;
                }
                overlap = 0.0;
                for (Integer i : epitope) {
                    if (!real.contains(i)) continue;
                    overlap += 1.0;
                }
                double ratio = (double)epitope.size() / (double)real.size();
                if ((overlap /= (double)real.size()) > limit || epitope.size() < 10) {
                    overlap = 1.0;
                    epitope = new ArrayList();
                    continue;
                }
                if (!(max_overlap > overlap)) continue;
                max_epi = epitope;
                max_overlap = overlap;
            }
        }
        FileSystemTools.append("dock_log.txt", userdir, String.valueOf(pdb_code) + " " + max_overlap + " " + max_epi.size() + "\n");
        return max_epi;
    }

    public static class Struct {
        public final double overlap;
        public final double ratio;

        public Struct(double o, double r) {
            this.overlap = o;
            this.ratio = r;
        }
    }

    public static class Struct_maximization {
        public final double overlap;
        public final double ratio;
        public final double precision;
        public ArrayList<Integer> correct_epitope;
        public double score;
        int small_size;
        public ArrayList<Integer> correct;
        public double ag_size;
        public final ArrayList<Integer> epitope;

        public Struct_maximization(double o, double r, ArrayList<Integer> epi, double prec) {
            this.overlap = o;
            this.ratio = r;
            this.epitope = epi;
            this.precision = prec;
        }
    }
}

