/*
 * Decompiled with CFR 0.152.
 */
package for_terry;

import for_terry.DBStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import utils.WebTools;

public class Abysis {
    public static void main(String[] args) {
        Abysis_rec ar = Abysis.readChainRec("1AHW_A");
        HashMap<Integer, String> annot = ar.chothia_annot;
        for (Integer i : annot.keySet()) {
            System.out.println(i + " : " + annot.get(i));
        }
    }

    public static Abysis_AB createRecord(String pdb) {
        HashMap<String, DBStats.PDB_record> map = DBStats.getLHMapping();
        char heavy = map.get((Object)pdb).H;
        char light = map.get((Object)pdb).L;
        Abysis_rec heavy_r = null;
        Abysis_rec light_r = null;
        if (heavy != '0') {
            heavy_r = Abysis.readChainRec(String.valueOf(pdb.toLowerCase()) + "_" + heavy);
        }
        if (light != '0') {
            light_r = Abysis.readChainRec(String.valueOf(pdb.toLowerCase()) + "_" + light);
        }
        Abysis_AB rec = new Abysis_AB(heavy_r, light_r);
        return rec;
    }

    public static Abysis_rec readChainRec(String acc_code) {
        HashMap<Integer, String> AAs = new HashMap<Integer, String>();
        HashMap<Integer, String> chothia_num = new HashMap<Integer, String>();
        HashMap<Integer, String> kabat_num = new HashMap<Integer, String>();
        HashMap<Integer, String> kabat_annot = new HashMap<Integer, String>();
        HashMap<Integer, String> chothia_annot = new HashMap<Integer, String>();
        HashMap<Integer, String> contact_annot = new HashMap<Integer, String>();
        HashMap<Integer, String> abm_annot = new HashMap<Integer, String>();
        String url = "http://www.bioinf.org.uk/abysis/sequences/run_search.cgi?ab_name_or_accession=" + acc_code + "&complete=true";
        ArrayList<String> lines = WebTools.readWebPage(url);
        int AA_i = 1;
        int chothia_num_i = 1;
        int kabat_num_i = 1;
        int kabat_annot_i = 1;
        int chothia_annot_i = 1;
        int contact_annot_i = 1;
        int abm_annot_i = 1;
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.contains("<td class='seq_display'><a")) {
                char AA = line.charAt(line.indexOf("</a></td>") - 1);
                AAs.put(AA_i++, String.valueOf(AA));
            }
            if (line.contains("<tr><th class='seq_res'>Chothia</th>")) {
                while (line.contains("<td class='seq_display'>")) {
                    String num = line.substring(line.indexOf("<td class='seq_display'>") + "<td class='seq_display'>".length(), line.indexOf("</td>"));
                    chothia_num.put(chothia_num_i++, num);
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            if (line.contains("<tr><th class='seq_res'>Kabat</th>")) {
                while (line.contains("<td class='seq_display'>")) {
                    String num = line.substring(line.indexOf("<td class='seq_display'>") + "<td class='seq_display'>".length(), line.indexOf("</td>"));
                    kabat_num.put(kabat_num_i++, num);
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            if (line.contains("<th class='seq_res'>kabat</th>")) {
                line = lines.get(++i);
                while (line.contains("</td>")) {
                    String culprit = line.substring(0, line.indexOf("</td>"));
                    if (culprit.contains("<td class='framework'>")) {
                        kabat_annot.put(kabat_annot_i++, "F");
                    } else if (culprit.contains("<td class='loop'>")) {
                        kabat_annot.put(kabat_annot_i++, "C");
                    } else {
                        kabat_annot.put(kabat_annot_i++, "D");
                    }
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            if (line.contains("<th class='seq_res'>chothia</th>")) {
                line = lines.get(++i);
                while (line.contains("</td>")) {
                    String culprit = line.substring(0, line.indexOf("</td>"));
                    if (culprit.contains("<td class='framework'>")) {
                        chothia_annot.put(chothia_annot_i++, "F");
                    } else if (culprit.contains("<td class='loop'>")) {
                        chothia_annot.put(chothia_annot_i++, "C");
                    } else {
                        chothia_annot.put(chothia_annot_i++, "D");
                    }
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            if (line.contains("<th class='seq_res'>contact</th>")) {
                line = lines.get(++i);
                while (line.contains("</td>")) {
                    String culprit = line.substring(0, line.indexOf("</td>"));
                    if (culprit.contains("<td class='framework'>")) {
                        contact_annot.put(contact_annot_i++, "F");
                    } else if (culprit.contains("<td class='loop'>")) {
                        contact_annot.put(contact_annot_i++, "C");
                    } else {
                        contact_annot.put(contact_annot_i++, "D");
                    }
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            if (line.contains("<th class='seq_res'>abm</th>")) {
                line = lines.get(++i);
                while (line.contains("</td>")) {
                    String culprit = line.substring(0, line.indexOf("</td>"));
                    if (culprit.contains("<td class='framework'>")) {
                        abm_annot.put(abm_annot_i++, "F");
                    } else if (culprit.contains("<td class='loop'>")) {
                        abm_annot.put(abm_annot_i++, "C");
                    } else {
                        abm_annot.put(abm_annot_i++, "D");
                    }
                    line = line.substring(line.indexOf("</td>") + 5);
                }
            }
            ++i;
        }
        Abysis_rec rec = new Abysis_rec(AAs, kabat_num, chothia_num, kabat_annot, chothia_annot, abm_annot, contact_annot);
        return rec;
    }

    public static class Abysis_AB {
        public final Abysis_rec light;
        public final Abysis_rec heavy;

        public Abysis_AB(Abysis_rec _h, Abysis_rec _l) {
            this.light = _l;
            this.heavy = _h;
        }
    }

    public static class Abysis_rec {
        public final HashMap<Integer, String> AAs;
        public final HashMap<Integer, String> kabat_num;
        public final HashMap<Integer, String> chothia_num;
        public final HashMap<Integer, String> chothia_annot;
        public final HashMap<Integer, String> kabat_annot;
        public final HashMap<Integer, String> contact_annot;
        public final HashMap<Integer, String> abm_annot;
        public final HashMap<String, String> cdr_ch;
        public final HashMap<String, String> cdr_kabat;
        public final HashMap<String, String> cdr_abm;
        public final HashMap<String, String> cdr_contact;

        public Abysis_rec(HashMap<Integer, String> _AAs, HashMap<Integer, String> kn, HashMap<Integer, String> cn, HashMap<Integer, String> ka, HashMap<Integer, String> ca, HashMap<Integer, String> aba, HashMap<Integer, String> contact_a) {
            this.AAs = _AAs;
            this.kabat_num = kn;
            this.chothia_num = cn;
            this.chothia_annot = ca;
            this.kabat_annot = ka;
            this.contact_annot = contact_a;
            this.abm_annot = aba;
            TreeSet<Integer> ts = new TreeSet<Integer>();
            for (Integer i : this.chothia_annot.keySet()) {
                ts.add(i);
            }
            this.cdr_ch = this.do_cdrs(this.chothia_annot, ts);
            this.cdr_kabat = this.do_cdrs(this.kabat_annot, ts);
            this.cdr_abm = this.do_cdrs(this.abm_annot, ts);
            this.cdr_contact = this.do_cdrs(this.contact_annot, ts);
        }

        public HashMap<String, String> do_cdrs(HashMap<Integer, String> annot, TreeSet<Integer> ts) {
            HashMap<String, String> cdrs = new HashMap<String, String>();
            int cdr_num = 0;
            String cdr = "";
            for (Integer i : ts) {
                if (!annot.get(i).equals("C")) continue;
                if (annot.get(i - 1).equals("F")) {
                    if (cdr_num != 0) {
                        cdrs.put("CDR" + cdr_num, cdr);
                        cdr = "";
                    }
                    ++cdr_num;
                    cdr = String.valueOf(cdr) + this.AAs.get(i);
                    continue;
                }
                cdr = String.valueOf(cdr) + this.AAs.get(i);
            }
            cdrs.put("CDR3", cdr);
            return cdrs;
        }
    }
}

