/*
 * Decompiled with CFR 0.152.
 */
package lite_score_calculators;

import data_structures.Gap_function;
import data_structures.MSA;
import data_structures.Residue_classification;
import data_structures.Residue_combinations;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import lite_score_calculators.Lite_TPro_calculator;

public class Lite_Score_calculator {
    public final SC_Structure structure_A;
    public final SC_Structure structure_B;
    private double[][] w_intraA;
    private double[][] w_intraB;

    public Lite_Score_calculator(MSA _msa, Gap_function g, SC_Structure strA, SC_Structure strB) {
        this.structure_A = strA;
        this.structure_B = strB;
        this.Calculate_w_intra(strA, strB);
        Lite_TPro_calculator.calculate_TPro(strA, strB, this.w_intraA, g, true);
        Lite_TPro_calculator.calculate_TPro(strB, strA, this.w_intraB, g, false);
    }

    private void Calculate_w_intra(SC_Structure str1, SC_Structure str2) {
        Residue_classification classit;
        Residue_classification classi;
        int it;
        Residue_type[] arr_A = str1.to_array();
        Residue_type[] arr_B = str2.to_array();
        this.w_intraA = new double[arr_A.length][arr_A.length];
        int i = 0;
        while (i < arr_A.length) {
            it = 0;
            while (it < arr_A.length) {
                if (i != it) {
                    classi = arr_A[i].classification;
                    classit = arr_A[it].classification;
                    double[] dArray = this.w_intraA[i];
                    int n = it;
                    dArray[n] = dArray[n] + Residue_combinations.intra_weight_lookup[classi.ordinal()][classit.ordinal()];
                }
                ++it;
            }
            ++i;
        }
        this.w_intraB = new double[arr_B.length][arr_B.length];
        i = 0;
        while (i < arr_B.length) {
            it = 0;
            while (it < arr_B.length) {
                if (i != it) {
                    classi = arr_B[i].classification;
                    classit = arr_B[it].classification;
                    double[] dArray = this.w_intraB[i];
                    int n = it;
                    dArray[n] = dArray[n] + Residue_combinations.intra_weight_lookup[classi.ordinal()][classit.ordinal()];
                }
                ++it;
            }
            ++i;
        }
    }
}

