/*
 * Decompiled with CFR 0.152.
 */
package lite_score_calculators;

import data_structures.Gap_function;
import data_structures.Residue;
import data_structures.Residue_combinations;
import data_structures.SC_Structure;
import java.util.HashMap;

public class Lite_TPro_calculator {
    public static void calculate_TPro(SC_Structure struc, SC_Structure struc_other, double[][] w_intra, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = Lite_TPro_calculator.getSis(struc, struc_other);
        for (Integer i : struc.residues.keySet()) {
            Residue res_central = struc.residues.get(i);
            double sum = 0.0;
            for (Residue res_inpatch : res_central.getPatch().patch_residues) {
                sum += w_intra[res_central.in_array][res_inpatch.in_array] * Sis.get(res_inpatch.in_array);
            }
            if (res_central.getPatch().patch_residues.size() == 0) continue;
            res_central.setTPro(sum / (double)res_central.getPatch().patch_residues.size());
        }
    }

    public static HashMap<Integer, Double> getSis(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Double> Sis = new HashMap<Integer, Double>();
        for (Integer i : s1.residues.keySet()) {
            Residue outer_res = s1.residues.get(i);
            double single_sum = 0.0;
            for (Integer k : s2.residues.keySet()) {
                double mul_tmp;
                Residue inner_res = s2.residues.get(k);
                double patch_sum = 0.0;
                for (Residue in_patch : outer_res.getPatch().patch_residues) {
                    mul_tmp = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[outer_res.type.classification.ordinal()][inner_res.type.classification.ordinal()].ordinal()][in_patch.type.classification.ordinal()];
                    patch_sum += mul_tmp * Residue_combinations.triangle_lookup[outer_res.type.classification.ordinal()][inner_res.type.classification.ordinal()][in_patch.type.classification.ordinal()];
                }
                for (Residue in_patch : inner_res.getPatch().patch_residues) {
                    mul_tmp = Residue_combinations.intra_pair_lookup[Residue_combinations.pair_lookup[outer_res.type.classification.ordinal()][inner_res.type.classification.ordinal()].ordinal()][in_patch.type.classification.ordinal()];
                    patch_sum += mul_tmp * Residue_combinations.triangle_lookup[outer_res.type.classification.ordinal()][inner_res.type.classification.ordinal()][in_patch.type.classification.ordinal()];
                }
                single_sum += (patch_sum /= (double)(outer_res.getPatch().patch_residues.size() + inner_res.getPatch().patch_residues.size()));
            }
            Sis.put(outer_res.in_array, single_sum /= (double)s2.residues.size());
        }
        return Sis;
    }
}

