/*
 * Decompiled with CFR 0.152.
 */
package parsing;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.Residue_type;
import data_structures.SC_Structure;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import utils.FileSystemTools;

public class PDB_parser {
    public static void main(String[] args) {
        String original = String.valueOf(System.getProperty("user.dir")) + "/protein_database/raw_files/1KB5.pdb";
        String temp = String.valueOf(System.getProperty("user.dir")) + "/temp_dump/test.txt";
        PDB_parser.writeConstrainingPDB(original, temp, 'A', 'B');
    }

    public static HashMap<Integer, Residue> parse(String pdb_file, ArrayList<Integer> roi, char chain) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            Residue res;
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            int curr_id = -1;
            int seq_id = -1;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            char lastchar = ' ';
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                typ = Residue_type.mapResidue(s.substring(17, 20));
                lastchar = s.charAt(21);
                if (curr_id != seq_id && curr_id != -1) {
                    if (s.charAt(21) == chain && (roi == null || roi != null && roi.contains(curr_id))) {
                        res = new Residue(curr_typ, curr_residue, curr_id);
                        residues.put(curr_id, res);
                    }
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            if (lastchar == chain && (roi == null || roi != null && roi.contains(curr_id))) {
                res = new Residue(curr_typ, curr_residue, curr_id);
                residues.put(curr_id, res);
            }
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static HashMap<Integer, Residue> parseBySeqs(String pdb_file) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            int curr_id = -1;
            int seq_id = -1;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            int lastchar = 32;
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                String sid = s.substring(22, 26).replace(" ", "");
                sid = sid.replace("A", "");
                sid = sid.replace("B", "");
                sid = sid.replace("C", "");
                sid = sid.replace("D", "");
                seq_id = Integer.parseInt(sid);
                typ = Residue_type.mapResidue(s.substring(17, 20));
                lastchar = s.charAt(21);
                if (curr_id != seq_id && curr_id != -1) {
                    Residue res = new Residue(curr_typ, curr_residue, seq_id);
                    residues.put(seq_id, res);
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            Residue res = new Residue(curr_typ, curr_residue, seq_id);
            residues.put(seq_id, res);
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static HashMap<Integer, Residue> parse(String pdb_file) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            int curr_id = -1;
            int seq_id = -1;
            int ordinal = 1;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            int lastchar = 32;
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                String sid = s.substring(22, 26).replace(" ", "");
                sid = sid.replace("A", "");
                sid = sid.replace("B", "");
                sid = sid.replace("C", "");
                sid = sid.replace("D", "");
                seq_id = Integer.parseInt(sid);
                typ = Residue_type.mapResidue(s.substring(17, 20));
                lastchar = s.charAt(21);
                if (curr_id != seq_id && curr_id != -1) {
                    Residue res = new Residue(curr_typ, curr_residue, ordinal);
                    residues.put(ordinal, res);
                    ++ordinal;
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            Residue res = new Residue(curr_typ, curr_residue, ordinal);
            residues.put(ordinal, res);
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static HashMap<Character, SC_Structure> parseByChain(String pdb_file) {
        HashMap<Character, SC_Structure> return_map = new HashMap<Character, SC_Structure>();
        String chains = PDB_parser.getChains(pdb_file);
        int i = 0;
        while (i < chains.length()) {
            HashMap<Integer, Residue> mapping = PDB_parser.parse(pdb_file, chains.charAt(i));
            SC_Structure str = new SC_Structure(mapping, chains.charAt(i), pdb_file);
            return_map.put(Character.valueOf(chains.charAt(i)), str);
            ++i;
        }
        return return_map;
    }

    public static HashMap<Integer, Residue> parseAB(String pdb_file, char chain) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            Residue res;
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            int curr_id = -1;
            int seq_id = -1;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            char curr_chain = ' ';
            boolean curr_ab = false;
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                typ = Residue_type.mapResidue(s.substring(17, 20), pdb_file);
                curr_chain = s.charAt(21);
                if (curr_chain == chain) {
                    curr_ab = true;
                }
                if (curr_chain != chain && curr_chain != 'C' && curr_chain != 'R') {
                    curr_ab = false;
                }
                if (curr_id != seq_id && curr_id != -1 && curr_ab) {
                    res = new Residue(curr_typ, curr_residue, curr_id);
                    residues.put(curr_id, res);
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            if (curr_ab) {
                res = new Residue(curr_typ, curr_residue, curr_id);
                residues.put(curr_id, res);
            }
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static HashMap<Integer, Residue> parseString(String pdb_file, char chain) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            Residue res;
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            String curr_id = "";
            int ordinal = 1;
            String seq_id = "";
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            char curr_chain = ' ';
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM") || (curr_chain = (char)s.charAt(21)) != chain) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                seq_id = s.substring(22, 27).replace(" ", "");
                typ = Residue_type.mapResidue(s.substring(17, 20), pdb_file);
                if (!curr_id.equals(seq_id) && curr_id.length() != 0) {
                    res = new Residue(curr_typ, curr_residue, ordinal);
                    residues.put(ordinal, res);
                    ++ordinal;
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            res = new Residue(curr_typ, curr_residue, ordinal);
            residues.put(ordinal, res);
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static HashMap<Integer, Residue> parse(String pdb_file, char chain) {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            Residue res;
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            String curr_id = "";
            int ordinal = 1;
            String seq_id = null;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            char curr_chain = ' ';
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM") || (curr_chain = (char)s.charAt(21)) != chain) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                seq_id = s.substring(22, 27).replace(" ", "");
                typ = Residue_type.mapResidue(s.substring(17, 20), pdb_file);
                if (!curr_id.equals(seq_id) && !curr_id.equals("")) {
                    res = new Residue(curr_typ, curr_residue, ordinal);
                    residues.put(ordinal, res);
                    ++ordinal;
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            res = new Residue(curr_typ, curr_residue, ordinal);
            residues.put(ordinal, res);
            curr_residue = new ArrayList();
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return residues;
    }

    public static String getChains(String pdb_file) {
        String result = "";
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(pdb_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            char chains = ' ';
            while ((s = dis.readLine()) != null) {
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                if (chains == ' ') {
                    chains = s.charAt(21);
                    result = String.valueOf(result) + chains;
                    continue;
                }
                if (chains == s.charAt(21)) continue;
                chains = s.charAt(21);
                result = String.valueOf(result) + chains;
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void writeConstrainingPDB(String pdb_file_source, String pdb_file_out, char heavy, char light) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            String seq_id = "";
            int i = 0;
            char curr_chain = 'P';
            String curr_seq = "";
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                seq_id = s.substring(22, 27).replace(" ", "");
                if (curr_chain != s.charAt(21)) {
                    i = 0;
                    curr_chain = s.charAt(21);
                }
                if (!curr_seq.equals(seq_id)) {
                    curr_seq = seq_id;
                    ++i;
                }
                String id = String.valueOf(i);
                while (id.length() < 4) {
                    id = " " + id;
                }
                if ((s = String.valueOf(s.substring(0, 22)) + id + " " + s.substring(27)).charAt(21) == heavy) {
                    out.write(String.valueOf(PDB_parser.renameChain(s, 'H')) + "\n");
                }
                if (s.charAt(21) != light) continue;
                out.write(String.valueOf(PDB_parser.renameChain(s, 'L')) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static String getSequenceFromPDB(String pdb_file, char chain) {
        HashMap<Integer, Residue> residues = PDB_parser.parse(pdb_file, chain);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : residues.keySet()) {
            sorted.add(i);
        }
        Residue_type[] types = new Residue_type[5000];
        String result = "";
        int i = 0;
        while (i < 5000) {
            types[i] = sorted.contains(i) ? residues.get((Object)Integer.valueOf((int)i)).type : Residue_type.gap;
            ++i;
        }
        i = 0;
        while (i < 5000) {
            result = String.valueOf(result) + (Object)((Object)types[i]);
            ++i;
        }
        if (sorted.size() == 0) {
            return null;
        }
        return result;
    }

    public static Residue_type[] getSeqFromPDB(String pdb_file, char chain) {
        HashMap<Integer, Residue> residues = PDB_parser.parse(pdb_file, chain);
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : residues.keySet()) {
            sorted.add(i);
        }
        Residue_type[] types = new Residue_type[5000];
        String result = "";
        int how_many = 0;
        int i = 0;
        while (i < 5000) {
            if (sorted.contains(i)) {
                types[i] = residues.get((Object)Integer.valueOf((int)i)).type;
                ++how_many;
            } else {
                types[i] = Residue_type.gap;
            }
            ++i;
        }
        Residue_type[] to_return = new Residue_type[how_many];
        int index = 0;
        int i2 = 0;
        while (i2 < 5000) {
            if (types[i2] != Residue_type.gap) {
                to_return[index++] = types[i2];
            }
            ++i2;
        }
        if (sorted.size() == 0) {
            return null;
        }
        return to_return;
    }

    public static String renameChain(String line, char new_name) {
        String firsthalf = line.substring(0, 21);
        String secondhalf = line.substring(22);
        return String.valueOf(firsthalf) + new_name + secondhalf;
    }

    public static void writeConstrainingPDB(String pdb_file_source, String pdb_file_out, ArrayList<Integer> roi, char chain) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM") || !roi.contains(seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""))) || s.charAt(21) != chain) continue;
                out.write(String.valueOf(s) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom and ROI constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeConstrainingPDBINDEX(String pdb_file_source, String pdb_file_out, ArrayList<Integer> roi, char chain) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            int index = 0;
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            int curr_seq_id = -10000;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM") || !roi.contains(seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""))) || s.charAt(21) != chain) continue;
                if (seq_id != curr_seq_id) {
                    ++index;
                    curr_seq_id = seq_id;
                }
                String index_write = index < 10 ? "   " + index : (index < 100 ? "  " + index : (index < 1000 ? " " + index : "" + index));
                String to_write = String.valueOf(s.substring(0, 16)) + " " + s.substring(17, 22) + index_write + s.substring(26);
                out.write(String.valueOf(to_write) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom and ROI constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeConstrainingPDBINDEX(String pdb_file_source, String pdb_file_out, char chain) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            int index = 0;
            int curr_seq_id = -100000;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                if (s.charAt(21) != chain) continue;
                if (seq_id != curr_seq_id) {
                    ++index;
                    curr_seq_id = seq_id;
                }
                String index_write = index < 10 ? "   " + index : (index < 100 ? "  " + index : (index < 1000 ? " " + index : "" + index));
                String to_write = String.valueOf(s.substring(0, 16)) + " " + s.substring(17, 22) + index_write + s.substring(26);
                out.write(String.valueOf(to_write) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Chain Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void standardizePDB(String pdb_file_source, String pdb_file_out, char chain) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            String seq_id = "oi";
            int index = 0;
            String curr_seq_id = "";
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                seq_id = s.substring(22, 27).replace(" ", "");
                if (!seq_id.equals(curr_seq_id)) {
                    ++index;
                    curr_seq_id = seq_id;
                }
                String index_write = index < 10 ? "   " + index : (index < 100 ? "  " + index : (index < 1000 ? " " + index : "" + index));
                String to_write = String.valueOf(s.substring(0, 16)) + " " + s.substring(17, 22) + index_write + s.substring(26);
                to_write = PDB_parser.renameChain(to_write, chain);
                out.write(String.valueOf(to_write) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Chain Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeCDR(String pdb_file_source, String pdb_code, String out_folder) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            BufferedWriter out = null;
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            int index = 0;
            int curr_seq_id = -100000;
            int count = 0;
            int curr_chain = 111;
            while ((s = dis.readLine()) != null) {
                FileWriter fstream;
                String filename;
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                if (s.charAt(21) == 'H' && curr_chain == 76) {
                    count = 0;
                } else if (s.charAt(21) == 'L' && curr_chain == 72) {
                    count = 0;
                }
                if (s.charAt(21) == 'C' && curr_chain == 72) {
                    if (out != null) {
                        out.close();
                    }
                    filename = String.valueOf(out_folder) + "/" + pdb_code + "H" + ++count + ".pdb";
                    fstream = new FileWriter(filename);
                    out = new BufferedWriter(fstream);
                    curr_chain = 67;
                    index = 0;
                } else if (s.charAt(21) == 'C' && curr_chain == 76) {
                    if (out != null) {
                        out.close();
                    }
                    filename = String.valueOf(out_folder) + "/" + pdb_code + "L" + ++count + ".pdb";
                    fstream = new FileWriter(filename);
                    out = new BufferedWriter(fstream);
                    curr_chain = 67;
                    index = 0;
                }
                if (s.charAt(21) == 'C') {
                    if (seq_id != curr_seq_id) {
                        ++index;
                        curr_seq_id = seq_id;
                    }
                    String index_write = index < 10 ? "   " + index : (index < 100 ? "  " + index : (index < 1000 ? " " + index : "" + index));
                    String to_write = String.valueOf(s.substring(0, 16)) + " " + s.substring(17, 22) + index_write + s.substring(26);
                    out.write(String.valueOf(to_write) + "\n");
                    continue;
                }
                curr_chain = s.charAt(21);
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (Exception e) {
            System.err.println("Chain Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeConstrainingPDB(String pdb_file_source, String pdb_file_out, char chain) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                if (s.charAt(21) != chain) continue;
                out.write(String.valueOf(s) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Chain Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeConstrainingPDB(String pdb_file_source, String pdb_file_out) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    out.write(String.valueOf(s) + "\n");
                    continue;
                }
                out.write(String.valueOf(s) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeConstrainingPDB(String pdb_file_source, String pdb_file_out, ArrayList<Integer> h_cdrs, ArrayList<Integer> l_cdrs) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    if (s.charAt(21) == 'H') {
                        if (h_cdrs.contains(seq_id)) {
                            s = PDB_parser.renameChain(s, 'C');
                        }
                    } else if (s.charAt(21) == 'L' && l_cdrs.contains(seq_id)) {
                        s = PDB_parser.renameChain(s, 'C');
                    }
                    out.write(String.valueOf(s) + "\n");
                    continue;
                }
                out.write(String.valueOf(s) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void renamePDBChain(String pdb_file_source, String pdb_file_out, char chainname) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    s = PDB_parser.renameChain(s, chainname);
                    out.write(String.valueOf(s) + "\n");
                    continue;
                }
                out.write(String.valueOf(s) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Atom Constrainer: Error: " + e.getMessage());
            System.out.println(s);
        }
    }

    public static void writeBiasedPDB(String pdb_file_source, String pdb_file_out, String bias) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            int curr_id = -1;
            boolean i = false;
            String curr_type = "";
            String output = "";
            while ((s = dis.readLine()) != null) {
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    if (seq_id != curr_id) {
                        curr_id = seq_id;
                        if (bias.equals("single_contact")) {
                            curr_type = Residue_type.mapResidueTo3(Residue_type.getRandomBiasedType_CON());
                        } else if (bias.equals("triple_contact")) {
                            curr_type = Residue_type.mapResidueTo3(Residue_type.getRandomBiasedType_CON3());
                        } else if (bias.equals("triple_relative")) {
                            curr_type = Residue_type.mapResidueTo3(Residue_type.getRandomBiasedType_PROP3());
                        } else if (bias.equals("surface_bias")) {
                            curr_type = Residue_type.mapResidueTo3(Residue_type.getRandomBiasedType_SURFACE());
                        }
                    }
                    String s_new = String.valueOf(s.substring(0, 17)) + curr_type + s.substring(20) + "\n";
                    output = String.valueOf(output) + s_new;
                    continue;
                }
                output = String.valueOf(output) + s + "\n";
            }
            FileSystemTools.writeFile(pdb_file_out, output);
            fis.close();
            bis.close();
            dis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public static void scrambleResidues(String pdb_file_source, String pdb_file_out) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            int curr_id = -1;
            boolean i = false;
            String curr_type = "";
            String output = "";
            while ((s = dis.readLine()) != null) {
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    if (seq_id != curr_id) {
                        curr_id = seq_id;
                        curr_type = Residue_type.mapResidueTo3(Residue_type.getRandomType());
                    }
                    String s_new = String.valueOf(s.substring(0, 17)) + curr_type + s.substring(20) + "\n";
                    output = String.valueOf(output) + s_new;
                    continue;
                }
                output = String.valueOf(output) + s + "\n";
            }
            FileSystemTools.writeFile(pdb_file_out, output);
            fis.close();
            bis.close();
            dis.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private static double calculatePercentLower(SC_Structure str, int seq_id) {
        double perc_lower = 0.0;
        Residue central = str.residues.get(seq_id);
        for (Integer i : str.residues.keySet()) {
            if (i == seq_id || !(central.getTPro() > str.residues.get(i).getTPro())) continue;
            perc_lower += 1.0;
        }
        return (perc_lower /= (double)str.residues.keySet().size()) * 100.0;
    }

    public static ArrayList<Integer> writePDB(SC_Structure str, String pdb_file_source, String pdb_file_out, boolean isA, double cutoff) {
        ArrayList<Integer> considered = new ArrayList<Integer>();
        ArrayList<Integer> vals = new ArrayList<Integer>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            if (pdb_file_out == null) {
                filename = isA ? String.valueOf(System.getProperty("user.dir")) + "/StrA.pdb" : String.valueOf(System.getProperty("user.dir")) + "/StrB.pdb";
            }
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            boolean i = false;
            int FP = 0;
            int TP = 0;
            int FN = 0;
            int TN = 0;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    if (str.residues.containsKey(seq_id) && s.charAt(21) == str.chain) {
                        bfactor = str.residues.get(seq_id).getTPro();
                        if (bfactor >= cutoff && str.residues.get((Object)Integer.valueOf((int)seq_id)).isContact) {
                            bfactor = 1.0;
                            if (!considered.contains(seq_id)) {
                                ++TP;
                            }
                        } else if (bfactor >= cutoff && !str.residues.get((Object)Integer.valueOf((int)seq_id)).isContact) {
                            bfactor = 2.0;
                            if (!considered.contains(seq_id)) {
                                ++FP;
                            }
                        } else if (bfactor < cutoff && str.residues.get((Object)Integer.valueOf((int)seq_id)).isContact) {
                            bfactor = 1.5;
                            if (!considered.contains(seq_id)) {
                                ++FN;
                            }
                        } else {
                            bfactor = 0.0;
                            if (!considered.contains(seq_id)) {
                                ++TN;
                            }
                        }
                        if (!considered.contains(seq_id)) {
                            considered.add(seq_id);
                        }
                        bfactor *= 100.0;
                    }
                    String bfstring = String.valueOf(Double.toString(bfactor)) + "0";
                    if (bfactor < 10.0) {
                        out.write(String.valueOf(s.substring(0, 60)) + "  " + bfstring + s.substring(66, s.length()) + "\n");
                        continue;
                    }
                    if (bfactor < 100.0) {
                        out.write(String.valueOf(s.substring(0, 60)) + " " + bfstring + s.substring(66, s.length()) + "\n");
                        continue;
                    }
                    out.write(String.valueOf(s.substring(0, 60)) + bfstring + s.substring(66, s.length()) + "\n");
                    continue;
                }
                out.write(String.valueOf(s) + "\n");
            }
            out.write("ATOM   4754  CG  LEU Z   1     -96.378 -24.907  -0.681  1.00  0.00           C \nATOM   4755  CD1 LEU Z   2     -96.033 -26.365  -0.907  1.00100.00           C \nATOM   4756  CD2 LEU Z   3     -97.461 -24.767   0.382  1.00150.00           C \nATOM   4757  OXT LEU Z   4     -93.601 -22.244   1.522  1.00200.00           O \n");
            vals.add(TP);
            vals.add(FP);
            vals.add(TN);
            vals.add(FN);
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error in writePDB: " + e.getMessage());
        }
        return vals;
    }

    public static ArrayList<Integer> writePDBHalf(SC_Structure str, boolean isA, double cutoff, ArrayList<Integer> tns) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        for (Integer seq_id : str.residues.keySet()) {
            double bfactor = 0.0;
            bfactor = str.residues.get(seq_id).getTPro();
            if (bfactor >= cutoff && str.residues.get((Object)seq_id).isContact) {
                ++TP;
                continue;
            }
            if (bfactor >= cutoff && !str.residues.get((Object)seq_id).isContact) {
                if (!tns.contains(seq_id)) continue;
                ++FP;
                continue;
            }
            if (bfactor < cutoff && str.residues.get((Object)seq_id).isContact) {
                ++FN;
                continue;
            }
            if (!tns.contains(seq_id)) continue;
            ++TN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static ArrayList<Integer> writePDBHalf(SC_Structure str, boolean isA, double cutoff, String method) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        for (Integer seq_id : str.residues.keySet()) {
            double bfactor = 0.0;
            if (!str.residues.containsKey(seq_id)) continue;
            if (method.equals("TPRO")) {
                bfactor = str.residues.get(seq_id).getTPro();
            } else if (method.equals("PPRO")) {
                bfactor = str.residues.get(seq_id).getPPro();
            } else if (method.equals("APRO")) {
                bfactor = str.residues.get(seq_id).getAPro();
            } else {
                System.err.println("Invalid method specified " + method);
                System.exit(0);
            }
            if (bfactor >= cutoff && str.residues.get((Object)seq_id).isContact) {
                ++TP;
                continue;
            }
            if (bfactor >= cutoff && !str.residues.get((Object)seq_id).isContact) {
                ++FP;
                continue;
            }
            if (bfactor < cutoff && str.residues.get((Object)seq_id).isContact) {
                ++FN;
                continue;
            }
            ++TN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static ArrayList<Integer> writePDBHalfCDR(String pdb_code, SC_Structure str, boolean isA, double cutoff, String method) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        for (Integer seq_id : str.sorted) {
            double bfactor = 0.0;
            if (str.residues.containsKey(seq_id) && str.residues.get((Object)seq_id).isCDR) {
                if (method.equals("TPRO")) {
                    bfactor = str.residues.get(seq_id).getTPro();
                } else if (method.equals("PPRO")) {
                    bfactor = str.residues.get(seq_id).getPPro();
                } else if (method.equals("APRO")) {
                    bfactor = str.residues.get(seq_id).getAPro();
                } else {
                    System.err.println("Invalid method specified " + method);
                    System.exit(0);
                }
                if (bfactor >= cutoff && str.residues.get((Object)seq_id).isContact) {
                    ++TP;
                    continue;
                }
                if (bfactor >= cutoff && !str.residues.get((Object)seq_id).isContact) {
                    ++FP;
                    continue;
                }
                if (bfactor < cutoff && str.residues.get((Object)seq_id).isContact) {
                    ++FN;
                    continue;
                }
                ++TN;
                continue;
            }
            if (!str.residues.get((Object)seq_id).isContact) continue;
            ++FN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static TreeMap<Integer, Double> sortResidues(SC_Structure str) {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (Integer i : str.residues.keySet()) {
            map.put(i, str.residues.get(i).getTPro());
        }
        ValueComparator bvc = new ValueComparator(map);
        TreeMap<Integer, Double> sorted = new TreeMap<Integer, Double>(bvc);
        for (Integer i : str.residues.keySet()) {
            sorted.put(i, str.residues.get(i).getTPro());
        }
        return sorted;
    }

    public static ArrayList<Integer> writePDBHalfTOPN(SC_Structure str, boolean isA, double cutoff, String method, TreeMap<Integer, Double> sorted) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        int checked = 0;
        for (Integer seq_id : sorted.keySet()) {
            double bfactor = 0.0;
            if (!str.residues.containsKey(seq_id)) continue;
            if (method.equals("TPRO")) {
                bfactor = str.residues.get(seq_id).getTPro();
            } else if (method.equals("PPRO")) {
                bfactor = str.residues.get(seq_id).getPPro();
            } else if (method.equals("APRO")) {
                bfactor = str.residues.get(seq_id).getAPro();
            } else {
                System.err.println("Invalid method specified " + method);
                System.exit(0);
            }
            if ((double)checked < cutoff) {
                ++checked;
                if (str.residues.get((Object)seq_id).isContact) {
                    ++TP;
                    continue;
                }
                if (str.residues.get((Object)seq_id).isContact) continue;
                ++FP;
                continue;
            }
            if (str.residues.get((Object)seq_id).isContact) {
                ++FN;
                continue;
            }
            ++TN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static ArrayList<Integer> writePDBHalfCDRTOPN(String pdb_code, SC_Structure str, boolean isA, double cutoff, String method, TreeMap<Integer, Double> sorted) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        int checked = 0;
        for (Integer seq_id : sorted.keySet()) {
            double bfactor = 0.0;
            if (str.residues.containsKey(seq_id) && str.residues.get((Object)seq_id).isCDR) {
                if (method.equals("TPRO")) {
                    bfactor = str.residues.get(seq_id).getTPro();
                } else if (method.equals("PPRO")) {
                    bfactor = str.residues.get(seq_id).getPPro();
                } else if (method.equals("APRO")) {
                    bfactor = str.residues.get(seq_id).getAPro();
                } else {
                    System.err.println("Invalid method specified " + method);
                    System.exit(0);
                }
                if ((double)checked < cutoff) {
                    ++checked;
                    if (str.residues.get((Object)seq_id).isContact) {
                        ++TP;
                        continue;
                    }
                    if (str.residues.get((Object)seq_id).isContact) continue;
                    ++FP;
                    continue;
                }
                if (str.residues.get((Object)seq_id).isContact) {
                    ++FN;
                    continue;
                }
                ++TN;
                continue;
            }
            if (str.residues.get((Object)seq_id).isContact) {
                ++FN;
                continue;
            }
            ++TN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static ArrayList<Integer> writePDBHalfTEMP(SC_Structure str, boolean isA, double cutoff, String method) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        int FP = 0;
        int TP = 0;
        int FN = 0;
        int TN = 0;
        for (Integer seq_id : str.residues.keySet()) {
            double bfactor = 0.0;
            if (!str.residues.containsKey(seq_id)) continue;
            if (method.equals("TPRO")) {
                bfactor = str.residues.get((Object)seq_id).tempTPRO;
            } else if (method.equals("PPRO")) {
                bfactor = str.residues.get(seq_id).getPPro();
            } else if (method.equals("APRO")) {
                bfactor = str.residues.get(seq_id).getAPro();
            } else {
                System.err.println("Invalid method specified " + method);
                System.exit(0);
            }
            if (bfactor >= cutoff && str.residues.get((Object)seq_id).isContact) {
                ++TP;
                continue;
            }
            if (bfactor >= cutoff && !str.residues.get((Object)seq_id).isContact) {
                ++FP;
                continue;
            }
            if (bfactor < cutoff && str.residues.get((Object)seq_id).isContact) {
                ++FN;
                continue;
            }
            ++TN;
        }
        vals.add(TP);
        vals.add(FP);
        vals.add(TN);
        vals.add(FN);
        return vals;
    }

    public static double[] writeResultPDB(SC_Structure str, String pdb_file_source, String pdb_file_out, boolean isA) {
        double max_c = -1.0;
        double min_c = 100.0;
        double[] res = new double[2];
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            String filename = pdb_file_out;
            if (pdb_file_out == null) {
                filename = isA ? String.valueOf(System.getProperty("user.dir")) + "/StrA.pdb" : String.valueOf(System.getProperty("user.dir")) + "/StrB.pdb";
            }
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            fis = new FileInputStream(pdb_file_source);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int seq_id = -1;
            while ((s = dis.readLine()) != null) {
                double bfactor = 0.0;
                String tpro = "";
                if (s.length() > 10 && s.substring(0, 4).equals("ATOM")) {
                    seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                    if (str.residues.containsKey(seq_id) && s.charAt(21) == str.chain) {
                        bfactor = str.residues.get(seq_id).getTPro();
                        if (bfactor > max_c) {
                            max_c = bfactor;
                        }
                        if (bfactor < min_c) {
                            min_c = bfactor;
                        }
                        if ((tpro = String.valueOf(bfactor)).length() > 4) {
                            tpro = tpro.substring(0, tpro.indexOf(46) + 3);
                        }
                    }
                    out.write(String.valueOf(SC_Structure.colorBFactor(s, String.valueOf(tpro))) + "\n");
                    continue;
                }
                out.write(String.valueOf(SC_Structure.colorBFactor(s, "0.0")) + "\n");
            }
            fis.close();
            bis.close();
            dis.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error in WriteResultPDB: " + e.getMessage());
        }
        res[0] = min_c;
        res[1] = max_c;
        return res;
    }

    public static HashMap<Integer, Residue> readFromWeb(String pdb_file, ArrayList<Integer> roi, char chain) throws IOException {
        HashMap<Integer, Residue> residues = new HashMap<Integer, Residue>();
        ArrayList<Atom> curr_residue = new ArrayList<Atom>();
        try {
            Residue res;
            String s;
            String urltext = "http://www.rcsb.org/pdb/files/" + pdb_file;
            URL url = new URL(urltext);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            FileWriter fstream = new FileWriter("/data/martial/krawczyk/data/PropensityPDBs/" + pdb_file);
            BufferedWriter out = new BufferedWriter(fstream);
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            int curr_id = -1;
            int seq_id = -1;
            Residue_type curr_typ = Residue_type.gap;
            Residue_type typ = Residue_type.gap;
            char lastchar = ' ';
            while ((s = in.readLine()) != null) {
                out.write(String.valueOf(s) + "\n");
                if (s.length() <= 10 || !s.substring(0, 4).equals("ATOM")) continue;
                x = Double.parseDouble(s.substring(30, 38).replace(" ", ""));
                y = Double.parseDouble(s.substring(38, 46).replace(" ", ""));
                z = Double.parseDouble(s.substring(46, 54).replace(" ", ""));
                seq_id = Integer.parseInt(s.substring(22, 26).replace(" ", ""));
                typ = Residue_type.mapResidue(s.substring(17, 20));
                lastchar = s.charAt(21);
                if (curr_id != seq_id && curr_id != -1) {
                    if (s.charAt(21) == chain && (roi == null || roi != null && roi.contains(curr_id))) {
                        res = new Residue(curr_typ, curr_residue, curr_id);
                        residues.put(curr_id, res);
                    }
                    curr_residue = new ArrayList();
                }
                Atom atm = new Atom(x, y, z, s);
                curr_typ = typ;
                curr_id = seq_id;
                curr_residue.add(atm);
            }
            if (lastchar == chain && (roi == null || roi != null && roi.contains(curr_id))) {
                res = new Residue(curr_typ, curr_residue, curr_id);
                residues.put(curr_id, res);
            }
            curr_residue = new ArrayList();
            in.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not locate pdb");
        }
        return residues;
    }

    private static Residue_type mapResidue(String resid) {
        if (resid.equals("ALA")) {
            return Residue_type.A;
        }
        if (resid.equals("ARG")) {
            return Residue_type.R;
        }
        if (resid.equals("ASN")) {
            return Residue_type.N;
        }
        if (resid.equals("ASP")) {
            return Residue_type.D;
        }
        if (resid.equals("CYS")) {
            return Residue_type.C;
        }
        if (resid.equals("GLN")) {
            return Residue_type.Q;
        }
        if (resid.equals("GLU")) {
            return Residue_type.E;
        }
        if (resid.equals("GLY")) {
            return Residue_type.G;
        }
        if (resid.equals("HIS")) {
            return Residue_type.H;
        }
        if (resid.equals("ILE")) {
            return Residue_type.I;
        }
        if (resid.equals("LEU")) {
            return Residue_type.L;
        }
        if (resid.equals("LYS")) {
            return Residue_type.K;
        }
        if (resid.equals("MET")) {
            return Residue_type.M;
        }
        if (resid.equals("PHE")) {
            return Residue_type.F;
        }
        if (resid.equals("PRO")) {
            return Residue_type.P;
        }
        if (resid.equals("SER")) {
            return Residue_type.S;
        }
        if (resid.equals("THR")) {
            return Residue_type.T;
        }
        if (resid.equals("TRP")) {
            return Residue_type.W;
        }
        if (resid.equals("TYR")) {
            return Residue_type.Y;
        }
        if (resid.equals("VAL")) {
            return Residue_type.V;
        }
        return Residue_type.gap;
    }

    public static void OutputHTML(SC_Structure strA, SC_Structure strB, String out_dir, String pdb_filename1, String pdb_filename2) {
        String htmloutput = "<html><body><p>";
        htmloutput = String.valueOf(htmloutput) + "</p></body></html>";
        htmloutput = String.valueOf(htmloutput) + "<font size=\"4\" color=\"black\">Sequence of Structure A:</font><br>";
        htmloutput = String.valueOf(htmloutput) + PDB_parser.SingleOutputHTML(strA, pdb_filename1, out_dir);
        htmloutput = String.valueOf(htmloutput) + "<br><font size=\"4\" color=\"black\">Sequence of Structure B:</font><br>";
        htmloutput = String.valueOf(htmloutput) + PDB_parser.SingleOutputHTML(strB, pdb_filename2, out_dir);
        FileSystemTools.writeFile("annotation.inc.html", out_dir, htmloutput);
    }

    public static String SingleOutputHTML(SC_Structure str, String pdb_filename, String out_dir) {
        int linebreakconst = 10;
        String buried_color = "000033";
        String htmloutput = "";
        String[] colordefs = new String[]{"000066", "0000CC", "3366FF", "33FF99", "339933", "99FF33", "FFFF33", "FF9933", "FF0000"};
        double max = -1.0;
        for (Integer res : str.residues.keySet()) {
            if (!(str.residues.get(res).getTPro() > max)) continue;
            max = str.residues.get(res).getTPro();
        }
        ArrayList<String> pdb = FileSystemTools.readFile(pdb_filename, out_dir);
        int curr_seqid = -1;
        int linebreaks_added = 0;
        int linebreak = linebreakconst;
        int i = 0;
        while (i < pdb.size()) {
            String pdb_line = pdb.get(i);
            if (pdb_line.subSequence(0, 4).equals("ATOM")) {
                String residue_color;
                int seq_id = Integer.parseInt(pdb_line.substring(22, 26).replace(" ", ""));
                if (str.residues.containsKey(seq_id) && pdb_line.charAt(21) == str.chain) {
                    double score = str.residues.get(seq_id).getTPro();
                    int index = (int)Math.round(score / max * (double)colordefs.length);
                    if (index == colordefs.length) {
                        --index;
                    }
                    residue_color = colordefs[index];
                    if (seq_id != curr_seqid) {
                        htmloutput = String.valueOf(htmloutput) + "<font size=\"4\" color=\"" + residue_color + "\">" + (Object)((Object)str.residues.get((Object)Integer.valueOf((int)seq_id)).type) + "</font>";
                        curr_seqid = seq_id;
                        if (--linebreak == 0) {
                            linebreak = linebreakconst;
                            htmloutput = String.valueOf(htmloutput) + "<font size=\"4\" color=\"black\">\t" + ++linebreaks_added * linebreakconst + "</font>";
                            htmloutput = String.valueOf(htmloutput) + "<br>\n";
                        }
                    }
                } else {
                    String resType = pdb_line.substring(17, 20);
                    residue_color = buried_color;
                    if (seq_id != curr_seqid) {
                        htmloutput = String.valueOf(htmloutput) + "<font size=\"4\" color=\"" + residue_color + "\">" + (Object)((Object)PDB_parser.mapResidue(resType)) + "</font>";
                        curr_seqid = seq_id;
                        if (--linebreak == 0) {
                            linebreak = linebreakconst;
                            htmloutput = String.valueOf(htmloutput) + "<font size=\"4\" color=\"black\">\t" + ++linebreaks_added * linebreakconst + "</font>";
                            htmloutput = String.valueOf(htmloutput) + "<br>\n";
                        }
                    }
                }
            }
            ++i;
        }
        return htmloutput;
    }

    static class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            if ((Double)this.base.get(a) < (Double)this.base.get(b)) {
                return 1;
            }
            if ((Double)this.base.get(a) == (Double)this.base.get(b)) {
                return 0;
            }
            return -1;
        }
    }
}

