/*
 * Decompiled with CFR 0.152.
 */
package parsing;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class ROI_parser {
    public static ArrayList<Integer> parse(String roi_file) {
        ArrayList<Integer> roi = new ArrayList<Integer>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(roi_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((s = dis.readLine()) != null) {
                if ((s = s.replace(" ", "")).length() == 0 || s.charAt(0) == '>' || s.charAt(0) == '<') continue;
                if (s.indexOf(45) == -1) {
                    int i = Integer.parseInt(s);
                    if (roi.contains(i)) continue;
                    roi.add(i);
                    continue;
                }
                int _start = Integer.parseInt(s.substring(0, s.indexOf(45)));
                int _end = Integer.parseInt(s.substring(s.indexOf(45) + 1));
                if (_end <= _start) {
                    System.err.println("Invalid residue range in file " + roi_file + " " + "start: " + _start + " end: " + _end);
                }
                int i = _start;
                while (i <= _end) {
                    if (!roi.contains(i)) {
                        roi.add(i);
                    }
                    ++i;
                }
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (roi.size() == 0) {
            roi = null;
        }
        return roi;
    }

    public static char getChain(String roi_file) {
        char chain = ' ';
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(roi_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((s = dis.readLine()) != null) {
                if ((s = s.replace(" ", "")).length() == 0 || s.charAt(0) != '>') continue;
                chain = s.charAt(1);
                return chain;
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return chain;
    }

    public static int getSpacing(String roi_file) {
        int spacing = -1;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(roi_file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((s = dis.readLine()) != null) {
                if ((s = s.replace(" ", "")).length() == 0 || s.charAt(0) != '<') continue;
                spacing = Integer.parseInt(s.substring(1));
                return spacing;
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return spacing;
    }
}

