/*
 * Decompiled with CFR 0.152.
 */
package db_interface;

import db_interface.Molecule;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class Complex_Structure {
    private static final String userdir = System.getProperty("user.dir");
    private static final String db_folder = String.valueOf(userdir) + "/protein_database/complex_pairs";
    private static final String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
    private static final String concat_folder = String.valueOf(userdir) + "/protein_database/concat";
    private static final String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
    public final String pdb_name;
    public final double resolution;
    public final String technique;
    public final String source;
    public Molecule m1;
    public Molecule m2;

    public Complex_Structure(String _pdb_name, String folder, String mol_folder) {
        String _source;
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/" + _pdb_name.substring(0, 4) + ".pdb");
        String _technique = Complex_Structure.getTechnique(lines);
        double _resolution = -1.0;
        if (_technique.equals("X-RAYDIFFRACTION")) {
            _resolution = Complex_Structure.getResolution(lines);
        }
        if ((_source = Complex_Structure.getSource(lines)) == null) {
            System.out.println(_pdb_name);
        }
        this.pdb_name = _pdb_name;
        this.source = _source;
        this.resolution = _resolution;
        this.technique = _technique;
        this.m1 = new Molecule(String.valueOf(this.pdb_name) + "_A", mol_folder);
        this.m2 = new Molecule(String.valueOf(this.pdb_name) + "_B", mol_folder);
        if (this.m1.chains.size() == 0 || this.m1.chains.size() == 0) {
            System.err.println("Empty structure " + this.pdb_name);
        }
        for (Character c : this.m1.chains.keySet()) {
            if (this.m1.chains.get((Object)c).residues.size() != 0) continue;
            System.err.println("Incomplete structure " + this.pdb_name + ", chain " + c + " is empty");
        }
        for (Character c : this.m2.chains.keySet()) {
            if (this.m2.chains.get((Object)c).residues.size() != 0) continue;
            System.err.println("Incomplete structure " + this.pdb_name + ", chain " + c + " is empty");
        }
    }

    public void runPSA() {
        System.out.println("Running PSA " + this.pdb_name);
        HashMap<Integer, Double> antibody_NC = PSA.runPSA(this.m1.pdb_src);
        HashMap<Integer, Double> antigen_NC = PSA.runPSA(this.m2.pdb_src);
        HashMap<Integer, Double> antibody_IC = PSA.runPSA(String.valueOf(concat_folder) + "/" + this.pdb_name + "_C.pdb", true);
        HashMap<Integer, Double> antigen_IC = PSA.runPSA(String.valueOf(concat_folder) + "/" + this.pdb_name + "_C.pdb", false);
        for (Integer i : this.m1.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
            this.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).asa_IC = antibody_IC.get(i);
            this.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).asa_NC = antibody_NC.get(i);
            this.m1.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).d_asa = antibody_IC.get(i) - antibody_NC.get(i);
        }
        for (Integer i : this.m2.chains.get((Object)Character.valueOf((char)'A')).residues.keySet()) {
            this.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).asa_IC = antigen_IC.get(i);
            this.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).asa_NC = antigen_NC.get(i);
            this.m2.chains.get((Object)Character.valueOf((char)'A')).residues.get((Object)i).d_asa = antigen_IC.get(i) - antigen_NC.get(i);
        }
    }

    public Complex_Structure(String _pdb_name) {
        this(_pdb_name, raw_folder, db_folder);
    }

    public static double getResolution(ArrayList<String> lines) {
        for (String line : lines) {
            String resolution_bit;
            double resolution;
            if (!line.toUpperCase().contains("RESOLUTION") || line.toUpperCase().contains(" TITL ") || line.toUpperCase().contains(" AT ") || (resolution = MathFunctions.getNumber(resolution_bit = line.substring(line.toUpperCase().indexOf("RESOLUTION") + 10))) == -1.0) continue;
            return resolution;
        }
        System.err.println("EXPDTA field not found: ");
        System.exit(0);
        return -1.0;
    }

    public static String getTechnique(ArrayList<String> lines) {
        for (String line : lines) {
            if (line.length() <= 8 || !line.substring(0, 6).equals("EXPDTA")) continue;
            String exptech = line.substring(7);
            exptech = exptech.replace(" ", "").toUpperCase();
            return exptech;
        }
        System.err.println("EXPDTA field not found: ");
        System.exit(0);
        return null;
    }

    public static String getSource(ArrayList<String> lines) {
        for (String line : lines) {
            if (!line.contains("ORGANISM_SCIENTIFIC:")) continue;
            return line.substring(line.indexOf("ORGANISM_SCIENTIFIC:") + "ORGANISM_SCIENTIFIC:".length()).replace(" ", "").replace(";", "");
        }
        for (String line : lines) {
            if (!line.contains("ENGINEERED: YES")) continue;
            return "ENGINEERED";
        }
        System.err.println("Source field not found: ");
        return null;
    }

    public String File_A() {
        return String.valueOf(db_folder) + "/" + this.pdb_name + "_A.pdb";
    }

    public String File_B() {
        return String.valueOf(db_folder) + "/" + this.pdb_name + "_B.pdb";
    }

    public String File_A_std() {
        return String.valueOf(std_folder) + "/" + this.pdb_name + "_A.pdb";
    }

    public String File_B_std() {
        return String.valueOf(std_folder) + "/" + this.pdb_name + "_B.pdb";
    }

    public void printMolecule() {
        System.out.println("=================");
        System.out.println("Name: " + this.pdb_name);
        System.out.println("Technique: " + this.technique);
        if (this.resolution != -1.0) {
            System.out.println("Resolution: " + this.resolution + " Angstroms");
        }
        System.out.println("Source: " + this.source);
        System.out.println("Molecule A:");
        System.out.println("Chains: " + this.m1.chains.size());
        for (Character c : this.m1.chains.keySet()) {
            System.out.println("\t Chain :" + c);
            System.out.println("\t Size :" + this.m1.chains.get((Object)c).residues.size());
        }
        System.out.println("Molecule B:");
        System.out.println("Chains: " + this.m2.chains.size());
        for (Character c : this.m2.chains.keySet()) {
            System.out.println("\t Chain :" + c);
            System.out.println("\t Size :" + this.m2.chains.get((Object)c).residues.size());
        }
        System.out.println("=================");
    }

    public void writeAntibody(String filename) {
        String output = "";
        output = String.valueOf(output) + this.m1.chains.get(Character.valueOf('A')).getPDBRenamed('A');
        output = String.valueOf(output) + this.m2.chains.get(Character.valueOf('A')).getPDBRenamed('B');
        FileSystemTools.writeFile(filename, output);
    }
}

