/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking.DockingAnalyzer;
import docking_global.PrepareData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class BatchFactory {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        BatchFactory.Maximization(100, 2);
        System.out.println("Done");
    }

    public static void ShowFitting(String docker, String name, String cutoff, String _case, String pdb, String contrast) {
        String line;
        Residue r;
        String filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/" + docker + "_" + name + "_" + cutoff + "_" + _case + "/" + pdb;
        String filename_contr = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/" + docker + "_" + contrast + "_" + cutoff + "_" + _case + "/" + pdb;
        HashMap<Integer, Residue> ab = PDB_parser.parse(String.valueOf(filename) + "/AB.pdb");
        HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(filename) + "/AG.pdb");
        ArrayList<String> epitope = FileSystemTools.readFile(String.valueOf(filename) + "/epitope.txt");
        ArrayList<String> paratope = FileSystemTools.readFile(String.valueOf(filename) + "/paratope.txt");
        ArrayList<String> para_contr_lines = FileSystemTools.readFile(String.valueOf(filename_contr) + "/paratope.txt");
        ArrayList<Integer> ep = new ArrayList<Integer>();
        ArrayList<Integer> para = new ArrayList<Integer>();
        ArrayList<Integer> para_contrast = new ArrayList<Integer>();
        for (String line2 : epitope) {
            ep.add(Integer.parseInt(line2));
        }
        for (String line2 : paratope) {
            para.add(Integer.parseInt(line2));
        }
        for (String line2 : para_contr_lines) {
            para_contrast.add(Integer.parseInt(line2));
        }
        ArrayList<String> ab_lines = new ArrayList<String>();
        ArrayList<String> ag_lines = new ArrayList<String>();
        for (Integer i : ab.keySet()) {
            r = ab.get(i);
            for (Atom a : r.atoms) {
                line = a.pdb_line;
                line = para.contains(i) && para_contrast.contains(i) ? SC_Structure.colorBFactor(line, "100") : (para.contains(i) && !para_contrast.contains(i) ? SC_Structure.colorBFactor(line, "75") : (!para.contains(i) && para_contrast.contains(i) ? SC_Structure.colorBFactor(line, "25") : SC_Structure.colorBFactor(line, "0")));
                ab_lines.add(line);
            }
        }
        for (Integer i : ag.keySet()) {
            r = ag.get(i);
            for (Atom a : r.atoms) {
                line = a.pdb_line;
                line = ep.contains(i) ? SC_Structure.colorBFactor(line, "100") : SC_Structure.colorBFactor(line, "0");
                ag_lines.add(line);
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/case_visualization/Ab_" + pdb + ".pdb", ab_lines);
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/case_visualization/Ag_" + pdb + ".pdb", ag_lines);
    }

    public static void prepareGlobalCases() {
        ArrayList<String> case_names = new ArrayList<String>();
        ArrayList<Integer> cuts = new ArrayList<Integer>();
        cuts.add(4);
        case_names.add("cdr");
        case_names.add("ipatch");
        case_names.add("paratome");
        case_names.add("correct");
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        int global_ind = 1;
        while (global_ind < 2) {
            for (String pdb : pdbs) {
                ArrayList<Integer> ep_cons = PrepareData.getRandomEpitope(pdb);
                System.out.println(String.valueOf(pdb) + "...");
                for (String name : case_names) {
                    for (Integer cut : cuts) {
                        BatchFactory.prepareGlobalCase("zdock", pdb, 'H', name, cut, true, "global_cases/" + global_ind, ep_cons);
                        BatchFactory.prepareGlobalCase("zdock", pdb, 'R', name, cut, true, "global_cases/" + global_ind, ep_cons);
                    }
                }
            }
            ++global_ind;
        }
    }

    public static void Maximization(int iterations, int big_iteration) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        int i = 1;
        while (i < big_iteration) {
            for (String pdb : pdbs) {
                PrepareData.MaximizeEpitope(pdb, iterations, i);
            }
            ++i;
        }
    }

    public static void prepareCases() {
        ArrayList<String> case_names = new ArrayList<String>();
        ArrayList<Integer> cuts = new ArrayList<Integer>();
        cuts.add(4);
        cuts.add(5);
        cuts.add(6);
        case_names.add("ipatch");
        case_names.add("cdr");
        case_names.add("correct");
        case_names.add("paratome");
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        for (String pdb : pdbs) {
            System.out.println(String.valueOf(pdb) + "...");
            for (String name : case_names) {
                for (Integer cut : cuts) {
                    BatchFactory.prepareCase("zdock", pdb, 'H', name, cut, false, "batch_cases");
                    BatchFactory.prepareCase("zdock", pdb, 'R', name, cut, false, "batch_cases");
                    BatchFactory.prepareCase("patchdock", pdb, 'H', name, cut, false, "batch_cases");
                    BatchFactory.prepareCase("patchdock", pdb, 'R', name, cut, false, "batch_cases");
                }
            }
        }
    }

    public static void prepareCase(String docker, String pdb, char _case, String name, int ep_cut, boolean random_epitope, String folder) {
        File pdb_fold;
        HashMap<Integer, Residue> ab_cas = BatchFactory.getCase(pdb, "AB", _case);
        HashMap<Integer, Residue> ag_cas = BatchFactory.getCase(pdb, "AG", _case);
        ArrayList<Integer> ab_cons = new ArrayList();
        if (name.equals("ipatch")) {
            ArrayList<Integer> cdr_cons = DockingAnalyzer.loadOurCDRs(pdb);
            ArrayList<Integer> raw_cons = DockingAnalyzer.loadIPCons("R", pdb, 1);
            for (Integer i : raw_cons) {
                if (!cdr_cons.contains(i)) continue;
                ab_cons.add(i);
            }
        } else if (name.equals("paratome")) {
            ab_cons = DockingAnalyzer.loadParatomeCDRs(pdb);
        } else if (name.equals("cdr")) {
            ab_cons = DockingAnalyzer.loadOurCDRs(pdb);
        } else if (name.equals("correct")) {
            ab_cons = DockingAnalyzer.loadTruesList(pdb);
        } else {
            System.out.println("Unknown case " + name);
            System.exit(0);
        }
        if (docker.equals("zdock")) {
            ab_cons = BatchFactory.zdock_constraint(ab_cons, ab_cas);
        } else if (!docker.equals("patchdock")) {
            System.out.println("Unknown docker: " + docker);
            System.exit(0);
        }
        ArrayList<Integer> ep_cons = null;
        ep_cons = random_epitope ? PrepareData.getRandomEpitope(pdb) : DockingAnalyzer.loadEPConsPartialParametrized("H", pdb, String.valueOf(ep_cut));
        if (docker.equals("zdock")) {
            ep_cons = BatchFactory.zdock_constraint(ep_cons, ag_cas);
        }
        String ab_out = "";
        for (Integer i : ab_cons) {
            ab_out = docker.equals("patchdock") ? String.valueOf(ab_out) + i + " A\n" : String.valueOf(ab_out) + i + "\n";
        }
        String ag_out = "";
        for (Integer i : ep_cons) {
            ag_out = docker.equals("patchdock") ? String.valueOf(ag_out) + i + " A\n" : String.valueOf(ag_out) + i + "\n";
        }
        File case_fold = new File(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/" + folder + "/" + docker + "_" + name + "_" + ep_cut + "_" + _case);
        if (!case_fold.exists()) {
            case_fold.mkdir();
        }
        if (!(pdb_fold = new File(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/" + folder + "/" + docker + "_" + name + "_" + ep_cut + "_" + _case + "/" + pdb)).exists()) {
            pdb_fold.mkdir();
        }
        String ab_file = BatchFactory.getCaseFile(pdb, "AB", _case);
        String ag_file = BatchFactory.getCaseFile(pdb, "AG", _case);
        FileSystemTools.CopyFile(ab_file, String.valueOf(pdb_fold.getAbsolutePath()) + "/AB.pdb");
        FileSystemTools.CopyFile(ag_file, String.valueOf(pdb_fold.getAbsolutePath()) + "/AG.pdb");
        FileSystemTools.writeFile(String.valueOf(pdb_fold.getAbsolutePath()) + "/paratope.txt", ab_out);
        FileSystemTools.writeFile(String.valueOf(pdb_fold.getAbsolutePath()) + "/epitope.txt", ag_out);
    }

    public static void prepareGlobalCase(String docker, String pdb, char _case, String name, int ep_cut, boolean random_epitope, String folder, ArrayList<Integer> ep_cons) {
        File pdb_fold;
        HashMap<Integer, Residue> ab_cas = BatchFactory.getCase(pdb, "AB", _case);
        HashMap<Integer, Residue> ag_cas = BatchFactory.getCase(pdb, "AG", _case);
        ArrayList<Integer> ab_cons = new ArrayList();
        if (name.equals("ipatch")) {
            ArrayList<Integer> cdr_cons = DockingAnalyzer.loadOurCDRs(pdb);
            ArrayList<Integer> raw_cons = DockingAnalyzer.loadIPCons("R", pdb, 1);
            for (Integer n : raw_cons) {
                if (!cdr_cons.contains(n)) continue;
                ab_cons.add(n);
            }
        } else if (name.equals("paratome")) {
            ab_cons = DockingAnalyzer.loadParatomeCDRs(pdb);
        } else if (name.equals("cdr")) {
            ab_cons = DockingAnalyzer.loadOurCDRs(pdb);
        } else if (name.equals("correct")) {
            ab_cons = DockingAnalyzer.loadTruesList(pdb);
        } else {
            System.out.println("Unknown case " + name);
            System.exit(0);
        }
        if (docker.equals("zdock")) {
            ab_cons = BatchFactory.zdock_constraint(ab_cons, ab_cas);
        } else if (!docker.equals("patchdock")) {
            System.out.println("Unknown docker: " + docker);
            System.exit(0);
        }
        if (docker.equals("zdock")) {
            ep_cons = BatchFactory.zdock_constraint(ep_cons, ag_cas);
        }
        String ab_out = "";
        for (Integer i : ab_cons) {
            ab_out = docker.equals("patchdock") ? String.valueOf(ab_out) + i + " A\n" : String.valueOf(ab_out) + i + "\n";
        }
        String ag_out = "";
        for (Integer n : ep_cons) {
            ag_out = docker.equals("patchdock") ? String.valueOf(ag_out) + n + " A\n" : String.valueOf(ag_out) + n + "\n";
        }
        File file = new File(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/" + folder + "/" + docker + "_" + name + "_" + ep_cut + "_" + _case);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(pdb_fold = new File(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/" + folder + "/" + docker + "_" + name + "_" + ep_cut + "_" + _case + "/" + pdb)).exists()) {
            pdb_fold.mkdir();
        }
        String ab_file = BatchFactory.getCaseFile(pdb, "AB", _case);
        String ag_file = BatchFactory.getCaseFile(pdb, "AG", _case);
        FileSystemTools.CopyFile(ab_file, String.valueOf(pdb_fold.getAbsolutePath()) + "/AB.pdb");
        FileSystemTools.CopyFile(ag_file, String.valueOf(pdb_fold.getAbsolutePath()) + "/AG.pdb");
        FileSystemTools.writeFile(String.valueOf(pdb_fold.getAbsolutePath()) + "/paratope.txt", ab_out);
        FileSystemTools.writeFile(String.valueOf(pdb_fold.getAbsolutePath()) + "/epitope.txt", ag_out);
    }

    public static ArrayList<Integer> zdock_constraint(ArrayList<Integer> cons, HashMap<Integer, Residue> pdb) {
        ArrayList<Integer> nons = new ArrayList<Integer>();
        for (Integer i : pdb.keySet()) {
            if (cons.contains(i)) continue;
            nons.add(i);
        }
        return nons;
    }

    public static void CreateTrues() {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        for (String pdb : pdbs) {
            ArrayList<String> ab_out = new ArrayList<String>();
            ArrayList<String> ag_out = new ArrayList<String>();
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            for (Integer ab_i : ab_sol.keySet()) {
                for (Integer ag_i : ag_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    if (!ab_out.contains("" + ab_i)) {
                        ab_out.add("" + ab_i);
                    }
                    if (ag_out.contains("" + ag_i)) continue;
                    ag_out.add("" + ag_i);
                }
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution_residues/" + pdb + "_ab.txt", ab_out);
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution_residues/" + pdb + "_ag.txt", ag_out);
        }
    }

    public static void validateCDR(int cut) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double TP = 0.0;
        double FN = 0.0;
        double FP = 0.0;
        for (String pdb : pdbs) {
            System.out.println("Doing " + pdb);
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            ArrayList<Integer> cdr = DockingAnalyzer.loadOurCDRs(pdb);
            ArrayList<Integer> para = DockingAnalyzer.loadParatomeCDRs(pdb);
            ArrayList<Integer> trues = DockingAnalyzer.loadTruesList(pdb);
            double para_in_cdr = 0.0;
            double cdr_in_para = 0.0;
            for (int i : cdr) {
                if (!para.contains(i)) continue;
                para_in_cdr += 1.0;
            }
            for (int i : para) {
                if (!cdr.contains(i)) continue;
                cdr_in_para += 1.0;
            }
            ArrayList<String> lines = new ArrayList<String>();
            int i = 1;
            while (i < 400) {
                if (ab_sol.containsKey(i)) {
                    Residue r = ab_sol.get(i);
                    for (Atom a : r.atoms) {
                        String line = a.pdb_line;
                        line = trues.contains(i) ? SC_Structure.colorBFactor(line, "100") : (cdr.contains(i) && para.contains(i) ? SC_Structure.colorBFactor(line, "75") : (cdr.contains(i) && !para.contains(i) ? SC_Structure.colorBFactor(line, "50") : (!cdr.contains(i) && para.contains(i) ? SC_Structure.colorBFactor(line, "25") : SC_Structure.colorBFactor(line, "0"))));
                        lines.add(line);
                    }
                }
                ++i;
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/paratome_cdr/" + pdb + ".pdb", lines);
            System.out.println("Para in CDR = " + para_in_cdr / (double)para.size());
            System.out.println("CDR in Para = " + cdr_in_para / (double)cdr.size());
            for (Integer ab_i : ab_sol.keySet()) {
                boolean contact = false;
                for (Integer ag_i : ag_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    contact = true;
                    break;
                }
                if (contact && cdr.contains(ab_i)) {
                    TP += 1.0;
                }
                if (!contact && cdr.contains(ab_i)) {
                    FP += 1.0;
                }
                if (!contact || cdr.contains(ab_i)) continue;
                FN += 1.0;
            }
        }
        System.out.println("cut=" + cut + " recall = " + TP / (TP + FN));
        System.out.println("cut=" + cut + " precision = " + TP / (TP + FP));
    }

    public static void validateParatome(int cut) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double TP = 0.0;
        double FN = 0.0;
        double FP = 0.0;
        for (String pdb : pdbs) {
            System.out.println("Doing " + pdb);
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            ArrayList<Integer> cdr = DockingAnalyzer.loadParatomeCDRs(pdb);
            for (Integer ab_i : ab_sol.keySet()) {
                boolean contact = false;
                for (Integer ag_i : ag_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    contact = true;
                    break;
                }
                if (contact && cdr.contains(ab_i)) {
                    TP += 1.0;
                }
                if (!contact && cdr.contains(ab_i)) {
                    FP += 1.0;
                }
                if (!contact || cdr.contains(ab_i)) continue;
                FN += 1.0;
            }
        }
        System.out.println("cut=" + cut + " recall = " + TP / (TP + FN));
        System.out.println("cut=" + cut + " precision = " + TP / (TP + FP));
    }

    public static void validateEp(int cut) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double TP = 0.0;
        double FN = 0.0;
        double FP = 0.0;
        HashMap<Integer, Double> percentages = new HashMap<Integer, Double>();
        for (String pdb : pdbs) {
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            ArrayList<Integer> cdr = null;
            cdr = cut != 0 ? DockingAnalyzer.loadEPConsPartialParametrized("H", pdb, String.valueOf(cut)) : DockingAnalyzer.loadTruesListAg(pdb);
            for (Integer ag_i : ag_sol.keySet()) {
                boolean contact = false;
                for (Integer ab_i : ab_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    contact = true;
                    break;
                }
                if (contact && cdr.contains(ag_i)) {
                    TP += 1.0;
                }
                if (!contact && cdr.contains(ag_i)) {
                    FP += 1.0;
                }
                if (!contact || cdr.contains(ag_i)) continue;
                FN += 1.0;
            }
            percentages.put(ag_sol.size(), (double)cdr.size() / (double)ag_sol.size());
            System.out.println(String.valueOf(ag_sol.size()) + " " + (double)cdr.size() / (double)ag_sol.size());
        }
        for (Integer n : percentages.keySet()) {
        }
    }

    public static void validateTrues(int cut) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double TP = 0.0;
        double FN = 0.0;
        double FP = 0.0;
        for (String pdb : pdbs) {
            System.out.println("Doing " + pdb);
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            ArrayList<Integer> cdr = DockingAnalyzer.loadTruesList(pdb);
            for (Integer ab_i : ab_sol.keySet()) {
                boolean contact = false;
                for (Integer ag_i : ag_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    contact = true;
                    break;
                }
                if (contact && cdr.contains(ab_i)) {
                    TP += 1.0;
                }
                if (!contact && cdr.contains(ab_i)) {
                    FP += 1.0;
                }
                if (!contact || cdr.contains(ab_i)) continue;
                FN += 1.0;
            }
        }
        System.out.println("cut=" + cut + " recall = " + TP / (TP + FN));
        System.out.println("cut=" + cut + " precision = " + TP / (TP + FP));
    }

    public static void validatePrec(int cut) {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution");
        double TP = 0.0;
        double FN = 0.0;
        double FP = 0.0;
        for (String pdb : pdbs) {
            System.out.println("Doing " + pdb);
            HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
            HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
            ArrayList<Integer> cons = DockingAnalyzer.loadIPCons("H", pdb, cut);
            ArrayList<Integer> cdr = DockingAnalyzer.loadOurCDRs(pdb);
            for (Integer ab_i : ab_sol.keySet()) {
                boolean contact = false;
                for (Integer ag_i : ag_sol.keySet()) {
                    if (!(ab_sol.get(ab_i).distanceFrom(ag_sol.get(ag_i)) < 4.5)) continue;
                    contact = true;
                    break;
                }
                if (contact && cons.contains(ab_i) && cdr.contains(ab_i)) {
                    TP += 1.0;
                }
                if (!contact && cons.contains(ab_i) && cdr.contains(ab_i)) {
                    FP += 1.0;
                }
                if (!contact || cons.contains(ab_i)) continue;
                FN += 1.0;
            }
        }
        System.out.println("cut=" + cut + " recall = " + TP / (TP + FN));
        System.out.println("cut=" + cut + " precision = " + TP / (TP + FP));
    }

    public static void validateHR(String pdb) {
        System.out.println("Checking consistency of " + pdb);
        HashMap<Integer, Residue> ab_sol = BatchFactory.getSolution(pdb, "AB");
        HashMap<Integer, Residue> ag_sol = BatchFactory.getSolution(pdb, "AG");
        HashMap<Integer, Residue> ab_R_cas = BatchFactory.getCase(pdb, "AB", 'R');
        HashMap<Integer, Residue> ag_R_cas = BatchFactory.getCase(pdb, "AG", 'R');
        HashMap<Integer, Residue> ab_H_cas = BatchFactory.getCase(pdb, "AB", 'H');
        HashMap<Integer, Residue> ag_H_cas = BatchFactory.getCase(pdb, "AG", 'H');
        for (Integer i : ab_sol.keySet()) {
            if (ab_R_cas.get((Object)i).type != ab_sol.get((Object)i).type) {
                System.out.println("Kaputt 1");
                System.exit(0);
            }
            if (ab_H_cas.get((Object)i).type == ab_sol.get((Object)i).type) continue;
            System.out.println("Kaputt 2");
            System.out.println("Sol i=" + i);
            System.out.println("Sol t=" + (Object)((Object)ab_sol.get((Object)i).type));
            System.out.println("Cas t=" + (Object)((Object)ab_H_cas.get((Object)i).type));
            System.exit(0);
        }
        System.out.println("ab_sol size " + ab_sol.size());
        for (Integer i : ag_sol.keySet()) {
            if (ag_R_cas.get((Object)i).type != ag_sol.get((Object)i).type) {
                System.out.println("Kaputt");
                System.exit(0);
            }
            if (ag_H_cas.get((Object)i).type == ag_sol.get((Object)i).type) continue;
            System.out.println("Kaputt");
            System.exit(0);
        }
        System.out.println("ag_sol size " + ag_sol.size());
        System.out.println("All is good for " + pdb);
    }

    public static HashMap<Integer, Residue> getSolution(String pdb, String abag) {
        String filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb.toLowerCase() + "/" + abag + ".pdb";
        HashMap<Integer, Residue> res = PDB_parser.parse(filename);
        return res;
    }

    public static HashMap<Integer, Residue> getCase(String pdb, String abag, char _case) {
        String filename = "";
        if (_case == 'H') {
            filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/zdock_cdr_4_H/" + pdb.toLowerCase() + "/" + abag + ".pdb";
        } else if (_case == 'R') {
            filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/zdock_cdr_4_R/" + pdb.toLowerCase() + "/" + abag + ".pdb";
        } else {
            System.err.println("Submitted unknown case: " + _case);
            System.exit(0);
        }
        HashMap<Integer, Residue> res = PDB_parser.parse(filename);
        return res;
    }

    public static String getCaseFile(String pdb, String abag, char _case) {
        String filename = "";
        if (_case == 'H') {
            filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/zdock_cdr_4_H/" + pdb.toLowerCase() + "/" + abag + ".pdb";
            return filename;
        }
        if (_case == 'R') {
            filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/batch_cases/zdock_cdr_4_R/" + pdb.toLowerCase() + "/" + abag + ".pdb";
            return filename;
        }
        System.err.println("Submitted unknown case: " + _case);
        System.exit(0);
        return null;
    }
}

