/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Residue;
import data_structures.Residue_type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.MathFunctions;

public class DockingAnalyzer {
    private static final String userdir = System.getProperty("user.dir");
    private static final String temp_dir = String.valueOf(userdir) + "/temp_dump";
    private static final String temp_AB = String.valueOf(temp_dir) + "/tempAB.pdb";
    private static final String temp_AG = String.valueOf(temp_dir) + "/tempAG.pdb";

    public static void main(String[] args) {
        DockingAnalyzer.analyzeCasesPatchDock(false);
    }

    public static void comparePredictions(String precision, String _case) {
        String case_fold = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case;
        ArrayList<String> cases = FileSystemTools.getFolders(case_fold);
        double tot_good = 0.0;
        double tot_bad = 0.0;
        double tot_ok = 0.0;
        for (String pdb : cases) {
            System.out.println(pdb);
            ArrayList<String> map_con = FileSystemTools.readFile(String.valueOf(case_fold) + "/" + pdb + "/map_con.txt");
            ArrayList<Integer> real_cons = new ArrayList<Integer>();
            for (String i : map_con) {
                if (!i.contains("AB")) continue;
                real_cons.add(Integer.parseInt(i.replace("_AB", "")));
            }
            ArrayList<String> i_patch = FileSystemTools.readFile(String.valueOf(case_fold) + "/" + pdb + "/ipatch_" + precision + ".txt");
            ArrayList<Integer> pred_cons = new ArrayList<Integer>();
            for (String i : i_patch) {
                pred_cons.add(Integer.parseInt(i));
            }
            double good = 0.0;
            double bad = 0.0;
            for (Integer pred_i : pred_cons) {
                if (!real_cons.contains(pred_i)) {
                    bad += 1.0;
                    continue;
                }
                good += 1.0;
            }
            tot_good += good;
            tot_bad += bad;
            tot_ok += (double)real_cons.size();
            System.out.println("Precision: " + good / (good + bad));
            System.out.println("Recall: " + good / (double)real_cons.size());
        }
        System.out.println("Total Precision: " + tot_good / (tot_good + tot_bad));
        System.out.println("Recall: " + tot_good / tot_ok);
        System.out.println("Total good: " + tot_good);
        System.out.println("Total bad: " + tot_bad);
        System.out.println("Total TP: " + tot_ok);
    }

    public static HashMap<Integer, Double> getZrank(String main_fold, String _case, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(main_fold) + "/" + _case + "/" + pdb + "/output/zrank_list.txt");
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (String line : lines) {
            String index = line.substring(0, line.indexOf(".pdb"));
            index = index.replace("complex.", "");
            index = index.replace(".H", "");
            index = index.replace(".R", "");
            int zdock_id = Integer.parseInt(index);
            String zrank = line.substring(line.indexOf(".pdb") + 4);
            double zrank_val = Double.parseDouble(zrank);
            map.put(zdock_id, zrank_val);
        }
        return map;
    }

    public static void analyzeCases(boolean copy_decoys) {
        String iter_fold = "/Volumes/D/iter_results";
        String main_fold = "/Volumes/D/results_p_zdock";
        String rmsd_fold = "/Volumes/D/output";
        String decoy_fold = String.valueOf(userdir) + "/result_dump/Docking/decoys";
        File fi = new File(decoy_fold);
        if (!fi.exists()) {
            fi.mkdir();
        }
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("case_part_3H");
        _cases.add("case_part_5H");
        String out_main_fold = String.valueOf(userdir) + "/result_dump/Docking/results";
        File f = new File(out_main_fold);
        if (!f.exists()) {
            f.mkdir();
        }
        int c = 0;
        int[][] corr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_pars.txt");
        int[][] incorr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_pars.txt");
        double[][] prop_mat = new double[20][20];
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                double summa = corr_tmp[i][j] + incorr_tmp[i][j];
                if (summa > 0.0) {
                    prop_mat[i][j] = (double)corr_tmp[i][j] / summa;
                }
                ++j;
            }
            ++i;
        }
        double[][] corr = MathFunctions.normalizeAARows(corr_tmp);
        double[][] incorr = MathFunctions.normalizeAARows(incorr_tmp);
        for (String _case : _cases) {
            ++c;
            char case_id = _case.charAt(_case.length() - 1);
            if (_case.contains("H")) {
                case_id = 'H';
            }
            if (_case.contains("R")) {
                case_id = 'R';
            }
            if (_case.equals("case_1")) continue;
            String res_fold = String.valueOf(main_fold) + "/" + _case;
            HashMap<String, Double> results = new HashMap<String, Double>();
            ArrayList<String> pdbs = FileSystemTools.getFolders(res_fold);
            String out_fold = String.valueOf(out_main_fold) + "/" + _case;
            String d_case_fold = String.valueOf(decoy_fold) + "/" + _case;
            f = new File(d_case_fold);
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(out_fold)).exists()) {
                f.mkdir();
            }
            int j = 0;
            for (String pdb_code : pdbs) {
                HashMap<Integer, Residue_type> typs = DockingAnalyzer.loadTypeMapping(pdb_code.toLowerCase());
                HashMap<Integer, Double> tpros = DockingAnalyzer.loadIpatchMapping(pdb_code.toLowerCase());
                HashMap<Integer, Boolean> cdr = DockingAnalyzer.loadCDRs(pdb_code);
                HashMap<Integer, Boolean> trues = DockingAnalyzer.loadTrues(pdb_code);
                HashMap<Integer, Double> l_rmsd = DockingAnalyzer.getLRMSD(rmsd_fold, _case, pdb_code);
                HashMap<Integer, Double> i_rmsd = DockingAnalyzer.getIRMSD(rmsd_fold, _case, pdb_code);
                HashMap<Integer, Double> zrank = null;
                if (!_case.contains("PD_") && !_case.contains("R")) {
                    zrank = DockingAnalyzer.getZrank(main_fold, _case, pdb_code);
                }
                ArrayList<Integer> epitope_cons = null;
                epitope_cons = _case.contains("part") ? DockingAnalyzer.loadEPConsPartial(String.valueOf(case_id), pdb_code) : DockingAnalyzer.loadEPCons(String.valueOf(case_id), pdb_code);
                FileWriter fstream = null;
                BufferedWriter out = null;
                System.out.println(String.valueOf(_case) + " [" + c + "/" + _cases.size() + "] - " + pdb_code + "[" + j + "/" + pdbs.size() + "]");
                String d_fold = String.valueOf(d_case_fold) + "/" + pdb_code;
                f = new File(d_fold);
                if (!f.exists()) {
                    f.mkdir();
                }
                try {
                    f = new File(String.valueOf(out_fold) + "/" + pdb_code + "_stat.txt");
                    if (f.exists()) continue;
                    fstream = new FileWriter(String.valueOf(out_fold) + "/" + pdb_code + "_stat.txt");
                    out = new BufferedWriter(fstream);
                    if (pdb_code.equals("output")) continue;
                    ++j;
                    ArrayList<String> files = FileSystemTools.getFiles(String.valueOf(res_fold) + "/" + pdb_code + "/output");
                    boolean i2 = false;
                    int best = 0;
                    int tot_cons_main = 0;
                    ArrayList<Integer> paratome_cdrs = DockingAnalyzer.loadParatomeCDRs(pdb_code);
                    ArrayList<Integer> our_cdrs = DockingAnalyzer.loadOurCDRs(pdb_code);
                    ArrayList<Integer> cons_1 = DockingAnalyzer.loadIPCons(String.valueOf(case_id), pdb_code, 1);
                    int[][] arr = DockingAnalyzer.getSpecificMatrix(pdb_code);
                    for (String file : files) {
                        if (file.contains(".fix")) continue;
                        double score_1 = 0.0;
                        double score_2 = 0.0;
                        double score_3 = 0.0;
                        double score_4 = 0.0;
                        int score_ab = 0;
                        int score_ag = 0;
                        double score_ab_p = 0.0;
                        double score_ag_p = 0.0;
                        double score_all_p = 0.0;
                        double probability_score = 0.0;
                        double probability_with_ipatch = 0.0;
                        double probability_score_2 = 0.0;
                        double probability_score_3 = 0.0;
                        double probability_score_4 = 0.0;
                        double scaled_corr = 0.0;
                        double scaled_incorr = 0.0;
                        double ipatch_scaled_1 = 0.0;
                        double ipatch_scaled_2 = 0.0;
                        double ipatch_scaled_3 = 0.0;
                        double ipatch_scaled_4 = 0.0;
                        double our_cdrs_score = 0.0;
                        double paratome_cdrs_score = 0.0;
                        int file_ind = Integer.parseInt(file.substring(file.indexOf(".") + 1, file.lastIndexOf(".")));
                        if (file_ind > 200) continue;
                        String res_file = String.valueOf(res_fold) + "/" + pdb_code + "/output/" + file;
                        DockingAnalyzer.createTemp(res_file, "");
                        HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
                        HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
                        int got_cons = 0;
                        int got_false = 0;
                        int tot_cons = 0;
                        int clashes = 0;
                        for (int ab_i : ab.keySet()) {
                            Residue ab_r = ab.get(ab_i);
                            for (int ag_i : ag.keySet()) {
                                Residue ag_r = ag.get(ag_i);
                                if (arr[ab_i][ag_i] == 1) {
                                    ++tot_cons;
                                }
                                if (ab_r.distanceFrom(ag_r) < 3.0) {
                                    ++clashes;
                                }
                                if (ab_r.distanceFrom(ag_r) < 4.5) {
                                    if (epitope_cons.contains(ag_i) && paratome_cdrs.contains(ab_i)) {
                                        paratome_cdrs_score += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                    }
                                    if (epitope_cons.contains(ag_i) && our_cdrs.contains(ab_i)) {
                                        our_cdrs_score += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                    }
                                    if (epitope_cons.contains(ag_i) && our_cdrs.contains(ab_i)) {
                                        probability_with_ipatch = cons_1.contains(ab_i) ? (probability_with_ipatch += 0.45 * prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()]) : (probability_with_ipatch += 0.55 * prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()]);
                                    }
                                    if (epitope_cons.contains(ag_i) && cons_1.contains(ab_i)) {
                                        probability_score += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                    }
                                    if (epitope_cons.contains(ag_i) && cdr.containsKey(ab_i) && cdr.get(ab_i).booleanValue()) {
                                        Residue_type t = typs.get(ab_i);
                                        probability_score_2 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        probability_score_3 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        if (typs.get(ab_i) != null && tpros.get(ab_i) > 4.0) {
                                            probability_score_2 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                            probability_score_2 = tpros.get(ab_i) > 10.0 ? (probability_score_2 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()] * 1.0) : (probability_score_2 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()] * (tpros.get(ab_i) / 10.0));
                                        }
                                        if (typs.get(ab_i) != null && trues.get(ab_i).booleanValue()) {
                                            probability_score_3 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()] * 1.0;
                                        }
                                    }
                                }
                                if (arr[ab_i][ag_i] == 1 && ab_r.distanceFrom(ag_r) < 4.5) {
                                    ++got_cons;
                                }
                                if (arr[ab_i][ag_i] == 1 || !(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                                ++got_false;
                            }
                        }
                        String rank_s = file.substring(file.indexOf(46) + 1);
                        rank_s = rank_s.substring(0, rank_s.indexOf(46));
                        int rank = Integer.parseInt(rank_s);
                        double f_nat = (double)got_cons / (double)tot_cons;
                        double f_non = (double)got_false / (double)tot_cons;
                        double prec = (double)got_cons / ((double)got_false + (double)got_cons);
                        out.write(String.valueOf(rank) + " " + f_nat + " " + f_non + " " + prec + " " + score_1 + " " + score_2 + " " + score_3 + " " + score_4 + " " + l_rmsd.get(file_ind) + " " + i_rmsd.get(file_ind) + " " + clashes + " " + score_ab_p + " " + score_ag_p + " " + score_all_p + " " + score_ag_p * score_ab_p + " " + score_ab * score_ag + " " + scaled_corr + " " + scaled_incorr + " " + scaled_corr / scaled_incorr + " " + probability_score + " " + probability_score_2 + " " + probability_score_3 + " " + probability_score_4 + " " + ipatch_scaled_1 + " " + ipatch_scaled_2 + " " + ipatch_scaled_3 + " " + ipatch_scaled_4 + " " + our_cdrs_score + " " + paratome_cdrs_score + " " + probability_with_ipatch + "\n");
                        tot_cons_main = tot_cons;
                        if (got_cons <= best) continue;
                        best = got_cons;
                    }
                    System.out.println(String.valueOf(pdb_code) + " best: " + best);
                    System.out.println(String.valueOf(pdb_code) + " total: " + tot_cons_main);
                    results.put(pdb_code, (double)best / (double)tot_cons_main);
                    out.close();
                    fstream.close();
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(0);
                }
            }
            for (String pdb : results.keySet()) {
                System.out.println(String.valueOf(pdb) + " : " + (Double)results.get(pdb) * 100.0 + "%");
            }
        }
    }

    public static void analyzeCasesPatchDock(boolean copy_decoys) {
        String iter_fold = "/Volumes/D/iter_results";
        String main_fold = "/Volumes/D/PatchDock/input";
        String rmsd_fold = "/Volumes/D/PatchDock/ProFitV3.1/output";
        String decoy_fold = String.valueOf(userdir) + "/result_dump/Docking/decoys";
        File fi = new File(decoy_fold);
        if (!fi.exists()) {
            fi.mkdir();
        }
        ArrayList<String> _cases = new ArrayList<String>();
        _cases.add("patchdock_correct_4_H");
        _cases.add("patchdock_ipatch_4_H");
        _cases.add("patchdock_paratome_4_H");
        _cases.add("patchdock_cdr_4_H");
        _cases.add("patchdock_correct_4_R");
        _cases.add("patchdock_ipatch_4_R");
        _cases.add("patchdock_paratome_4_R");
        _cases.add("patchdock_cdr_4_R");
        String out_main_fold = String.valueOf(userdir) + "/result_dump/Docking/results";
        File f = new File(out_main_fold);
        if (!f.exists()) {
            f.mkdir();
        }
        int c = 0;
        int[][] corr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_pars.txt");
        int[][] incorr_tmp = MathFunctions.readParsable2D(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_pars.txt");
        double[][] prop_mat = new double[20][20];
        int i = 0;
        while (i < 20) {
            int j = 0;
            while (j < 20) {
                double summa = corr_tmp[i][j] + incorr_tmp[i][j];
                if (summa > 0.0) {
                    prop_mat[i][j] = (double)corr_tmp[i][j] / summa;
                }
                ++j;
            }
            ++i;
        }
        double[][] corr = MathFunctions.normalizeAARows(corr_tmp);
        double[][] incorr = MathFunctions.normalizeAARows(incorr_tmp);
        for (String _case : _cases) {
            ++c;
            char case_id = _case.charAt(_case.length() - 1);
            if (_case.contains("H")) {
                case_id = 'H';
            }
            if (_case.contains("R")) {
                case_id = 'R';
            }
            if (_case.equals("case_1")) continue;
            String res_fold = String.valueOf(main_fold) + "/" + _case;
            HashMap<String, Double> results = new HashMap<String, Double>();
            System.out.println(res_fold);
            ArrayList<String> pdbs = FileSystemTools.getFolders(res_fold);
            String out_fold = String.valueOf(out_main_fold) + "/" + _case;
            String d_case_fold = String.valueOf(decoy_fold) + "/" + _case;
            f = new File(d_case_fold);
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(out_fold)).exists()) {
                f.mkdir();
            }
            int j = 0;
            for (String pdb_code : pdbs) {
                HashMap<Integer, Double> l_rmsd = DockingAnalyzer.getLRMSD(rmsd_fold, _case, pdb_code);
                HashMap<Integer, Double> i_rmsd = DockingAnalyzer.getIRMSD(rmsd_fold, _case, pdb_code);
                Object zrank = null;
                ArrayList<Integer> epitope_cons = null;
                epitope_cons = _case.contains("part") ? DockingAnalyzer.loadEPConsActual(iter_fold, "case_part_3H_1", pdb_code) : DockingAnalyzer.loadEPCons(String.valueOf(case_id), pdb_code);
                FileWriter fstream = null;
                BufferedWriter out = null;
                System.out.println(String.valueOf(_case) + " [" + c + "/" + _cases.size() + "] - " + pdb_code + "[" + j + "/" + pdbs.size() + "]");
                String d_fold = String.valueOf(d_case_fold) + "/" + pdb_code;
                f = new File(d_fold);
                if (!f.exists()) {
                    f.mkdir();
                }
                try {
                    f = new File(String.valueOf(out_fold) + "/" + pdb_code + "_stat.txt");
                    fstream = new FileWriter(String.valueOf(out_fold) + "/" + pdb_code + "_stat.txt");
                    out = new BufferedWriter(fstream);
                    if (pdb_code.equals("output")) continue;
                    ++j;
                    ArrayList<String> files = FileSystemTools.getFiles(String.valueOf(res_fold) + "/" + pdb_code + "/output");
                    boolean i2 = false;
                    int best = 0;
                    int tot_cons_main = 0;
                    for (String file : files) {
                        ArrayList<Integer> dup_ab_1 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ag_1 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ab_2 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ag_2 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ab_3 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ag_3 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ab_4 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_ag_4 = new ArrayList<Integer>();
                        ArrayList<Integer> dup_1 = new ArrayList<Integer>();
                        ArrayList<Integer> cons_1 = DockingAnalyzer.loadIPCons(String.valueOf(case_id), pdb_code, 1);
                        double score_1 = 0.0;
                        ArrayList<Integer> dup_2 = new ArrayList<Integer>();
                        ArrayList<Integer> cons_2 = DockingAnalyzer.loadIPCons(String.valueOf(case_id), pdb_code, 3);
                        double score_2 = 0.0;
                        ArrayList<Integer> dup_3 = new ArrayList<Integer>();
                        ArrayList<Integer> cons_3 = DockingAnalyzer.loadIPCons(String.valueOf(case_id), pdb_code, 6);
                        double score_3 = 0.0;
                        ArrayList<Integer> dup_4 = new ArrayList<Integer>();
                        ArrayList<Integer> cons_4 = DockingAnalyzer.loadIPCons(String.valueOf(case_id), pdb_code, 8);
                        double score_4 = 0.0;
                        int score_ab = 0;
                        int score_ag = 0;
                        double score_ab_p = 0.0;
                        double score_ag_p = 0.0;
                        double score_all_p = 0.0;
                        double probability_score = 0.0;
                        double scaled_corr = 0.0;
                        double scaled_incorr = 0.0;
                        int file_ind = Integer.parseInt(file.substring(file.indexOf("out.txt.") + 8, file.lastIndexOf(".")));
                        if (file_ind > 200) continue;
                        if (copy_decoys) {
                            FileSystemTools.CopyFile(String.valueOf(res_fold) + "/" + pdb_code + "/output/" + file, String.valueOf(d_fold) + "/" + file);
                        }
                        String res_file = String.valueOf(res_fold) + "/" + pdb_code + "/output/" + file;
                        DockingAnalyzer.createTemp(res_file, "");
                        int[][] arr = DockingAnalyzer.getSpecificMatrix(pdb_code);
                        HashMap<Integer, Residue> ab = PDB_parser.parse(temp_AB);
                        HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
                        int got_cons = 0;
                        int got_false = 0;
                        int tot_cons = 0;
                        int clashes = 0;
                        for (int ab_i : ab.keySet()) {
                            Residue ab_r = ab.get(ab_i);
                            for (int ag_i : ag.keySet()) {
                                Residue ag_r = ag.get(ag_i);
                                if (arr[ab_i][ag_i] == 1) {
                                    ++tot_cons;
                                }
                                if (ab_r.distanceFrom(ag_r) < 3.0) {
                                    ++clashes;
                                }
                                if (ab_r.distanceFrom(ag_r) < 4.5) {
                                    if (epitope_cons.contains(ag_i) && cons_1.contains(ab_i)) {
                                        if (!dup_ab_1.contains(ab_i)) {
                                            ++score_ab;
                                            dup_ab_1.add(ab_i);
                                        }
                                        probability_score += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        score_1 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        scaled_corr += corr[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        scaled_incorr += incorr[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        if (!dup_ag_1.contains(ag_i)) {
                                            ++score_ag;
                                            dup_ag_1.add(ag_i);
                                        }
                                        score_ab_p += ab_r.type.prop_score;
                                        score_all_p += ab_r.type.prop_score;
                                        score_ag_p += ag_r.type.prop_score_ag;
                                        score_all_p += ag_r.type.prop_score_ag;
                                        dup_1.add(ab_i);
                                    }
                                    if (epitope_cons.contains(ag_i) && cons_2.contains(ab_i)) {
                                        score_2 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        if (!dup_ab_2.contains(ab_i)) {
                                            dup_ab_2.add(ab_i);
                                        }
                                        if (!dup_ag_2.contains(ag_i)) {
                                            dup_ag_2.add(ag_i);
                                        }
                                        dup_2.add(ab_i);
                                        score_ab_p += ab_r.type.prop_score;
                                        score_all_p += ab_r.type.prop_score;
                                        score_ag_p += ag_r.type.prop_score_ag;
                                        score_all_p += ag_r.type.prop_score_ag;
                                    }
                                    if (epitope_cons.contains(ag_i) && cons_3.contains(ab_i)) {
                                        score_3 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        if (!dup_ab_3.contains(ab_i)) {
                                            dup_ab_3.add(ab_i);
                                        }
                                        if (!dup_ag_3.contains(ag_i)) {
                                            dup_ag_3.add(ag_i);
                                        }
                                        dup_3.add(ab_i);
                                        score_ab_p += ab_r.type.prop_score;
                                        score_all_p += ab_r.type.prop_score;
                                        score_ag_p += ag_r.type.prop_score_ag;
                                        score_all_p += ag_r.type.prop_score_ag;
                                    }
                                    if (epitope_cons.contains(ag_i) && cons_4.contains(ab_i)) {
                                        score_4 += prop_mat[ab_r.type.ordinal()][ag_r.type.ordinal()];
                                        if (!dup_ab_4.contains(ab_i)) {
                                            dup_ab_4.add(ab_i);
                                        }
                                        if (!dup_ag_4.contains(ag_i)) {
                                            dup_ag_4.add(ag_i);
                                        }
                                        dup_4.add(ab_i);
                                        score_ab_p += ab_r.type.prop_score;
                                        score_all_p += ab_r.type.prop_score;
                                        score_ag_p += ag_r.type.prop_score_ag;
                                        score_all_p += ag_r.type.prop_score_ag;
                                    }
                                }
                                if (arr[ab_i][ag_i] == 1 && ab_r.distanceFrom(ag_r) < 4.5) {
                                    ++got_cons;
                                }
                                if (arr[ab_i][ag_i] == 1 || !(ab_r.distanceFrom(ag_r) < 4.5)) continue;
                                ++got_false;
                            }
                        }
                        double f_nat = (double)got_cons / (double)tot_cons;
                        double f_non = (double)got_false / (double)tot_cons;
                        double prec = (double)got_cons / ((double)got_false + (double)got_cons);
                        out.write(String.valueOf(file_ind) + " " + f_nat + " " + f_non + " " + prec + " " + score_1 + " " + score_2 + " " + score_3 + " " + score_4 + " " + l_rmsd.get(file_ind) + " " + i_rmsd.get(file_ind) + " " + clashes + " " + score_ab_p + " " + score_ag_p + " " + score_all_p + " " + score_ag_p * score_ab_p + " " + score_ab * score_ag + " " + scaled_corr + " " + scaled_incorr + " " + scaled_corr / scaled_incorr + " " + probability_score + "\n");
                        tot_cons_main = tot_cons;
                        if (got_cons <= best) continue;
                        best = got_cons;
                    }
                    System.out.println(String.valueOf(pdb_code) + " best: " + best);
                    System.out.println(String.valueOf(pdb_code) + " total: " + tot_cons_main);
                    results.put(pdb_code, (double)best / (double)tot_cons_main);
                    out.close();
                    fstream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(e.getLocalizedMessage());
                    System.exit(0);
                }
            }
            for (String pdb : results.keySet()) {
                System.out.println(String.valueOf(pdb) + " : " + (Double)results.get(pdb) * 100.0 + "%");
            }
        }
    }

    public static HashMap<Integer, Double> getLRMSD(String top_dir, String _case, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(top_dir) + "/case_part_3H/" + pdb + "/lrmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static HashMap<Integer, Double> getIRMSD(String top_dir, String _case, String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(top_dir) + "/" + _case + "/" + pdb + "/irmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static ArrayList<Integer> loadIPCons(String _case, String pdb, int cutoff) {
        String filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case + "/" + pdb + "/ipatch_" + cutoff + ".txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line));
        }
        return cons;
    }

    public static ArrayList<Integer> loadOurCDRs(String pdb) {
        String filename = String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/our_cdrs/" + pdb + ".txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line));
        }
        return cons;
    }

    public static ArrayList<Integer> loadParatomeCDRs(String pdb) {
        String filename = String.valueOf(userdir) + "/result_dump/Docking/paratome_comparison/paratome_cdrs/" + pdb + ".txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line));
        }
        return cons;
    }

    public static boolean acceptType(Residue_type t) {
        return t == Residue_type.Y || t == Residue_type.R || t == Residue_type.N || t == Residue_type.D || t == Residue_type.W;
    }

    public static HashMap<Integer, Double> loadIpatchMapping(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + pdb);
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            String type = line.substring(0, line.indexOf(" ")).replace(" ", "");
            Residue_type typ = Residue_type.mapResidue_char(type.charAt(0));
            line = line.substring(line.indexOf(" ") + 1);
            double tpro = Double.parseDouble(line.substring(0, line.indexOf(" ")));
            map.put(id, tpro);
        }
        return map;
    }

    public static HashMap<Integer, Boolean> loadCDRs(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + pdb);
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            String type = line.substring(0, line.indexOf(" ")).replace(" ", "");
            Residue_type typ = Residue_type.mapResidue_char(type.charAt(0));
            line = line.substring(line.indexOf(" ") + 1);
            double tpro = Double.parseDouble(line.substring(0, line.indexOf(" ")));
            boolean bool = (line = line.substring(line.indexOf(" ") + 1)).substring(0, line.indexOf(" ")).replace(" ", "").equals("true");
            map.put(id, bool);
        }
        return map;
    }

    public static HashMap<Integer, Boolean> loadTrues(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + pdb);
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            String type = line.substring(0, line.indexOf(" ")).replace(" ", "");
            Residue_type typ = Residue_type.mapResidue_char(type.charAt(0));
            line = line.substring(line.indexOf(" ") + 1);
            double tpro = Double.parseDouble(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            boolean bool = (line = line.substring(line.indexOf(" ") + 1)).replace(" ", "").equals("true");
            map.put(id, bool);
        }
        return map;
    }

    public static ArrayList<Integer> loadTruesList(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution_residues/" + pdb + "_ab.txt");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String line : lines) {
            list.add(Integer.parseInt(line));
        }
        return list;
    }

    public static ArrayList<Integer> loadTruesListAg(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution_residues/" + pdb + "_ag.txt");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String line : lines) {
            list.add(Integer.parseInt(line));
        }
        return list;
    }

    public static HashMap<Integer, Residue_type> loadTypeMapping(String pdb) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro/" + pdb);
        HashMap<Integer, Residue_type> map = new HashMap<Integer, Residue_type>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            String type = line.substring(0, line.indexOf(" ")).replace(" ", "");
            Residue_type typ = Residue_type.mapResidue_char(type.charAt(0));
            line = line.substring(line.indexOf(" ") + 1);
            double tpro = Double.parseDouble(line.substring(0, line.indexOf(" ")));
            map.put(id, typ);
        }
        return map;
    }

    public static ArrayList<Integer> loadEPCons(String _case, String pdb) {
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/Docking/docking_dataset/case_5BASE/case_5" + _case + "/" + pdb + "/epitope.txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line.replace(" A", "")));
        }
        return cons;
    }

    public static ArrayList<Integer> loadEPConsActual(String main_fold, String _case, String pdb) {
        String res_fold = String.valueOf(main_fold) + "/" + _case;
        String res_file = String.valueOf(res_fold) + "/" + pdb + "/output/complex.1.pdb";
        DockingAnalyzer.createTemp(res_file, "");
        HashMap<Integer, Residue> ag = PDB_parser.parse(temp_AG);
        String filename = String.valueOf(main_fold) + "/" + _case + "/" + pdb + "/epitope_z.txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> ncons = new ArrayList<Integer>();
        for (String line : lines) {
            ncons.add(Integer.parseInt(line));
        }
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (Integer i : ag.keySet()) {
            if (ncons.contains(i)) continue;
            cons.add(i);
        }
        return cons;
    }

    public static ArrayList<Integer> loadEPConsPartial(String _case, String pdb) {
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/Docking/docking_dataset/real/" + pdb + "/epitope_4_raw.txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line.replace(" A", "")));
        }
        return cons;
    }

    public static ArrayList<Integer> loadEPConsPartialParametrized(String _case, String pdb, String cut) {
        String filename = "/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/Docking/docking_dataset/real/" + pdb + "/epitope_" + cut + "_raw.txt";
        ArrayList<String> lines = FileSystemTools.readFile(filename);
        ArrayList<Integer> cons = new ArrayList<Integer>();
        for (String line : lines) {
            cons.add(Integer.parseInt(line.replace(" A", "")));
        }
        return cons;
    }

    public static int[][] getSpecificMatrix(String pdb) {
        String arr_file = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution/" + pdb + "/specific.txt";
        int[][] arr = MathFunctions.readAdjustableParsable2D(arr_file);
        return arr;
    }

    public static void createTemp(String pdb, String supp) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            fstream = new FileWriter(String.valueOf(temp_dir) + "/tempAB" + supp + ".pdb");
            out = new BufferedWriter(fstream);
            ArrayList<String> lines = FileSystemTools.readFile(pdb);
            int prev_seq_id = 1;
            int i = 0;
            while (i < lines.size()) {
                String line = lines.get(i);
                if (line.contains("ATOM")) {
                    int seq_id = Integer.parseInt(line.substring(22, 26).replace(" ", ""));
                    if (seq_id >= prev_seq_id) {
                        out.write(String.valueOf(line) + "\n");
                    } else {
                        out.flush();
                        out.close();
                        fstream.close();
                        fstream = new FileWriter(String.valueOf(temp_dir) + "/tempAG" + supp + ".pdb");
                        out = new BufferedWriter(fstream);
                        out.write(String.valueOf(line) + "\n");
                    }
                    prev_seq_id = seq_id;
                }
                ++i;
            }
            out.flush();
            out.close();
            fstream.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

