/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Atom;
import data_structures.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class Fixer {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String model_f = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/with_H3";
        String real_f = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/real";
        String solution_f = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/solution";
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/with_H3");
        for (String pdb : pdbs) {
            System.out.println(pdb);
            HashMap<Integer, Residue> model = PDB_parser.parse(String.valueOf(model_f) + "/" + pdb + "/AB.pdb", 'A');
            HashMap<Integer, Residue> real = PDB_parser.parse(String.valueOf(real_f) + "/" + pdb + "/AB.pdb", 'A');
            HashMap<Integer, Residue> solution = PDB_parser.parse(String.valueOf(solution_f) + "/" + pdb + "/AB.pdb", 'A');
            Fixer.writeProperlyReal(real, pdb);
            Fixer.writeProperlyModel(model, pdb);
            for (Integer i : solution.keySet()) {
                if (solution.get((Object)i).type == model.get((Object)i).type) continue;
                System.out.println(String.valueOf(pdb) + " : model vs sol length");
                System.out.println(i + " : " + (Object)((Object)model.get((Object)i).type));
                System.out.println(i + " : " + (Object)((Object)solution.get((Object)i).type));
                break;
            }
            for (Integer i : solution.keySet()) {
                if (solution.get((Object)i).type == real.get((Object)i).type) continue;
                System.out.println(String.valueOf(pdb) + " : real vs sol length");
                System.out.println(i + " : " + (Object)((Object)real.get((Object)i).type));
                System.out.println(i + " : " + (Object)((Object)real.get((Object)i).type));
                break;
            }
            if (real.size() == solution.size()) continue;
            System.out.println(String.valueOf(pdb) + " : real vs sol length");
        }
    }

    public static void writeProperlyReal(HashMap<Integer, Residue> res, String pdb) {
        String out = "";
        TreeSet<Integer> ordered = new TreeSet<Integer>();
        for (Integer i : res.keySet()) {
            ordered.add(i);
        }
        for (Integer i : ordered) {
            String seq_id = "" + i;
            while (seq_id.length() < 4) {
                seq_id = " " + seq_id;
            }
            for (Atom atoms : res.get((Object)i).atoms) {
                String line = atoms.pdb_line;
                line = String.valueOf(line.substring(0, 22)) + seq_id + line.substring(26) + "\n";
                out = String.valueOf(out) + line;
            }
        }
        String model_1 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_1/case_1R/" + pdb + "/AB.pdb";
        String model_3 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/case_3R/" + pdb + "/AB.pdb";
        String model_5 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5R/" + pdb + "/AB.pdb";
        String model_part_4 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_partial/4/case_3R/" + pdb + "/AB.pdb";
        FileSystemTools.writeFile(model_part_4, out);
        FileSystemTools.writeFile(model_1, out);
        FileSystemTools.writeFile(model_3, out);
        FileSystemTools.writeFile(model_5, out);
    }

    public static void writeProperlyModel(HashMap<Integer, Residue> res, String pdb) {
        String out = "";
        TreeSet<Integer> ordered = new TreeSet<Integer>();
        for (Integer i : res.keySet()) {
            ordered.add(i);
        }
        for (Integer i : ordered) {
            String seq_id = "" + i;
            while (seq_id.length() < 4) {
                seq_id = " " + seq_id;
            }
            for (Atom atoms : res.get((Object)i).atoms) {
                String line = atoms.pdb_line;
                line = String.valueOf(line.substring(0, 22)) + seq_id + line.substring(26) + "\n";
                out = String.valueOf(out) + line;
            }
        }
        String model_1 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_1/case_1H/" + pdb + "/AB.pdb";
        String model_3 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_3/case_3H/" + pdb + "/AB.pdb";
        String model_5 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_5BASE/case_5H/" + pdb + "/AB.pdb";
        String model_part_4 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_partial/4/case_3H/" + pdb + "/AB.pdb";
        FileSystemTools.writeFile(model_part_4, out);
        FileSystemTools.writeFile(model_1, out);
        FileSystemTools.writeFile(model_3, out);
        FileSystemTools.writeFile(model_5, out);
    }
}

