/*
 * Decompiled with CFR 0.152.
 */
package docking;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking.DockingAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class Visualization {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        String filename = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/newnew_cases/case_part_5H/1ahw";
        String filename2 = String.valueOf(userdir) + "/result_dump/Docking/docking_dataset/case_1/case_1S/1ahw";
        Visualization.colorAbContrast(filename, filename2);
    }

    public static void colorStruc(String name, HashMap<Integer, Residue> str, HashMap<Integer, String> colors) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Integer i : sorted) {
            Residue r = str.get(i);
            for (Atom a : r.atoms) {
                out.add(SC_Structure.colorBFactor(a.pdb_line, colors.get(i)));
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/" + name + ".pdb", out);
    }

    public static void colorRandom(String name, HashMap<Integer, Residue> antigen, ArrayList<Integer> real, ArrayList<Integer> random) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : antigen.keySet()) {
            sorted.add(i);
        }
        String out = "";
        for (Integer i : sorted) {
            if (real.contains(i) && random.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "75") + "\n";
                }
                continue;
            }
            if (real.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "50") + "\n";
                }
                continue;
            }
            if (random.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "100") + "\n";
                }
                continue;
            }
            for (Atom a : antigen.get((Object)i).atoms) {
                out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "0") + "\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/" + name + ".pdb", out);
    }

    public static void colorAg(String folder) {
        HashMap<Integer, Residue> antigen = PDB_parser.parse(String.valueOf(folder) + "/AG.pdb", 'A');
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/epitope_z.txt");
        ArrayList<Integer> nons = new ArrayList<Integer>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            nons.add(Integer.parseInt(line));
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : antigen.keySet()) {
            sorted.add(i);
        }
        String out = "";
        for (Integer i : sorted) {
            if (nons.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "0") + "\n";
                }
                continue;
            }
            for (Atom a : antigen.get((Object)i).atoms) {
                out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "100") + "\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/AG.pdb", out);
    }

    public static void colorAB(String folder) {
        HashMap<Integer, Residue> antigen = PDB_parser.parse(String.valueOf(folder) + "/AB.pdb", 'A');
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/paratope_z.txt");
        ArrayList<Integer> nons = new ArrayList<Integer>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            nons.add(Integer.parseInt(line));
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : antigen.keySet()) {
            sorted.add(i);
        }
        String out = "";
        for (Integer i : sorted) {
            if (nons.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "0") + "\n";
                }
                continue;
            }
            for (Atom a : antigen.get((Object)i).atoms) {
                out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "100") + "\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/AB.pdb", out);
    }

    public static void colorAgContrast(String folder, String folder_precise) {
        HashMap<Integer, Residue> antigen = PDB_parser.parse(String.valueOf(folder) + "/AG.pdb", 'A');
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/epitope_z.txt");
        ArrayList<Integer> nons = new ArrayList<Integer>();
        for (String line : lines) {
            if (line.length() <= 0) continue;
            nons.add(Integer.parseInt(line));
        }
        ArrayList<String> lines_full = FileSystemTools.readFile(String.valueOf(folder_precise) + "/epitope_z.txt");
        ArrayList<Integer> precise = new ArrayList<Integer>();
        for (String line : lines_full) {
            if (line.length() <= 0) continue;
            precise.add(Integer.parseInt(line));
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : antigen.keySet()) {
            sorted.add(i);
        }
        String out = "";
        for (Integer i : sorted) {
            if (nons.contains(i) && precise.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "0") + "\n";
                }
                continue;
            }
            if (!precise.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "100") + "\n";
                }
                continue;
            }
            for (Atom a : antigen.get((Object)i).atoms) {
                out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "50") + "\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/AG.pdb", out);
    }

    public static void colorAbContrast(String folder, String folder_precise) {
        HashMap<Integer, Residue> antigen = PDB_parser.parse(String.valueOf(folder) + "/AB.pdb", 'A');
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(folder) + "/paratope_z.txt");
        ArrayList<Integer> cons = DockingAnalyzer.loadIPCons("H", "1ahw", 9);
        ArrayList<String> lines_full = FileSystemTools.readFile(String.valueOf(folder_precise) + "/paratope_z.txt");
        ArrayList<Integer> precise_nons = new ArrayList<Integer>();
        for (String line : lines_full) {
            if (line.length() <= 0) continue;
            precise_nons.add(Integer.parseInt(line));
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : antigen.keySet()) {
            sorted.add(i);
        }
        String out = "";
        for (Integer i : sorted) {
            if (!cons.contains(i) && precise_nons.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "0") + "\n";
                }
                continue;
            }
            if (!precise_nons.contains(i) && cons.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "100") + "\n";
                }
                continue;
            }
            if (!precise_nons.contains(i) && !cons.contains(i)) {
                for (Atom a : antigen.get((Object)i).atoms) {
                    out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "25") + "\n";
                }
                continue;
            }
            for (Atom a : antigen.get((Object)i).atoms) {
                out = String.valueOf(out) + SC_Structure.colorBFactor(a.pdb_line, "75") + "\n";
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/AB.pdb", out);
    }
}

