/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.util.ArrayList;
import utils.FileSystemTools;

public class alanine_scanning {
    public static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        ArrayList<String> pdbs = alanine_scanning.getPdbs();
        ArrayList<String> cdrs = new ArrayList<String>();
        cdrs.add("H1");
        cdrs.add("H2");
        cdrs.add("H3");
        cdrs.add("L1");
        cdrs.add("L2");
        cdrs.add("L3");
        String cdr_out = "";
        String ipatch_out = "";
        for (String pdb : pdbs) {
            for (String cdr : cdrs) {
                int muts = alanine_scanning.getNumMuts(pdb, cdr);
                int m = 1;
                while (m <= muts) {
                    double ddg = alanine_scanning.getDDG(pdb, cdr, m);
                    double tpro = alanine_scanning.getTPRO(pdb, cdr, m);
                    cdr_out = String.valueOf(cdr_out) + ddg + "\n";
                    if (tpro != -1.0) {
                        ipatch_out = String.valueOf(ipatch_out) + ddg + " " + tpro + "\n";
                    }
                    ++m;
                }
            }
        }
        String res_fold = String.valueOf(userdir) + "/result_dump/Alanine_scanning/results";
        FileSystemTools.writeFile(String.valueOf(res_fold) + "/ipatch.txt", ipatch_out);
        FileSystemTools.writeFile(String.valueOf(res_fold) + "/cdr.txt", cdr_out);
    }

    public static ArrayList<String> getPdbs() {
        String pdbs_file = String.valueOf(userdir) + "/result_dump/Alanine_scanning/scan_pdbs.txt";
        ArrayList<String> lines = FileSystemTools.readFile(pdbs_file);
        ArrayList<String> pdbs = new ArrayList<String>();
        for (String line : lines) {
            pdbs.add(line);
        }
        return pdbs;
    }

    public static int getNumMuts(String pdb, String cdr) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/Tests/ABPonom/" + pdb + "/" + cdr + ".pdb");
        return lines.get(0).length() - 1;
    }

    public static double getTPRO(String pdb, String cdr, int mutant) {
        String tpro_fold = String.valueOf(userdir) + "/result_dump/Alanine_scanning/single_tpro";
        String map_fold = String.valueOf(userdir) + "/result_dump/Alanine_scanning/chain_maps";
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(map_fold) + "/" + pdb + "_" + cdr + ".pdb");
        int target_seq = -1;
        for (String line : lines) {
            int seq_id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            int mut = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            if (mut != mutant) continue;
            target_seq = seq_id;
            break;
        }
        lines = FileSystemTools.readFile(String.valueOf(tpro_fold) + "/" + pdb);
        double target_tpro = -1.0;
        for (String line : lines) {
            int seq_id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            line = line.substring(line.indexOf(" ") + 1);
            double TPRO = Double.parseDouble(line.substring(0, line.indexOf(" ")));
            line = line.substring(line.indexOf(" ") + 1);
            String tf = line.replace(" ", "");
            boolean contact = false;
            if (tf.equals("true")) {
                contact = true;
            }
            if (seq_id != target_seq || !contact) continue;
            target_tpro = TPRO;
            break;
        }
        return target_tpro;
    }

    public static double getDDG(String pdb, String cdr, int mutant) {
        String ene_fold = String.valueOf(userdir) + "/result_dump/Alanine_scanning/alanine_out";
        ArrayList<String> mt_line = FileSystemTools.readFile(String.valueOf(ene_fold) + "/mt_" + pdb + cdr + mutant + ".txt");
        ArrayList<String> wt_line = FileSystemTools.readFile(String.valueOf(ene_fold) + "/wt_" + pdb + cdr + mutant + ".txt");
        String mt = mt_line.get(0);
        String wt = wt_line.get(0);
        double mt_ddg = alanine_scanning.getEnergy(mt);
        double wt_ddg = alanine_scanning.getEnergy(wt);
        double ddg = mt_ddg - wt_ddg;
        return ddg;
    }

    public static double getEnergy(String line) {
        String ene = "";
        int space_count = 0;
        int i = 1;
        while (i < line.length()) {
            if (line.charAt(i - 1) != '\t' && line.charAt(i) == '\t') {
                ++space_count;
            }
            if (space_count == 5) {
                ene = String.valueOf(ene) + line.charAt(i);
            }
            if (space_count == 6) break;
            ++i;
        }
        ene = ene.replace("\t", "");
        return Double.parseDouble(ene);
    }
}

