/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import data_structures.Residue_type;
import docking.Visualization;
import docking_global.DockingDistances;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDBStandardizer;
import parsing.PDB_parser;
import utils.FileSystemTools;
import utils.WebTools;

public class ADARS {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        ADARS.extendedEpis();
    }

    public static void getLengths() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dock_bench.txt");
        int prog = 0;
        ArrayList<String> outs = new ArrayList<String>();
        for (String pdb : pdbs) {
            String solution;
            System.out.println(String.valueOf(pdb) + " : " + ++prog + "/" + pdbs.size());
            String fold_name = solution = FileSystemTools.getColumn(pdb, 1).substring(0, pdb.indexOf("_"));
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name.toLowerCase() + "/AG.pdb", 'A');
            outs.add("'" + pdb.substring(0, 4).toLowerCase() + " " + ab_sol.size() + " " + ag_sol.size() + "'");
        }
        FileSystemTools.writeFile("lengths.txt", outs);
    }

    public static void extendedEpis() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dock_bench.txt");
        int prog = 0;
        for (String pdb : pdbs) {
            String solution;
            System.out.println(String.valueOf(pdb) + " : " + ++prog + "/" + pdbs.size());
            String fold_name = solution = FileSystemTools.getColumn(pdb, 1).substring(0, pdb.indexOf("_"));
            HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AG.pdb", 'A');
            double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
            ArrayList<Integer> ag_cons_corr = DockingDistances.augmentBinding(ag_sol, 0.0);
            ArrayList<Integer> ag_cons_ext = DockingDistances.augmentBinding(ag_sol, 5.0);
            ArrayList<Integer> ag_cons_IRMSD = DockingDistances.augmentBinding(ag_sol, 10.0);
            ArrayList<Integer> ab_cons_corr = DockingDistances.augmentBinding(ab_sol, 0.0);
            ArrayList<Integer> ab_cons_IRMSD = DockingDistances.augmentBinding(ab_sol, 10.0);
            HashMap<Integer, String> cols = new HashMap<Integer, String>();
            for (Integer i : ag_sol.keySet()) {
                if (ag_cons_corr.contains(i)) {
                    cols.put(i, "100");
                    continue;
                }
                if (ag_cons_ext.contains(i)) {
                    cols.put(i, "75");
                    continue;
                }
                if (ag_cons_IRMSD.contains(i)) {
                    cols.put(i, "25");
                    continue;
                }
                cols.put(i, "0");
            }
            ArrayList<String> ag_ext = new ArrayList<String>();
            for (Integer i : ag_sol.keySet()) {
                if (ag_cons_ext.contains(i)) continue;
                ag_ext.add("" + i);
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/epitope.txt", ag_ext);
            ArrayList<String> ab_IRMSD = new ArrayList<String>();
            for (Integer i : ab_cons_IRMSD) {
                ab_IRMSD.add("" + i);
            }
            ArrayList<String> ag_IRMSD = new ArrayList<String>();
            for (Integer i : ag_cons_IRMSD) {
                ag_IRMSD.add("" + i);
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/IRMSD/" + fold_name.toLowerCase() + "_AB.txt", ab_IRMSD);
            FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/IRMSD/" + fold_name.toLowerCase() + "_AG.txt", ag_IRMSD);
            Visualization.colorStruc(String.valueOf(fold_name) + "_AG", ag_sol, cols);
            cols = new HashMap();
            for (Integer i : ab_sol.keySet()) {
                if (ab_cons_corr.contains(i)) {
                    cols.put(i, "100");
                    continue;
                }
                if (ab_cons_IRMSD.contains(i)) {
                    cols.put(i, "25");
                    continue;
                }
                cols.put(i, "0");
            }
            Visualization.colorStruc(String.valueOf(fold_name) + "_AB", ab_sol, cols);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void annotateCDRs() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dock_bench.txt");
        for (String pdb : pdbs) {
            void var11_13;
            HashMap<Object, Object> res;
            String solution;
            String fold_name = solution = FileSystemTools.getColumn(pdb, 1).substring(0, pdb.indexOf("_"));
            String sol_ab = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String sol_ag = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf(":") + 1);
            System.out.println(fold_name);
            ArrayList<Integer> cdrs = new ArrayList<Integer>();
            Residue_type[] sol = PDB_parser.getSeqFromPDB(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            if (fold_name.equals("1QF1")) {
                res = new HashMap<String, String>();
                res.put("H1", "DYTFTSYW");
                res.put("H2", "INPTNGRT");
                res.put("H3", "ARRYGNSFDY");
                res.put("L1", "EDSYGNSF");
                res.put("L2", "RAS");
                res.put("L3", "QQSDEYPYMYT");
            } else if (fold_name.equals("1QF2")) {
                res = new HashMap();
                res.put("H1", "GFAFSSFD");
                res.put("H2", "ITNVGTYT");
                res.put("H3", "ARQGTAAQPYWYFDV");
                res.put("L1", "ETVDSF");
                res.put("L2", "GAS");
                res.put("L3", "GQTYNHPYTFGG");
            } else if (fold_name.equals("2I25")) {
                res = new HashMap();
                res.put("H1", "DSRCVLST");
                res.put("H3", "KPESRYGSYDAVCAALN");
            } else if (fold_name.equals("1FSK")) {
                res = new HashMap();
                res.put("H1", "GYTFTSYW");
                res.put("H2", "IFPSDSYT");
                res.put("H3", "TRGARDTWFAY");
                res.put("L1", "ENVDTY");
                res.put("L2", "GPS");
                res.put("L3", "GQSYSYPYT");
            } else if (fold_name.equals("1KXQ")) {
                res = new HashMap();
                res.put("H1", "TYTDT");
                res.put("H2", "IYRRTGYT");
                res.put("H3", "ATGNSVRLASWEGYFY");
            } else {
                res = WebTools.downloadCDRRealChain(fold_name.substring(0, 4).toUpperCase(), sol_ab);
            }
            String seq = "";
            boolean bl = false;
            while (var11_13 < sol.length) {
                seq = String.valueOf(seq) + (Object)((Object)sol[var11_13]);
                ++var11_13;
            }
            System.out.println("Sequence: \n" + seq);
            for (String string : res.keySet()) {
                System.out.println(String.valueOf(string) + " : " + (String)res.get(string) + " : " + seq.indexOf((String)res.get(string)));
                if (seq.indexOf((String)res.get(string)) == -1) {
                    System.err.println("ERR");
                    System.exit(0);
                    continue;
                }
                int start_ini = seq.indexOf((String)res.get(string)) + 1;
                int start = seq.indexOf((String)res.get(string)) + 1;
                while (start < start_ini + ((String)res.get(string)).length()) {
                    cdrs.add(start);
                    ++start;
                }
            }
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            int i2 = 0;
            while (i2 < sol.length) {
                if (cdrs.contains(i2 + 1)) {
                    hashMap.put(i2 + 1, "100");
                } else {
                    hashMap.put(i2 + 1, "0");
                }
                ++i2;
            }
            HashMap<Integer, Residue> str = PDB_parser.parse(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            Visualization.colorStruc(String.valueOf(fold_name) + "_CDR", str, hashMap);
            ArrayList<String> cdr_constr = new ArrayList<String>();
            for (Integer i3 : str.keySet()) {
                if (cdrs.contains(i3)) continue;
                cdr_constr.add("" + i3);
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/paratope.txt", cdr_constr);
            FileSystemTools.writeFile(String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name.toLowerCase() + "/paratope.txt", cdr_constr);
        }
    }

    public static void Verify() {
        ADARS.createdata();
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dock_bench.txt");
        ArrayList codes = new ArrayList();
        block0: for (String pdb : pdbs) {
            String solution;
            String fold_name = solution = FileSystemTools.getColumn(pdb, 1).substring(0, pdb.indexOf("_"));
            String sol_ab = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String sol_ag = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf(":") + 1);
            Residue_type[] sol = PDB_parser.getSeqFromPDB(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            Residue_type[] dat = PDB_parser.getSeqFromPDB(String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name.toLowerCase() + "/AB.pdb", 'A');
            System.out.println("AB " + fold_name + " : " + sol.length + " : " + dat.length);
            if (sol.length != dat.length) {
                System.out.println("Lengths dont match");
                System.exit(0);
            }
            int i = 0;
            while (i < sol.length) {
                if (sol[i] != sol[i]) {
                    System.out.println(String.valueOf(fold_name) + " : " + i + " : " + (Object)((Object)sol[i]) + " : " + (Object)((Object)dat[i]));
                    break;
                }
                ++i;
            }
            sol = PDB_parser.getSeqFromPDB(String.valueOf(userdir) + "/resources/adars/solution/" + fold_name.toLowerCase() + "/AG.pdb", 'A');
            dat = PDB_parser.getSeqFromPDB(String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name.toLowerCase() + "/AG.pdb", 'A');
            System.out.println("AG " + fold_name + " : " + sol.length + " : " + dat.length);
            if (sol.length != dat.length) {
                System.out.println("Lengths dont match");
                System.exit(0);
            }
            i = 0;
            while (i < sol.length) {
                if (sol[i] != dat[i]) {
                    System.out.println(String.valueOf(fold_name) + " : " + i + " : " + (Object)((Object)sol[i]) + " : " + (Object)((Object)dat[i]));
                    continue block0;
                }
                ++i;
            }
        }
    }

    public static void createdata() {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/adars/dock_bench.txt");
        ArrayList codes = new ArrayList();
        for (String pdb : pdbs) {
            String solution;
            String fold_name = solution = FileSystemTools.getColumn(pdb, 1).substring(0, pdb.indexOf("_"));
            File f = new File(String.valueOf(userdir) + "/resources/adars/solution/" + solution.toLowerCase());
            if (!f.exists()) {
                f.mkdir();
            }
            if (!(f = new File(String.valueOf(userdir) + "/resources/adars/dataset/" + solution.toLowerCase())).exists()) {
                f.mkdir();
            }
            String sol_ab = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf("_") + 1, pdb.indexOf(":"));
            String sol_ag = FileSystemTools.getColumn(pdb, 1).substring(pdb.indexOf(":") + 1);
            String out_ab = String.valueOf(userdir) + "/resources/adars/solution/" + fold_name + "/AB.pdb";
            String out_ag = String.valueOf(userdir) + "/resources/adars/solution/" + fold_name + "/AG.pdb";
            solution = solution.substring(0, 4);
            String raw_file = String.valueOf(userdir) + "/resources/adars/raw/" + solution.toUpperCase() + ".pdb";
            PDBStandardizer.standardize(raw_file, out_ab, sol_ab);
            PDBStandardizer.standardize(raw_file, out_ag, sol_ag);
            String ab = FileSystemTools.getColumn(pdb, 3).substring(0, 4);
            String ab_ch = FileSystemTools.getColumn(pdb, 3).substring(pdb.indexOf("_") + 1);
            System.out.println(FileSystemTools.getColumn(pdb, 5));
            String ag = FileSystemTools.getColumn(pdb, 5).substring(0, 4);
            String ag_ch = FileSystemTools.getColumn(pdb, 5).substring(pdb.indexOf("_") + 1);
            out_ab = String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name + "/AB.pdb";
            out_ag = String.valueOf(userdir) + "/resources/adars/dataset/" + fold_name + "/AG.pdb";
            String raw_ab = String.valueOf(userdir) + "/resources/adars/raw/" + ab.toUpperCase() + ".pdb";
            String raw_ag = String.valueOf(userdir) + "/resources/adars/raw/" + ag.toUpperCase() + ".pdb";
            PDBStandardizer.standardize(raw_ab, out_ab, ab_ch);
            PDBStandardizer.standardize(raw_ag, out_ag, ag_ch);
            System.out.println("Sol " + solution + " " + sol_ab + " " + sol_ag);
            System.out.println("Ab " + ab + " " + ab_ch);
            System.out.println("Ag " + ag + " " + ag_ch);
        }
    }

    public static String getStats(ArrayList<Integer> pred, ArrayList<Integer> ext, ArrayList<Integer> real) {
        double got_tot = 0.0;
        for (Integer i : real) {
            if (!ext.contains(i)) continue;
            got_tot += 1.0;
        }
        double ext_prec = got_tot / (double)ext.size();
        ext_prec = (double)Math.round(ext_prec * 100.0) / 100.0;
        double ext_rec = got_tot / (double)real.size();
        ext_rec = (double)Math.round(ext_rec * 100.0) / 100.0;
        got_tot = 0.0;
        for (Integer i : real) {
            if (!pred.contains(i)) continue;
            got_tot += 1.0;
        }
        double pred_prec = got_tot / (double)pred.size();
        pred_prec = (double)Math.round(pred_prec * 100.0) / 100.0;
        double pred_rec = got_tot / (double)real.size();
        pred_rec = (double)Math.round(pred_rec * 100.0) / 100.0;
        double ratio = (double)pred.size() / (double)ext.size();
        ratio = (double)Math.round(ratio * 100.0) / 100.0;
        String out_line = String.valueOf(ratio) + " " + ext_rec + " " + ext_prec + " " + pred_rec + " " + pred_prec;
        return out_line;
    }
}

