/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking.DockingAnalyzer;
import docking_global.DockingDistances;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class CalculateGlobalMatrix {
    private static final String userdir = System.getProperty("user.dir");
    private static final String temp_dir = String.valueOf(userdir) + "/temp_dump";
    private static final String temp_AB = String.valueOf(temp_dir) + "/tempAB.pdb";
    private static final String temp_AG = String.valueOf(temp_dir) + "/tempAG.pdb";

    public static void main(String[] args) {
        ArrayList<String> pdbs = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/pdbs.txt");
        double[][] tp = new double[20][20];
        double[][] fp = new double[20][20];
        int prog = 0;
        int run = 4;
        while (run < 5) {
            for (String pdb_code : pdbs) {
                int i2;
                ++prog;
                if (pdb_code.equals("2b4c") || pdb_code.equals("2qr0") || pdb_code.equals("1bgx")) continue;
                String ab_dir = "/Volumes/NOAH/global_trainin/zdock_runs/training_cases/done_runs/" + run + "/" + pdb_code;
                System.out.println(pdb_code);
                String ag_folder = String.valueOf(userdir) + "/protein_database/standard_pono";
                HashMap<Integer, Residue> ab_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb", 'A');
                HashMap<Integer, Residue> ag_sol = PDB_parser.parse(String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb", 'A');
                double[][] cons = DockingDistances.extractCons(ab_sol, ag_sol);
                HashMap<Integer, Boolean> ab_surf = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_A.pdb");
                HashMap<Integer, Boolean> ag_surf = PSA.runPSA(7.5, String.valueOf(ag_folder) + "/" + pdb_code.toUpperCase() + "_B.pdb");
                for (int i2 : ab_sol.keySet()) {
                    for (int j : ag_sol.keySet()) {
                        if (ab_surf.get(i2).booleanValue() && ag_surf.get(j).booleanValue() || cons[i2][j] != 1.0) continue;
                        cons[i2][j] = 0.0;
                    }
                }
                i2 = 1;
                while (i2 < 500) {
                    System.out.println(String.valueOf(prog) + " " + i2);
                    DockingAnalyzer.createTemp(String.valueOf(ab_dir) + "/complex." + i2 + ".pdb", "");
                    HashMap<Integer, Residue> ab_decoy = PDB_parser.parse(temp_AB, 'A');
                    HashMap<Integer, Residue> ag_decoy = PDB_parser.parse(temp_AG, 'A');
                    CalculateGlobalMatrix.calcTPFP(ab_decoy, ag_decoy, cons, tp, fp, ab_surf, ag_surf);
                    ++i2;
                }
            }
            ++run;
        }
        MathFunctions.printParsable2D(tp, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/corr_pars_global.txt");
        MathFunctions.printParsable2D(fp, String.valueOf(userdir) + "/result_dump/Docking/binding_profiles/incorr_pars_global.txt");
    }

    public static void calcTPFP(HashMap<Integer, Residue> ab_decoy, HashMap<Integer, Residue> ag_decoy, double[][] corr_map, double[][] tp, double[][] fp, HashMap<Integer, Boolean> ab_surf, HashMap<Integer, Boolean> ag_surf) {
        for (Integer i_ab : ab_decoy.keySet()) {
            if (!ab_surf.get(i_ab).booleanValue()) continue;
            Residue ab_res = ab_decoy.get(i_ab);
            for (Integer i_ag : ag_decoy.keySet()) {
                Residue ag_res;
                if (!ag_surf.get(i_ag).booleanValue() || !(ab_res.distanceFrom(ag_res = ag_decoy.get(i_ag)) < 4.5)) continue;
                if (corr_map[i_ab][i_ag] == 1.0) {
                    double[] dArray = tp[ab_res.type.ordinal()];
                    int n = ag_res.type.ordinal();
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                double[] dArray = fp[ab_res.type.ordinal()];
                int n = ag_res.type.ordinal();
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }
}

