/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import data_structures.Residue;
import docking_global.DockingDistances;
import java.util.ArrayList;
import java.util.HashMap;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;

public class Misc {
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/GlobalDocking/ResTables/fnat_raw.txt");
        for (String line : lines) {
            String pdb = FileSystemTools.getColumn(line, 1);
            double _rank = Double.parseDouble(FileSystemTools.getColumn(line, 3));
            int rank = (int)_rank;
            double fnat = Double.parseDouble(FileSystemTools.getColumn(line, 5));
            String irmsd = FileSystemTools.getColumn(line, 6);
            System.out.println("rs = new ResStruc(" + rank + "," + irmsd + ");");
            System.out.println("rs.fnat = " + fnat + ";");
            System.out.println("gegner.put(\"" + pdb.toLowerCase() + "\", rs);");
        }
    }

    public static void surfs() {
        ArrayList<String> xf = new ArrayList<String>();
        xf.add("1AWH");
        xf.add("1BGX");
        xf.add("1BJ1");
        xf.add("1BQL");
        xf.add("1BVK");
        xf.add("1DQJ");
        xf.add("1E6J");
        xf.add("1FSK");
        xf.add("1I9R");
        xf.add("1IQD");
        xf.add("1JHL");
        xf.add("1JPS");
        xf.add("1K4C");
        xf.add("1MLC");
        xf.add("1NCA");
        xf.add("1NSN");
        xf.add("1P2C");
        xf.add("1QFW");
        xf.add("1VFB");
        xf.add("1WEJ");
        xf.add("2DD8");
        xf.add("2FD6");
        xf.add("2JEL");
        xf.add("2VIS");
        xf.add("3CVH");
        xf.add("3EO1");
        xf.add("3GJF");
        xf.add("3HI6");
        double tot = 0.0;
        for (String pdb : xf) {
            System.out.println(pdb);
            String ag_file = String.valueOf(userdir) + "/dataset/" + pdb.toLowerCase() + "/AG.pdb";
            HashMap<Integer, Boolean> ag_surface_exp = PSA.runPSA(7.5, ag_file);
            ArrayList<String> out = new ArrayList<String>();
            for (Integer i : ag_surface_exp.keySet()) {
                if (!ag_surface_exp.get(i).booleanValue()) continue;
                out.add("" + i);
            }
            FileSystemTools.writeFile(String.valueOf(userdir) + "/dataset/surface/" + pdb + ".txt", out);
        }
        System.out.println(String.valueOf(tot) + "/" + xf.size());
    }

    public static void get10A() {
        ArrayList<String> pdbs = FileSystemTools.getFolders(String.valueOf(userdir) + "/resources/xf_test/dataset");
        for (String pdb : pdbs) {
            String ab_file = String.valueOf(userdir) + "/resources/xf_test/dataset/" + pdb + "/AB.pdb";
            String ag_file = String.valueOf(userdir) + "/resources/xf_test/dataset/" + pdb + "/AG.pdb";
            HashMap<Integer, Residue> ab = PDB_parser.parse(ab_file, 'A');
            HashMap<Integer, Residue> ag = PDB_parser.parse(ag_file, 'A');
            DockingDistances.extractCons(ab, ag);
            ArrayList<Integer> ab_a = DockingDistances.augmentBinding(ab, 10.0);
            ArrayList<Integer> ag_a = DockingDistances.augmentBinding(ag, 10.0);
            FileSystemTools.writeFileInts(String.valueOf(userdir) + "/result_dump/GlobalDocking/IRMSD/" + pdb.toLowerCase() + "_AB.txt", ab_a);
            FileSystemTools.writeFileInts(String.valueOf(userdir) + "/result_dump/GlobalDocking/IRMSD/" + pdb.toLowerCase() + "_AG.txt", ag_a);
        }
    }
}

