/*
 * Decompiled with CFR 0.152.
 */
package docking_global;

import docking_global.BatchAnalyzerGlobal;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import utils.FileSystemTools;
import utils.MathFunctions;

public class ResultSorter {
    private static final String curr_scoring = "rescored_local";
    private static final String constr_curr_scoring = "rescored_local";
    private static final int distro = 200;
    private static int top_rank = 5;
    private static int to_add = 2;
    private static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        int w = ResultSorter.ZDOCKAdarsConstr(3);
    }

    public static void runStudy() {
        int best = 0;
        int ta = 0;
        while (ta < 7) {
            int r = 0;
            while (r < 40) {
                top_rank = r;
                to_add = ta;
                int w = ResultSorter.ZDOCKAdarsConstr(3);
                if (w > best) {
                    System.out.println(String.valueOf(ta) + " " + r + " got " + w);
                    best = w;
                }
                ++r;
            }
            ++ta;
        }
    }

    public static void compareCorrectness() {
        String test = "zdock";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_4_H");
        cases.add("paratome_4_H");
        cases.add("ipatch_4_H");
        cases.add("correct_4_H");
        cases.add("cdr_4_R");
        cases.add("paratome_4_R");
        cases.add("ipatch_4_R");
        cases.add("correct_4_R");
        for (String _case_temp : cases) {
            System.out.println(_case_temp);
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                System.out.println(pdb);
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Integer, Double> recalls = new HashMap<Integer, Double>();
                HashMap<Integer, Double> avgs = new HashMap<Integer, Double>();
                ArrayList<Double> scores = new ArrayList<Double>();
                int i = 0;
                while (i < 5) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    double rec = ResultSorter.getRecall(pdb, test, "zdock_" + _case, "1");
                    recalls.put(i, rec);
                    System.out.println(String.valueOf(i) + " : " + rec);
                    int run = 1;
                    while (run < 6) {
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                        all_res.putAll(res);
                        for (Double d : res.keySet()) {
                            scores.add(d);
                        }
                        ++run;
                    }
                    avgs.put(i, MathFunctions.Mean(scores));
                    System.out.println(String.valueOf(i) + " : " + MathFunctions.Mean(scores));
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
        }
    }

    public static double getRecall(String pdb, String test, String _case, String run) {
        ArrayList<String> in_epi = FileSystemTools.readFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/input/" + _case + "/" + pdb + "/epitope.txt");
        ArrayList<String> corr_in = FileSystemTools.readFile("/Users/bielasek/Sites/Dropbox/workspace/I-Patch/result_dump/Docking/docking_dataset/solution_residues/" + pdb + "_ag.txt");
        ArrayList<Integer> corrs = new ArrayList<Integer>();
        for (String s : corr_in) {
            corrs.add(Integer.parseInt(s));
        }
        ArrayList<Integer> epi = new ArrayList<Integer>();
        for (String s : in_epi) {
            epi.add(Integer.parseInt(s));
        }
        double corr = 0.0;
        Iterator iterator = corrs.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (epi.contains(i)) continue;
            corr += 1.0;
        }
        return corr / (double)corrs.size();
    }

    public static void PredictedConstraintsReduced() {
        String test = "global_red";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_H");
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                int i = 0;
                while (i < 1) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while (run < 2) {
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecRandom(int tops) {
        String test = "zdock_HR_rand";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Integer, Double> ranking = new HashMap<Integer, Double>();
                int i = 0;
                while (i < 20) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    double score = 0.0;
                    int run = 1;
                    while (run < 6) {
                        score = ResultSorter.getAverage("zdock_" + _case, pdb, run, test);
                        ++run;
                    }
                    ranking.put(i, score /= 5.0);
                    ++i;
                }
                ArrayList<Integer> useus = ResultSorter.exploreRanking("zdock_ipatch_0_R", pdb, ranking, tops);
                int i2 = 0;
                while (i2 < 20) {
                    if (useus.contains(i2)) {
                        String _case = _case_temp.replace("_4_", "_" + i2 + "_");
                        int run = 1;
                        while (run < 6) {
                            HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                            all_res.putAll(res);
                            ++run;
                        }
                    }
                    ++i2;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecPredictedCockatrice(int tops, int cutoff) {
        String test = "zdock_HR";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Double, Integer> runs = new HashMap<Double, Integer>();
                HashMap<Double, Integer> ids = new HashMap<Double, Integer>();
                HashMap<Double, Integer> pdb_id = new HashMap<Double, Integer>();
                int i = 0;
                while (i < 20) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while (run < 6) {
                        System.out.println(String.valueOf(pdb) + ", case : " + i + " run " + run);
                        ReturnStruc rs = ResultSorter.getTop10Full("zdock_" + _case, pdb, run, test);
                        HashMap<Double, Double> res = rs.score_map;
                        HashMap<Double, Integer> decoy_map = rs.decoy_map;
                        all_res.putAll(res);
                        for (Double d : res.keySet()) {
                            runs.put(d, run);
                            ids.put(d, i);
                            pdb_id.put(d, decoy_map.get(d));
                        }
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                ArrayList<String> recprec_out = new ArrayList<String>();
                System.out.println("Analyzing the recall/precision...");
                for (ResStruc rs : top10) {
                    double score = rs.score;
                    int run = (Integer)runs.get(score);
                    int id = (Integer)ids.get(score);
                    double irmsd = rs.irmsd;
                    int decoy_id = (Integer)pdb_id.get(score);
                    String out = BatchAnalyzerGlobal.AnalyzeCaseSingle("zdock_ipatch_0_R".replace("_0_", "_" + id + "_"), String.valueOf(run), cutoff, pdb, decoy_id);
                    recprec_out.add(String.valueOf(out) + " " + irmsd);
                    System.out.println(String.valueOf(pdb) + " " + id + " " + run + " " + decoy_id + " " + score + " " + irmsd);
                }
                FileSystemTools.writeFile(String.valueOf(result_folder) + "/" + pdb + ".txt", recprec_out);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecPredicted(int tops) {
        String test = "zdock_HR";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Integer, Double> ranking = new HashMap<Integer, Double>();
                int i = 0;
                while (i < 20) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    double score = 0.0;
                    int run = 1;
                    while (run < 6) {
                        score = ResultSorter.getAverage("zdock_" + _case, pdb, run, test);
                        ++run;
                    }
                    ranking.put(i, score /= 5.0);
                    ++i;
                }
                HashMap<Double, Integer> runs = new HashMap<Double, Integer>();
                HashMap<Double, Integer> ids = new HashMap<Double, Integer>();
                HashMap<Double, Integer> pdb_id = new HashMap<Double, Integer>();
                int i2 = 0;
                while (i2 < 20) {
                    String _case = _case_temp.replace("_4_", "_" + i2 + "_");
                    int run = 1;
                    while (run < 6) {
                        ReturnStruc returnStruc = ResultSorter.getTop10Full("zdock_" + _case, pdb, run, test);
                        HashMap<Double, Double> res = returnStruc.score_map;
                        HashMap<Double, Integer> decoy_map = returnStruc.decoy_map;
                        HashMap<Double, Double> temp = new HashMap<Double, Double>();
                        for (Double d : res.keySet()) {
                            temp.put(d + (Double)ranking.get(i2), res.get(d));
                        }
                        all_res.putAll(res);
                        for (Double d : res.keySet()) {
                            runs.put(d, run);
                            ids.put(d, i2);
                            pdb_id.put(d, decoy_map.get(d));
                        }
                        ++run;
                    }
                    ++i2;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                for (ResStruc resStruc : top10) {
                    double score = resStruc.score;
                    int run = (Integer)runs.get(score);
                    int id = (Integer)ids.get(score);
                    double irmsd = resStruc.irmsd;
                    int decoy_id = (Integer)pdb_id.get(score);
                    System.out.println(String.valueOf(pdb) + " " + id + " " + run + " " + decoy_id + " " + score + " " + irmsd);
                }
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double d = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    d = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + d + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static int ZDOCKAdarsConstr(int o2ps) {
        int c_ours = 0;
        int c_theirs = 0;
        String test = "zdock_XF_US";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1awh");
        pdbs.add("1bgx");
        pdbs.add("1bj1");
        pdbs.add("1bql");
        pdbs.add("1bvk");
        pdbs.add("1dqj");
        pdbs.add("1e6j");
        pdbs.add("1fsk");
        pdbs.add("1i9r");
        pdbs.add("1iqd");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1nsn");
        pdbs.add("1p2c");
        pdbs.add("1qfw");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("2dd8");
        pdbs.add("2fd6");
        pdbs.add("2him");
        pdbs.add("2jel");
        pdbs.add("2vis");
        pdbs.add("3cvh");
        pdbs.add("3eo1");
        pdbs.add("3gjf");
        pdbs.add("3hi6");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_4");
        int w = 0;
        int draw = 0;
        int l = 0;
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c ||c}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars} & Win\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD & Win \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Double, Double> all_res_fnat = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                HashMap<Double, Integer> stdmap = new HashMap<Double, Integer>();
                TreeSet<Double> sorted = new TreeSet<Double>();
                int i = 0;
                while (i < 3) {
                    String _case = _case_temp.replace("_4", "_" + i);
                    int run = 1;
                    while (run < 2) {
                        HashMap<Double, Double> res = ResultSorter.getTopN(_case, pdb, run, test, 200);
                        ArrayList<Double> scores = new ArrayList<Double>();
                        for (Double d : res.keySet()) {
                            scores.add(d + Math.random() / 1.0E8);
                        }
                        double mean = MathFunctions.getMeanDouble(scores);
                        double std = MathFunctions.getStdDevDouble(scores);
                        System.out.println(String.valueOf(i) + " Mean = " + mean);
                        System.out.println(String.valueOf(i) + " Std = " + std);
                        std *= std;
                        stdmap.put(mean / std, i);
                        sorted.add(mean / std);
                        ++run;
                    }
                    ++i;
                }
                ArrayList<Integer> eligible = new ArrayList<Integer>();
                int added = 0;
                for (Double d : sorted.descendingSet()) {
                    if (added > to_add) break;
                    eligible.add((Integer)stdmap.get(d));
                    ++added;
                }
                int i2 = 0;
                while (i2 < 3) {
                    if (!eligible.contains(i2)) {
                        System.out.println("Skipping " + i2);
                    } else {
                        String _case = _case_temp.replace("_4", "_" + i2);
                        int run = 1;
                        while (run < 2) {
                            HashMap<Double, Double> res = ResultSorter.getTop10(_case, pdb, run, test);
                            HashMap<Double, Double> fnat = ResultSorter.getTop10FNAT(_case, pdb, run, test);
                            ArrayList<String> parti = new ArrayList<String>();
                            for (Double d : res.keySet()) {
                                parti.add(d + " " + res.get(d));
                            }
                            File f = new File(String.valueOf(userdir) + "/result_dump/adars/" + pdb);
                            if (!f.exists()) {
                                f.mkdir();
                            }
                            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/adars/" + pdb + "/" + _case + ".txt", parti);
                            all_res.putAll(res);
                            all_res_fnat.putAll(fnat);
                            ++run;
                        }
                    }
                    ++i2;
                }
                double grmsd = -1.0;
                double gfnat = -1.0;
                double grank = -1.0;
                String tag = "";
                grmsd = gegner.get((Object)pdb).irmsd;
                grank = gegner.get((Object)pdb).rank;
                gfnat = gegner.get((Object)pdb).fnat;
                outline = String.valueOf(outline) + grank + " & " + gfnat + "(" + grmsd + ")& ";
                if (gegner.containsKey(pdb)) {
                    ResStruc rs_s = ResultSorter.getSuccessWRT(all_res, all_res_fnat, pdb, grmsd, grank);
                    outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.fnat + "(" + rs_s.irmsd + ")" + " & ";
                    if ((double)rs_s.rank == -1.0) {
                        ++l;
                        tag = "L";
                    } else if (rs_s.rank <= gegner.get((Object)pdb).rank && rs_s.irmsd <= gegner.get((Object)pdb).irmsd) {
                        ++w;
                        tag = "W";
                    } else if (rs_s.rank <= gegner.get((Object)pdb).rank || rs_s.irmsd <= gegner.get((Object)pdb).irmsd) {
                        ++draw;
                        tag = "D";
                    } else {
                        System.out.println(String.valueOf(pdb) + " <-");
                        ++l;
                        tag = "L";
                    }
                    if (rs_s.rank < 10 && ResultSorter.CapriGood(rs_s.irmsd, rs_s.fnat)) {
                        ++c_ours;
                    }
                    if (grank < 10.0 && ResultSorter.CapriGood(grmsd, gfnat)) {
                        ++c_theirs;
                    }
                }
                System.out.println("Us :" + c_ours);
                System.out.println("Them: " + c_theirs);
                System.out.println("L " + l);
                System.out.println("D " + draw);
                System.out.println("W " + w);
                outline = String.valueOf(outline) + tag + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + "rescored_local" + "_irmsd.tex", output);
        }
        return w;
    }

    public static int ZDOCKAdarsConstrFNAT(int ops) {
        int c_ours = 0;
        int c_theirs = 0;
        String test = "zdock_XF_US";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetitionFnat();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1awh");
        pdbs.add("1bgx");
        pdbs.add("1bj1");
        pdbs.add("1bql");
        pdbs.add("1bvk");
        pdbs.add("1dqj");
        pdbs.add("1e6j");
        pdbs.add("1fsk");
        pdbs.add("1i9r");
        pdbs.add("1iqd");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1nsn");
        pdbs.add("1p2c");
        pdbs.add("1qfw");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("2dd8");
        pdbs.add("2fd6");
        pdbs.add("2him");
        pdbs.add("2jel");
        pdbs.add("2vis");
        pdbs.add("3cvh");
        pdbs.add("3eo1");
        pdbs.add("3gjf");
        pdbs.add("3hi6");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_4");
        int w = 0;
        int draw = 0;
        int l = 0;
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c ||c}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars} & Win\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD & Win \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap<Double, Double> all_res_irmsd = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                HashMap<Double, Integer> stdmap = new HashMap<Double, Integer>();
                TreeSet<Double> sorted = new TreeSet<Double>();
                int i = 0;
                while (i < 3) {
                    String _case = _case_temp.replace("_4", "_" + i);
                    int run = 1;
                    while (run < 2) {
                        HashMap<Double, Double> res = ResultSorter.getTopNFNAT(_case, pdb, run, test, 200);
                        ArrayList<Double> scores = new ArrayList<Double>();
                        for (Double d : res.keySet()) {
                            scores.add(d + Math.random() / 1.0E8);
                        }
                        double mean = MathFunctions.getMeanDouble(scores);
                        double std = MathFunctions.getStdDevDouble(scores);
                        std *= std;
                        stdmap.put(mean / std, i);
                        sorted.add(mean / std);
                        ++run;
                    }
                    ++i;
                }
                ArrayList<Integer> eligible = new ArrayList<Integer>();
                int added = 0;
                for (Double d : sorted.descendingSet()) {
                    if (added > to_add) break;
                    eligible.add((Integer)stdmap.get(d));
                    ++added;
                }
                int i2 = 0;
                while (i2 < 10) {
                    if (eligible.contains(i2)) {
                        String _case = _case_temp.replace("_4", "_" + i2);
                        int run = 1;
                        while (run < 2) {
                            HashMap<Double, Double> res = ResultSorter.getTop10FNAT(_case, pdb, run, test);
                            HashMap<Double, Double> res_irmsd = ResultSorter.getTop10(_case, pdb, run, test);
                            ArrayList<String> parti = new ArrayList<String>();
                            for (Double d : res.keySet()) {
                                parti.add(d + " " + res.get(d));
                            }
                            File f = new File(String.valueOf(userdir) + "/result_dump/adars/" + pdb);
                            if (!f.exists()) {
                                f.mkdir();
                            }
                            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/adars/" + pdb + "/" + _case + ".txt", parti);
                            FileSystemTools.CopyFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/input/" + _case + "/" + pdb + "/stats.txt", String.valueOf(userdir) + "/result_dump/adars/" + pdb + "/" + _case + "_stats.txt");
                            all_res.putAll(res);
                            all_res_irmsd.putAll(res_irmsd);
                            ++run;
                        }
                    }
                    ++i2;
                }
                double grmsd = -1.0;
                double grank = -1.0;
                double girmsd = -1.0;
                String tag = "";
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).fnat;
                    girmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                    ResStruc rs_s = ResultSorter.getSuccessWRTFNAT(all_res, all_res_irmsd, pdb, grmsd, grank);
                    outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.fnat + " (" + rs_s.irmsd + ")" + " & ";
                    if (rs_s.fnat == 0.0) {
                        ++l;
                        tag = "L";
                    } else if (rs_s.rank <= gegner.get((Object)pdb).rank && rs_s.fnat >= gegner.get((Object)pdb).fnat) {
                        System.out.println(String.valueOf(rs_s.fnat) + " : " + gegner.get((Object)pdb).fnat + " (" + rs_s.irmsd + ")");
                        ++w;
                        tag = "W";
                    } else if (rs_s.rank <= gegner.get((Object)pdb).rank || rs_s.fnat >= gegner.get((Object)pdb).fnat) {
                        ++draw;
                        tag = "D";
                    } else {
                        ++l;
                        tag = "L";
                    }
                    if (rs_s.rank <= 10 && ResultSorter.CapriGood(rs_s.irmsd, rs_s.fnat)) {
                        ++c_ours;
                    }
                    if (grank <= 10.0 && ResultSorter.CapriGood(girmsd, grmsd)) {
                        ++c_theirs;
                    }
                }
                System.out.println("L " + l);
                System.out.println("D " + draw);
                System.out.println("W " + w);
                outline = String.valueOf(outline) + grank + " & " + grmsd + " (" + girmsd + ")" + "& " + tag + " \\\\ \\hline";
                System.out.println("Us :" + c_ours);
                System.out.println("Them: " + c_theirs);
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + "rescored_local" + "_fnat.tex", output);
        }
        return w;
    }

    public static boolean CapriGood(double irmsd, double fnat) {
        return fnat >= 0.1 && irmsd <= 4.0;
    }

    public static void ZDOCKAdars(int ops) {
        String test = "zdock_adars";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bj1");
        pdbs.add("1bvk");
        pdbs.add("1dqj");
        pdbs.add("1e6j");
        pdbs.add("1fsk");
        pdbs.add("1iqd");
        pdbs.add("1jps");
        pdbs.add("1kxq");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1qf1");
        pdbs.add("1qf2");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("2fd6");
        pdbs.add("2i25");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("case_4");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                int i = 0;
                while (i < 10) {
                    String _case = _case_temp.replace("_4", "_" + i);
                    int run = 1;
                    while (run < 2) {
                        HashMap<Double, Double> res = ResultSorter.getTop10(_case, pdb, run, test);
                        ArrayList<String> parti = new ArrayList<String>();
                        for (Double d : res.keySet()) {
                            parti.add(d + " " + res.get(d));
                        }
                        File f = new File(String.valueOf(userdir) + "/result_dump/adars/" + pdb);
                        if (!f.exists()) {
                            f.mkdir();
                        }
                        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/adars/" + pdb + "/" + _case + ".txt", parti);
                        FileSystemTools.CopyFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/input/" + _case + "/" + pdb + "/stats.txt", String.valueOf(userdir) + "/result_dump/adars/" + pdb + "/" + _case + "_stats.txt");
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + "rescored_local" + ".tex", output);
        }
    }

    public static void HighPrecPredictedGlobal(int tops) {
        String test = "zdock_HR_globalscore";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                int i = 0;
                while (i < 20) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 4;
                    while (run < 5) {
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecPredictedGlobalMultiple(int tops) {
        String test_early = "zdock_HR";
        String test = "zdock_HR_multiple";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                int i = 0;
                while (i < 10) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while (run < 14) {
                        String test_tmp = "";
                        test_tmp = run < 6 ? test_early : test;
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test_tmp);
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecPredictedGlobalMultipleAverage(int tops) {
        String test_early = "zdock_HR";
        String test = "zdock_HR_multiple";
        double tot_runs = 13.0;
        double tot_cases = 10.0;
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                double irmsds = 0.0;
                double ranks = 0.0;
                double denom = tot_cases * tot_runs;
                int i = 0;
                while ((double)i < tot_cases) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while ((double)run < tot_runs + 1.0) {
                        String test_tmp = "";
                        test_tmp = run < 6 ? test_early : test;
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test_tmp);
                        ResStruc rs_s = ResultSorter.getSuccess(res, pdb);
                        if (rs_s.irmsd == -1.0) {
                            denom -= 1.0;
                        } else {
                            irmsds += rs_s.irmsd;
                            ranks += (double)rs_s.rank;
                        }
                        ++run;
                    }
                    ++i;
                }
                double avg_rank = ranks / denom;
                double avg_irmsd = irmsds / denom;
                avg_rank = (double)Math.round(avg_rank * 100.0) / 100.0;
                avg_irmsd = (double)Math.round(avg_irmsd * 100.0) / 100.0;
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                System.out.println(String.valueOf(pdb) + " " + avg_rank + " " + avg_irmsd);
                outline = String.valueOf(outline) + avg_rank + " & " + avg_irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/zdock_HR_multipleAVG/" + _case_temp + ".tex", output);
        }
    }

    public static void HighPrecPredictedGlobalMultipleBest(int tops) {
        String test_early = "zdock_HR";
        String test = "zdock_HR_multiple";
        double tot_runs = 13.0;
        double tot_cases = 10.0;
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("ipatch_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                System.out.println(pdb);
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                HashMap ranking = new HashMap();
                double irmsds = 0.0;
                double ranks = 0.0;
                double denom = tot_cases * tot_runs;
                int i = 0;
                while ((double)i < tot_cases) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while ((double)run < tot_runs + 1.0) {
                        String test_tmp = "";
                        test_tmp = run < 6 ? test_early : test;
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test_tmp);
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                double avg_rank = ranks / denom;
                double avg_irmsd = irmsds / denom;
                avg_rank = (double)Math.round(avg_rank * 100.0) / 100.0;
                avg_irmsd = (double)Math.round(avg_irmsd * 100.0) / 100.0;
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                ArrayList<ResStruc> top10 = ResultSorter.getTop10(all_res);
                String result_folder = String.valueOf(userdir) + "/result_dump/global_precision/" + test;
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/zdock_HR_best/" + _case_temp + ".tex", output);
        }
    }

    public static ArrayList<Integer> exploreRanking(String _case, String pdb, HashMap<Integer, Double> ranking, int tops) {
        ArrayList<Integer> res_use = new ArrayList<Integer>();
        String pred_dir = "/Users/bielasek/Desktop/GraphAnalyzer/resources/GlobalDockingCases_predicted/zdock/" + _case + "/" + pdb;
        String stats = String.valueOf(pred_dir) + "/stats.txt";
        double curr_prec = 0.0;
        double prec_best = -1.0;
        double prec_rec = 0.0;
        for (int i : ranking.keySet()) {
            String s_read = FileSystemTools.readFile(stats.replace("_0_", "_" + i + "_")).get(0);
            double prec = Double.parseDouble(FileSystemTools.getColumn(s_read, 11));
            double rec = Double.parseDouble(FileSystemTools.getColumn(s_read, 10));
            if (!(prec > curr_prec)) continue;
            prec_best = i;
            curr_prec = prec;
            prec_rec = rec;
        }
        double curr_rec = 0.0;
        double rec_best = -1.0;
        double rec_prec = 0.0;
        for (int i : ranking.keySet()) {
            String s_read = FileSystemTools.readFile(stats.replace("_0_", "_" + i + "_")).get(0);
            double prec = Double.parseDouble(FileSystemTools.getColumn(s_read, 11));
            double rec = Double.parseDouble(FileSystemTools.getColumn(s_read, 10));
            if (!(rec > curr_rec)) continue;
            rec_best = i;
            curr_rec = rec;
            rec_prec = prec;
        }
        double avg_curr = 0.0;
        double avg_best = -1.0;
        double avg_prec = 0.0;
        double avg_rec = 0.0;
        for (int i : ranking.keySet()) {
            String s_read = FileSystemTools.readFile(stats.replace("_0_", "_" + i + "_")).get(0);
            double prec = Double.parseDouble(FileSystemTools.getColumn(s_read, 11));
            double rec = Double.parseDouble(FileSystemTools.getColumn(s_read, 10));
            double score = ranking.get(i);
            if (!(score > avg_curr)) continue;
            avg_best = i;
            avg_curr = score;
            avg_prec = prec;
            avg_rec = rec;
        }
        res_use.add((int)avg_best);
        System.out.println("=========");
        System.out.println("PDB : " + pdb);
        System.out.println("best_prec : " + prec_best + " " + prec_rec + " " + curr_prec);
        System.out.println("best_rec : " + rec_best + " " + curr_rec + " " + rec_prec);
        System.out.println("best_avg 1 : " + avg_best + " " + avg_rec + " " + avg_prec);
        ArrayList<Double> duplicates = new ArrayList<Double>();
        duplicates.add(avg_rec * avg_prec);
        int iter = 2;
        while (iter < tops + 1) {
            ranking.remove((int)avg_best);
            avg_curr = 0.0;
            avg_best = -1.0;
            avg_prec = 0.0;
            avg_rec = 0.0;
            for (int i : ranking.keySet()) {
                String s_read = FileSystemTools.readFile(stats.replace("_0_", "_" + i + "_")).get(0);
                double prec = Double.parseDouble(FileSystemTools.getColumn(s_read, 11));
                double rec = Double.parseDouble(FileSystemTools.getColumn(s_read, 10));
                double score = ranking.get(i);
                if (!(score > avg_curr) || duplicates.contains(prec * rec)) continue;
                avg_best = i;
                avg_curr = score;
                avg_prec = prec;
                avg_rec = rec;
            }
            res_use.add((int)avg_best);
            duplicates.add(avg_prec * avg_rec);
            System.out.println("best_avg " + iter + " : " + avg_best + " " + avg_rec + " " + avg_prec);
            ++iter;
        }
        return res_use;
    }

    public static void PredictedConstraints() {
        String test = "zdock";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_4_H");
        cases.add("paratome_4_H");
        cases.add("ipatch_4_H");
        cases.add("correct_4_H");
        cases.add("cdr_4_R");
        cases.add("paratome_4_R");
        cases.add("ipatch_4_R");
        cases.add("correct_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                int i = 0;
                while (i < 2) {
                    String _case = _case_temp.replace("_4_", "_" + i + "_");
                    int run = 1;
                    while (run < 2) {
                        HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                        all_res.putAll(res);
                        ++run;
                    }
                    ++i;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void noConstraints() {
        String test = "jre_test";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_4_H");
        cases.add("paratome_4_H");
        cases.add("ipatch_4_H");
        cases.add("correct_4_H");
        cases.add("cdr_4_R");
        cases.add("paratome_4_R");
        cases.add("ipatch_4_R");
        cases.add("correct_4_R");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                String _case = _case_temp;
                int run = 1;
                while (run < 6) {
                    HashMap<Double, Double> res = ResultSorter.getTop10("zdock_" + _case, pdb, run, test);
                    all_res.putAll(res);
                    ++run;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static void highprecPOC() {
        String test = "highprec";
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("R");
        cases.add("H");
        for (String _case_temp : cases) {
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{table}\\caption{" + _case_temp.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Us}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            for (String pdb : pdbs) {
                String outline = String.valueOf(pdb) + " & ";
                HashMap<Double, Double> all_res = new HashMap<Double, Double>();
                String _case = _case_temp;
                int run = 1;
                while (run < 5) {
                    HashMap<Double, Double> res = ResultSorter.getTop10(_case, pdb, run, test);
                    all_res.putAll(res);
                    ++run;
                }
                ResStruc rs_s = ResultSorter.getSuccess(all_res, pdb);
                outline = String.valueOf(outline) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                double grmsd = -1.0;
                double grank = -1.0;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                outline = String.valueOf(outline) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(outline);
            }
            output.add("\\end{tabular}\\end{table}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case_temp + ".tex", output);
        }
    }

    public static ResStruc getSuccess(HashMap<Double, Double> map, String pdb) {
        ArrayList<String> distribution = new ArrayList<String>();
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (double d : map.keySet()) {
            sorted.add(d);
        }
        int rank = sorted.size() + 1;
        double s_irmsd = -1.0;
        int s_rank = -1;
        double best_rmsd = 100.0;
        double best_score = 100.0;
        int best_rank = -1;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            --rank;
            if (map.get(d) < best_rmsd) {
                best_rmsd = map.get(d);
                best_rank = rank;
                best_score = d;
            }
            if (map.get(d) < 10.0) {
                s_irmsd = map.get(d);
                s_rank = rank;
            }
            if (rank >= 1000) continue;
            distribution.add(String.valueOf(rank) + " " + d + " " + map.get(d));
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_distributions/" + pdb + ".txt", distribution);
        return new ResStruc(s_rank, s_irmsd);
    }

    public static ResStruc getSuccessWRT(HashMap<Double, Double> map, HashMap<Double, Double> fnat, String pdb, double i, double r) {
        double d;
        ArrayList<String> distribution = new ArrayList<String>();
        TreeSet<Double> sorted = new TreeSet<Double>();
        double scores = 0.0;
        for (double d2 : map.keySet()) {
            sorted.add(d2);
        }
        int rank = 0;
        double best_rmsd = 100.0;
        double best_fnat = 0.0;
        int best_rank = 100;
        Iterator iterator = sorted.descendingSet().iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            if (rank < 20) {
                scores += d;
            }
            ++rank;
        }
        rank = 0;
        iterator = sorted.descendingSet().iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            if (map.get(d) <= 5.0 && rank < 10) {
                best_rmsd = map.get(d);
                best_rank = rank;
                best_fnat = fnat.get(d);
                break;
            }
            if ((double)rank <= r && map.get(d) <= i) {
                best_rmsd = map.get(d);
                best_fnat = fnat.get(d);
                best_rank = rank;
                break;
            }
            ++rank;
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_distributions/" + pdb + ".txt", distribution);
        ResStruc rs = new ResStruc(best_rank, best_rmsd, best_fnat);
        rs.score = scores;
        return rs;
    }

    public static ResStruc getSuccessWRTFNAT(HashMap<Double, Double> map, HashMap<Double, Double> irmsd, String pdb, double i, double r) {
        ArrayList<String> distribution = new ArrayList<String>();
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (double d : map.keySet()) {
            sorted.add(d);
        }
        int rank = sorted.size() + 1;
        double best_rmsd = 0.0;
        int best_rank = 100;
        double best_irmsd = 100.0;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if ((double)(--rank) <= r && map.get(d) >= i) {
                best_irmsd = irmsd.get(d);
                best_rmsd = map.get(d);
                best_rank = rank;
                break;
            }
            if (!(map.get(d) > best_rmsd) || rank >= best_rank) continue;
            best_irmsd = irmsd.get(d);
            System.out.println("Old " + best_rmsd);
            best_rmsd = map.get(d);
            System.out.println("New " + best_rmsd);
            System.out.println("Vs " + i);
            best_rank = rank;
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_distributions/" + pdb + ".txt", distribution);
        return new ResStruc(best_rank, best_irmsd, best_rmsd);
    }

    public static ResStruc getBest(HashMap<Double, Double> map) {
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (double d : map.keySet()) {
            sorted.add(d);
        }
        int rank = sorted.size() + 1;
        double s_irmsd = 100.0;
        int s_rank = -1;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            --rank;
            if (!(map.get(d) < 5.0)) continue;
            s_irmsd = map.get(d);
            s_rank = rank;
        }
        return new ResStruc(s_rank, s_irmsd);
    }

    public static ArrayList<ResStruc> getTop10(HashMap<Double, Double> map) {
        ArrayList<ResStruc> result = new ArrayList<ResStruc>();
        TreeSet<Double> sorted = new TreeSet<Double>();
        for (double d : map.keySet()) {
            sorted.add(d);
        }
        int rank = sorted.size() + 1;
        double s_irmsd = -1.0;
        int s_rank = -1;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if (--rank >= 11) continue;
            s_irmsd = map.get(d);
            s_rank = rank;
            ResStruc rs = new ResStruc(s_rank, s_irmsd);
            rs.score = d;
            result.add(rs);
        }
        return result;
    }

    public static void createTablesPredicted(String test) {
        HashMap results = new HashMap();
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_4_H");
        cases.add("paratome_4_H");
        cases.add("ipatch_4_H");
        cases.add("correct_4_H");
        cases.add("cdr_4_R");
        cases.add("paratome_4_R");
        cases.add("ipatch_4_R");
        cases.add("correct_4_R");
        int i = 0;
        while (i < 5) {
            for (String _case : cases) {
                _case = _case.replace("_4_", "_" + i + "_");
                System.out.println("Doing case " + _case);
                ArrayList<String> output = new ArrayList<String>();
                output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{landscape}\\begin{table}\\caption{" + _case.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c | c || c | l || c |c || c |c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Run 1}& \\multicolumn{2}{|c|}{Run 2}& \\multicolumn{2}{|c|}{Run 3}& \\multicolumn{2}{|c|}{Run 4}& \\multicolumn{2}{|c|}{Run 5}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
                int pdb_id = 0;
                for (String pdb : pdbs) {
                    String out_line = String.valueOf(pdb) + " &";
                    int run = 1;
                    while (run < 6) {
                        ResStruc rs_s = ResultSorter.getScores("zdock_" + _case, pdb, run, test);
                        out_line = String.valueOf(out_line) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                        ++run;
                    }
                    double grmsd = -1.0;
                    int grank = -1;
                    if (gegner.containsKey(pdb)) {
                        grmsd = gegner.get((Object)pdb).irmsd;
                        grank = gegner.get((Object)pdb).rank;
                    }
                    out_line = String.valueOf(out_line) + grank + " & " + grmsd + " \\\\ \\hline";
                    output.add(out_line);
                    ++pdb_id;
                }
                output.add("\\end{tabular}\\end{table}\\end{landscape}\\end{document}");
                FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case + ".tex", output);
            }
            ++i;
        }
    }

    public static void createTablesHighPrec(String test) {
        HashMap results = new HashMap();
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("H");
        cases.add("R");
        for (String _case : cases) {
            System.out.println("Doing case " + _case);
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{landscape}\\begin{table}\\caption{" + _case.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c | c || c | l || c |c || c |c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Run 1}& \\multicolumn{2}{|c|}{Run 2}& \\multicolumn{2}{|c|}{Run 3}& \\multicolumn{2}{|c|}{Run 4}& \\multicolumn{2}{|c|}{Run 5}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            int pdb_id = 0;
            for (String pdb : pdbs) {
                String out_line = String.valueOf(pdb) + " &";
                int run = 1;
                while (run < 5) {
                    ResStruc rs_s = ResultSorter.getScores(_case, pdb, run, test);
                    out_line = String.valueOf(out_line) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                    ++run;
                }
                double grmsd = -1.0;
                int grank = -1;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                out_line = String.valueOf(out_line) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(out_line);
                ++pdb_id;
            }
            output.add("\\end{tabular}\\end{table}\\end{landscape}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case + ".tex", output);
        }
    }

    public static void createTablesSimple(String test) {
        HashMap results = new HashMap();
        HashMap<String, ResStruc> gegner = ResultSorter.CreateCompetition();
        ArrayList<String> pdbs = new ArrayList<String>();
        pdbs.add("1ahw");
        pdbs.add("1bql");
        pdbs.add("1jhl");
        pdbs.add("1jps");
        pdbs.add("1k4c");
        pdbs.add("1mlc");
        pdbs.add("1nca");
        pdbs.add("1vfb");
        pdbs.add("1wej");
        pdbs.add("1ynt");
        pdbs.add("1ztx");
        pdbs.add("2aep");
        pdbs.add("2b2x");
        pdbs.add("2bdn");
        pdbs.add("2jel");
        ArrayList<String> cases = new ArrayList<String>();
        cases.add("cdr_4_H");
        cases.add("paratome_4_H");
        cases.add("ipatch_4_H");
        cases.add("correct_4_H");
        cases.add("cdr_4_R");
        cases.add("paratome_4_R");
        cases.add("ipatch_4_R");
        cases.add("correct_4_R");
        for (String _case : cases) {
            System.out.println("Doing case " + _case);
            ArrayList<String> output = new ArrayList<String>();
            output.add("\\documentclass{article}\\usepackage{lscape}\\begin{document}\\begin{landscape}\\begin{table}\\caption{" + _case.replace("_", "") + "}\\begin{tabular}{ | c || c | c || c | c || c | l || c |c || c |c || c |c |}\\hline" + "\n pdb & \\multicolumn{2}{|c|}{Run 1}& \\multicolumn{2}{|c|}{Run 2}& \\multicolumn{2}{|c|}{Run 3}& \\multicolumn{2}{|c|}{Run 4}& \\multicolumn{2}{|c|}{Run 5}& \\multicolumn{2}{|c|}{Adars}\\\\ \\hline" + "\n pdb &rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD & rank&iRMSD \\\\ \\hline \\hline");
            int pdb_id = 0;
            for (String pdb : pdbs) {
                String out_line = String.valueOf(pdb) + " &";
                int run = 1;
                while (run < 6) {
                    ResStruc rs_s = ResultSorter.getScores("zdock_" + _case, pdb, run, test);
                    out_line = String.valueOf(out_line) + rs_s.rank + " & " + rs_s.irmsd + " & ";
                    ++run;
                }
                double grmsd = -1.0;
                int grank = -1;
                if (gegner.containsKey(pdb)) {
                    grmsd = gegner.get((Object)pdb).irmsd;
                    grank = gegner.get((Object)pdb).rank;
                }
                out_line = String.valueOf(out_line) + grank + " & " + grmsd + " \\\\ \\hline";
                output.add(out_line);
                ++pdb_id;
            }
            output.add("\\end{tabular}\\end{table}\\end{landscape}\\end{document}");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/global_toplevel/" + test + "/" + _case + ".tex", output);
        }
    }

    public static HashMap<String, ResStruc> CreateCompetition() {
        HashMap<String, ResStruc> gegner = new HashMap<String, ResStruc>();
        ResStruc rs = new ResStruc(17, 21.793);
        rs.fnat = 0.02;
        gegner.put("1bgx", rs);
        rs = new ResStruc(14, 3.895);
        rs.fnat = 0.64;
        gegner.put("1bj1", rs);
        rs = new ResStruc(8, 7.991);
        rs.fnat = 0.24;
        gegner.put("1bql", rs);
        rs = new ResStruc(14, 8.931);
        rs.fnat = 0.11;
        gegner.put("1bvk", rs);
        rs = new ResStruc(28, 8.793);
        rs.fnat = 0.06;
        gegner.put("1dqj", rs);
        rs = new ResStruc(22, 3.609);
        rs.fnat = 0.33;
        gegner.put("1e6j", rs);
        rs = new ResStruc(9, 2.702);
        rs.fnat = 0.84;
        gegner.put("1i9r", rs);
        rs = new ResStruc(14, 4.108);
        rs.fnat = 0.36;
        gegner.put("1iqd", rs);
        rs = new ResStruc(25, 18.147);
        rs.fnat = 0.08;
        gegner.put("3hi6", rs);
        rs = new ResStruc(14, 9.686);
        rs.fnat = 0.07;
        gegner.put("1mlc", rs);
        rs = new ResStruc(29, 1.283);
        rs.fnat = 0.85;
        gegner.put("2dd8", rs);
        rs = new ResStruc(10, 6.047);
        rs.fnat = 0.48;
        gegner.put("2jel", rs);
        rs = new ResStruc(4, 25.693);
        rs.fnat = 0.09;
        gegner.put("3eo1", rs);
        rs = new ResStruc(5, 13.402);
        rs.fnat = 0.17;
        gegner.put("3gjf", rs);
        rs = new ResStruc(1, 3.303);
        rs.fnat = 0.39;
        gegner.put("1awh", rs);
        rs = new ResStruc(2, 6.811);
        rs.fnat = 0.14;
        gegner.put("1jps", rs);
        rs = new ResStruc(8, 24.2);
        rs.fnat = 0.01;
        gegner.put("1k4c", rs);
        rs = new ResStruc(0, 4.286);
        rs.fnat = 0.6;
        gegner.put("1fsk", rs);
        rs = new ResStruc(14, 7.376);
        rs.fnat = 0.16;
        gegner.put("1nsn", rs);
        rs = new ResStruc(3, 3.305);
        rs.fnat = 0.55;
        gegner.put("1qfw", rs);
        rs = new ResStruc(9, 5.604);
        rs.fnat = 0.12;
        gegner.put("1vfb", rs);
        rs = new ResStruc(1, 6.967);
        rs.fnat = 0.34;
        gegner.put("1wej", rs);
        rs = new ResStruc(3, 6.792);
        rs.fnat = 0.19;
        gegner.put("2him", rs);
        rs = new ResStruc(13, 14.513);
        rs.fnat = 0.02;
        gegner.put("2vis", rs);
        rs = new ResStruc(3, 29.356);
        rs.fnat = 0.0;
        gegner.put("3cvh", rs);
        rs = new ResStruc(24, 4.864);
        rs.fnat = 0.61;
        gegner.put("1jhl", rs);
        rs = new ResStruc(1, 3.517);
        rs.fnat = 0.64;
        gegner.put("1nca", rs);
        rs = new ResStruc(11, 5.668);
        rs.fnat = 0.28;
        gegner.put("1p2c", rs);
        rs = new ResStruc(1, 3.611);
        rs.fnat = 0.55;
        gegner.put("2fd6", rs);
        return gegner;
    }

    public static HashMap<String, ResStruc> CreateCompetitionFnat() {
        HashMap<String, ResStruc> gegner = new HashMap<String, ResStruc>();
        ResStruc rs = new ResStruc(17, 21.793);
        rs.fnat = 0.02;
        gegner.put("1bgx", rs);
        rs = new ResStruc(14, 3.895);
        rs.fnat = 0.64;
        gegner.put("1bj1", rs);
        rs = new ResStruc(8, 7.991);
        rs.fnat = 0.24;
        gegner.put("1bql", rs);
        rs = new ResStruc(18, 16.552);
        rs.fnat = 0.17;
        gegner.put("1dqj", rs);
        rs = new ResStruc(22, 3.609);
        rs.fnat = 0.33;
        gegner.put("1e6j", rs);
        rs = new ResStruc(9, 2.702);
        rs.fnat = 0.84;
        gegner.put("1i9r", rs);
        rs = new ResStruc(14, 4.108);
        rs.fnat = 0.36;
        gegner.put("1iqd", rs);
        rs = new ResStruc(11, 28.36);
        rs.fnat = 0.04;
        gegner.put("1k4c", rs);
        rs = new ResStruc(6, 20.211);
        rs.fnat = 0.14;
        gegner.put("1mlc", rs);
        rs = new ResStruc(13, 14.06);
        rs.fnat = 0.16;
        gegner.put("1nsn", rs);
        rs = new ResStruc(27, 8.622);
        rs.fnat = 0.2;
        gegner.put("1vfb", rs);
        rs = new ResStruc(9, 7.678);
        rs.fnat = 0.41;
        gegner.put("1wej", rs);
        rs = new ResStruc(29, 1.283);
        rs.fnat = 0.85;
        gegner.put("2dd8", rs);
        rs = new ResStruc(10, 6.47);
        rs.fnat = 0.48;
        gegner.put("2jel", rs);
        rs = new ResStruc(4, 25.693);
        rs.fnat = 0.09;
        gegner.put("3eo1", rs);
        rs = new ResStruc(5, 13.402);
        rs.fnat = 0.17;
        gegner.put("3gjf", rs);
        rs = new ResStruc(25, 18.147);
        rs.fnat = 0.08;
        gegner.put("3hi6", rs);
        rs = new ResStruc(13, 14.513);
        rs.fnat = 0.02;
        gegner.put("2vis", rs);
        rs = new ResStruc(20, 34.91);
        rs.fnat = 0.04;
        gegner.put("3cvh", rs);
        rs = new ResStruc(3, 6.792);
        rs.fnat = 0.19;
        gegner.put("2him", rs);
        rs = new ResStruc(3, 3.305);
        rs.fnat = 0.55;
        gegner.put("1qfw", rs);
        rs = new ResStruc(13, 15.06);
        rs.fnat = 0.11;
        gegner.put("1bvk", rs);
        rs = new ResStruc(0, 4.286);
        rs.fnat = 0.6;
        gegner.put("1fsk", rs);
        rs = new ResStruc(23, 7.39);
        rs.fnat = 0.32;
        gegner.put("1jps", rs);
        rs = new ResStruc(1, 3.303);
        rs.fnat = 0.39;
        gegner.put("1awh", rs);
        rs = new ResStruc(1, 3.611);
        rs.fnat = 0.55;
        gegner.put("2fd6", rs);
        rs = new ResStruc(1, 3.517);
        rs.fnat = 0.64;
        gegner.put("1nca", rs);
        rs = new ResStruc(24, 4.864);
        rs.fnat = 0.61;
        gegner.put("1jhl", rs);
        rs = new ResStruc(11, 5.668);
        rs.fnat = 0.28;
        gegner.put("1p2c", rs);
        return gegner;
    }

    public static ResStruc getUnscored(String _case, String pdb, int run, String test) {
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSD(_case, String.valueOf(run), pdb, test);
        TreeSet<Integer> sorted_scores = new TreeSet<Integer>();
        for (Integer i : irmsds.keySet()) {
            sorted_scores.add(i);
        }
        double succ_irmsd = -1.0;
        int succ_rank = 200;
        for (Integer d : sorted_scores) {
            if (!(irmsds.get(d) < 10.0)) continue;
            succ_irmsd = irmsds.get(d);
            succ_rank = d;
            break;
        }
        return new ResStruc(succ_rank, succ_irmsd);
    }

    public static double getAverage(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORE(_case, String.valueOf(run), pdb, test);
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        double score = 0.0;
        for (Double d : sorted_scores) {
            score += d.doubleValue();
        }
        return score;
    }

    public static HashMap<Double, Double> getTopNFNAT(String _case, String pdb, int run, String test, int howmany) {
        HashMap<Double, Integer> scores = ResultSorter.getSCOREN(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getFNAT(_case, String.valueOf(run), pdb, test);
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            if (--rank >= howmany) continue;
            result.put(d, irmsds.get(scores.get(d)));
        }
        return result;
    }

    public static HashMap<Double, Double> getTopN(String _case, String pdb, int run, String test, int howmany) {
        HashMap<Double, Integer> scores = ResultSorter.getSCOREN(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSD(_case, String.valueOf(run), pdb, test);
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            if (--rank >= howmany) continue;
            result.put(d, irmsds.get(scores.get(d)));
        }
        return result;
    }

    public static HashMap<Double, Double> getTop10FNAT(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORE(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getFNAT(_case, String.valueOf(run), pdb, test);
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            System.out.println(String.valueOf(--rank) + " : " + d + " " + irmsds.get(scores.get(d)));
            if (rank >= top_rank) continue;
            result.put(d, irmsds.get(scores.get(d)));
            System.out.println("added");
        }
        return result;
    }

    public static HashMap<Double, Double> getTop10(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORE(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSD(_case, String.valueOf(run), pdb, test);
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            if (--rank >= top_rank) continue;
            result.put(d, irmsds.get(scores.get(d)));
        }
        return result;
    }

    public static ReturnStruc getTop10Full(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORELocal(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSDLocal(_case, String.valueOf(run), pdb, test);
        HashMap<Double, Double> result = new HashMap<Double, Double>();
        HashMap<Double, Integer> irmsdmap = new HashMap<Double, Integer>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            if (--rank >= 11) continue;
            result.put(d, irmsds.get(scores.get(d)));
            irmsdmap.put(d, scores.get(d));
        }
        return new ReturnStruc(result, irmsdmap);
    }

    public static HashMap<Integer, Double> getTop10Original(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORELocal(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSDLocal(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        for (Double d : sorted_scores) {
            if (--rank >= 11) continue;
            result.put(scores.get(d), irmsds.get(scores.get(d)));
        }
        return result;
    }

    public static ResStruc getScores(String _case, String pdb, int run, String test) {
        HashMap<Double, Integer> scores = ResultSorter.getSCORE(_case, String.valueOf(run), pdb, test);
        HashMap<Integer, Double> irmsds = ResultSorter.getIRMSD(_case, String.valueOf(run), pdb, test);
        TreeSet<Double> sorted_scores = new TreeSet<Double>();
        for (Double i : scores.keySet()) {
            sorted_scores.add(i);
        }
        int rank = 201;
        double succ_irmsd = -1.0;
        int succ_rank = 200;
        for (Double d : sorted_scores) {
            --rank;
            if (!(irmsds.get(scores.get(d)) < 10.0)) continue;
            succ_irmsd = irmsds.get(scores.get(d));
            succ_rank = rank;
        }
        return new ResStruc(succ_rank, succ_irmsd);
    }

    public static HashMap<Integer, Double> getFNAT(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/fnat.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt((line = line.replace(" Fnat = ", " ")).substring(0, line.indexOf(" ")));
            if (id > 200) continue;
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            rmsd = (double)Math.round(rmsd * 100.0) / 100.0;
            if (rmsd_map.containsKey(id)) {
                System.err.println("IRMSD Double key...");
                System.exit(0);
            }
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static HashMap<Integer, Double> getIRMSD(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/irmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            if (id > 200) continue;
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            if (rmsd_map.containsKey(id)) {
                System.err.println("IRMSD Double key...");
                System.exit(0);
            }
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static HashMap<Double, Integer> getSCORE(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/" + "rescored_local" + ".txt");
        HashMap<Double, Integer> rmsd_map = new HashMap<Double, Integer>();
        for (String line : lines) {
            String rmsd_str;
            int id;
            if (line.length() == 0 || (id = Integer.parseInt(line.substring(0, line.indexOf(" ")))) > 200) continue;
            double rmsd = line.contains("data") || line.contains("java") || line.contains("Cannot") ? 0.0 : ((rmsd_str = line.substring(line.indexOf(" "))).replace(" ", "").length() == 0 ? 0.0 : Double.parseDouble(rmsd_str));
            if (rmsd_map.containsKey(rmsd)) {
                double rand = Math.random() / 1.0E8;
                rmsd += rand;
            }
            rmsd_map.put(rmsd, id);
        }
        return rmsd_map;
    }

    public static HashMap<Double, Integer> getSCOREN(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile("/Volumes/NOAH/" + test + "/zdock_runs/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/" + "rescored_local" + ".txt");
        HashMap<Double, Integer> rmsd_map = new HashMap<Double, Integer>();
        for (String line : lines) {
            String rmsd_str;
            int id;
            if (line.length() == 0 || (id = Integer.parseInt(line.substring(0, line.indexOf(" ")))) > 200) continue;
            double rmsd = line.contains("data") || line.contains("java") || line.contains("Cannot") ? 0.0 : ((rmsd_str = line.substring(line.indexOf(" "))).replace(" ", "").length() == 0 ? 0.0 : Double.parseDouble(rmsd_str));
            double rand = Math.random() / 1.0E8;
            if (rmsd_map.containsKey(rmsd += rand)) {
                System.err.println("Score key..." + rmsd);
                System.exit(0);
            }
            rmsd_map.put(rmsd, id);
        }
        return rmsd_map;
    }

    public static HashMap<Integer, Double> getIRMSDLocal(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/irmsds.txt");
        HashMap<Integer, Double> rmsd_map = new HashMap<Integer, Double>();
        for (String line : lines) {
            int id = Integer.parseInt(line.substring(0, line.indexOf(" ")));
            if (id > 200) continue;
            double rmsd = Double.parseDouble(line.substring(line.indexOf(" ")));
            if (rmsd_map.containsKey(id)) {
                System.err.println("IRMSD Double key...");
                System.exit(0);
            }
            rmsd_map.put(id, rmsd);
        }
        return rmsd_map;
    }

    public static HashMap<Double, Integer> getSCORELocal(String _case, String run, String pdb, String test) {
        ArrayList<String> lines = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/docking_cases/" + _case + "/ProFitV3.1/output/" + run + "/" + pdb + "/rescored.txt");
        HashMap<Double, Integer> rmsd_map = new HashMap<Double, Integer>();
        for (String line : lines) {
            String rmsd_str;
            int id;
            if (line.length() == 0 || (id = Integer.parseInt(line.substring(0, line.indexOf(" ")))) > 200) continue;
            double rmsd = line.contains("data") || line.contains("java") || line.contains("Cannot") ? 0.0 : ((rmsd_str = line.substring(line.indexOf(" "))).replace(" ", "").length() == 0 ? 0.0 : Double.parseDouble(rmsd_str));
            double rand = Math.random() / 1.0E8;
            if (rmsd_map.containsKey(rmsd += rand)) {
                System.err.println("Score key..." + rmsd);
                System.exit(0);
            }
            rmsd_map.put(rmsd, id);
        }
        return rmsd_map;
    }

    public static class ResStruc {
        public final int rank;
        public final double irmsd;
        public double fnat;
        public double score;

        public ResStruc(int r, double i) {
            this.rank = r;
            this.irmsd = i;
        }

        public ResStruc(int r, double i, double f) {
            this.rank = r;
            this.irmsd = i;
            this.fnat = f;
        }

        public void printOut() {
            System.out.println("Rank : " + this.rank);
            System.out.println("Irmsd : " + this.irmsd);
            System.out.println("Fnat : " + this.fnat);
        }
    }

    public static class ReturnStruc {
        public final HashMap<Double, Double> score_map;
        public final HashMap<Double, Integer> decoy_map;

        public ReturnStruc(HashMap<Double, Double> r, HashMap<Double, Integer> i) {
            this.score_map = r;
            this.decoy_map = i;
        }
    }
}

