/*
 * Decompiled with CFR 0.152.
 */
package dockingfurther;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import docking_global.DockingDistances;
import for_terry.Abysis;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import parsing.PSA;
import utils.FileSystemTools;
import utils.MathFunctions;

public class PropensityCalculation {
    private static final boolean visualize = false;
    public static final String userdir = System.getProperty("user.dir");
    public static final String res_dir = String.valueOf(userdir) + "/result_dump/DP_recalculation";
    public static final String data_dir = "/Volumes/NOAH/Wissenschaft/DP_recalculation";
    public static final String single_dir = String.valueOf(userdir) + "/result_dump/ab_propensity/data/single_arrays_AG_";
    private static final double inter_cut = 5.0;

    public static void main(String[] args) {
        PropensityCalculation.createData();
    }

    public static void ShowSurface(HashMap<Integer, Residue> str, HashMap<Integer, Boolean> sexp, String name) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer i : str.keySet()) {
            sorted.add(i);
        }
        ArrayList<String> output = new ArrayList<String>();
        for (Integer i : sorted) {
            for (Atom a : str.get((Object)i).atoms) {
                output.add(SC_Structure.colorBFactor(a.pdb_line, sexp.get(i) != false ? "100" : "0"));
            }
        }
        FileSystemTools.writeFile(String.valueOf(userdir) + "/pymol_temp/" + name + ".pdb", output);
    }

    public static ArrayList<String> recalculateProps(String dataset, int test_n) {
        String temp_dir = String.valueOf(userdir) + "/result_dump/ab_propensity/data/recalc_data_" + dataset;
        ArrayList<String> all = FileSystemTools.readFile(String.valueOf(res_dir) + "/PDBs/AG_" + dataset + ".txt");
        ArrayList<String> test = MathFunctions.NoutOfKString(all, test_n);
        all.addAll(PropensityCalculation.diff(dataset));
        int[] ab_cons = new int[20];
        int[] ab_nons = new int[20];
        int[] ag_cons = new int[20];
        int[] ag_nons = new int[20];
        int[][] ab_cons_p = new int[20][20];
        int[][] ab_nons_p = new int[20][20];
        int[][] ag_cons_p = new int[20][20];
        int[][] ag_nons_p = new int[20][20];
        int[][][] ab_cons_t = new int[20][20][20];
        int[][][] ab_nons_t = new int[20][20][20];
        int[][][] ag_cons_t = new int[20][20][20];
        int[][][] ag_nons_t = new int[20][20][20];
        System.out.println("Test has: " + test.size());
        for (String folder : test) {
            System.out.println(folder);
        }
        System.out.println("Training has: " + all.size());
        for (String folder : all) {
            System.out.println(folder);
        }
        System.exit(0);
        boolean prog = false;
        for (String folder : all) {
            int[] temp_ab_cons = MathFunctions.readParsable1D(String.valueOf(single_dir) + dataset + "/p_single_ab_cons_" + folder + ".txt");
            int[] temp_ab_nons = MathFunctions.readParsable1D(String.valueOf(single_dir) + dataset + "/p_single_ab_nons_" + folder + ".txt");
            int[] temp_ag_cons = MathFunctions.readParsable1D(String.valueOf(single_dir) + dataset + "/p_single_ag_cons_" + folder + ".txt");
            int[] temp_ag_nons = MathFunctions.readParsable1D(String.valueOf(single_dir) + dataset + "/p_single_ag_nons_" + folder + ".txt");
            int i = 0;
            while (i < 20) {
                int n = i;
                ab_cons[n] = ab_cons[n] + temp_ab_cons[i];
                int n2 = i;
                ab_nons[n2] = ab_nons[n2] + temp_ab_nons[i];
                int n3 = i;
                ag_cons[n3] = ag_cons[n3] + temp_ag_cons[i];
                int n4 = i;
                ag_nons[n4] = ag_nons[n4] + temp_ag_nons[i];
                ++i;
            }
            int[][] temp_ab_cons_p = MathFunctions.readParsable2D(String.valueOf(single_dir) + dataset + "/p_pair_ab_cons_" + folder + ".txt");
            int[][] temp_ab_nons_p = MathFunctions.readParsable2D(String.valueOf(single_dir) + dataset + "/p_pair_ab_nons_" + folder + ".txt");
            int[][] temp_ag_cons_p = MathFunctions.readParsable2D(String.valueOf(single_dir) + dataset + "/p_pair_ag_cons_" + folder + ".txt");
            int[][] temp_ag_nons_p = MathFunctions.readParsable2D(String.valueOf(single_dir) + dataset + "/p_pair_ag_nons_" + folder + ".txt");
            int i2 = 0;
            while (i2 < 20) {
                int j = 0;
                while (j < 20) {
                    int[] nArray = ab_cons_p[i2];
                    int n = j;
                    nArray[n] = nArray[n] + temp_ab_cons_p[i2][j];
                    int[] nArray2 = ab_nons_p[i2];
                    int n5 = j;
                    nArray2[n5] = nArray2[n5] + temp_ab_nons_p[i2][j];
                    int[] nArray3 = ag_cons_p[i2];
                    int n6 = j;
                    nArray3[n6] = nArray3[n6] + temp_ag_cons_p[i2][j];
                    int[] nArray4 = ag_nons_p[i2];
                    int n7 = j;
                    nArray4[n7] = nArray4[n7] + temp_ag_nons_p[i2][j];
                    ++j;
                }
                ++i2;
            }
            int[][][] temp_ab_cons_t = MathFunctions.readParsable3D(String.valueOf(single_dir) + dataset + "/p_triangle_ab_cons_" + folder + ".txt");
            int[][][] temp_ab_nons_t = MathFunctions.readParsable3D(String.valueOf(single_dir) + dataset + "/p_triangle_ab_nons_" + folder + ".txt");
            int[][][] temp_ag_cons_t = MathFunctions.readParsable3D(String.valueOf(single_dir) + dataset + "/p_triangle_ag_cons_" + folder + ".txt");
            int[][][] temp_ag_nons_t = MathFunctions.readParsable3D(String.valueOf(single_dir) + dataset + "/p_triangle_ag_nons_" + folder + ".txt");
            int i3 = 0;
            while (i3 < 20) {
                int j = 0;
                while (j < 20) {
                    int k = 0;
                    while (k < 20) {
                        int[] nArray = ab_cons_t[i3][j];
                        int n = k;
                        nArray[n] = nArray[n] + temp_ab_cons_t[i3][j][k];
                        int[] nArray5 = ab_nons_t[i3][j];
                        int n8 = k;
                        nArray5[n8] = nArray5[n8] + temp_ab_nons_t[i3][j][k];
                        int[] nArray6 = ag_cons_t[i3][j];
                        int n9 = k;
                        nArray6[n9] = nArray6[n9] + temp_ag_cons_t[i3][j][k];
                        int[] nArray7 = ag_nons_t[i3][j];
                        int n10 = k;
                        nArray7[n10] = nArray7[n10] + temp_ag_nons_t[i3][j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        MathFunctions.printParsable1D(ab_cons, String.valueOf(temp_dir) + "/p_single_ab_cons.txt");
        MathFunctions.printParsable1D(ab_nons, String.valueOf(temp_dir) + "/p_single_ab_nons.txt");
        MathFunctions.printParsable1D(ag_cons, String.valueOf(temp_dir) + "/p_single_ag_cons.txt");
        MathFunctions.printParsable1D(ag_nons, String.valueOf(temp_dir) + "/p_single_ag_nons.txt");
        MathFunctions.printParsable2D(ab_cons_p, String.valueOf(temp_dir) + "/p_pair_ab_cons.txt");
        MathFunctions.printParsable2D(ab_nons_p, String.valueOf(temp_dir) + "/p_pair_ab_nons.txt");
        MathFunctions.printParsable2D(ag_cons_p, String.valueOf(temp_dir) + "/p_pair_ag_cons.txt");
        MathFunctions.printParsable2D(ag_nons_p, String.valueOf(temp_dir) + "/p_pair_ag_nons.txt");
        MathFunctions.printParsable3D(ab_cons_t, String.valueOf(temp_dir) + "/p_triangle_ab_cons.txt");
        MathFunctions.printParsable3D(ab_nons_t, String.valueOf(temp_dir) + "/p_triangle_ab_nons.txt");
        MathFunctions.printParsable3D(ag_cons_t, String.valueOf(temp_dir) + "/p_triangle_ag_cons.txt");
        MathFunctions.printParsable3D(ag_nons_t, String.valueOf(temp_dir) + "/p_triangle_ag_nons.txt");
        return test;
    }

    public static HashMap<Integer, Boolean> getSurfExp(String pdb, String dataset, String abag) {
        String file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + dataset + "/" + pdb + "/" + abag + "_std_exp.txt";
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        ArrayList<String> lines = FileSystemTools.readFile(file);
        for (String line : lines) {
            String tf;
            int sid = Integer.parseInt(FileSystemTools.getColumn(line, 1));
            if (map.containsKey(sid)) {
                System.err.println("Sth wrong!");
                System.exit(0);
            }
            if ((tf = FileSystemTools.getColumn(line, 2)).equals("true")) {
                map.put(sid, true);
                continue;
            }
            if (tf.equals("false")) {
                map.put(sid, false);
                continue;
            }
            System.err.println("Sth wrong!");
            System.exit(0);
        }
        return map;
    }

    public static ArrayList<String> diff(String d_name) {
        ArrayList<String> dff = new ArrayList<String>();
        ArrayList<String> n = FileSystemTools.readFile(String.valueOf(res_dir) + "/PDBs/AG_" + d_name + ".txt");
        ArrayList<String> src = FileSystemTools.readFile(String.valueOf(res_dir) + "/PDBs_all/AG_" + d_name + ".txt");
        for (String s : src) {
            if (n.contains(s)) continue;
            System.out.println(s);
            dff.add(s);
        }
        return dff;
    }

    public static void check_abysis(String d_name) {
        ArrayList<String> folders = FileSystemTools.readFile(String.valueOf(res_dir) + "/PDBs/" + d_name + ".txt");
        ArrayList<String> annots = new ArrayList<String>();
        ArrayList<String> cdrs = new ArrayList<String>();
        annots.add("ch");
        annots.add("a");
        annots.add("k");
        annots.add("co");
        cdrs.add("CDR1");
        cdrs.add("CDR2");
        cdrs.add("CDR3");
        int prog = 0;
        for (String folder : folders) {
            String seq;
            String pdb = folder.substring(0, 4);
            String vh = String.valueOf(folder.charAt(5));
            String vl = String.valueOf(folder.charAt(7));
            if (pdb.equals("2ghw")) {
                vh = "D_i";
                vl = "D_ii";
            }
            if (pdb.equals("3h3b")) {
                vh = "C_i";
                vl = "C_ii";
            }
            System.out.println(String.valueOf(++prog) + "/" + folders.size() + " : " + folder);
            System.out.println(String.valueOf(pdb) + " : " + vh + " : " + vl);
            File f = new File(String.valueOf(userdir) + "/result_dump/DP_recalculation/CDR_rep/" + pdb + "_ch_L_CDR1.txt");
            if (f.exists()) continue;
            Abysis.Abysis_rec ar = Abysis.readChainRec(String.valueOf(pdb.toUpperCase()) + "_" + vh);
            for (String annotation : annots) {
                for (String cdr : cdrs) {
                    seq = "";
                    if (annotation.equals("ch")) {
                        seq = ar.cdr_ch.get(cdr);
                    }
                    if (annotation.equals("a")) {
                        seq = ar.cdr_abm.get(cdr);
                    }
                    if (annotation.equals("k")) {
                        seq = ar.cdr_kabat.get(cdr);
                    }
                    if (annotation.equals("co")) {
                        seq = ar.cdr_contact.get(cdr);
                    }
                    if (seq == null || seq.equals("")) {
                        System.err.println(String.valueOf(folder) + " H " + cdr + " " + annotation);
                        continue;
                    }
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/CDR_rep/" + pdb + "_" + annotation + "_H_" + cdr + ".txt", seq);
                }
            }
            ar = Abysis.readChainRec(String.valueOf(pdb.toUpperCase()) + "_" + vl);
            for (String annotation : annots) {
                for (String cdr : cdrs) {
                    seq = "";
                    if (annotation.equals("ch")) {
                        seq = ar.cdr_ch.get(cdr);
                    }
                    if (annotation.equals("a")) {
                        seq = ar.cdr_abm.get(cdr);
                    }
                    if (annotation.equals("k")) {
                        seq = ar.cdr_kabat.get(cdr);
                    }
                    if (annotation.equals("co")) {
                        seq = ar.cdr_contact.get(cdr);
                    }
                    if (seq.equals("")) {
                        System.err.println(String.valueOf(folder) + " L " + cdr + " " + annotation);
                        continue;
                    }
                    FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/DP_recalculation/CDR_rep/" + pdb + "_" + annotation + "_L_" + cdr + ".txt", seq);
                }
            }
        }
    }

    public static void createData() {
        String d_name = "AG_protein";
        ArrayList<String> folders = FileSystemTools.getFolders("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name);
        for (String folder : folders) {
            File s_folder;
            if (folder.contains("2nyy")) continue;
            String ab_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std.pdb";
            String ag_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std.pdb";
            File d_folder = new File(String.valueOf(userdir) + "/resources/nr/dataset/" + folder.toLowerCase());
            if (!d_folder.exists()) {
                d_folder.mkdir();
            }
            if (!(s_folder = new File(String.valueOf(userdir) + "/resources/nr/solution/" + folder.toLowerCase())).exists()) {
                s_folder.mkdir();
            }
            String ab_t1 = String.valueOf(userdir) + "/resources/nr/dataset/" + folder.toLowerCase() + "/AB.pdb";
            String ag_t1 = String.valueOf(userdir) + "/resources/nr/dataset/" + folder.toLowerCase() + "/AG.pdb";
            String ab_t2 = String.valueOf(userdir) + "/resources/nr/solution/" + folder.toLowerCase() + "/AB.pdb";
            String ag_t2 = String.valueOf(userdir) + "/resources/nr/solution/" + folder.toLowerCase() + "/AG.pdb";
            FileSystemTools.CopyFile(ab_file, ab_t1);
            FileSystemTools.CopyFile(ab_file, ab_t2);
            FileSystemTools.CopyFile(ag_file, ag_t1);
            FileSystemTools.CopyFile(ag_file, ag_t2);
        }
    }

    public static void BindingCalcIPATCH(String d_name) {
        int prog = 0;
        ArrayList<String> folders = FileSystemTools.getFolders("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name);
        for (String folder : folders) {
            if (folder.contains("2nyy")) continue;
            int[] ab_cons = new int[20];
            int[] ab_nons = new int[20];
            int[] ag_cons = new int[20];
            int[] ag_nons = new int[20];
            System.out.println(String.valueOf(d_name) + " : " + ++prog + "/" + folders.size() + " [" + folder + "]");
            String ab_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std.pdb";
            String ag_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std.pdb";
            HashMap<Integer, Residue> ab_str = PDB_parser.parse(ab_file);
            HashMap<Integer, Residue> ag_str = PDB_parser.parse(ag_file);
            DockingDistances.extractCons(ab_str, ag_str);
            HashMap<Integer, Boolean> map_ab = PropensityCalculation.getSurfExp(folder, d_name, "Ab");
            HashMap<Integer, Boolean> map_ag = PropensityCalculation.getSurfExp(folder, d_name, "Ag");
            for (Integer i : ab_str.keySet()) {
                if (!map_ab.get(i).booleanValue()) continue;
                if (ab_str.get((Object)i).isContact) {
                    int n = ab_str.get((Object)i).type.ordinal();
                    ab_cons[n] = ab_cons[n] + 1;
                    continue;
                }
                int n = ab_str.get((Object)i).type.ordinal();
                ab_nons[n] = ab_nons[n] + 1;
            }
            for (Integer i : ag_str.keySet()) {
                if (!map_ag.get(i).booleanValue()) continue;
                if (ag_str.get((Object)i).isContact) {
                    int n = ag_str.get((Object)i).type.ordinal();
                    ag_cons[n] = ag_cons[n] + 1;
                    continue;
                }
                int n = ag_str.get((Object)i).type.ordinal();
                ag_nons[n] = ag_nons[n] + 1;
            }
            PropensityCalculation.pairData(d_name, ab_str, ag_str, map_ab, map_ag, folder);
            PropensityCalculation.triData(d_name, ab_str, ag_str, map_ab, map_ag, folder);
            MathFunctions.printParsable1D(ab_cons, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_single_ab_cons_" + folder + ".txt");
            MathFunctions.printParsable1D(ab_nons, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_single_ab_nons_" + folder + ".txt");
            MathFunctions.printParsable1D(ag_cons, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_single_ag_cons_" + folder + ".txt");
            MathFunctions.printParsable1D(ag_nons, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_single_ag_nons_" + folder + ".txt");
        }
    }

    public static void triData(String d_name, HashMap<Integer, Residue> ab_str, HashMap<Integer, Residue> ag_str, HashMap<Integer, Boolean> ab_map, HashMap<Integer, Boolean> ag_map, String folder) {
        int[][][] ab_cons_t = new int[20][20][20];
        int[][][] ab_nons_t = new int[20][20][20];
        int[][][] ag_cons_t = new int[20][20][20];
        int[][][] ag_nons_t = new int[20][20][20];
        for (Integer i_ab : ab_str.keySet()) {
            if (!ab_map.get(i_ab).booleanValue()) continue;
            Residue r_ab = ab_str.get(i_ab);
            for (Integer i_ab2 : ab_str.keySet()) {
                Residue r_ab2;
                if (!ab_map.get(i_ab2).booleanValue() || !(r_ab.distanceFrom(r_ab2 = ab_str.get(i_ab2)) < 4.5)) continue;
                for (Integer i_ag : ag_str.keySet()) {
                    if (!ag_map.get(i_ag).booleanValue()) continue;
                    Residue r_ag = ag_str.get(i_ag);
                    if (r_ag.distanceFrom(r_ab) < 4.5 && r_ag.distanceFrom(r_ab2) < 4.5) {
                        int[] nArray = ab_cons_t[r_ab.type.ordinal()][r_ab2.type.ordinal()];
                        int n = r_ag.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    int[] nArray = ab_nons_t[r_ab.type.ordinal()][r_ab2.type.ordinal()];
                    int n = r_ag.type.ordinal();
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (Integer i_ag : ag_str.keySet()) {
            if (!ag_map.get(i_ag).booleanValue()) continue;
            Residue r_ag = ag_str.get(i_ag);
            for (Integer i_ag2 : ag_str.keySet()) {
                Residue r_ag2;
                if (!ag_map.get(i_ag2).booleanValue() || !(r_ag.distanceFrom(r_ag2 = ag_str.get(i_ag2)) < 4.5)) continue;
                for (Integer i_ab : ab_str.keySet()) {
                    if (!ab_map.get(i_ab).booleanValue()) continue;
                    Residue r_ab = ab_str.get(i_ab);
                    if (r_ab.distanceFrom(r_ag) < 4.5 && r_ab.distanceFrom(r_ag2) < 4.5) {
                        int[] nArray = ag_cons_t[r_ag.type.ordinal()][r_ag2.type.ordinal()];
                        int n = r_ab.type.ordinal();
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    int[] nArray = ag_nons_t[r_ag.type.ordinal()][r_ag2.type.ordinal()];
                    int n = r_ab.type.ordinal();
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        MathFunctions.printParsable3D(ab_cons_t, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_triangle_ab_cons_" + folder + ".txt");
        MathFunctions.printParsable3D(ab_nons_t, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_triangle_ab_nons_" + folder + ".txt");
        MathFunctions.printParsable3D(ag_cons_t, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_triangle_ag_cons_" + folder + ".txt");
        MathFunctions.printParsable3D(ag_nons_t, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_triangle_ag_nons_" + folder + ".txt");
    }

    public static void pairData(String d_name, HashMap<Integer, Residue> ab_str, HashMap<Integer, Residue> ag_str, HashMap<Integer, Boolean> ab_map, HashMap<Integer, Boolean> ag_map, String folder) {
        int[][] ab_cons_p = new int[20][20];
        int[][] ab_nons_p = new int[20][20];
        int[][] ag_cons_p = new int[20][20];
        int[][] ag_nons_p = new int[20][20];
        for (Integer i_ab : ab_str.keySet()) {
            if (!ab_map.get(i_ab).booleanValue()) continue;
            Residue r_ab = ab_str.get(i_ab);
            for (Integer i_ag : ag_str.keySet()) {
                if (!ag_map.get(i_ag).booleanValue()) continue;
                Residue r_ag = ag_str.get(i_ag);
                if (r_ab.distanceFrom(r_ag) < 4.5) {
                    int[] nArray = ab_cons_p[r_ab.type.ordinal()];
                    int n = r_ag.type.ordinal();
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = ag_cons_p[r_ag.type.ordinal()];
                    int n2 = r_ab.type.ordinal();
                    nArray2[n2] = nArray2[n2] + 1;
                    continue;
                }
                int[] nArray = ab_nons_p[r_ab.type.ordinal()];
                int n = r_ag.type.ordinal();
                nArray[n] = nArray[n] + 1;
                int[] nArray3 = ag_nons_p[r_ag.type.ordinal()];
                int n3 = r_ab.type.ordinal();
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
        System.out.println(d_name);
        MathFunctions.printParsable2D(ab_cons_p, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_pair_ab_cons_" + folder + ".txt");
        MathFunctions.printParsable2D(ab_nons_p, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_pair_ab_nons_" + folder + ".txt");
        MathFunctions.printParsable2D(ag_cons_p, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_pair_ag_cons_" + folder + ".txt");
        MathFunctions.printParsable2D(ag_nons_p, String.valueOf(single_dir) + d_name.replace("AG_", "") + "/p_pair_ag_nons_" + folder + ".txt");
    }

    public static void BindingCalc(String d_name) {
        int prog = 0;
        int[] cons = new int[20];
        int[] nons = new int[20];
        ArrayList<String> folders = FileSystemTools.getFolders("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name);
        for (String folder : folders) {
            if (folder.contains("2nyy")) continue;
            System.out.println(String.valueOf(d_name) + " : " + ++prog + "/" + folders.size() + " [" + folder + "]");
            String ab_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std.pdb";
            String ag_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std.pdb";
            HashMap<Integer, Residue> ab_str = PDB_parser.parse(ab_file);
            HashMap<Integer, Residue> ag_str = PDB_parser.parse(ag_file);
            DockingDistances.extractCons(ab_str, ag_str);
            HashMap<Integer, Boolean> map_ab = PropensityCalculation.getSurfExp(folder, d_name, "Ab");
            HashMap<Integer, Boolean> map_ag = PropensityCalculation.getSurfExp(folder, d_name, "Ag");
            for (Integer i : ab_str.keySet()) {
                if (!map_ab.get(i).booleanValue()) continue;
                if (ab_str.get((Object)i).isContact) {
                    int n = ab_str.get((Object)i).type.ordinal();
                    cons[n] = cons[n] + 1;
                    continue;
                }
                int n = ab_str.get((Object)i).type.ordinal();
                nons[n] = nons[n] + 1;
            }
        }
        MathFunctions.write1Drray(cons, String.valueOf(res_dir) + "/cons_" + d_name + ".txt");
        MathFunctions.write1Drray(nons, String.valueOf(res_dir) + "/nons_" + d_name + ".txt");
    }

    public static void BindingCalcInterface(String d_name) {
        int prog = 0;
        int[] cons = new int[20];
        int[] nons = new int[20];
        ArrayList<String> folders = FileSystemTools.getFolders("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name);
        for (String folder : folders) {
            if (folder.contains("2nyy")) continue;
            System.out.println(String.valueOf(d_name) + " : " + ++prog + "/" + folders.size() + " [" + folder + "]");
            String ab_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std.pdb";
            String ag_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std.pdb";
            HashMap<Integer, Residue> ab_str = PDB_parser.parse(ab_file);
            HashMap<Integer, Residue> ag_str = PDB_parser.parse(ag_file);
            DockingDistances.extractCons(ab_str, ag_str);
            ArrayList<Integer> ab_interface = DockingDistances.augmentBinding(ab_str, 10.0);
            HashMap<Integer, Boolean> map_ab = PropensityCalculation.getSurfExp(folder, d_name, "Ab");
            HashMap<Integer, Boolean> map_ag = PropensityCalculation.getSurfExp(folder, d_name, "Ag");
            for (Integer i : ab_str.keySet()) {
                if (map_ab.get(i).booleanValue() && ab_interface.contains(i)) {
                    if (ab_str.get((Object)i).isContact) {
                        int n = ab_str.get((Object)i).type.ordinal();
                        cons[n] = cons[n] + 1;
                        continue;
                    }
                    int n = ab_str.get((Object)i).type.ordinal();
                    nons[n] = nons[n] + 1;
                    continue;
                }
                System.out.println("Ommitting");
            }
        }
        MathFunctions.write1Drray(cons, String.valueOf(res_dir) + "/cons_" + d_name + "_I.txt");
        MathFunctions.write1Drray(nons, String.valueOf(res_dir) + "/nons_" + d_name + "_I.txt");
    }

    public static void calculateSE(String d_name) {
        int prog = 0;
        ArrayList<String> folders = FileSystemTools.getFolders("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name);
        for (String folder : folders) {
            System.out.println(String.valueOf(d_name) + " : " + ++prog + "/" + folders.size() + " [" + folder + "]");
            String ab_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std.pdb";
            String ag_file = "/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std.pdb";
            HashMap<Integer, Residue> ab_str = PDB_parser.parse(ab_file);
            HashMap<Integer, Residue> ag_str = PDB_parser.parse(ag_file);
            HashMap<Integer, Boolean> ab_se = PSA.runPSA(7.5, ab_file);
            HashMap<Integer, Boolean> ag_se = PSA.runPSA(7.5, ag_file);
            if (ag_str.size() < 5) {
                System.out.println(folder);
            }
            ArrayList<String> ab_out = new ArrayList<String>();
            for (Integer i : ab_se.keySet()) {
                ab_out.add(i + " " + ab_se.get(i));
            }
            FileSystemTools.writeFile("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ab_std_exp.txt", ab_out);
            ArrayList<String> ag_out = new ArrayList<String>();
            for (Integer i : ag_se.keySet()) {
                ag_out.add(i + " " + ag_se.get(i));
            }
            FileSystemTools.writeFile("/Volumes/NOAH/Wissenschaft/DP_recalculation/" + d_name + "/" + folder + "/Ag_std_exp.txt", ag_out);
        }
    }
}

