/*
 * Decompiled with CFR 0.152.
 */
package domain_analysis;

import data_structures.Residue;
import data_structures.SC_Structure;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Complex_parser {
    public static void main(String[] args) {
        Complex_parser.parseScopFile();
    }

    public static void parseScopFile() {
        String file_name = "/home/markov/krawczyk/Desktop/complex";
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        String s = null;
        try {
            fis = new FileInputStream(file_name);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            int rejects = 0;
            int accepts = 0;
            int accepted_proteins = 0;
            int total = 0;
            while ((s = dis.readLine()) != null) {
                ++total;
                boolean acceptation = false;
                String pdb_code = s.substring(0, 4);
                String domains = s.substring(8);
                if (!acceptation) continue;
                System.out.println(pdb_code);
                ++accepted_proteins;
            }
            System.out.println("Accepted chains: " + accepts);
            System.out.println("Rejected chains: " + rejects);
            System.out.println("From " + accepted_proteins + " proteins out of " + total);
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void CalculatePropensities(HashMap<String, ArrayList<SC_Structure>> mapping) {
        for (String pdb_code : mapping.keySet()) {
            HashMap<String, Integer> chain_map = new HashMap<String, Integer>();
            for (SC_Structure struc : mapping.get(pdb_code)) {
                if (chain_map.containsKey(String.valueOf(struc.chain))) {
                    int old = (Integer)chain_map.get(String.valueOf(struc.chain));
                    chain_map.put(String.valueOf(struc.chain), old + 1);
                    continue;
                }
                chain_map.put(String.valueOf(struc.chain), 1);
            }
        }
    }

    private static SC_Structure calculateNeighborsA(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Residue> residues_s1 = s1.residues;
        HashMap<Integer, Residue> residues_s2 = s2.residues;
        for (Integer i : residues_s1.keySet()) {
            s1.residues.get((Object)i).isContact = false;
            for (Integer j : residues_s2.keySet()) {
                if (!(residues_s2.get(j).distanceFrom(residues_s1.get(i)) < 4.5)) continue;
                s1.residues.get((Object)i).isContact = true;
            }
        }
        return s1;
    }
}

