/*
 * Decompiled with CFR 0.152.
 */
package energy;

import db_interface.Complex_Structure;
import db_interface.Energetics;
import energy.ABMARS;
import energy.InputGenerator;
import java.io.FileReader;
import java.util.HashMap;
import utils.FileSystemTools;
import weka.classifiers.trees.M5P;
import weka.classifiers.trees.RandomForest;
import weka.core.Instance;
import weka.core.Instances;

public class CombinedClassifier {
    public static final String userdir = System.getProperty("user.dir");
    private final ABMARS mars = new ABMARS(4, 2);
    private final RandomForest rf = new RandomForest();
    private final M5P m5p = new M5P();

    public static void main(String[] args) {
        InputGenerator.CreateInputForComparison(50);
        CombinedClassifier.TestTheClassifier();
    }

    public CombinedClassifier(Instances numeric, Instances classy) {
        try {
            this.mars.buildClassifier(numeric);
            this.rf.setNumTrees(400);
            this.rf.setNumFeatures(4);
            this.rf.buildClassifier(classy);
            this.m5p.buildClassifier(numeric);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void TestTheClassifier() {
        System.out.println("Testing the classifier");
        String inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/diff_test_class";
        String inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/diff_test_num";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
            instances_class.setClassIndex(instances_class.numAttributes() - 1);
            CombinedClassifier cc = CombinedClassifier.TrainTheClassifier();
            System.out.println("Training completed");
            int got_right = 0;
            int i_inst = 0;
            while (i_inst < instances_numeric.size()) {
                Instance instance_num = instances_numeric.get(i_inst);
                Instance instance_class = instances_class.get(i_inst);
                double classification = cc.getClassification(instance_num, instance_class);
                double actual = instance_num.value(instances_numeric.numAttributes() - 1);
                classification = Math.round(classification);
                System.out.println("============");
                System.out.println("Actual = " + actual);
                System.out.println("Predicted = " + classification);
                System.out.println("============");
                if (actual == classification) {
                    ++got_right;
                }
                ++i_inst;
            }
            System.out.println("Total " + (double)got_right / (double)instances_numeric.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static CombinedClassifier TrainTheClassifier() {
        System.out.println("Training the classifier");
        String inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/diff_train_class";
        String inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/diff_train_num";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
            instances_class.setClassIndex(instances_class.numAttributes() - 1);
            CombinedClassifier cc = new CombinedClassifier(instances_numeric, instances_class);
            return cc;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public double getClassification(Instance instance_num, Instance instance_class) {
        try {
            double rf_out = this.rf.classifyInstance(instance_class);
            double mars_out = this.mars.classifyInstance(instance_num);
            double m5_out = this.m5p.classifyInstance(instance_num);
            double result = (rf_out + m5_out + mars_out) / 3.0;
            return result;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
            System.err.println("CombinedClassifier.getClassification() -> Error, jumped out of the try/catch");
            System.exit(0);
            return -1.0;
        }
    }

    public static double RunCombinedClassifierAloneOverfit() {
        String inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_class";
        String inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_num";
        String tc_inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/SINGLE_class";
        String tc_inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/SINGLE_num";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            FileReader reader_numeric_inst = new FileReader(tc_inst_numeric);
            FileReader reader_class_inst = new FileReader(tc_inst_class);
            Instances tc_instances_numeric = new Instances(reader_numeric_inst);
            Instances tc_instances_class = new Instances(reader_class_inst);
            tc_instances_numeric.setClassIndex(tc_instances_numeric.numAttributes() - 1);
            tc_instances_class.setClassIndex(tc_instances_class.numAttributes() - 1);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            reader_numeric = new FileReader(inst_numeric);
            reader_class = new FileReader(inst_class);
            Instances temp_instances_numeric = new Instances(reader_numeric);
            Instances temp_instances_class = new Instances(reader_class);
            temp_instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
            temp_instances_class.setClassIndex(instances_class.numAttributes() - 1);
            CombinedClassifier cc = new CombinedClassifier(temp_instances_numeric, temp_instances_class);
            int got_right = 0;
            int inst_ind = 0;
            while (inst_ind < tc_instances_numeric.size()) {
                Instance to_classify_class;
                Instance to_classify_num = tc_instances_numeric.remove(inst_ind);
                double result = cc.getClassification(to_classify_num, to_classify_class = tc_instances_class.remove(inst_ind));
                if ((double)Math.round(result) == to_classify_num.value(temp_instances_numeric.numAttributes() - 1)) {
                    ++got_right;
                }
                ++inst_ind;
            }
            return (double)got_right / (double)tc_instances_numeric.size();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
            System.err.println("RUN CLASSIFIER: Shouldn't be here");
            System.exit(0);
            return -100.0;
        }
    }

    public static boolean RunCombinedClassifierAloneREMOVER() {
        String inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_class";
        String inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_num";
        String tc_inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/SINGLE_class";
        String tc_inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/SINGLE_num";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            FileReader reader_numeric_inst = new FileReader(tc_inst_numeric);
            FileReader reader_class_inst = new FileReader(tc_inst_class);
            Instances tc_instances_numeric = new Instances(reader_numeric_inst);
            Instances tc_instances_class = new Instances(reader_class_inst);
            tc_instances_numeric.setClassIndex(tc_instances_numeric.numAttributes() - 1);
            tc_instances_class.setClassIndex(tc_instances_class.numAttributes() - 1);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            reader_numeric = new FileReader(inst_numeric);
            reader_class = new FileReader(inst_class);
            Instances temp_instances_numeric = new Instances(reader_numeric);
            Instances temp_instances_class = new Instances(reader_class);
            Instance to_classify_num = tc_instances_numeric.remove(0);
            Instance to_classify_class = tc_instances_class.remove(0);
            temp_instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
            temp_instances_class.setClassIndex(instances_class.numAttributes() - 1);
            CombinedClassifier cc = new CombinedClassifier(temp_instances_numeric, temp_instances_class);
            double result = cc.getClassification(to_classify_num, to_classify_class);
            System.out.println("Actual " + to_classify_num.value(temp_instances_numeric.numAttributes() - 1));
            System.out.println("===============");
            return (double)Math.round(result) == to_classify_num.value(temp_instances_numeric.numAttributes() - 1);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
            System.err.println("RUN CLASSIFIER: Shouldn't be here");
            System.exit(0);
            return false;
        }
    }

    public static void RunCombinedClassifierAlone() {
        String inst_class = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_class";
        String inst_numeric = String.valueOf(userdir) + "/resources/BindingAffinity/ARFF/REAL_num";
        String output = "";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            int got_right = 0;
            int inst_i = 0;
            while (inst_i < instances_numeric.size()) {
                System.out.println("Prgrs " + (inst_i + 1) + "/" + instances_numeric.size());
                reader_numeric = new FileReader(inst_numeric);
                reader_class = new FileReader(inst_class);
                Instances temp_instances_numeric = new Instances(reader_numeric);
                Instances temp_instances_class = new Instances(reader_class);
                Instance to_classify_num = temp_instances_numeric.remove(inst_i);
                Instance to_classify_class = temp_instances_class.remove(inst_i);
                temp_instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
                temp_instances_class.setClassIndex(instances_class.numAttributes() - 1);
                CombinedClassifier cc = new CombinedClassifier(temp_instances_numeric, temp_instances_class);
                double result = cc.getClassification(to_classify_num, to_classify_class);
                System.out.println("Actual " + to_classify_num.value(temp_instances_numeric.numAttributes() - 1));
                output = String.valueOf(output) + to_classify_num.value(temp_instances_numeric.numAttributes() - 1) + " " + result + "\n";
                System.out.println("===============");
                if ((double)Math.round(result) == to_classify_num.value(temp_instances_numeric.numAttributes() - 1)) {
                    ++got_right;
                }
                ++inst_i;
            }
            System.out.println("NEW: " + (double)got_right / (double)instances_numeric.size());
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/BindingAffinity/correlation2.txt", output);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void runCombinedClassifier() {
        ABMARS gab = new ABMARS(4, 2);
        RandomForest frf = new RandomForest();
        String inst_class = String.valueOf(userdir) + "/resources/instances";
        String inst_numeric = String.valueOf(userdir) + "/resources/instances_numeric";
        try {
            FileReader reader_numeric = new FileReader(inst_numeric);
            FileReader reader_class = new FileReader(inst_class);
            Instances instances_numeric = new Instances(reader_numeric);
            Instances instances_class = new Instances(reader_class);
            int got_right = 0;
            int inst_i = 0;
            while (inst_i < instances_numeric.size()) {
                reader_numeric = new FileReader(inst_numeric);
                reader_class = new FileReader(inst_class);
                Instances temp_instances_numeric = new Instances(reader_numeric);
                Instances temp_instances_class = new Instances(reader_class);
                Instance to_classify_num = temp_instances_numeric.remove(inst_i);
                Instance to_classify_class = temp_instances_class.remove(inst_i);
                temp_instances_numeric.setClassIndex(instances_numeric.numAttributes() - 1);
                temp_instances_class.setClassIndex(instances_class.numAttributes() - 1);
                gab.buildClassifier(temp_instances_numeric);
                frf.setNumTrees(1000);
                frf.setNumFeatures(3);
                frf.buildClassifier(temp_instances_class);
                double rf_out = frf.classifyInstance(to_classify_class);
                double mars_out = gab.classifyInstance(to_classify_num);
                double result = (rf_out + mars_out) / 2.0;
                if ((double)Math.round(result) == to_classify_num.value(temp_instances_numeric.numAttributes() - 1)) {
                    ++got_right;
                }
                ++inst_i;
            }
            System.out.println("OLD: " + (double)got_right / (double)instances_numeric.size());
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(0);
        }
    }

    public static void prepareData() {
        String out_fold = String.valueOf(userdir) + "/protein_database/combined_input/";
        HashMap<String, Complex_Structure> comps = CombinedClassifier.getData("all");
        for (String pdb : comps.keySet()) {
            Complex_Structure cs = comps.get(pdb);
            cs.writeAntibody(String.valueOf(out_fold) + "/" + pdb + ".pdb");
        }
    }

    public static HashMap<String, Complex_Structure> getData(String abag) {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        HashMap<String, Double> energy_map = null;
        if (abag.equals("big")) {
            energy_map = Energetics.BigAntigenEnergies();
        } else if (abag.equals("pep")) {
            energy_map = Energetics.PeptideEnergies();
        } else if (abag.equals("all")) {
            energy_map = Energetics.AllAntigenEnergies();
        }
        HashMap<Integer, String> kd_class_list = new HashMap<Integer, String>();
        int specimen = 0;
        int progress = 0;
        HashMap<String, Complex_Structure> complexes = new HashMap<String, Complex_Structure>();
        for (String pdb : energy_map.keySet()) {
            System.out.println("Fetching structures: " + ++progress + "/" + energy_map.size());
            double Kd = energy_map.get(pdb);
            String molarity_class = Energetics.ClassifyMolarity(Kd);
            kd_class_list.put(specimen, molarity_class);
            Complex_Structure cs = new Complex_Structure(String.valueOf(pdb) + "_AB", raw_folder, std_folder);
            complexes.put(pdb, cs);
        }
        return complexes;
    }
}

