/*
 * Decompiled with CFR 0.152.
 */
package for_terry;

import data_structures.Atom;
import data_structures.Residue;
import data_structures.SC_Structure;
import db_interface.Complex_Structure;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import parsing.PDB_parser;
import utils.FileSystemTools;

public class DBStats {
    static final String userdir = System.getProperty("user.dir");

    public static void main(String[] args) {
        HashMap<String, PDB_record> map = DBStats.getLHMapping();
        System.out.println(map.get((Object)"1AHW").Ag);
    }

    public static void ProduceDistanceData() {
        DBStats.ProduceContactData();
    }

    public static void ProduceAbysisContactData(String def) {
        ArrayList<String> eligible = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/peptides_and_eligible_pdbs.txt");
        int hs = 0;
        int ls = 0;
        for (String filename : eligible) {
            HashMap<Integer, Residue> residues;
            System.out.println(String.valueOf(def) + " : " + filename);
            filename = filename.substring(0, 4);
            if (filename.equals("1F3R") || filename.equals("3BKJ")) continue;
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/complex_pairs/" + filename + "_AB_B.pdb");
            if (new File(String.valueOf(userdir) + "/protein_database/definitions/" + def + "/" + filename + "_H.pdb").exists()) {
                ++hs;
                residues = PDB_parser.parseBySeqs(String.valueOf(userdir) + "/protein_database/definitions/" + def + "/" + filename + "_H.pdb");
                DBStats.processFile(def, residues, ag, String.valueOf(filename) + "_H");
            }
            if (!new File(String.valueOf(userdir) + "/protein_database/definitions/" + def + "/" + filename + "_L.pdb").exists()) continue;
            ++ls;
            residues = PDB_parser.parseBySeqs(String.valueOf(userdir) + "/protein_database/definitions/" + def + "/" + filename + "_L.pdb");
            DBStats.processFile(def, residues, ag, String.valueOf(filename) + "_L");
        }
        System.out.println("hs=" + hs);
        System.out.println("ls=" + ls);
    }

    public static void ProduceContactData() {
        ArrayList<String> eligible = FileSystemTools.readFile(String.valueOf(userdir) + "/result_dump/peptides_and_eligible_pdbs.txt");
        int hs = 0;
        int ls = 0;
        for (String filename : eligible) {
            HashMap<Integer, Residue> residues;
            System.out.println(filename);
            HashMap<Integer, Residue> ag = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/complex_pairs/" + filename + "_B.pdb");
            if (new File(String.valueOf(userdir) + "/protein_database/frames/imgt/" + filename + "_H.pdb").exists() && new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H1.pdb").exists() && new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H2.pdb").exists() && new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H3.pdb").exists()) {
                ++hs;
                residues = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/frames/imgt/" + filename + "_H.pdb");
                DBStats.processFile("imgt", residues, ag, String.valueOf(filename) + "_H");
                HashMap<Integer, Residue> H1 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H1.pdb");
                HashMap<Integer, Residue> H2 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H2.pdb");
                HashMap<Integer, Residue> H3 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "H3.pdb");
                DBStats.processFile("imgt", H1, ag, String.valueOf(filename) + "_H1");
                DBStats.processFile("imgt", H2, ag, String.valueOf(filename) + "_H2");
                DBStats.processFile("imgt", H3, ag, String.valueOf(filename) + "_H3");
            }
            if (!new File(String.valueOf(userdir) + "/protein_database/frames/imgt/" + filename + "_L.pdb").exists() || !new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L1.pdb").exists() || !new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L2.pdb").exists() || !new File(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L3.pdb").exists()) continue;
            ++ls;
            residues = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/frames/imgt/" + filename + "_L.pdb");
            DBStats.processFile("imgt", residues, ag, String.valueOf(filename) + "_L");
            HashMap<Integer, Residue> L1 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L1.pdb");
            HashMap<Integer, Residue> L2 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L2.pdb");
            HashMap<Integer, Residue> L3 = PDB_parser.parse(String.valueOf(userdir) + "/protein_database/antibodies/cdrs/" + filename.substring(0, 4) + "L3.pdb");
            DBStats.processFile("imgt", L1, ag, String.valueOf(filename) + "_L1");
            DBStats.processFile("imgt", L2, ag, String.valueOf(filename) + "_L2");
            DBStats.processFile("imgt", L3, ag, String.valueOf(filename) + "_L3");
        }
        System.out.println("hs=" + hs);
        System.out.println("ls=" + ls);
    }

    public static void processFile(String def, HashMap<Integer, Residue> ab, HashMap<Integer, Residue> ag, String out_name) {
        String output = "";
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer res_id : ab.keySet()) {
            sorted.add(res_id);
        }
        for (Integer res_id : sorted) {
            Residue res_A = ab.get(res_id);
            Atom c_alpha = null;
            for (Atom atom : res_A.atoms) {
                String a_name = "" + (Object)((Object)atom.atom_name);
                if (!a_name.contains("_CA")) continue;
                c_alpha = atom;
                break;
            }
            double curr_alpha_min = Double.MAX_VALUE;
            for (Integer ag_id : ag.keySet()) {
                double d;
                Residue ag_res = ag.get(ag_id);
                Atom ag_alpha = null;
                for (Atom atom : ag_res.atoms) {
                    String a_name = "" + (Object)((Object)atom.atom_name);
                    if (!a_name.contains("_CA")) continue;
                    ag_alpha = atom;
                    break;
                }
                if (ag_alpha == null || c_alpha == null || !((d = ag_alpha.distanceFrom(c_alpha)) < curr_alpha_min)) continue;
                curr_alpha_min = d;
            }
            double curr_atom_min = Double.MAX_VALUE;
            for (Integer ag_id : ag.keySet()) {
                Residue ag_res = ag.get(ag_id);
                for (Atom atom : ag_res.atoms) {
                    double d;
                    if (c_alpha == null || !((d = atom.distanceFrom(c_alpha)) < curr_atom_min)) continue;
                    curr_atom_min = d;
                }
            }
            if (c_alpha == null) continue;
            output = String.valueOf(output) + res_id + " " + curr_alpha_min + " " + curr_atom_min + " " + ag.size() + "\n";
        }
        if (output.length() != 0) {
            out_name = out_name.replace("_AB", "");
            FileSystemTools.writeFile(String.valueOf(userdir) + "/result_dump/Docking/Distances/" + def + "/" + out_name + ".txt", output);
        }
    }

    public static HashMap<String, PDB_record> getLHMapping() {
        ArrayList<String> abag = FileSystemTools.readFile(String.valueOf(userdir) + "/resources/ABAGSummary.txt");
        HashMap<String, PDB_record> rec_map = new HashMap<String, PDB_record>();
        for (String line : abag) {
            String pdb_code = line.substring(0, 4);
            line = line.substring(line.indexOf(" ") + 1);
            char H = line.charAt(0);
            line = line.substring(line.indexOf(" ") + 1);
            line = line.substring(line.indexOf(" ") + 1);
            char L = line.charAt(0);
            line = line.substring(line.indexOf(" ") + 1);
            line = line.substring(line.indexOf(" ") + 1);
            String Ag = line.substring(0, line.indexOf(" "));
            PDB_record pdb_rec = new PDB_record(pdb_code, H, L, Ag);
            rec_map.put(pdb_code, pdb_rec);
        }
        return rec_map;
    }

    public static void readInComplex() {
        String std_folder = String.valueOf(userdir) + "/protein_database/standardized";
        String raw_folder = String.valueOf(userdir) + "/protein_database/raw_files";
        ArrayList<String> pdb_codes = FileSystemTools.getFiles(String.valueOf(userdir) + "/protein_database/complex_pairs");
        int progress = 0;
        ArrayList<String> noCDR = new ArrayList<String>();
        for (String pdb_code : pdb_codes) {
            if ((pdb_code = pdb_code.substring(0, 7)).indexOf("_AB") == -1) continue;
            System.out.println("Examining: " + ++progress + "/" + pdb_codes.size() + " : " + pdb_code);
            Complex_Structure cs = new Complex_Structure(pdb_code);
            if (!cs.m1.chains.containsKey(Character.valueOf('C'))) {
                System.err.println(pdb_code);
                noCDR.add(pdb_code);
            }
            for (char chain : cs.m1.chains.keySet()) {
                SC_Structure sc = cs.m1.chains.get(Character.valueOf(chain));
                TreeSet<Integer> sorted = cs.m1.chains.get((Object)Character.valueOf((char)chain)).sorted;
                int index = 1;
                String output = "";
                for (Integer res_i : sorted) {
                    Residue res = sc.residues.get(res_i);
                    for (Atom atom : res.atoms) {
                        String line = atom.pdb_line;
                        String num = "" + index;
                        while (num.length() < 3) {
                            num = " " + num;
                        }
                        line = String.valueOf(line.substring(0, 23)) + num + line.substring(26);
                        output = String.valueOf(output) + line + "\n";
                    }
                    ++index;
                }
                FileSystemTools.writeFile(String.valueOf(userdir) + "/protein_database/frames/imgt/" + pdb_code + "_" + chain + ".pdb", output);
            }
        }
        System.out.println("No cdr:");
        for (String pdb : noCDR) {
            System.out.println(pdb);
        }
    }

    public static class PDB_record {
        public final char H;
        public final char L;
        public final String Ag;
        public final String pdb_code;

        public PDB_record(String _pdb_code, char _H, char _L, String _Ag) {
            this.pdb_code = _pdb_code;
            this.H = _H;
            this.L = _L;
            this.Ag = _Ag;
        }
    }
}

