/*
 * Decompiled with CFR 0.152.
 */
package lite_score_calculators;

import data_structures.AB_Residue_combinations;
import data_structures.AG_Residue_combinations;
import data_structures.Gap_function;
import data_structures.Residue;
import data_structures.SC_Structure;
import java.util.HashMap;

public class AB_Lite_TPro_calculator {
    public static void calculate_TPro(SC_Structure struc, SC_Structure struc_other, double[][] w_intra, Gap_function g, boolean isA) {
        HashMap<Integer, Double> Sis = AB_Lite_TPro_calculator.getSis(struc, struc_other);
        double max = Double.MIN_VALUE;
        for (Integer i : struc.residues.keySet()) {
            Residue res_central = struc.residues.get(i);
            double sum = 0.0;
            for (Residue res_inpatch : res_central.getPatch().patch_residues) {
                sum += w_intra[res_central.in_array][res_inpatch.in_array] * Sis.get(res_inpatch.in_array);
            }
            if (res_central.getPatch().patch_residues.size() != 0) {
                res_central.setTPro(sum / (double)res_central.getPatch().patch_residues.size() * 10000.0);
            }
            if (!(res_central.getTPro() > max)) continue;
            max = res_central.getTPro();
        }
    }

    public static HashMap<Integer, Double> getSis(SC_Structure s1, SC_Structure s2) {
        HashMap<Integer, Double> Sis = new HashMap<Integer, Double>();
        for (Integer i : s1.residues.keySet()) {
            Residue outer_res = s1.residues.get(i);
            double single_sum = 0.0;
            for (Integer k : s2.residues.keySet()) {
                double mul_tmp;
                Residue inner_res = s2.residues.get(k);
                double patch_sum = 0.0;
                for (Residue in_patch : outer_res.getPatch().patch_residues) {
                    mul_tmp = AB_Residue_combinations.intra_pair_lookup[AB_Residue_combinations.pair_lookup[outer_res.type.ab_classification.ordinal()][inner_res.type.ab_classification.ordinal()].ordinal()][in_patch.type.ab_classification.ordinal()];
                    patch_sum += mul_tmp * AB_Residue_combinations.triangle_lookup[outer_res.type.ab_classification.ordinal()][inner_res.type.ab_classification.ordinal()][in_patch.type.ab_classification.ordinal()];
                }
                for (Residue in_patch : inner_res.getPatch().patch_residues) {
                    mul_tmp = AG_Residue_combinations.intra_pair_lookup[AG_Residue_combinations.pair_lookup[outer_res.type.ag_classification.ordinal()][inner_res.type.ag_classification.ordinal()].ordinal()][in_patch.type.ag_classification.ordinal()];
                    patch_sum += mul_tmp * AG_Residue_combinations.triangle_lookup[outer_res.type.ag_classification.ordinal()][inner_res.type.ag_classification.ordinal()][in_patch.type.ag_classification.ordinal()];
                }
                single_sum += (patch_sum /= (double)(outer_res.getPatch().patch_residues.size() + inner_res.getPatch().patch_residues.size()));
            }
            Sis.put(outer_res.in_array, single_sum /= (double)s2.residues.size());
        }
        return Sis;
    }
}

